// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package util

import (
	"fmt"
	"strconv"
)

func ConvertMap[FromType, ToType any](objects []FromType, converter func(f FromType) ToType) []ToType {
	converted := make([]ToType, 0, len(objects))
	for _, object := range objects {
		converted = append(converted, converter(object))
	}
	return converted
}

func ParseInt(s string) int64 {
	if s == "" {
		return 0
	}
	v, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(fmt.Errorf("%s %w", s, err))
	}
	return v
}
