// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package util

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestTerminate(t *testing.T) {
	ctx, cancel := context.WithCancel(context.Background())
	assert.False(t, CatchTerminate(func() { MaybeTerminate(ctx) }))
	cancel()
	assert.True(t, CatchTerminate(func() { MaybeTerminate(ctx) }))
	assert.Panics(t, func() {
		CatchTerminate(func() { panic(true) })
	})
}
