// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package intsid

const (
	// Label holds the string label denoting the intsid type in the database.
	Label = "int_sid"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// EdgeParent holds the string denoting the parent edge name in mutations.
	EdgeParent = "parent"
	// EdgeChildren holds the string denoting the children edge name in mutations.
	EdgeChildren = "children"
	// Table holds the table name of the intsid in the database.
	Table = "int_si_ds"
	// ParentTable is the table that holds the parent relation/edge.
	ParentTable = "int_si_ds"
	// ParentColumn is the table column denoting the parent relation/edge.
	ParentColumn = "int_sid_parent"
	// ChildrenTable is the table that holds the children relation/edge.
	ChildrenTable = "int_si_ds"
	// ChildrenColumn is the table column denoting the children relation/edge.
	ChildrenColumn = "int_sid_parent"
)

// Columns holds all SQL columns for intsid fields.
var Columns = []string{
	FieldID,
}

// ForeignKeys holds the SQL foreign-keys that are owned by the "int_si_ds"
// table and are not defined as standalone fields in the schema.
var ForeignKeys = []string{
	"int_sid_parent",
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	for i := range ForeignKeys {
		if column == ForeignKeys[i] {
			return true
		}
	}
	return false
}
