// Code generated by smithy-go-codegen DO NOT EDIT.

package opsworkscm

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/opsworkscm/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all configuration management servers that are identified with your
// account. Only the stored results from Amazon DynamoDB are returned. AWS OpsWorks
// CM does not query other services. This operation is synchronous. A
// ResourceNotFoundException is thrown when the server does not exist. A
// ValidationException is raised when parameters of the request are not valid.
func (c *Client) DescribeServers(ctx context.Context, params *DescribeServersInput, optFns ...func(*Options)) (*DescribeServersOutput, error) {
	if params == nil {
		params = &DescribeServersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeServers", params, optFns, c.addOperationDescribeServersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeServersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeServersInput struct {

	// This is not currently implemented for DescribeServers requests.
	MaxResults *int32

	// This is not currently implemented for DescribeServers requests.
	NextToken *string

	// Describes the server with the specified ServerName.
	ServerName *string

	noSmithyDocumentSerde
}

type DescribeServersOutput struct {

	// This is not currently implemented for DescribeServers requests.
	NextToken *string

	// Contains the response to a DescribeServers request. For Chef Automate servers:
	// If DescribeServersResponse$Servers$EngineAttributes includes
	// CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef
	// Automate 2. To be eligible for upgrade, a server running Chef Automate 1 must
	// have had at least one successful maintenance run after November 1, 2019. For
	// Puppet servers: DescribeServersResponse$Servers$EngineAttributes contains the
	// following two responses:
	//   - PUPPET_API_CA_CERT , the PEM-encoded CA certificate that is used by the
	//   Puppet API over TCP port number 8140. The CA certificate is also used to sign
	//   node certificates.
	//   - PUPPET_API_CRL , a certificate revocation list. The certificate revocation
	//   list is for internal maintenance purposes only. For more information about the
	//   Puppet certificate revocation list, see Man Page: puppet
	//   certificate_revocation_list (https://puppet.com/docs/puppet/5.5/man/certificate_revocation_list.html)
	//   in the Puppet documentation.
	Servers []types.Server

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeServersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeServers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeServers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeServers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeServers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeServersAPIClient is a client that implements the DescribeServers
// operation.
type DescribeServersAPIClient interface {
	DescribeServers(context.Context, *DescribeServersInput, ...func(*Options)) (*DescribeServersOutput, error)
}

var _ DescribeServersAPIClient = (*Client)(nil)

// DescribeServersPaginatorOptions is the paginator options for DescribeServers
type DescribeServersPaginatorOptions struct {
	// This is not currently implemented for DescribeServers requests.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeServersPaginator is a paginator for DescribeServers
type DescribeServersPaginator struct {
	options   DescribeServersPaginatorOptions
	client    DescribeServersAPIClient
	params    *DescribeServersInput
	nextToken *string
	firstPage bool
}

// NewDescribeServersPaginator returns a new DescribeServersPaginator
func NewDescribeServersPaginator(client DescribeServersAPIClient, params *DescribeServersInput, optFns ...func(*DescribeServersPaginatorOptions)) *DescribeServersPaginator {
	if params == nil {
		params = &DescribeServersInput{}
	}

	options := DescribeServersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeServersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeServersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeServers page.
func (p *DescribeServersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeServersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeServers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeServers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeServers",
	}
}
