// Code generated by smithy-go-codegen DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/storagegateway/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets a list of FileSystemAssociationSummary objects. Each object contains a
// summary of a file system association. This operation is only supported for FSx
// File Gateways.
func (c *Client) ListFileSystemAssociations(ctx context.Context, params *ListFileSystemAssociationsInput, optFns ...func(*Options)) (*ListFileSystemAssociationsOutput, error) {
	if params == nil {
		params = &ListFileSystemAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFileSystemAssociations", params, optFns, c.addOperationListFileSystemAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFileSystemAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFileSystemAssociationsInput struct {

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a
	// list of gateways for your account and Amazon Web Services Region.
	GatewayARN *string

	// The maximum number of file system associations to return in the response. If
	// present, Limit must be an integer with a value greater than zero. Optional.
	Limit *int32

	// Opaque pagination token returned from a previous ListFileSystemAssociations
	// operation. If present, Marker specifies where to continue the list from after a
	// previous call to ListFileSystemAssociations . Optional.
	Marker *string

	noSmithyDocumentSerde
}

type ListFileSystemAssociationsOutput struct {

	// An array of information about the Amazon FSx gateway's file system associations.
	FileSystemAssociationSummaryList []types.FileSystemAssociationSummary

	// If the request includes Marker , the response returns that value in this field.
	Marker *string

	// If a value is present, there are more file system associations to return. In a
	// subsequent request, use NextMarker as the value for Marker to retrieve the next
	// set of file system associations.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFileSystemAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListFileSystemAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListFileSystemAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFileSystemAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFileSystemAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListFileSystemAssociationsPaginatorOptions is the paginator options for
// ListFileSystemAssociations
type ListFileSystemAssociationsPaginatorOptions struct {
	// The maximum number of file system associations to return in the response. If
	// present, Limit must be an integer with a value greater than zero. Optional.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFileSystemAssociationsPaginator is a paginator for
// ListFileSystemAssociations
type ListFileSystemAssociationsPaginator struct {
	options   ListFileSystemAssociationsPaginatorOptions
	client    ListFileSystemAssociationsAPIClient
	params    *ListFileSystemAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListFileSystemAssociationsPaginator returns a new
// ListFileSystemAssociationsPaginator
func NewListFileSystemAssociationsPaginator(client ListFileSystemAssociationsAPIClient, params *ListFileSystemAssociationsInput, optFns ...func(*ListFileSystemAssociationsPaginatorOptions)) *ListFileSystemAssociationsPaginator {
	if params == nil {
		params = &ListFileSystemAssociationsInput{}
	}

	options := ListFileSystemAssociationsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFileSystemAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFileSystemAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFileSystemAssociations page.
func (p *ListFileSystemAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFileSystemAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFileSystemAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFileSystemAssociationsAPIClient is a client that implements the
// ListFileSystemAssociations operation.
type ListFileSystemAssociationsAPIClient interface {
	ListFileSystemAssociations(context.Context, *ListFileSystemAssociationsInput, ...func(*Options)) (*ListFileSystemAssociationsOutput, error)
}

var _ ListFileSystemAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFileSystemAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFileSystemAssociations",
	}
}
