package main

import "github.com/pterm/pterm"

func main() {
	// Using the default paragraph printer to print a long text.
	// The text is split at the spaces, which is useful for continuous text of all kinds.
	// The line width can be manually adjusted if needed.
	pterm.DefaultParagraph.Println("This is the default paragraph printer. As you can see, no words are separated, " +
		"but the text is split at the spaces. This is useful for continuous text of all kinds. You can manually change the line width if you want to." +
		"Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam")

	// Printing a line space for separation.
	pterm.Println()

	// Printing a long text without using the paragraph printer.
	// The default Println() function is used here, which does not provide intelligent splitting.
	pterm.Println("This text is written with the default Println() function. No intelligent splitting here." +
		"Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam")
}
