// Copyright 2022 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v5.29.4
// source: sigstore_trustroot.proto

package v1

import (
	v1 "github.com/sigstore/protobuf-specs/gen/pb-go/common/v1"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ServiceSelector specifies how a client SHOULD select a set of
// Services to connect to. A client SHOULD throw an error if
// the value is SERVICE_SELECTOR_UNDEFINED.
type ServiceSelector int32

const (
	ServiceSelector_SERVICE_SELECTOR_UNDEFINED ServiceSelector = 0
	// Clients SHOULD select all Services based on supported API version
	// and validity window.
	ServiceSelector_ALL ServiceSelector = 1
	// Clients SHOULD select one Service based on supported API version
	// and validity window. It is up to the client implementation to
	// decide how to select the Service, e.g. random or round-robin.
	ServiceSelector_ANY ServiceSelector = 2
	// Clients SHOULD select a specific number of Services based on
	// supported API version and validity window, using the provided
	// `count`. It is up to the client implementation to decide how to
	// select the Service, e.g. random or round-robin.
	ServiceSelector_EXACT ServiceSelector = 3
)

// Enum value maps for ServiceSelector.
var (
	ServiceSelector_name = map[int32]string{
		0: "SERVICE_SELECTOR_UNDEFINED",
		1: "ALL",
		2: "ANY",
		3: "EXACT",
	}
	ServiceSelector_value = map[string]int32{
		"SERVICE_SELECTOR_UNDEFINED": 0,
		"ALL":                        1,
		"ANY":                        2,
		"EXACT":                      3,
	}
)

func (x ServiceSelector) Enum() *ServiceSelector {
	p := new(ServiceSelector)
	*p = x
	return p
}

func (x ServiceSelector) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceSelector) Descriptor() protoreflect.EnumDescriptor {
	return file_sigstore_trustroot_proto_enumTypes[0].Descriptor()
}

func (ServiceSelector) Type() protoreflect.EnumType {
	return &file_sigstore_trustroot_proto_enumTypes[0]
}

func (x ServiceSelector) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceSelector.Descriptor instead.
func (ServiceSelector) EnumDescriptor() ([]byte, []int) {
	return file_sigstore_trustroot_proto_rawDescGZIP(), []int{0}
}

// TransparencyLogInstance describes the immutable parameters from a
// transparency log.
// See https://www.rfc-editor.org/rfc/rfc9162.html#name-log-parameters
// for more details.
// The included parameters are the minimal set required to identify a log,
// and verify an inclusion proof/promise.
type TransparencyLogInstance struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The base URL at which can be used to URLs for the client.
	BaseUrl string `protobuf:"bytes,1,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// The hash algorithm used for the Merkle Tree.
	HashAlgorithm v1.HashAlgorithm `protobuf:"varint,2,opt,name=hash_algorithm,json=hashAlgorithm,proto3,enum=dev.sigstore.common.v1.HashAlgorithm" json:"hash_algorithm,omitempty"`
	// The public key used to verify signatures generated by the log.
	// This attribute contains the signature algorithm used by the log.
	PublicKey *v1.PublicKey `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// The unique identifier for this transparency log.
	// Represented as the SHA-256 hash of the log's public key,
	// calculated over the DER encoding of the key represented as
	// SubjectPublicKeyInfo.
	// See https://www.rfc-editor.org/rfc/rfc6962#section-3.2
	LogId *v1.LogId `protobuf:"bytes,4,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	// The checkpoint key identifier for the log used in a checkpoint.
	// Optional, not provided for logs that do not generate checkpoints.
	// For logs that do generate checkpoints, if not set, assume
	// log_id equals checkpoint_key_id.
	// Follows the specification described here
	// for ECDSA and Ed25519 signatures:
	// https://github.com/C2SP/C2SP/blob/main/signed-note.md#signatures
	// For RSA signatures, the key ID will match the ECDSA format, the
	// hashed DER-encoded SPKI public key. Publicly witnessed logs MUST NOT
	// use RSA-signed checkpoints, since witnesses do not support
	// RSA signatures.
	// This is provided for convenience. Clients can also calculate the
	// checkpoint key ID given the log's public key.
	// SHOULD be set for logs generating Ed25519 signatures.
	// SHOULD be 4 bytes long, as a truncated hash.
	CheckpointKeyId *v1.LogId `protobuf:"bytes,5,opt,name=checkpoint_key_id,json=checkpointKeyId,proto3" json:"checkpoint_key_id,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *TransparencyLogInstance) Reset() {
	*x = TransparencyLogInstance{}
	mi := &file_sigstore_trustroot_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransparencyLogInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransparencyLogInstance) ProtoMessage() {}

func (x *TransparencyLogInstance) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_trustroot_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransparencyLogInstance.ProtoReflect.Descriptor instead.
func (*TransparencyLogInstance) Descriptor() ([]byte, []int) {
	return file_sigstore_trustroot_proto_rawDescGZIP(), []int{0}
}

func (x *TransparencyLogInstance) GetBaseUrl() string {
	if x != nil {
		return x.BaseUrl
	}
	return ""
}

func (x *TransparencyLogInstance) GetHashAlgorithm() v1.HashAlgorithm {
	if x != nil {
		return x.HashAlgorithm
	}
	return v1.HashAlgorithm(0)
}

func (x *TransparencyLogInstance) GetPublicKey() *v1.PublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *TransparencyLogInstance) GetLogId() *v1.LogId {
	if x != nil {
		return x.LogId
	}
	return nil
}

func (x *TransparencyLogInstance) GetCheckpointKeyId() *v1.LogId {
	if x != nil {
		return x.CheckpointKeyId
	}
	return nil
}

// CertificateAuthority enlists the information required to identify which
// CA to use and perform signature verification.
type CertificateAuthority struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The root certificate MUST be self-signed, and so the subject and
	// issuer are the same.
	Subject *v1.DistinguishedName `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	// The URI identifies the certificate authority.
	//
	// It is RECOMMENDED that the URI is the base URL for the certificate
	// authority, that can be provided to any SDK/client provided
	// by the certificate authority to interact with the certificate
	// authority.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// The certificate chain for this CA. The last certificate in the chain
	// MUST be the trust anchor. The trust anchor MAY be a self-signed root
	// CA certificate or MAY be an intermediate CA certificate.
	CertChain *v1.X509CertificateChain `protobuf:"bytes,3,opt,name=cert_chain,json=certChain,proto3" json:"cert_chain,omitempty"`
	// The time the *entire* chain was valid. This is at max the
	// longest interval when *all* certificates in the chain were valid,
	// but it MAY be shorter. Clients MUST check timestamps against *both*
	// the `valid_for` time range *and* the entire certificate chain.
	//
	// The TimeRange should be considered valid *inclusive* of the
	// endpoints.
	ValidFor      *v1.TimeRange `protobuf:"bytes,4,opt,name=valid_for,json=validFor,proto3" json:"valid_for,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CertificateAuthority) Reset() {
	*x = CertificateAuthority{}
	mi := &file_sigstore_trustroot_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateAuthority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority) ProtoMessage() {}

func (x *CertificateAuthority) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_trustroot_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority.ProtoReflect.Descriptor instead.
func (*CertificateAuthority) Descriptor() ([]byte, []int) {
	return file_sigstore_trustroot_proto_rawDescGZIP(), []int{1}
}

func (x *CertificateAuthority) GetSubject() *v1.DistinguishedName {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *CertificateAuthority) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *CertificateAuthority) GetCertChain() *v1.X509CertificateChain {
	if x != nil {
		return x.CertChain
	}
	return nil
}

func (x *CertificateAuthority) GetValidFor() *v1.TimeRange {
	if x != nil {
		return x.ValidFor
	}
	return nil
}

// TrustedRoot describes the client's complete set of trusted entities.
// How the TrustedRoot is populated is not specified, but can be a
// combination of many sources such as TUF repositories, files on disk etc.
//
// The TrustedRoot is not meant to be used for any artifact verification, only
// to capture the complete/global set of trusted verification materials.
// When verifying an artifact, based on the artifact and policies, a selection
// of keys/authorities are expected to be extracted and provided to the
// verification function. This way the set of keys/authorities can be kept to
// a minimal set by the policy to gain better control over what signatures
// that are allowed.
//
// The embedded transparency logs, CT logs, CAs and TSAs MUST include any
// previously used instance -- otherwise signatures made in the past cannot
// be verified.
//
// All the listed instances SHOULD be sorted by the 'valid_for' in ascending
// order, that is, the oldest instance first. Only the last instance is
// allowed to have their 'end' timestamp unset. All previous instances MUST
// have a closed interval of validity. The last instance MAY have a closed
// interval. Clients MUST accept instances that overlaps in time, if not
// clients may experience problems during rotations of verification
// materials.
//
// To be able to manage planned rotations of either transparency logs or
// certificate authorities, clienst MUST accept lists of instances where
// the last instance have a 'valid_for' that belongs to the future.
// This should not be a problem as clients SHOULD first seek the trust root
// for a suitable instance before creating a per artifact trust root (that
// is, a sub-set of the complete trust root) that is used for verification.
type TrustedRoot struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// MUST be application/vnd.dev.sigstore.trustedroot.v0.1+json
	// when encoded as JSON.
	// Clients MUST be able to process and parse content with the media
	// type defined in the old format:
	// application/vnd.dev.sigstore.trustedroot+json;version=0.1
	MediaType string `protobuf:"bytes,1,opt,name=media_type,json=mediaType,proto3" json:"media_type,omitempty"`
	// A set of trusted Rekor servers.
	Tlogs []*TransparencyLogInstance `protobuf:"bytes,2,rep,name=tlogs,proto3" json:"tlogs,omitempty"`
	// A set of trusted certificate authorities (e.g Fulcio), and any
	// intermediate certificates they provide.
	// If a CA is issuing multiple intermediate certificate, each
	// combination shall be represented as separate chain. I.e, a single
	// root cert may appear in multiple chains but with different
	// intermediate and/or leaf certificates.
	// The certificates are intended to be used for verifying artifact
	// signatures.
	CertificateAuthorities []*CertificateAuthority `protobuf:"bytes,3,rep,name=certificate_authorities,json=certificateAuthorities,proto3" json:"certificate_authorities,omitempty"`
	// A set of trusted certificate transparency logs.
	Ctlogs []*TransparencyLogInstance `protobuf:"bytes,4,rep,name=ctlogs,proto3" json:"ctlogs,omitempty"`
	// A set of trusted timestamping authorities.
	TimestampAuthorities []*CertificateAuthority `protobuf:"bytes,5,rep,name=timestamp_authorities,json=timestampAuthorities,proto3" json:"timestamp_authorities,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *TrustedRoot) Reset() {
	*x = TrustedRoot{}
	mi := &file_sigstore_trustroot_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrustedRoot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrustedRoot) ProtoMessage() {}

func (x *TrustedRoot) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_trustroot_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrustedRoot.ProtoReflect.Descriptor instead.
func (*TrustedRoot) Descriptor() ([]byte, []int) {
	return file_sigstore_trustroot_proto_rawDescGZIP(), []int{2}
}

func (x *TrustedRoot) GetMediaType() string {
	if x != nil {
		return x.MediaType
	}
	return ""
}

func (x *TrustedRoot) GetTlogs() []*TransparencyLogInstance {
	if x != nil {
		return x.Tlogs
	}
	return nil
}

func (x *TrustedRoot) GetCertificateAuthorities() []*CertificateAuthority {
	if x != nil {
		return x.CertificateAuthorities
	}
	return nil
}

func (x *TrustedRoot) GetCtlogs() []*TransparencyLogInstance {
	if x != nil {
		return x.Ctlogs
	}
	return nil
}

func (x *TrustedRoot) GetTimestampAuthorities() []*CertificateAuthority {
	if x != nil {
		return x.TimestampAuthorities
	}
	return nil
}

// SigningConfig represents the trusted entities/state needed by Sigstore
// signing. In particular, it primarily contains service URLs that a Sigstore
// signer may need to connect to for the online aspects of signing.
type SigningConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// MUST be application/vnd.dev.sigstore.signingconfig.v0.2+json
	// Clients MAY choose to also support
	// application/vnd.dev.sigstore.signingconfig.v0.1+json
	MediaType string `protobuf:"bytes,5,opt,name=media_type,json=mediaType,proto3" json:"media_type,omitempty"`
	// URLs to Fulcio-compatible CAs, capable of receiving
	// Certificate Signing Requests (CSRs) and responding with
	// issued certificates.
	//
	// These URLs MUST be the "base" URL for the CAs, which clients
	// should construct an appropriate CSR endpoint on top of.
	// For example, if a CA URL is `https://example.com/ca`, then
	// the client MAY construct the CSR endpoint as
	// `https://example.com/ca/api/v2/signingCert`.
	//
	// Clients MUST select only one Service with the highest API version
	// that the client is compatible with, that is within its
	// validity period, and has the newest validity start date.
	// Client SHOULD select the first Service that meets this requirement.
	// All listed Services SHOULD be sorted by the `valid_for` window in
	// descending order, with the newest instance first.
	CaUrls []*Service `protobuf:"bytes,6,rep,name=ca_urls,json=caUrls,proto3" json:"ca_urls,omitempty"`
	// URLs to OpenID Connect identity providers.
	//
	// These URLs MUST be the "base" URLs for the OIDC IdPs, which clients
	// should perform well-known OpenID Connect discovery against.
	//
	// Clients MUST select only one Service with the highest API version
	// that the client is compatible with, that is within its
	// validity period, and has the newest validity start date.
	// Client SHOULD select the first Service that meets this requirement.
	// All listed Services SHOULD be sorted by the `valid_for` window in
	// descending order, with the newest instance first.
	OidcUrls []*Service `protobuf:"bytes,7,rep,name=oidc_urls,json=oidcUrls,proto3" json:"oidc_urls,omitempty"`
	// URLs to Rekor transparency logs.
	//
	// These URL MUST be the "base" URLs for the transparency logs,
	// which clients should construct appropriate API endpoints on top of.
	//
	// Clients MUST select Services with the highest API version
	// that the client is compatible with, that are within its
	// validity period, and have the newest validity start dates.
	// All listed Services SHOULD be sorted by the `valid_for` window in
	// descending order, with the newest instance first.
	//
	// Clients MUST select Services based on the selector value of
	// `rekor_tlog_config`.
	RekorTlogUrls []*Service `protobuf:"bytes,8,rep,name=rekor_tlog_urls,json=rekorTlogUrls,proto3" json:"rekor_tlog_urls,omitempty"`
	// Specifies how a client should select the set of Rekor transparency
	// logs to write to.
	RekorTlogConfig *ServiceConfiguration `protobuf:"bytes,9,opt,name=rekor_tlog_config,json=rekorTlogConfig,proto3" json:"rekor_tlog_config,omitempty"`
	// URLs to RFC 3161 Time Stamping Authorities (TSA).
	//
	// These URLs MUST be the *full* URL for the TSA, meaning that it
	// should be suitable for submitting Time Stamp Requests (TSRs) to
	// via HTTP, per RFC 3161.
	//
	// Clients MUST select Services with the highest API version
	// that the client is compatible with, that are within its
	// validity period, and have the newest validity start dates.
	// All listed Services SHOULD be sorted by the `valid_for` window in
	// descending order, with the newest instance first.
	//
	// Clients MUST select Services based on the selector value of
	// `tsa_config`.
	TsaUrls []*Service `protobuf:"bytes,10,rep,name=tsa_urls,json=tsaUrls,proto3" json:"tsa_urls,omitempty"`
	// Specifies how a client should select the set of TSAs to request
	// signed timestamps from.
	TsaConfig     *ServiceConfiguration `protobuf:"bytes,11,opt,name=tsa_config,json=tsaConfig,proto3" json:"tsa_config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SigningConfig) Reset() {
	*x = SigningConfig{}
	mi := &file_sigstore_trustroot_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SigningConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SigningConfig) ProtoMessage() {}

func (x *SigningConfig) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_trustroot_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SigningConfig.ProtoReflect.Descriptor instead.
func (*SigningConfig) Descriptor() ([]byte, []int) {
	return file_sigstore_trustroot_proto_rawDescGZIP(), []int{3}
}

func (x *SigningConfig) GetMediaType() string {
	if x != nil {
		return x.MediaType
	}
	return ""
}

func (x *SigningConfig) GetCaUrls() []*Service {
	if x != nil {
		return x.CaUrls
	}
	return nil
}

func (x *SigningConfig) GetOidcUrls() []*Service {
	if x != nil {
		return x.OidcUrls
	}
	return nil
}

func (x *SigningConfig) GetRekorTlogUrls() []*Service {
	if x != nil {
		return x.RekorTlogUrls
	}
	return nil
}

func (x *SigningConfig) GetRekorTlogConfig() *ServiceConfiguration {
	if x != nil {
		return x.RekorTlogConfig
	}
	return nil
}

func (x *SigningConfig) GetTsaUrls() []*Service {
	if x != nil {
		return x.TsaUrls
	}
	return nil
}

func (x *SigningConfig) GetTsaConfig() *ServiceConfiguration {
	if x != nil {
		return x.TsaConfig
	}
	return nil
}

// Service represents an instance of a service that is a part of Sigstore infrastructure.
// Clients MUST use the API version hint to determine the service with the
// highest API version that the client is compatible with. Clients MUST also
// only connect to services within the specified validity period and that has the
// newest validity start date.
type Service struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// URL of the service. MUST include scheme and authority. MAY include path.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Specifies the major API version. A value of 0 represents a service that
	// has not yet been released.
	MajorApiVersion uint32 `protobuf:"varint,2,opt,name=major_api_version,json=majorApiVersion,proto3" json:"major_api_version,omitempty"`
	// Validity period of a service. A service that has only a start date
	// SHOULD be considered the most recent instance of that service, but
	// the client MUST NOT assume there is only one valid instance.
	// The TimeRange MUST be considered valid *inclusive* of the
	// endpoints.
	ValidFor      *v1.TimeRange `protobuf:"bytes,3,opt,name=valid_for,json=validFor,proto3" json:"valid_for,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Service) Reset() {
	*x = Service{}
	mi := &file_sigstore_trustroot_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_trustroot_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_sigstore_trustroot_proto_rawDescGZIP(), []int{4}
}

func (x *Service) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Service) GetMajorApiVersion() uint32 {
	if x != nil {
		return x.MajorApiVersion
	}
	return 0
}

func (x *Service) GetValidFor() *v1.TimeRange {
	if x != nil {
		return x.ValidFor
	}
	return nil
}

// ServiceConfiguration specifies how a client should select a set of
// Services to connect to, along with a count when a specific number
// of Services is requested.
type ServiceConfiguration struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// How a client should select a set of Services to connect to.
	Selector ServiceSelector `protobuf:"varint,1,opt,name=selector,proto3,enum=dev.sigstore.trustroot.v1.ServiceSelector" json:"selector,omitempty"`
	// count specifies the number of Services the client should use.
	// Only used when selector is set to EXACT, and count MUST be greater
	// than 0. count MUST be less than or equal to the number of Services.
	Count         uint32 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServiceConfiguration) Reset() {
	*x = ServiceConfiguration{}
	mi := &file_sigstore_trustroot_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConfiguration) ProtoMessage() {}

func (x *ServiceConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_trustroot_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConfiguration.ProtoReflect.Descriptor instead.
func (*ServiceConfiguration) Descriptor() ([]byte, []int) {
	return file_sigstore_trustroot_proto_rawDescGZIP(), []int{5}
}

func (x *ServiceConfiguration) GetSelector() ServiceSelector {
	if x != nil {
		return x.Selector
	}
	return ServiceSelector_SERVICE_SELECTOR_UNDEFINED
}

func (x *ServiceConfiguration) GetCount() uint32 {
	if x != nil {
		return x.Count
	}
	return 0
}

// ClientTrustConfig describes the complete state needed by a client
// to perform both signing and verification operations against a particular
// instance of Sigstore.
type ClientTrustConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// MUST be application/vnd.dev.sigstore.clienttrustconfig.v0.1+json
	MediaType string `protobuf:"bytes,1,opt,name=media_type,json=mediaType,proto3" json:"media_type,omitempty"`
	// The root of trust, which MUST be present.
	TrustedRoot *TrustedRoot `protobuf:"bytes,2,opt,name=trusted_root,json=trustedRoot,proto3" json:"trusted_root,omitempty"`
	// Configuration for signing clients, which MUST be present.
	SigningConfig *SigningConfig `protobuf:"bytes,3,opt,name=signing_config,json=signingConfig,proto3" json:"signing_config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClientTrustConfig) Reset() {
	*x = ClientTrustConfig{}
	mi := &file_sigstore_trustroot_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClientTrustConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientTrustConfig) ProtoMessage() {}

func (x *ClientTrustConfig) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_trustroot_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientTrustConfig.ProtoReflect.Descriptor instead.
func (*ClientTrustConfig) Descriptor() ([]byte, []int) {
	return file_sigstore_trustroot_proto_rawDescGZIP(), []int{6}
}

func (x *ClientTrustConfig) GetMediaType() string {
	if x != nil {
		return x.MediaType
	}
	return ""
}

func (x *ClientTrustConfig) GetTrustedRoot() *TrustedRoot {
	if x != nil {
		return x.TrustedRoot
	}
	return nil
}

func (x *ClientTrustConfig) GetSigningConfig() *SigningConfig {
	if x != nil {
		return x.SigningConfig
	}
	return nil
}

var File_sigstore_trustroot_proto protoreflect.FileDescriptor

var file_sigstore_trustroot_proto_rawDesc = string([]byte{
	0x0a, 0x18, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x72, 0x75, 0x73, 0x74,
	0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x64, 0x65, 0x76, 0x2e,
	0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f,
	0x6f, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc5, 0x02,
	0x0a, 0x17, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x4c, 0x6f,
	0x67, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x61, 0x73,
	0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x61, 0x73,
	0x65, 0x55, 0x72, 0x6c, 0x12, 0x4c, 0x0a, 0x0e, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x61, 0x6c, 0x67,
	0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x64,
	0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x52, 0x0d, 0x68, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x12, 0x40, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x12, 0x34, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x67, 0x49, 0x64, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x49, 0x0a, 0x11, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x6f, 0x67, 0x49, 0x64, 0x52, 0x0f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x4b, 0x65, 0x79, 0x49, 0x64, 0x22, 0xfa, 0x01, 0x0a, 0x14, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x43,
	0x0a, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x75, 0x69, 0x73, 0x68, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x4b, 0x0a, 0x0a, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x63, 0x68,
	0x61, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x64, 0x65, 0x76, 0x2e,
	0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x58, 0x35, 0x30, 0x39, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x09, 0x63, 0x65, 0x72, 0x74, 0x43, 0x68, 0x61,
	0x69, 0x6e, 0x12, 0x3e, 0x0a, 0x09, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x08, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x46,
	0x6f, 0x72, 0x22, 0x92, 0x03, 0x0a, 0x0b, 0x54, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x52, 0x6f,
	0x6f, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x48, 0x0a, 0x05, 0x74, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x4c, 0x6f, 0x67, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x74, 0x6c, 0x6f, 0x67, 0x73, 0x12, 0x68, 0x0a, 0x17, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x64,
	0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x74, 0x72, 0x75, 0x73,
	0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x16, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x06, 0x63, 0x74, 0x6c, 0x6f, 0x67, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x4c, 0x6f,
	0x67, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x63, 0x74, 0x6c, 0x6f, 0x67,
	0x73, 0x12, 0x64, 0x0a, 0x15, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x52, 0x14, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0xea, 0x03, 0x0a, 0x0d, 0x53, 0x69, 0x67, 0x6e,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x07, 0x63, 0x61, 0x5f, 0x75,
	0x72, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x76, 0x2e,
	0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f,
	0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x06, 0x63,
	0x61, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x3f, 0x0a, 0x09, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x75, 0x72,
	0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73,
	0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x08, 0x6f, 0x69,
	0x64, 0x63, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x4a, 0x0a, 0x0f, 0x72, 0x65, 0x6b, 0x6f, 0x72, 0x5f,
	0x74, 0x6c, 0x6f, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x74,
	0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x0d, 0x72, 0x65, 0x6b, 0x6f, 0x72, 0x54, 0x6c, 0x6f, 0x67, 0x55, 0x72,
	0x6c, 0x73, 0x12, 0x5b, 0x0a, 0x11, 0x72, 0x65, 0x6b, 0x6f, 0x72, 0x5f, 0x74, 0x6c, 0x6f, 0x67,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x74, 0x72, 0x75,
	0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x72, 0x65, 0x6b, 0x6f, 0x72, 0x54, 0x6c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3d, 0x0a, 0x08, 0x74, 0x73, 0x61, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x74, 0x73, 0x61, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x4e,
	0x0a, 0x0a, 0x74, 0x73, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x09, 0x74, 0x73, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4a, 0x04,
	0x08, 0x01, 0x10, 0x05, 0x22, 0x87, 0x01, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x72, 0x6c, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x5f, 0x61, 0x70, 0x69, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x6d,
	0x61, 0x6a, 0x6f, 0x72, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e,
	0x0a, 0x09, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x52, 0x08, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x46, 0x6f, 0x72, 0x22, 0x74,
	0x0a, 0x14, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73,
	0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x14,
	0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x22, 0xd8, 0x01, 0x0a, 0x11, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54,
	0x72, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65,
	0x64, 0x69, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4e, 0x0a, 0x0c, 0x74, 0x72, 0x75,
	0x73, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x74,
	0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x73,
	0x74, 0x65, 0x64, 0x52, 0x6f, 0x6f, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x72,
	0x75, 0x73, 0x74, 0x65, 0x64, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x73, 0x69, 0x67,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69,
	0x67, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0d, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2a,
	0x4e, 0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x53, 0x45,
	0x4c, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x41,
	0x4e, 0x59, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x58, 0x41, 0x43, 0x54, 0x10, 0x03, 0x42,
	0x88, 0x01, 0x0a, 0x1f, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74,
	0x2e, 0x76, 0x31, 0x42, 0x0e, 0x54, 0x72, 0x75, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x39, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2d, 0x73, 0x70, 0x65, 0x63, 0x73, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x62,
	0x2d, 0x67, 0x6f, 0x2f, 0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2f, 0x76, 0x31,
	0xea, 0x02, 0x17, 0x53, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3a, 0x3a, 0x54, 0x72, 0x75,
	0x73, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
})

var (
	file_sigstore_trustroot_proto_rawDescOnce sync.Once
	file_sigstore_trustroot_proto_rawDescData []byte
)

func file_sigstore_trustroot_proto_rawDescGZIP() []byte {
	file_sigstore_trustroot_proto_rawDescOnce.Do(func() {
		file_sigstore_trustroot_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_sigstore_trustroot_proto_rawDesc), len(file_sigstore_trustroot_proto_rawDesc)))
	})
	return file_sigstore_trustroot_proto_rawDescData
}

var file_sigstore_trustroot_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_sigstore_trustroot_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_sigstore_trustroot_proto_goTypes = []any{
	(ServiceSelector)(0),            // 0: dev.sigstore.trustroot.v1.ServiceSelector
	(*TransparencyLogInstance)(nil), // 1: dev.sigstore.trustroot.v1.TransparencyLogInstance
	(*CertificateAuthority)(nil),    // 2: dev.sigstore.trustroot.v1.CertificateAuthority
	(*TrustedRoot)(nil),             // 3: dev.sigstore.trustroot.v1.TrustedRoot
	(*SigningConfig)(nil),           // 4: dev.sigstore.trustroot.v1.SigningConfig
	(*Service)(nil),                 // 5: dev.sigstore.trustroot.v1.Service
	(*ServiceConfiguration)(nil),    // 6: dev.sigstore.trustroot.v1.ServiceConfiguration
	(*ClientTrustConfig)(nil),       // 7: dev.sigstore.trustroot.v1.ClientTrustConfig
	(v1.HashAlgorithm)(0),           // 8: dev.sigstore.common.v1.HashAlgorithm
	(*v1.PublicKey)(nil),            // 9: dev.sigstore.common.v1.PublicKey
	(*v1.LogId)(nil),                // 10: dev.sigstore.common.v1.LogId
	(*v1.DistinguishedName)(nil),    // 11: dev.sigstore.common.v1.DistinguishedName
	(*v1.X509CertificateChain)(nil), // 12: dev.sigstore.common.v1.X509CertificateChain
	(*v1.TimeRange)(nil),            // 13: dev.sigstore.common.v1.TimeRange
}
var file_sigstore_trustroot_proto_depIdxs = []int32{
	8,  // 0: dev.sigstore.trustroot.v1.TransparencyLogInstance.hash_algorithm:type_name -> dev.sigstore.common.v1.HashAlgorithm
	9,  // 1: dev.sigstore.trustroot.v1.TransparencyLogInstance.public_key:type_name -> dev.sigstore.common.v1.PublicKey
	10, // 2: dev.sigstore.trustroot.v1.TransparencyLogInstance.log_id:type_name -> dev.sigstore.common.v1.LogId
	10, // 3: dev.sigstore.trustroot.v1.TransparencyLogInstance.checkpoint_key_id:type_name -> dev.sigstore.common.v1.LogId
	11, // 4: dev.sigstore.trustroot.v1.CertificateAuthority.subject:type_name -> dev.sigstore.common.v1.DistinguishedName
	12, // 5: dev.sigstore.trustroot.v1.CertificateAuthority.cert_chain:type_name -> dev.sigstore.common.v1.X509CertificateChain
	13, // 6: dev.sigstore.trustroot.v1.CertificateAuthority.valid_for:type_name -> dev.sigstore.common.v1.TimeRange
	1,  // 7: dev.sigstore.trustroot.v1.TrustedRoot.tlogs:type_name -> dev.sigstore.trustroot.v1.TransparencyLogInstance
	2,  // 8: dev.sigstore.trustroot.v1.TrustedRoot.certificate_authorities:type_name -> dev.sigstore.trustroot.v1.CertificateAuthority
	1,  // 9: dev.sigstore.trustroot.v1.TrustedRoot.ctlogs:type_name -> dev.sigstore.trustroot.v1.TransparencyLogInstance
	2,  // 10: dev.sigstore.trustroot.v1.TrustedRoot.timestamp_authorities:type_name -> dev.sigstore.trustroot.v1.CertificateAuthority
	5,  // 11: dev.sigstore.trustroot.v1.SigningConfig.ca_urls:type_name -> dev.sigstore.trustroot.v1.Service
	5,  // 12: dev.sigstore.trustroot.v1.SigningConfig.oidc_urls:type_name -> dev.sigstore.trustroot.v1.Service
	5,  // 13: dev.sigstore.trustroot.v1.SigningConfig.rekor_tlog_urls:type_name -> dev.sigstore.trustroot.v1.Service
	6,  // 14: dev.sigstore.trustroot.v1.SigningConfig.rekor_tlog_config:type_name -> dev.sigstore.trustroot.v1.ServiceConfiguration
	5,  // 15: dev.sigstore.trustroot.v1.SigningConfig.tsa_urls:type_name -> dev.sigstore.trustroot.v1.Service
	6,  // 16: dev.sigstore.trustroot.v1.SigningConfig.tsa_config:type_name -> dev.sigstore.trustroot.v1.ServiceConfiguration
	13, // 17: dev.sigstore.trustroot.v1.Service.valid_for:type_name -> dev.sigstore.common.v1.TimeRange
	0,  // 18: dev.sigstore.trustroot.v1.ServiceConfiguration.selector:type_name -> dev.sigstore.trustroot.v1.ServiceSelector
	3,  // 19: dev.sigstore.trustroot.v1.ClientTrustConfig.trusted_root:type_name -> dev.sigstore.trustroot.v1.TrustedRoot
	4,  // 20: dev.sigstore.trustroot.v1.ClientTrustConfig.signing_config:type_name -> dev.sigstore.trustroot.v1.SigningConfig
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_sigstore_trustroot_proto_init() }
func file_sigstore_trustroot_proto_init() {
	if File_sigstore_trustroot_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_sigstore_trustroot_proto_rawDesc), len(file_sigstore_trustroot_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sigstore_trustroot_proto_goTypes,
		DependencyIndexes: file_sigstore_trustroot_proto_depIdxs,
		EnumInfos:         file_sigstore_trustroot_proto_enumTypes,
		MessageInfos:      file_sigstore_trustroot_proto_msgTypes,
	}.Build()
	File_sigstore_trustroot_proto = out.File
	file_sigstore_trustroot_proto_goTypes = nil
	file_sigstore_trustroot_proto_depIdxs = nil
}
