/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _NEW_GAME_DIALOG_H
#define _NEW_GAME_DIALOG_H

#include "dialog.h"

class Game;

class NewGameDialog : public Dialog {
   GtkWidget*	_beginner;
   GtkWidget*	_intermediate;
   GtkWidget*	_expert;
   GtkWidget*	_user_definable;
   GtkWidget*	_row_label;
   GtkWidget*	_column_label;
   GtkWidget* 	_rows;
   GtkWidget*	_columns;

   void SetRowColumns(gboolean sensitive);
   static void UserDefinableCB(GtkWidget *widget, gpointer data);
protected:
   Game*	_game;
   void	OnOk();
public:
   NewGameDialog(Game* game);
};

#endif // _NEW_DIALOG_H
