/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class MapsTransformValuesTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testClear() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testClear();
}

public void testContainsKey() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testContainsKey();
}

public void testContainsValue() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testContainsValue();
}

public void testEntrySet() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testEqualsForSmallerMap();
}

public void testGet() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testGet();
}

public void testGetForEmptyMap() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testGetForEmptyMap();
}

public void testGetNull() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testGetNull();
}

public void testHashCode() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testKeySetClear();
}

public void testKeySetRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testPutExistingKey();
}

public void testPutNewKey() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testPutNewKey();
}

public void testPutNullKey() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testPutNullKey();
}

public void testPutNullValue() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testRemove();
}

public void testRemoveMissingKey() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testRemoveMissingKey();
}

public void testSize() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testSize();
}

public void testTransformChangesAreReflectedInUnderlyingMap() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testTransformChangesAreReflectedInUnderlyingMap();
}

public void testTransformEmptyMapEquality() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testTransformEmptyMapEquality();
}

public void testTransformEntrySetContains() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testTransformEntrySetContains();
}

public void testTransformEqualityOfMapsWithNullValues() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testTransformEqualityOfMapsWithNullValues();
}

public void testTransformEquals() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testTransformEquals();
}

public void testTransformIdentityFunctionEquality() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testTransformIdentityFunctionEquality();
}

public void testTransformPutEntryIsUnsupported() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testTransformPutEntryIsUnsupported();
}

public void testTransformReflectsUnderlyingMap() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testTransformReflectsUnderlyingMap();
}

public void testTransformRemoveEntry() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testTransformRemoveEntry();
}

public void testTransformSingletonMapEquality() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testTransformSingletonMapEquality();
}

public void testValues() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testValues();
}

public void testValuesClear() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesTest testCase = new com.google.common.collect.MapsTransformValuesTest();
  testCase.testValuesRetainAllNullFromEmpty();
}
}
