{-# LANGUAGE ForeignFunctionInterface #-}

#include <bindings.dsl.h>
#include <nettle/camellia.h>

module Bindings.Nettle.Cipher.Camellia where
#strict_import

#num CAMELLIA_BLOCK_SIZE
#num CAMELLIA128_KEY_SIZE
#num CAMELLIA192_KEY_SIZE
#num CAMELLIA256_KEY_SIZE

#starttype struct camellia128_ctx
#stoptype

#starttype struct camellia256_ctx
#stoptype

#ccall camellia128_set_encrypt_key , Ptr <struct camellia128_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall camellia128_set_decrypt_key , Ptr <struct camellia128_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall camellia128_invert_key , Ptr <struct camellia128_ctx> -> Ptr <struct camellia128_ctx> -> IO ()
#ccall camellia128_crypt , Ptr <struct camellia128_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()

#ccall camellia192_set_encrypt_key , Ptr <struct camellia256_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall camellia192_set_decrypt_key , Ptr <struct camellia256_ctx> -> CUInt -> Ptr CUChar -> IO ()

#ccall camellia256_set_encrypt_key , Ptr <struct camellia256_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall camellia256_set_decrypt_key , Ptr <struct camellia256_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall camellia256_invert_key , Ptr <struct camellia256_ctx> -> Ptr <struct camellia256_ctx> -> IO ()
#ccall camellia256_crypt , Ptr <struct camellia256_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()
