/*
 * hoz - Hacha Open Zource
 * Copyright (C) 2004 Gustavo Picon (http://hoz.sourceforge.net/)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

                         /* #define HOZ_WIN *//* uncomment to compile for ms windows (GUI  mode) */
/* #define HOZ_GTK */
/* language: Makefile will take care of these */
                             /* #define HOZ_LANG_EN *//* english */
                             /* #define HOZ_LANG_ES *//* espaol */
                             /* #define HOZ_LANG_FR *//* franaise */
#define HOZ_PROGRAM         "HOZ"
#define HOZ_VERSION         "1.65"
#define HOZ_URL             "http://hoz.sourceforge.net/"
#define HOZ_CRAUTH          "Copyright (c) 2004 Gustavo Picon"
#define HOZ_PROGNAME        HOZ_PROGRAM " " HOZ_VERSION
#define HOZ_COPYRIGHT1      HOZ_PROGNAME "  " HOZ_CRAUTH        /* "   " __DATE__ */
#define HOZ_COPYRIGHT2      "         " HOZ_URL
#define PROGRMETERSTR       " -"

#define MAXLEN 1024             /* max length of a pathname */
#define FILESTREAMSIZE 4096     /* < 4096 */
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>

#if defined(HOZ_LANG_EN)
#define HOZ_REPLACE_C       "Output file '%s' exists, replace? (Y/N) "
#define HOZ_BADARGSOPT      "%s: You must specify one of the '-cph' options"
#define HOZ_BADARGSFILE     "%s: Missing file argument"
#define HOZ_HMOREINFO       "Try '%s --help' for more information."
#define HOZ_USAGE_1         "%s [-pvf] [-c size[K|M]] [-o outpath] inputfname"
#define HOZ_USAGE_2         "Options:"
#define HOZ_USAGE_3         "    -c   --cut         cut (file->pieces)"
#define HOZ_USAGE_4         "    -p   --paste       paste (pieces->file)"
#define HOZ_USAGE_5         "    -v   --verbose     verbose output"
#define HOZ_USAGE_6         "    -f   --force       force overwrite of file when pasting"
#define HOZ_USAGE_7         "    -o   --outpath     specify an output directory"
#define HOZ_USAGE_8         "    -h   --help        print this help, then exit"
#define HOZ_USAGE_9         "         --version     print hoz program version number, then exit"
#define HOZ_ENDDOTO         "ERROR: The file must end with a '.0' extension"
#define HOZ_NOFILE          "ERROR: File not found: %s"
#define HOZ_BADHEADER       "ERROR: Corrupted file header: %s"
#define HOZ_BADPARTS        "ERROR: Corrupted .??? files, final_size/real_size: %s"
#define HOZ_ERROPENWRITE    "ERROR: Cannot open file for writing: %s"
#define HOZ_ERROPENREAD     "ERROR: Cannot open file for reading: %s"
#define HOZ_ERRPARTSIZE     "ERROR: Invalid partial size: %s"
#define HOZ_ERRPROCESS      "ERROR: Operation failed total_files/file_size: %s"
#define HOZ_ERROUTNODIR     "ERROR: Output path isn't a directory: '%s'"
#define HOZ_ERRWRITE        "ERROR: Couldn't write to file: '%s'"
#define HOZ_CUTTOFILE       "* Cutting to file \"%s\": "
#define HOZ_PROGRESS        "* Progress: %u of %u bytes (%.2f%%)"
#define HOZ_CUTEND          "*** Processed file: %s (%u bytes) in %.3f seconds (%u bytes/s) [output path='%s']"
#define HOZ_BEGINPASTE      "*** Extracting file: \"%s\" (%u bytes)"
#define HOZ_PASTEFILE       "* Extracting \"%s\": "
#define HOZ_PASTEMISSING    "ERROR: Missing file in paste operation: '%s'"
#define HOZ_PASTEEND        "*** Extracted file: %s (%u bytes) in %.3f seconds (%u bytes/s) [output path='%s']"
#define HOZ_REPLACE_W       "File '%s' exists, replace?"
#define HOZ_BADSIZE         "ERROR: Invalid size: '%s'"
#define HOZ_FDPASTE         "Hoz/Hacha file to paste"
#define HOZ_FDCUT           "File to cut"
#define HOZ_READY           "* Ready!"
#define HOZ_PSIZECAPTION    "Partial size:"
#define HOZ_OUTPCAPTION     "Output path:"
#define HOZ_CBPRGRCAPTION   "Show Progress"
#define HOZ_BTNCUTCAPTION   "Cut"
#define HOZ_BTNPASTECAPTION "Paste"
#define HOZ_YESCHARS        "yY"
#define HOZ_NOCHARS         "nN"
#endif                          /* #if defined(HOZ_LANG_EN) */

#if defined(HOZ_LANG_ES)
#define HOZ_REPLACE_C       "Archivo de salida '%s' ya existe, reemplazar? (S/N) "
#define HOZ_BADARGSOPT      "%s: Debes especificar una de las opciones '-cph'"
#define HOZ_BADARGSFILE     "%s: Falta argumento de archivo"
#define HOZ_HMOREINFO       "Intenta '%s -help' para mas informacion."
#define HOZ_USAGE_1         "%s [-pvf] [-c tamano[K|M]] [-o outpath] inputfname"
#define HOZ_USAGE_2         "Opciones:"
#define HOZ_USAGE_3         "    -c   --cut         cortar (archivo->piezas)"
#define HOZ_USAGE_4         "    -p   --paste       pegar (piezas->archivo)"
#define HOZ_USAGE_5         "    -v   --verbose     info. descriptiva"
#define HOZ_USAGE_6         "    -f   --force       forzar sobreescritura de archivo al pegar"
#define HOZ_USAGE_7         "    -o   --outpath     especificar un directorio de salida"
#define HOZ_USAGE_8         "    -h   --help        ayuda"
#define HOZ_USAGE_9         "         --version     print hoz program version number, then exit"
#if defined(WIN32) && defined(HOZ_WIN)
#define HOZ_BADPARTS        "ERROR: Archivos .??? corruptos, tamao_final/tamao_real: %s"
#define HOZ_ERRPARTSIZE     "ERROR: Tamao parcial no vlido: %s"
#define HOZ_ERRPROCESS      "ERROR: Operacin fallida total_archivos/tamao_archivo: %s"
#define HOZ_BADSIZE         "ERROR: Tamao no vlido: '%s'"
#else                           /* #if defined(WIN32) && defined(HOZ_WIN) */
#define HOZ_BADPARTS        "ERROR: Archivos .??? corruptos, tama\xA4o_final/tama\xA4o_real: %s"
#define HOZ_ERRPARTSIZE     "ERROR: Tama\xA4o parcial no v\xA0lido: %s"
#define HOZ_ERRPROCESS      "ERROR: Operaci\xA2n fallida total_archivos/tama\xA4o_archivo: %s"
#define HOZ_BADSIZE         "ERROR: Tama\xA4o no v\xA0lido: '%s'"
#endif                          /* #if defined(WIN32) && defined(HOZ_WIN) */
#define HOZ_PSIZECAPTION    "Tam. parcial:"
#define HOZ_ERROUTNODIR     "ERROR: Path de salida no es un directorio: '%s'"
#define HOZ_OUTPCAPTION     "Dir destino:"
#define HOZ_ENDDOTO         "ERROR: El archivo debe terminar con '.0'"
#define HOZ_NOFILE          "ERROR: Archivo no encontrado: %s"
#define HOZ_BADHEADER       "ERROR: Cabecera de archivo corrupta: %s"
#define HOZ_ERROPENWRITE    "ERROR: No se puede abrir archivo para escritura: %s"
#define HOZ_ERROPENREAD     "ERROR: No se puede abrir archivo para lectura: %s"
#define HOZ_ERRWRITE        "ERROR: No se pudo escribir al archivo: '%s'"
#define HOZ_CUTTOFILE       "* Cortando a archivo: \"%s\": "
#define HOZ_PROGRESS        "* Progreso: %u de %u bytes (%.2f%%)"
#define HOZ_CUTEND          "*** Archivo cortado: %s (%u bytes) en %.3f segundos (%u bytes/s) [path de sailda='%s']"
#define HOZ_BEGINPASTE      "*** Pegando archivo: \"%s\" (%u bytes)"
#define HOZ_PASTEFILE       "* Pegando \"%s\": "
#define HOZ_PASTEMISSING    "ERROR: Archivo no encontrado al pegar: '%s'"
#define HOZ_PASTEEND        "*** Archivo pegado: %s (%u bytes) en %.3f segundos (%u bytes/s) [path de salida='%s']"
#define HOZ_REPLACE_W       "Archivo '%s' existe, reemplazar?"
#define HOZ_FDPASTE         "Archivo de Hoz/Hacha a pegar"
#define HOZ_FDCUT           "Archivo a cortar"
#define HOZ_READY           "* Listo!"
#define HOZ_CBPRGRCAPTION   "Mostrar Progreso"
#define HOZ_BTNCUTCAPTION   "Cortar"
#define HOZ_BTNPASTECAPTION "Pegar"
#define HOZ_YESCHARS        "sS"
#define HOZ_NOCHARS         "nN"
#endif                          /* #if defined(HOZ_LANG_ES) */

#if defined(HOZ_LANG_FR)
#define HOZ_REPLACE_C       "Ce Fichier '%s' a t dj cr, vous  tes sr le remplacer? (OUI/NON) "
#define HOZ_BADARGSOPT      "%s: Debes especificar una de las opciones '-cph'"
#define HOZ_BADARGSFILE     "%s: Falta argumento de archivo"
#define HOZ_HMOREINFO       "Intenta '%s -help' para mas informacion."
#define HOZ_USAGE_1         "%s [-pvf] [-c tamano[K|M]] [-o outpath] inputfname"
#define HOZ_USAGE_2         "Opciones:"
#define HOZ_USAGE_3         "    -c   --cut         cortar"
#define HOZ_USAGE_4         "    -p   --paste       pegar"
#define HOZ_USAGE_5         "    -v   --verbose     descriptivo"
#define HOZ_USAGE_6         "    -f   --force       forzar sobreescritura de archivo al pegar"
#define HOZ_USAGE_7         "    -o   --outpath     especificar un directorio de salida"
#define HOZ_USAGE_8         "    -h   --help        ayuda"
#define HOZ_USAGE_9         "         --version     hoz version"
#define HOZ_BADPARTS        "ERREUR: Fichiers .??? corrompus, taille_finale/taille_real: %s"
#define HOZ_ERRPARTSIZE     "ERREUR: La taille partielle n'est pas valide: %s"
#define HOZ_ERRPROCESS      "ERREUR: Cet opratin n'est pas possible total_fichier/taille_fichier: %s"
#define HOZ_ERROUTNODIR     "ERROR: Output path isn't a directory: '%s'"
#define HOZ_ERRWRITE        "ERROR: Couldn't write to file: '%s'"
#define HOZ_BADSIZE         "ERREUR: Taille n'est pas valide: '%s'"
#define HOZ_PSIZECAPTION    "Taille parcielle:"
#define HOZ_OUTPCAPTION     "Output path:"
#define HOZ_ENDDOTO         "ERREUR: Le fichier doit terminer avec '.0'"
#define HOZ_NOFILE          "ERREUR: Ce fichier n'a pas t trouv: %s"
#define HOZ_BADHEADER       "ERREUR: La tte de ce fichier est corrompue: %s"
#define HOZ_ERROPENWRITE    "ERREUR: N'est pas possible ouvrir ce ficheur pour crire: %s"
#define HOZ_ERROPENREAD     "ERREUR: N'est pas possible ouvrir ce ficheur pour lire: %s"
#define HOZ_CUTTOFILE       "* En dcoupant vers le nouveau ficheur: \"%s\": "
#define HOZ_PROGRESS        "* Progrs: %u de %u bytes (%.2f%%)"
#define HOZ_CUTEND          "*** Fichier dcoup: %s (%u bytes) en %.3f seconds (%u bytes/s) [output path='%s']"
#define HOZ_BEGINPASTE      "*** En Collant fichier: \"%s\" (%u bytes)"
#define HOZ_PASTEFILE       "* En dcoupant \"%s\": "
#define HOZ_PASTEMISSING    "ERROR: Missing file in paste operation: '%s'"
#define HOZ_PASTEEND        "*** Fichier dcoup: %s (%u bytes) en %.3f seconds (%u bytes/s) [output path='%s']"
#define HOZ_REPLACE_W       "Ce fichier '%s' dj existe , le remplacer?"
#define HOZ_FDPASTE         "Ficheur de Hoz/Hacha  coller"
#define HOZ_FDCUT           "Ficheur  couper"
#define HOZ_READY           "* Voil!"
#define HOZ_CBPRGRCAPTION   "Montrer le progrs"
#define HOZ_BTNCUTCAPTION   "Dcouper"
#define HOZ_BTNPASTECAPTION "Coller"
#define HOZ_YESCHARS        "oO"
#define HOZ_NOCHARS         "nN"
#endif                          /* #if defined(HOZ_LANG_FR) */
void hoz_print(const char *);
void hoz_lf();

void hoz_echo(const int, const char *);
int hoz_cut_main(const char *);
int hoz_paste_main(const char *);
int hoz_paste_hr(const char *, const char *);
size_t fsize(const char *);
int isfile(const char *);
int isdir(const char *);
char *hoz_nopath(const char *);
int hoz_replace_ask(const char *);
int mergepath(const char *, const char *, char *);
int atolp(const char *);
int atolmp(const char*, const int);

