/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.execution.process;

import org.jetbrains.annotations.NotNull;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author Konstantin Kolosovsky.
 */
public class ProcessWrapper extends Process {

  @NotNull private final Process myOriginalProcess;

  public ProcessWrapper(@NotNull Process originalProcess) {
    myOriginalProcess = originalProcess;
  }

  @Override
  public OutputStream getOutputStream() {
    return myOriginalProcess.getOutputStream();
  }

  @Override
  public InputStream getInputStream() {
    return myOriginalProcess.getInputStream();
  }

  @Override
  public InputStream getErrorStream() {
    return myOriginalProcess.getErrorStream();
  }

  @Override
  public int waitFor() throws InterruptedException {
    return myOriginalProcess.waitFor();
  }

  @Override
  public int exitValue() {
    return myOriginalProcess.exitValue();
  }

  @Override
  public void destroy() {
    myOriginalProcess.destroy();
  }

  @NotNull
  public Process getOriginalProcess() {
    return myOriginalProcess;
  }
}
