// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/kata-containers/kata-containers/src/agent/protocols/protos/oci.proto

package grpc

import (
	bytes "bytes"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type Spec struct {
	// Version of the Open Container Initiative Runtime Specification with which the bundle complies.
	Version string `protobuf:"bytes,1,opt,name=Version,proto3" json:"Version,omitempty"`
	// Process configures the container process.
	Process *Process `protobuf:"bytes,2,opt,name=Process,proto3" json:"Process,omitempty"`
	// Root configures the container's root filesystem.
	Root *Root `protobuf:"bytes,3,opt,name=Root,proto3" json:"Root,omitempty"`
	// Hostname configures the container's hostname.
	Hostname string `protobuf:"bytes,4,opt,name=Hostname,proto3" json:"Hostname,omitempty"`
	// Mounts configures additional mounts (on top of Root).
	Mounts []Mount `protobuf:"bytes,5,rep,name=Mounts,proto3" json:"Mounts"`
	// Hooks configures callbacks for container lifecycle events.
	Hooks *Hooks `protobuf:"bytes,6,opt,name=Hooks,proto3" json:"Hooks,omitempty"`
	// Annotations contains arbitrary metadata for the container.
	Annotations map[string]string `protobuf:"bytes,7,rep,name=Annotations,proto3" json:"Annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Linux is platform-specific configuration for Linux based containers.
	Linux *Linux `protobuf:"bytes,8,opt,name=Linux,proto3" json:"Linux,omitempty"`
	// Solaris is platform-specific configuration for Solaris based containers.
	Solaris *Solaris `protobuf:"bytes,9,opt,name=Solaris,proto3" json:"Solaris,omitempty"`
	// Windows is platform-specific configuration for Windows based containers.
	Windows              *Windows `protobuf:"bytes,10,opt,name=Windows,proto3" json:"Windows,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Spec) Reset()      { *m = Spec{} }
func (*Spec) ProtoMessage() {}
func (*Spec) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{0}
}
func (m *Spec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Spec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Spec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Spec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Spec.Merge(m, src)
}
func (m *Spec) XXX_Size() int {
	return m.Size()
}
func (m *Spec) XXX_DiscardUnknown() {
	xxx_messageInfo_Spec.DiscardUnknown(m)
}

var xxx_messageInfo_Spec proto.InternalMessageInfo

type Process struct {
	// Terminal creates an interactive terminal for the container.
	Terminal bool `protobuf:"varint,1,opt,name=Terminal,proto3" json:"Terminal,omitempty"`
	// ConsoleSize specifies the size of the console.
	ConsoleSize *Box `protobuf:"bytes,2,opt,name=ConsoleSize,proto3" json:"ConsoleSize,omitempty"`
	// User specifies user information for the process.
	User User `protobuf:"bytes,3,opt,name=User,proto3" json:"User"`
	// Args specifies the binary and arguments for the application to execute.
	Args []string `protobuf:"bytes,4,rep,name=Args,proto3" json:"Args,omitempty"`
	// Env populates the process environment for the process.
	Env []string `protobuf:"bytes,5,rep,name=Env,proto3" json:"Env,omitempty"`
	// Cwd is the current working directory for the process and must be
	// relative to the container's root.
	Cwd string `protobuf:"bytes,6,opt,name=Cwd,proto3" json:"Cwd,omitempty"`
	// Capabilities are Linux capabilities that are kept for the process.
	Capabilities *LinuxCapabilities `protobuf:"bytes,7,opt,name=Capabilities,proto3" json:"Capabilities,omitempty"`
	// Rlimits specifies rlimit options to apply to the process.
	Rlimits []POSIXRlimit `protobuf:"bytes,8,rep,name=Rlimits,proto3" json:"Rlimits"`
	// NoNewPrivileges controls whether additional privileges could be gained by processes in the container.
	NoNewPrivileges bool `protobuf:"varint,9,opt,name=NoNewPrivileges,proto3" json:"NoNewPrivileges,omitempty"`
	// ApparmorProfile specifies the apparmor profile for the container.
	ApparmorProfile string `protobuf:"bytes,10,opt,name=ApparmorProfile,proto3" json:"ApparmorProfile,omitempty"`
	// Specify an oom_score_adj for the container.
	OOMScoreAdj int64 `protobuf:"varint,11,opt,name=OOMScoreAdj,proto3" json:"OOMScoreAdj,omitempty"`
	// SelinuxLabel specifies the selinux context that the container process is run as.
	SelinuxLabel         string   `protobuf:"bytes,12,opt,name=SelinuxLabel,proto3" json:"SelinuxLabel,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Process) Reset()      { *m = Process{} }
func (*Process) ProtoMessage() {}
func (*Process) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{1}
}
func (m *Process) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Process) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Process.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Process) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Process.Merge(m, src)
}
func (m *Process) XXX_Size() int {
	return m.Size()
}
func (m *Process) XXX_DiscardUnknown() {
	xxx_messageInfo_Process.DiscardUnknown(m)
}

var xxx_messageInfo_Process proto.InternalMessageInfo

type Box struct {
	// Height is the vertical dimension of a box.
	Height uint32 `protobuf:"varint,1,opt,name=Height,proto3" json:"Height,omitempty"`
	// Width is the horizontal dimension of a box.
	Width                uint32   `protobuf:"varint,2,opt,name=Width,proto3" json:"Width,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Box) Reset()      { *m = Box{} }
func (*Box) ProtoMessage() {}
func (*Box) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{2}
}
func (m *Box) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Box) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Box.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Box) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Box.Merge(m, src)
}
func (m *Box) XXX_Size() int {
	return m.Size()
}
func (m *Box) XXX_DiscardUnknown() {
	xxx_messageInfo_Box.DiscardUnknown(m)
}

var xxx_messageInfo_Box proto.InternalMessageInfo

type User struct {
	// UID is the user id.
	UID uint32 `protobuf:"varint,1,opt,name=UID,proto3" json:"UID,omitempty"`
	// GID is the group id.
	GID uint32 `protobuf:"varint,2,opt,name=GID,proto3" json:"GID,omitempty"`
	// AdditionalGids are additional group ids set for the container's process.
	AdditionalGids []uint32 `protobuf:"varint,3,rep,packed,name=AdditionalGids,proto3" json:"AdditionalGids,omitempty"`
	// Username is the user name.
	Username             string   `protobuf:"bytes,4,opt,name=Username,proto3" json:"Username,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *User) Reset()      { *m = User{} }
func (*User) ProtoMessage() {}
func (*User) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{3}
}
func (m *User) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_User.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_User.Merge(m, src)
}
func (m *User) XXX_Size() int {
	return m.Size()
}
func (m *User) XXX_DiscardUnknown() {
	xxx_messageInfo_User.DiscardUnknown(m)
}

var xxx_messageInfo_User proto.InternalMessageInfo

type LinuxCapabilities struct {
	// Bounding is the set of capabilities checked by the kernel.
	Bounding []string `protobuf:"bytes,1,rep,name=Bounding,proto3" json:"Bounding,omitempty"`
	// Effective is the set of capabilities checked by the kernel.
	Effective []string `protobuf:"bytes,2,rep,name=Effective,proto3" json:"Effective,omitempty"`
	// Inheritable is the capabilities preserved across execve.
	Inheritable []string `protobuf:"bytes,3,rep,name=Inheritable,proto3" json:"Inheritable,omitempty"`
	// Permitted is the limiting superset for effective capabilities.
	Permitted []string `protobuf:"bytes,4,rep,name=Permitted,proto3" json:"Permitted,omitempty"`
	// Ambient is the ambient set of capabilities that are kept.
	Ambient              []string `protobuf:"bytes,5,rep,name=Ambient,proto3" json:"Ambient,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxCapabilities) Reset()      { *m = LinuxCapabilities{} }
func (*LinuxCapabilities) ProtoMessage() {}
func (*LinuxCapabilities) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{4}
}
func (m *LinuxCapabilities) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxCapabilities) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxCapabilities.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxCapabilities) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxCapabilities.Merge(m, src)
}
func (m *LinuxCapabilities) XXX_Size() int {
	return m.Size()
}
func (m *LinuxCapabilities) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxCapabilities.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxCapabilities proto.InternalMessageInfo

type POSIXRlimit struct {
	// Type of the rlimit to set
	Type string `protobuf:"bytes,1,opt,name=Type,proto3" json:"Type,omitempty"`
	// Hard is the hard limit for the specified type
	Hard uint64 `protobuf:"varint,2,opt,name=Hard,proto3" json:"Hard,omitempty"`
	// Soft is the soft limit for the specified type
	Soft                 uint64   `protobuf:"varint,3,opt,name=Soft,proto3" json:"Soft,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *POSIXRlimit) Reset()      { *m = POSIXRlimit{} }
func (*POSIXRlimit) ProtoMessage() {}
func (*POSIXRlimit) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{5}
}
func (m *POSIXRlimit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *POSIXRlimit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_POSIXRlimit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *POSIXRlimit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_POSIXRlimit.Merge(m, src)
}
func (m *POSIXRlimit) XXX_Size() int {
	return m.Size()
}
func (m *POSIXRlimit) XXX_DiscardUnknown() {
	xxx_messageInfo_POSIXRlimit.DiscardUnknown(m)
}

var xxx_messageInfo_POSIXRlimit proto.InternalMessageInfo

type Mount struct {
	// destination is the path inside the container expect when it starts with "tmp:/"
	Destination string `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// source is the path inside the container expect when it starts with "vm:/dev/" or "tmp:/"
	// the path which starts with "vm:/dev/" refers the guest vm's "/dev",
	// especially, "vm:/dev/hostfs/" refers to the shared filesystem.
	// "tmp:/" is a temporary directory which is used for temporary mounts.
	Source               string   `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	Type                 string   `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	Options              []string `protobuf:"bytes,4,rep,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Mount) Reset()      { *m = Mount{} }
func (*Mount) ProtoMessage() {}
func (*Mount) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{6}
}
func (m *Mount) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Mount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Mount.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Mount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mount.Merge(m, src)
}
func (m *Mount) XXX_Size() int {
	return m.Size()
}
func (m *Mount) XXX_DiscardUnknown() {
	xxx_messageInfo_Mount.DiscardUnknown(m)
}

var xxx_messageInfo_Mount proto.InternalMessageInfo

type Root struct {
	// Path is the absolute path to the container's root filesystem.
	Path string `protobuf:"bytes,1,opt,name=Path,proto3" json:"Path,omitempty"`
	// Readonly makes the root filesystem for the container readonly before the process is executed.
	Readonly             bool     `protobuf:"varint,2,opt,name=Readonly,proto3" json:"Readonly,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Root) Reset()      { *m = Root{} }
func (*Root) ProtoMessage() {}
func (*Root) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{7}
}
func (m *Root) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Root) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Root.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Root) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Root.Merge(m, src)
}
func (m *Root) XXX_Size() int {
	return m.Size()
}
func (m *Root) XXX_DiscardUnknown() {
	xxx_messageInfo_Root.DiscardUnknown(m)
}

var xxx_messageInfo_Root proto.InternalMessageInfo

type Hooks struct {
	// Prestart is a list of hooks to be run before the container process is executed.
	Prestart []Hook `protobuf:"bytes,1,rep,name=Prestart,proto3" json:"Prestart"`
	// Poststart is a list of hooks to be run after the container process is started.
	Poststart []Hook `protobuf:"bytes,2,rep,name=Poststart,proto3" json:"Poststart"`
	// Poststop is a list of hooks to be run after the container process exits.
	Poststop             []Hook   `protobuf:"bytes,3,rep,name=Poststop,proto3" json:"Poststop"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Hooks) Reset()      { *m = Hooks{} }
func (*Hooks) ProtoMessage() {}
func (*Hooks) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{8}
}
func (m *Hooks) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Hooks) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Hooks.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Hooks) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Hooks.Merge(m, src)
}
func (m *Hooks) XXX_Size() int {
	return m.Size()
}
func (m *Hooks) XXX_DiscardUnknown() {
	xxx_messageInfo_Hooks.DiscardUnknown(m)
}

var xxx_messageInfo_Hooks proto.InternalMessageInfo

type Hook struct {
	Path                 string   `protobuf:"bytes,1,opt,name=Path,proto3" json:"Path,omitempty"`
	Args                 []string `protobuf:"bytes,2,rep,name=Args,proto3" json:"Args,omitempty"`
	Env                  []string `protobuf:"bytes,3,rep,name=Env,proto3" json:"Env,omitempty"`
	Timeout              int64    `protobuf:"varint,4,opt,name=Timeout,proto3" json:"Timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Hook) Reset()      { *m = Hook{} }
func (*Hook) ProtoMessage() {}
func (*Hook) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{9}
}
func (m *Hook) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Hook) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Hook.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Hook) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Hook.Merge(m, src)
}
func (m *Hook) XXX_Size() int {
	return m.Size()
}
func (m *Hook) XXX_DiscardUnknown() {
	xxx_messageInfo_Hook.DiscardUnknown(m)
}

var xxx_messageInfo_Hook proto.InternalMessageInfo

type Linux struct {
	// UIDMapping specifies user mappings for supporting user namespaces.
	UIDMappings []LinuxIDMapping `protobuf:"bytes,1,rep,name=UIDMappings,proto3" json:"UIDMappings"`
	// GIDMapping specifies group mappings for supporting user namespaces.
	GIDMappings []LinuxIDMapping `protobuf:"bytes,2,rep,name=GIDMappings,proto3" json:"GIDMappings"`
	// Sysctl are a set of key value pairs that are set for the container on start
	Sysctl map[string]string `protobuf:"bytes,3,rep,name=Sysctl,proto3" json:"Sysctl,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Resources contain cgroup information for handling resource constraints
	// for the container
	Resources *LinuxResources `protobuf:"bytes,4,opt,name=Resources,proto3" json:"Resources,omitempty"`
	// CgroupsPath specifies the path to cgroups that are created and/or joined by the container.
	// The path is expected to be relative to the cgroups mountpoint.
	// If resources are specified, the cgroups at CgroupsPath will be updated based on resources.
	CgroupsPath string `protobuf:"bytes,5,opt,name=CgroupsPath,proto3" json:"CgroupsPath,omitempty"`
	// Namespaces contains the namespaces that are created and/or joined by the container
	Namespaces []LinuxNamespace `protobuf:"bytes,6,rep,name=Namespaces,proto3" json:"Namespaces"`
	// Devices are a list of device nodes that are created for the container
	Devices []LinuxDevice `protobuf:"bytes,7,rep,name=Devices,proto3" json:"Devices"`
	// Seccomp specifies the seccomp security settings for the container.
	Seccomp *LinuxSeccomp `protobuf:"bytes,8,opt,name=Seccomp,proto3" json:"Seccomp,omitempty"`
	// RootfsPropagation is the rootfs mount propagation mode for the container.
	RootfsPropagation string `protobuf:"bytes,9,opt,name=RootfsPropagation,proto3" json:"RootfsPropagation,omitempty"`
	// MaskedPaths masks over the provided paths inside the container.
	MaskedPaths []string `protobuf:"bytes,10,rep,name=MaskedPaths,proto3" json:"MaskedPaths,omitempty"`
	// ReadonlyPaths sets the provided paths as RO inside the container.
	ReadonlyPaths []string `protobuf:"bytes,11,rep,name=ReadonlyPaths,proto3" json:"ReadonlyPaths,omitempty"`
	// MountLabel specifies the selinux context for the mounts in the container.
	MountLabel string `protobuf:"bytes,12,opt,name=MountLabel,proto3" json:"MountLabel,omitempty"`
	// IntelRdt contains Intel Resource Director Technology (RDT) information
	// for handling resource constraints (e.g., L3 cache) for the container
	IntelRdt             *LinuxIntelRdt `protobuf:"bytes,13,opt,name=IntelRdt,proto3" json:"IntelRdt,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Linux) Reset()      { *m = Linux{} }
func (*Linux) ProtoMessage() {}
func (*Linux) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{10}
}
func (m *Linux) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Linux) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Linux.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Linux) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Linux.Merge(m, src)
}
func (m *Linux) XXX_Size() int {
	return m.Size()
}
func (m *Linux) XXX_DiscardUnknown() {
	xxx_messageInfo_Linux.DiscardUnknown(m)
}

var xxx_messageInfo_Linux proto.InternalMessageInfo

type Windows struct {
	// Dummy string, never used.
	Dummy                string   `protobuf:"bytes,1,opt,name=dummy,proto3" json:"dummy,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Windows) Reset()      { *m = Windows{} }
func (*Windows) ProtoMessage() {}
func (*Windows) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{11}
}
func (m *Windows) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Windows) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Windows.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Windows) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Windows.Merge(m, src)
}
func (m *Windows) XXX_Size() int {
	return m.Size()
}
func (m *Windows) XXX_DiscardUnknown() {
	xxx_messageInfo_Windows.DiscardUnknown(m)
}

var xxx_messageInfo_Windows proto.InternalMessageInfo

type Solaris struct {
	// Dummy string, never used.
	Dummy                string   `protobuf:"bytes,1,opt,name=dummy,proto3" json:"dummy,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Solaris) Reset()      { *m = Solaris{} }
func (*Solaris) ProtoMessage() {}
func (*Solaris) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{12}
}
func (m *Solaris) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Solaris) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Solaris.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Solaris) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Solaris.Merge(m, src)
}
func (m *Solaris) XXX_Size() int {
	return m.Size()
}
func (m *Solaris) XXX_DiscardUnknown() {
	xxx_messageInfo_Solaris.DiscardUnknown(m)
}

var xxx_messageInfo_Solaris proto.InternalMessageInfo

type LinuxIDMapping struct {
	// HostID is the starting UID/GID on the host to be mapped to 'ContainerID'
	HostID uint32 `protobuf:"varint,1,opt,name=HostID,proto3" json:"HostID,omitempty"`
	// ContainerID is the starting UID/GID in the container
	ContainerID uint32 `protobuf:"varint,2,opt,name=ContainerID,proto3" json:"ContainerID,omitempty"`
	// Size is the number of IDs to be mapped
	Size_                uint32   `protobuf:"varint,3,opt,name=Size,proto3" json:"Size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxIDMapping) Reset()      { *m = LinuxIDMapping{} }
func (*LinuxIDMapping) ProtoMessage() {}
func (*LinuxIDMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{13}
}
func (m *LinuxIDMapping) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxIDMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxIDMapping.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxIDMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxIDMapping.Merge(m, src)
}
func (m *LinuxIDMapping) XXX_Size() int {
	return m.Size()
}
func (m *LinuxIDMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxIDMapping.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxIDMapping proto.InternalMessageInfo

type LinuxNamespace struct {
	// Type is the type of namespace
	Type string `protobuf:"bytes,1,opt,name=Type,proto3" json:"Type,omitempty"`
	// Path is a path to an existing namespace persisted on disk that can be joined
	// and is of the same type
	Path                 string   `protobuf:"bytes,2,opt,name=Path,proto3" json:"Path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxNamespace) Reset()      { *m = LinuxNamespace{} }
func (*LinuxNamespace) ProtoMessage() {}
func (*LinuxNamespace) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{14}
}
func (m *LinuxNamespace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxNamespace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxNamespace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxNamespace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxNamespace.Merge(m, src)
}
func (m *LinuxNamespace) XXX_Size() int {
	return m.Size()
}
func (m *LinuxNamespace) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxNamespace.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxNamespace proto.InternalMessageInfo

type LinuxDevice struct {
	// Path to the device.
	Path string `protobuf:"bytes,1,opt,name=Path,proto3" json:"Path,omitempty"`
	// Device type, block, char, etc.
	Type string `protobuf:"bytes,2,opt,name=Type,proto3" json:"Type,omitempty"`
	// Major is the device's major number.
	Major int64 `protobuf:"varint,3,opt,name=Major,proto3" json:"Major,omitempty"`
	// Minor is the device's minor number.
	Minor int64 `protobuf:"varint,4,opt,name=Minor,proto3" json:"Minor,omitempty"`
	// FileMode permission bits for the device.
	FileMode uint32 `protobuf:"varint,5,opt,name=FileMode,proto3" json:"FileMode,omitempty"`
	// UID of the device.
	UID uint32 `protobuf:"varint,6,opt,name=UID,proto3" json:"UID,omitempty"`
	// Gid of the device.
	GID                  uint32   `protobuf:"varint,7,opt,name=GID,proto3" json:"GID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxDevice) Reset()      { *m = LinuxDevice{} }
func (*LinuxDevice) ProtoMessage() {}
func (*LinuxDevice) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{15}
}
func (m *LinuxDevice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxDevice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxDevice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxDevice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxDevice.Merge(m, src)
}
func (m *LinuxDevice) XXX_Size() int {
	return m.Size()
}
func (m *LinuxDevice) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxDevice.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxDevice proto.InternalMessageInfo

type LinuxResources struct {
	// Devices configures the device whitelist.
	Devices []LinuxDeviceCgroup `protobuf:"bytes,1,rep,name=Devices,proto3" json:"Devices"`
	// Memory restriction configuration
	Memory *LinuxMemory `protobuf:"bytes,2,opt,name=Memory,proto3" json:"Memory,omitempty"`
	// CPU resource restriction configuration
	CPU *LinuxCPU `protobuf:"bytes,3,opt,name=CPU,proto3" json:"CPU,omitempty"`
	// Task resource restriction configuration.
	Pids *LinuxPids `protobuf:"bytes,4,opt,name=Pids,proto3" json:"Pids,omitempty"`
	// BlockIO restriction configuration
	BlockIO *LinuxBlockIO `protobuf:"bytes,5,opt,name=BlockIO,proto3" json:"BlockIO,omitempty"`
	// Hugetlb limit (in bytes)
	HugepageLimits []LinuxHugepageLimit `protobuf:"bytes,6,rep,name=HugepageLimits,proto3" json:"HugepageLimits"`
	// Network restriction configuration
	Network              *LinuxNetwork `protobuf:"bytes,7,opt,name=Network,proto3" json:"Network,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LinuxResources) Reset()      { *m = LinuxResources{} }
func (*LinuxResources) ProtoMessage() {}
func (*LinuxResources) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{16}
}
func (m *LinuxResources) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxResources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxResources.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxResources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxResources.Merge(m, src)
}
func (m *LinuxResources) XXX_Size() int {
	return m.Size()
}
func (m *LinuxResources) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxResources.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxResources proto.InternalMessageInfo

type LinuxMemory struct {
	// Memory limit (in bytes).
	Limit int64 `protobuf:"varint,1,opt,name=Limit,proto3" json:"Limit,omitempty"`
	// Memory reservation or soft_limit (in bytes).
	Reservation int64 `protobuf:"varint,2,opt,name=Reservation,proto3" json:"Reservation,omitempty"`
	// Total memory limit (memory + swap).
	Swap int64 `protobuf:"varint,3,opt,name=Swap,proto3" json:"Swap,omitempty"`
	// Kernel memory limit (in bytes).
	Kernel int64 `protobuf:"varint,4,opt,name=Kernel,proto3" json:"Kernel,omitempty"`
	// Kernel memory limit for tcp (in bytes)
	KernelTCP int64 `protobuf:"varint,5,opt,name=KernelTCP,proto3" json:"KernelTCP,omitempty"`
	// How aggressive the kernel will swap memory pages.
	Swappiness uint64 `protobuf:"varint,6,opt,name=Swappiness,proto3" json:"Swappiness,omitempty"`
	// DisableOOMKiller disables the OOM killer for out of memory conditions
	DisableOOMKiller     bool     `protobuf:"varint,7,opt,name=DisableOOMKiller,proto3" json:"DisableOOMKiller,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxMemory) Reset()      { *m = LinuxMemory{} }
func (*LinuxMemory) ProtoMessage() {}
func (*LinuxMemory) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{17}
}
func (m *LinuxMemory) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxMemory) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxMemory.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxMemory) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxMemory.Merge(m, src)
}
func (m *LinuxMemory) XXX_Size() int {
	return m.Size()
}
func (m *LinuxMemory) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxMemory.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxMemory proto.InternalMessageInfo

type LinuxCPU struct {
	// CPU shares (relative weight (ratio) vs. other cgroups with cpu shares).
	Shares uint64 `protobuf:"varint,1,opt,name=Shares,proto3" json:"Shares,omitempty"`
	// CPU hardcap limit (in usecs). Allowed cpu time in a given period.
	Quota int64 `protobuf:"varint,2,opt,name=Quota,proto3" json:"Quota,omitempty"`
	// CPU period to be used for hardcapping (in usecs).
	Period uint64 `protobuf:"varint,3,opt,name=Period,proto3" json:"Period,omitempty"`
	// How much time realtime scheduling may use (in usecs).
	RealtimeRuntime int64 `protobuf:"varint,4,opt,name=RealtimeRuntime,proto3" json:"RealtimeRuntime,omitempty"`
	// CPU period to be used for realtime scheduling (in usecs).
	RealtimePeriod uint64 `protobuf:"varint,5,opt,name=RealtimePeriod,proto3" json:"RealtimePeriod,omitempty"`
	// CPUs to use within the cpuset. Default is to use any CPU available.
	Cpus string `protobuf:"bytes,6,opt,name=Cpus,proto3" json:"Cpus,omitempty"`
	// List of memory nodes in the cpuset. Default is to use any available memory node.
	Mems                 string   `protobuf:"bytes,7,opt,name=Mems,proto3" json:"Mems,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxCPU) Reset()      { *m = LinuxCPU{} }
func (*LinuxCPU) ProtoMessage() {}
func (*LinuxCPU) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{18}
}
func (m *LinuxCPU) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxCPU) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxCPU.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxCPU) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxCPU.Merge(m, src)
}
func (m *LinuxCPU) XXX_Size() int {
	return m.Size()
}
func (m *LinuxCPU) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxCPU.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxCPU proto.InternalMessageInfo

type LinuxWeightDevice struct {
	// Major is the device's major number.
	Major int64 `protobuf:"varint,1,opt,name=Major,proto3" json:"Major,omitempty"`
	// Minor is the device's minor number.
	Minor int64 `protobuf:"varint,2,opt,name=Minor,proto3" json:"Minor,omitempty"`
	// Weight is the bandwidth rate for the device.
	Weight uint32 `protobuf:"varint,3,opt,name=Weight,proto3" json:"Weight,omitempty"`
	// LeafWeight is the bandwidth rate for the device while competing with the cgroup's child cgroups, CFQ scheduler only
	LeafWeight           uint32   `protobuf:"varint,4,opt,name=LeafWeight,proto3" json:"LeafWeight,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxWeightDevice) Reset()      { *m = LinuxWeightDevice{} }
func (*LinuxWeightDevice) ProtoMessage() {}
func (*LinuxWeightDevice) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{19}
}
func (m *LinuxWeightDevice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxWeightDevice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxWeightDevice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxWeightDevice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxWeightDevice.Merge(m, src)
}
func (m *LinuxWeightDevice) XXX_Size() int {
	return m.Size()
}
func (m *LinuxWeightDevice) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxWeightDevice.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxWeightDevice proto.InternalMessageInfo

type LinuxThrottleDevice struct {
	// Major is the device's major number.
	Major int64 `protobuf:"varint,1,opt,name=Major,proto3" json:"Major,omitempty"`
	// Minor is the device's minor number.
	Minor int64 `protobuf:"varint,2,opt,name=Minor,proto3" json:"Minor,omitempty"`
	// Rate is the IO rate limit per cgroup per device
	Rate                 uint64   `protobuf:"varint,3,opt,name=Rate,proto3" json:"Rate,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxThrottleDevice) Reset()      { *m = LinuxThrottleDevice{} }
func (*LinuxThrottleDevice) ProtoMessage() {}
func (*LinuxThrottleDevice) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{20}
}
func (m *LinuxThrottleDevice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxThrottleDevice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxThrottleDevice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxThrottleDevice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxThrottleDevice.Merge(m, src)
}
func (m *LinuxThrottleDevice) XXX_Size() int {
	return m.Size()
}
func (m *LinuxThrottleDevice) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxThrottleDevice.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxThrottleDevice proto.InternalMessageInfo

type LinuxBlockIO struct {
	// Specifies per cgroup weight
	Weight uint32 `protobuf:"varint,1,opt,name=Weight,proto3" json:"Weight,omitempty"`
	// Specifies tasks' weight in the given cgroup while competing with the cgroup's child cgroups, CFQ scheduler only
	LeafWeight uint32 `protobuf:"varint,2,opt,name=LeafWeight,proto3" json:"LeafWeight,omitempty"`
	// Weight per cgroup per device, can override BlkioWeight
	WeightDevice []LinuxWeightDevice `protobuf:"bytes,3,rep,name=WeightDevice,proto3" json:"WeightDevice"`
	// IO read rate limit per cgroup per device, bytes per second
	ThrottleReadBpsDevice []LinuxThrottleDevice `protobuf:"bytes,4,rep,name=ThrottleReadBpsDevice,proto3" json:"ThrottleReadBpsDevice"`
	// IO write rate limit per cgroup per device, bytes per second
	ThrottleWriteBpsDevice []LinuxThrottleDevice `protobuf:"bytes,5,rep,name=ThrottleWriteBpsDevice,proto3" json:"ThrottleWriteBpsDevice"`
	// IO read rate limit per cgroup per device, IO per second
	ThrottleReadIOPSDevice []LinuxThrottleDevice `protobuf:"bytes,6,rep,name=ThrottleReadIOPSDevice,proto3" json:"ThrottleReadIOPSDevice"`
	// IO write rate limit per cgroup per device, IO per second
	ThrottleWriteIOPSDevice []LinuxThrottleDevice `protobuf:"bytes,7,rep,name=ThrottleWriteIOPSDevice,proto3" json:"ThrottleWriteIOPSDevice"`
	XXX_NoUnkeyedLiteral    struct{}              `json:"-"`
	XXX_unrecognized        []byte                `json:"-"`
	XXX_sizecache           int32                 `json:"-"`
}

func (m *LinuxBlockIO) Reset()      { *m = LinuxBlockIO{} }
func (*LinuxBlockIO) ProtoMessage() {}
func (*LinuxBlockIO) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{21}
}
func (m *LinuxBlockIO) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxBlockIO) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxBlockIO.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxBlockIO) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxBlockIO.Merge(m, src)
}
func (m *LinuxBlockIO) XXX_Size() int {
	return m.Size()
}
func (m *LinuxBlockIO) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxBlockIO.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxBlockIO proto.InternalMessageInfo

type LinuxPids struct {
	// Maximum number of PIDs. Default is "no limit".
	Limit                int64    `protobuf:"varint,1,opt,name=Limit,proto3" json:"Limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxPids) Reset()      { *m = LinuxPids{} }
func (*LinuxPids) ProtoMessage() {}
func (*LinuxPids) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{22}
}
func (m *LinuxPids) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxPids) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxPids.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxPids) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxPids.Merge(m, src)
}
func (m *LinuxPids) XXX_Size() int {
	return m.Size()
}
func (m *LinuxPids) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxPids.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxPids proto.InternalMessageInfo

type LinuxDeviceCgroup struct {
	// Allow or deny
	Allow bool `protobuf:"varint,1,opt,name=Allow,proto3" json:"Allow,omitempty"`
	// Device type, block, char, etc.
	Type string `protobuf:"bytes,2,opt,name=Type,proto3" json:"Type,omitempty"`
	// Major is the device's major number.
	Major int64 `protobuf:"varint,3,opt,name=Major,proto3" json:"Major,omitempty"`
	// Minor is the device's minor number.
	Minor int64 `protobuf:"varint,4,opt,name=Minor,proto3" json:"Minor,omitempty"`
	// Cgroup access permissions format, rwm.
	Access               string   `protobuf:"bytes,5,opt,name=Access,proto3" json:"Access,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxDeviceCgroup) Reset()      { *m = LinuxDeviceCgroup{} }
func (*LinuxDeviceCgroup) ProtoMessage() {}
func (*LinuxDeviceCgroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{23}
}
func (m *LinuxDeviceCgroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxDeviceCgroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxDeviceCgroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxDeviceCgroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxDeviceCgroup.Merge(m, src)
}
func (m *LinuxDeviceCgroup) XXX_Size() int {
	return m.Size()
}
func (m *LinuxDeviceCgroup) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxDeviceCgroup.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxDeviceCgroup proto.InternalMessageInfo

type LinuxNetwork struct {
	// Set class identifier for container's network packets
	ClassID uint32 `protobuf:"varint,1,opt,name=ClassID,proto3" json:"ClassID,omitempty"`
	// Set priority of network traffic for container
	Priorities           []LinuxInterfacePriority `protobuf:"bytes,2,rep,name=Priorities,proto3" json:"Priorities"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *LinuxNetwork) Reset()      { *m = LinuxNetwork{} }
func (*LinuxNetwork) ProtoMessage() {}
func (*LinuxNetwork) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{24}
}
func (m *LinuxNetwork) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxNetwork) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxNetwork.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxNetwork) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxNetwork.Merge(m, src)
}
func (m *LinuxNetwork) XXX_Size() int {
	return m.Size()
}
func (m *LinuxNetwork) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxNetwork.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxNetwork proto.InternalMessageInfo

type LinuxHugepageLimit struct {
	// Pagesize is the hugepage size
	Pagesize string `protobuf:"bytes,1,opt,name=Pagesize,proto3" json:"Pagesize,omitempty"`
	// Limit is the limit of "hugepagesize" hugetlb usage
	Limit                uint64   `protobuf:"varint,2,opt,name=Limit,proto3" json:"Limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxHugepageLimit) Reset()      { *m = LinuxHugepageLimit{} }
func (*LinuxHugepageLimit) ProtoMessage() {}
func (*LinuxHugepageLimit) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{25}
}
func (m *LinuxHugepageLimit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxHugepageLimit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxHugepageLimit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxHugepageLimit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxHugepageLimit.Merge(m, src)
}
func (m *LinuxHugepageLimit) XXX_Size() int {
	return m.Size()
}
func (m *LinuxHugepageLimit) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxHugepageLimit.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxHugepageLimit proto.InternalMessageInfo

type LinuxInterfacePriority struct {
	// Name is the name of the network interface
	Name string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	// Priority for the interface
	Priority             uint32   `protobuf:"varint,2,opt,name=Priority,proto3" json:"Priority,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxInterfacePriority) Reset()      { *m = LinuxInterfacePriority{} }
func (*LinuxInterfacePriority) ProtoMessage() {}
func (*LinuxInterfacePriority) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{26}
}
func (m *LinuxInterfacePriority) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxInterfacePriority) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxInterfacePriority.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxInterfacePriority) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxInterfacePriority.Merge(m, src)
}
func (m *LinuxInterfacePriority) XXX_Size() int {
	return m.Size()
}
func (m *LinuxInterfacePriority) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxInterfacePriority.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxInterfacePriority proto.InternalMessageInfo

type LinuxSeccomp struct {
	DefaultAction        string         `protobuf:"bytes,1,opt,name=DefaultAction,proto3" json:"DefaultAction,omitempty"`
	Architectures        []string       `protobuf:"bytes,2,rep,name=Architectures,proto3" json:"Architectures,omitempty"`
	Flags                []string       `protobuf:"bytes,3,rep,name=Flags,proto3" json:"Flags,omitempty"`
	Syscalls             []LinuxSyscall `protobuf:"bytes,4,rep,name=Syscalls,proto3" json:"Syscalls"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *LinuxSeccomp) Reset()      { *m = LinuxSeccomp{} }
func (*LinuxSeccomp) ProtoMessage() {}
func (*LinuxSeccomp) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{27}
}
func (m *LinuxSeccomp) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxSeccomp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxSeccomp.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxSeccomp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxSeccomp.Merge(m, src)
}
func (m *LinuxSeccomp) XXX_Size() int {
	return m.Size()
}
func (m *LinuxSeccomp) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxSeccomp.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxSeccomp proto.InternalMessageInfo

type LinuxSeccompArg struct {
	Index                uint64   `protobuf:"varint,1,opt,name=Index,proto3" json:"Index,omitempty"`
	Value                uint64   `protobuf:"varint,2,opt,name=Value,proto3" json:"Value,omitempty"`
	ValueTwo             uint64   `protobuf:"varint,3,opt,name=ValueTwo,proto3" json:"ValueTwo,omitempty"`
	Op                   string   `protobuf:"bytes,4,opt,name=Op,proto3" json:"Op,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxSeccompArg) Reset()      { *m = LinuxSeccompArg{} }
func (*LinuxSeccompArg) ProtoMessage() {}
func (*LinuxSeccompArg) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{28}
}
func (m *LinuxSeccompArg) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxSeccompArg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxSeccompArg.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxSeccompArg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxSeccompArg.Merge(m, src)
}
func (m *LinuxSeccompArg) XXX_Size() int {
	return m.Size()
}
func (m *LinuxSeccompArg) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxSeccompArg.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxSeccompArg proto.InternalMessageInfo

type LinuxSyscall struct {
	Names  []string `protobuf:"bytes,1,rep,name=Names,proto3" json:"Names,omitempty"`
	Action string   `protobuf:"bytes,2,opt,name=Action,proto3" json:"Action,omitempty"`
	// Types that are valid to be assigned to ErrnoRet:
	//	*LinuxSyscall_Errnoret
	ErrnoRet             isLinuxSyscall_ErrnoRet `protobuf_oneof:"ErrnoRet"`
	Args                 []LinuxSeccompArg       `protobuf:"bytes,4,rep,name=Args,proto3" json:"Args"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *LinuxSyscall) Reset()      { *m = LinuxSyscall{} }
func (*LinuxSyscall) ProtoMessage() {}
func (*LinuxSyscall) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{29}
}
func (m *LinuxSyscall) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxSyscall) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxSyscall.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxSyscall) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxSyscall.Merge(m, src)
}
func (m *LinuxSyscall) XXX_Size() int {
	return m.Size()
}
func (m *LinuxSyscall) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxSyscall.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxSyscall proto.InternalMessageInfo

type isLinuxSyscall_ErrnoRet interface {
	isLinuxSyscall_ErrnoRet()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type LinuxSyscall_Errnoret struct {
	Errnoret uint32 `protobuf:"varint,3,opt,name=errnoret,proto3,oneof" json:"errnoret,omitempty"`
}

func (*LinuxSyscall_Errnoret) isLinuxSyscall_ErrnoRet() {}

func (m *LinuxSyscall) GetErrnoRet() isLinuxSyscall_ErrnoRet {
	if m != nil {
		return m.ErrnoRet
	}
	return nil
}

func (m *LinuxSyscall) GetErrnoret() uint32 {
	if x, ok := m.GetErrnoRet().(*LinuxSyscall_Errnoret); ok {
		return x.Errnoret
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LinuxSyscall) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LinuxSyscall_Errnoret)(nil),
	}
}

type LinuxIntelRdt struct {
	// The schema for L3 cache id and capacity bitmask (CBM)
	// Format: "L3:<cache_id0>=<cbm0>;<cache_id1>=<cbm1>;..."
	L3CacheSchema        string   `protobuf:"bytes,1,opt,name=L3CacheSchema,proto3" json:"L3CacheSchema,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxIntelRdt) Reset()      { *m = LinuxIntelRdt{} }
func (*LinuxIntelRdt) ProtoMessage() {}
func (*LinuxIntelRdt) Descriptor() ([]byte, []int) {
	return fileDescriptor_e42fef2823778fc8, []int{30}
}
func (m *LinuxIntelRdt) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxIntelRdt) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxIntelRdt.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxIntelRdt) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxIntelRdt.Merge(m, src)
}
func (m *LinuxIntelRdt) XXX_Size() int {
	return m.Size()
}
func (m *LinuxIntelRdt) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxIntelRdt.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxIntelRdt proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Spec)(nil), "grpc.Spec")
	proto.RegisterMapType((map[string]string)(nil), "grpc.Spec.AnnotationsEntry")
	proto.RegisterType((*Process)(nil), "grpc.Process")
	proto.RegisterType((*Box)(nil), "grpc.Box")
	proto.RegisterType((*User)(nil), "grpc.User")
	proto.RegisterType((*LinuxCapabilities)(nil), "grpc.LinuxCapabilities")
	proto.RegisterType((*POSIXRlimit)(nil), "grpc.POSIXRlimit")
	proto.RegisterType((*Mount)(nil), "grpc.Mount")
	proto.RegisterType((*Root)(nil), "grpc.Root")
	proto.RegisterType((*Hooks)(nil), "grpc.Hooks")
	proto.RegisterType((*Hook)(nil), "grpc.Hook")
	proto.RegisterType((*Linux)(nil), "grpc.Linux")
	proto.RegisterMapType((map[string]string)(nil), "grpc.Linux.SysctlEntry")
	proto.RegisterType((*Windows)(nil), "grpc.Windows")
	proto.RegisterType((*Solaris)(nil), "grpc.Solaris")
	proto.RegisterType((*LinuxIDMapping)(nil), "grpc.LinuxIDMapping")
	proto.RegisterType((*LinuxNamespace)(nil), "grpc.LinuxNamespace")
	proto.RegisterType((*LinuxDevice)(nil), "grpc.LinuxDevice")
	proto.RegisterType((*LinuxResources)(nil), "grpc.LinuxResources")
	proto.RegisterType((*LinuxMemory)(nil), "grpc.LinuxMemory")
	proto.RegisterType((*LinuxCPU)(nil), "grpc.LinuxCPU")
	proto.RegisterType((*LinuxWeightDevice)(nil), "grpc.LinuxWeightDevice")
	proto.RegisterType((*LinuxThrottleDevice)(nil), "grpc.LinuxThrottleDevice")
	proto.RegisterType((*LinuxBlockIO)(nil), "grpc.LinuxBlockIO")
	proto.RegisterType((*LinuxPids)(nil), "grpc.LinuxPids")
	proto.RegisterType((*LinuxDeviceCgroup)(nil), "grpc.LinuxDeviceCgroup")
	proto.RegisterType((*LinuxNetwork)(nil), "grpc.LinuxNetwork")
	proto.RegisterType((*LinuxHugepageLimit)(nil), "grpc.LinuxHugepageLimit")
	proto.RegisterType((*LinuxInterfacePriority)(nil), "grpc.LinuxInterfacePriority")
	proto.RegisterType((*LinuxSeccomp)(nil), "grpc.LinuxSeccomp")
	proto.RegisterType((*LinuxSeccompArg)(nil), "grpc.LinuxSeccompArg")
	proto.RegisterType((*LinuxSyscall)(nil), "grpc.LinuxSyscall")
	proto.RegisterType((*LinuxIntelRdt)(nil), "grpc.LinuxIntelRdt")
}

func init() {
	proto.RegisterFile("github.com/kata-containers/kata-containers/src/agent/protocols/protos/oci.proto", fileDescriptor_e42fef2823778fc8)
}

var fileDescriptor_e42fef2823778fc8 = []byte{
	// 2118 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0xcb, 0x73, 0x5b, 0x49,
	0xd5, 0xcf, 0x95, 0x64, 0x59, 0x6a, 0xc5, 0x79, 0xf4, 0x64, 0x32, 0xf7, 0xcb, 0x97, 0xd2, 0x78,
	0x2e, 0x29, 0x30, 0x10, 0xec, 0x22, 0xe1, 0x31, 0x0c, 0x8f, 0x2a, 0xd9, 0x4e, 0x62, 0xd5, 0xc4,
	0x91, 0x68, 0xd9, 0x13, 0x98, 0xc5, 0x54, 0xb5, 0xaf, 0xda, 0x52, 0x8f, 0xaf, 0x6e, 0xdf, 0xea,
	0xdb, 0xb2, 0x63, 0x56, 0xb0, 0x63, 0xcf, 0x82, 0x35, 0x1b, 0x1e, 0xff, 0x01, 0xc5, 0x8a, 0x1d,
	0x29, 0x56, 0x2c, 0xa9, 0xa2, 0x0a, 0x88, 0xf7, 0xec, 0x59, 0x52, 0xa7, 0xfb, 0xdc, 0xab, 0x96,
	0xe4, 0xc0, 0x04, 0x56, 0xea, 0xf3, 0x3b, 0x8f, 0x7e, 0x9c, 0xe7, 0x15, 0xe9, 0x8d, 0xa4, 0x19,
	0x4f, 0x8f, 0x36, 0x63, 0x35, 0xd9, 0x3a, 0xe1, 0x86, 0x7f, 0x25, 0x56, 0xa9, 0xe1, 0x32, 0x15,
	0x3a, 0x5f, 0xa2, 0x73, 0x1d, 0x6f, 0xf1, 0x91, 0x48, 0xcd, 0x56, 0xa6, 0x95, 0x51, 0xb1, 0x4a,
	0x72, 0xb7, 0xca, 0xb7, 0x54, 0x2c, 0x37, 0xed, 0x92, 0xd6, 0x46, 0x3a, 0x8b, 0xef, 0x44, 0x23,
	0x35, 0x52, 0x8e, 0x79, 0x34, 0x3d, 0xde, 0x02, 0xca, 0x12, 0x76, 0xe5, 0x24, 0xa3, 0x3f, 0x54,
	0x49, 0x6d, 0x90, 0x89, 0x98, 0x86, 0x64, 0xf5, 0x23, 0xa1, 0x73, 0xa9, 0xd2, 0x30, 0x58, 0x0f,
	0x36, 0x9a, 0xac, 0x20, 0xe9, 0x17, 0xc8, 0x6a, 0x5f, 0xab, 0x58, 0xe4, 0x79, 0x58, 0x59, 0x0f,
	0x36, 0x5a, 0x0f, 0xd6, 0x36, 0xc1, 0xfc, 0x26, 0x82, 0xac, 0xe0, 0xd2, 0x36, 0xa9, 0x31, 0xa5,
	0x4c, 0x58, 0xb5, 0x52, 0xc4, 0x49, 0x01, 0xc2, 0x2c, 0x4e, 0xef, 0x90, 0xc6, 0x9e, 0xca, 0x4d,
	0xca, 0x27, 0x22, 0xac, 0xd9, 0x3d, 0x4a, 0x9a, 0x7e, 0x91, 0xd4, 0xf7, 0xd5, 0x34, 0x35, 0x79,
	0xb8, 0xb2, 0x5e, 0xdd, 0x68, 0x3d, 0x68, 0x39, 0x6d, 0x8b, 0x6d, 0xd7, 0x5e, 0xfe, 0xf5, 0xdd,
	0x2b, 0x0c, 0x05, 0xe8, 0x7b, 0x64, 0x65, 0x4f, 0xa9, 0x93, 0x3c, 0xac, 0xdb, 0x7d, 0x50, 0xd2,
	0x42, 0xcc, 0x71, 0xe8, 0x77, 0x49, 0xab, 0x93, 0xa6, 0xca, 0x70, 0x23, 0x55, 0x9a, 0x87, 0xab,
	0xd6, 0xe4, 0xff, 0x3b, 0x41, 0xb8, 0xed, 0xa6, 0xc7, 0x7d, 0x94, 0x1a, 0x7d, 0xce, 0x7c, 0x79,
	0xd8, 0xe1, 0xa9, 0x4c, 0xa7, 0x2f, 0xc2, 0x86, 0xbf, 0x83, 0x85, 0x98, 0xe3, 0xc0, 0xa3, 0x0c,
	0x54, 0xc2, 0xb5, 0xcc, 0xc3, 0xa6, 0xff, 0x28, 0x08, 0xb2, 0x82, 0x0b, 0x82, 0xcf, 0x65, 0x3a,
	0x54, 0x67, 0x79, 0x48, 0x7c, 0x41, 0x04, 0x59, 0xc1, 0xbd, 0xf3, 0x3d, 0x72, 0x63, 0xf1, 0x54,
	0xf4, 0x06, 0xa9, 0x9e, 0x88, 0x73, 0x74, 0x08, 0x2c, 0xe9, 0x2d, 0xb2, 0x72, 0xca, 0x93, 0xa9,
	0xb0, 0xae, 0x68, 0x32, 0x47, 0x7c, 0x50, 0x79, 0x3f, 0x88, 0x7e, 0x57, 0x2d, 0xfd, 0x04, 0x2f,
	0x7d, 0x20, 0xf4, 0x44, 0xa6, 0x3c, 0xb1, 0xca, 0x0d, 0x56, 0xd2, 0xf4, 0xcb, 0xa4, 0xb5, 0xa3,
	0xd2, 0x5c, 0x25, 0x62, 0x20, 0x7f, 0x24, 0xd0, 0xa5, 0x4d, 0x77, 0xa8, 0x6d, 0xf5, 0x82, 0xf9,
	0x5c, 0x7a, 0x8f, 0xd4, 0x0e, 0x73, 0xa1, 0xe7, 0x5d, 0x0a, 0x08, 0xfa, 0xc4, 0x72, 0x29, 0x25,
	0xb5, 0x8e, 0x1e, 0xe5, 0x61, 0x6d, 0xbd, 0xba, 0xd1, 0x64, 0x76, 0x0d, 0x47, 0x7f, 0x94, 0x9e,
	0x5a, 0x6f, 0x36, 0x19, 0x2c, 0x01, 0xd9, 0x39, 0x1b, 0x5a, 0xaf, 0x35, 0x19, 0x2c, 0xe9, 0xb7,
	0xc9, 0xd5, 0x1d, 0x9e, 0xf1, 0x23, 0x99, 0x48, 0x23, 0x05, 0xf8, 0x09, 0x76, 0x79, 0xc7, 0x7b,
	0x6e, 0x9f, 0xcd, 0xe6, 0x84, 0xe9, 0x57, 0xc9, 0x2a, 0x4b, 0xe4, 0x44, 0x9a, 0x3c, 0x6c, 0x58,
	0xff, 0xde, 0xc4, 0xb0, 0xec, 0x0d, 0xba, 0x3f, 0x70, 0x1c, 0x3c, 0x64, 0x21, 0x47, 0x37, 0xc8,
	0xf5, 0x67, 0xea, 0x99, 0x38, 0xeb, 0x6b, 0x79, 0x2a, 0x13, 0x31, 0x12, 0xce, 0x79, 0x0d, 0xb6,
	0x08, 0x83, 0x64, 0x27, 0xcb, 0xb8, 0x9e, 0x28, 0xdd, 0xd7, 0xea, 0x58, 0x26, 0xc2, 0x7a, 0xaf,
	0xc9, 0x16, 0x61, 0xba, 0x4e, 0x5a, 0xbd, 0xde, 0xfe, 0x20, 0x56, 0x5a, 0x74, 0x86, 0x9f, 0x86,
	0xad, 0xf5, 0x60, 0xa3, 0xca, 0x7c, 0x88, 0x46, 0xe4, 0xea, 0x40, 0x24, 0x70, 0x9b, 0xa7, 0xfc,
	0x48, 0x24, 0xe1, 0x55, 0x6b, 0x68, 0x0e, 0x8b, 0x1e, 0x92, 0xea, 0xb6, 0x7a, 0x41, 0x6f, 0x93,
	0xfa, 0x9e, 0x90, 0xa3, 0xb1, 0xb1, 0x5e, 0x5b, 0x63, 0x48, 0x81, 0xd7, 0x9f, 0xcb, 0xa1, 0x19,
	0x5b, 0x6f, 0xad, 0x31, 0x47, 0x44, 0xa9, 0x73, 0x0e, 0x3c, 0xec, 0x61, 0x77, 0x17, 0x55, 0x60,
	0x09, 0xc8, 0x93, 0xee, 0x2e, 0x4a, 0xc3, 0x92, 0x7e, 0x9e, 0x5c, 0xeb, 0x0c, 0x87, 0x12, 0x62,
	0x8b, 0x27, 0x4f, 0xe4, 0x30, 0x0f, 0xab, 0xeb, 0xd5, 0x8d, 0x35, 0xb6, 0x80, 0x42, 0xe4, 0x80,
	0x4d, 0x3f, 0x47, 0x0b, 0x3a, 0xfa, 0x55, 0x40, 0x6e, 0x2e, 0x79, 0x05, 0x34, 0xb6, 0xd5, 0x34,
	0x1d, 0xca, 0x74, 0x14, 0x06, 0xd6, 0xdb, 0x25, 0x4d, 0xef, 0x92, 0xe6, 0xa3, 0xe3, 0x63, 0x11,
	0x1b, 0x79, 0x0a, 0x91, 0x06, 0xcc, 0x19, 0x00, 0x4f, 0xd7, 0x4d, 0xc7, 0x42, 0x4b, 0xc3, 0x8f,
	0x12, 0x61, 0x0f, 0xd4, 0x64, 0x3e, 0x04, 0xfa, 0x7d, 0x88, 0x5b, 0x63, 0xc4, 0x10, 0xa3, 0x6b,
	0x06, 0x40, 0xc9, 0xea, 0x4c, 0x8e, 0xa4, 0x48, 0x0d, 0x86, 0x59, 0x41, 0x46, 0x5d, 0xd2, 0xf2,
	0xc2, 0x00, 0xe2, 0xf3, 0xe0, 0x3c, 0x13, 0x98, 0x47, 0x76, 0x0d, 0xd8, 0x1e, 0xd7, 0x43, 0xfb,
	0x46, 0x35, 0x66, 0xd7, 0x80, 0x0d, 0xd4, 0xb1, 0x2b, 0x60, 0x35, 0x66, 0xd7, 0x91, 0x22, 0x2b,
	0xb6, 0xee, 0xc0, 0x69, 0x87, 0x22, 0x37, 0x32, 0xb5, 0x09, 0x8a, 0xb6, 0x7c, 0x08, 0xbc, 0x97,
	0xab, 0xa9, 0x8e, 0x8b, 0xe4, 0x44, 0x0a, 0xcc, 0x1a, 0xd8, 0xbe, 0xea, 0xb6, 0x87, 0x35, 0x9c,
	0x5d, 0x65, 0xae, 0x3a, 0xb9, 0x7b, 0x15, 0x64, 0xf4, 0x0d, 0x57, 0x45, 0x41, 0xab, 0xcf, 0xcd,
	0xb8, 0x38, 0x34, 0xac, 0xe1, 0xad, 0x99, 0xe0, 0x43, 0x95, 0x26, 0xe7, 0x76, 0x8f, 0x06, 0x2b,
	0xe9, 0xe8, 0x67, 0x01, 0xd6, 0x45, 0x7a, 0x9f, 0x34, 0xfa, 0x5a, 0xe4, 0x86, 0x6b, 0x63, 0x3d,
	0x52, 0x26, 0x2e, 0xb0, 0x31, 0x27, 0x4a, 0x09, 0xba, 0x49, 0x9a, 0x7d, 0x95, 0x1b, 0x27, 0x5e,
	0x79, 0x8d, 0xf8, 0x4c, 0xc4, 0x5a, 0xb7, 0x84, 0xca, 0xac, 0xcb, 0x2e, 0xb7, 0x8e, 0x12, 0xd1,
	0xc7, 0xa4, 0x06, 0xf8, 0xa5, 0xb7, 0x29, 0xca, 0x46, 0x65, 0xb9, 0x6c, 0x54, 0x67, 0x65, 0x23,
	0x24, 0xab, 0x07, 0x72, 0x22, 0xd4, 0xd4, 0xd8, 0x80, 0xac, 0xb2, 0x82, 0x8c, 0x7e, 0xb3, 0x82,
	0x75, 0x9a, 0x7e, 0x87, 0xb4, 0x0e, 0xbb, 0xbb, 0xfb, 0x3c, 0xcb, 0x64, 0x3a, 0xca, 0xf1, 0xd2,
	0xb7, 0xbc, 0x3a, 0x52, 0x32, 0xf1, 0x80, 0xbe, 0x38, 0x68, 0x3f, 0xf1, 0xb4, 0x2b, 0xff, 0x59,
	0xdb, 0x13, 0xa7, 0x5b, 0xa4, 0x3e, 0x38, 0xcf, 0x63, 0x93, 0xe0, 0x6b, 0xf8, 0xe5, 0x6b, 0xd3,
	0x71, 0x5c, 0x8b, 0x41, 0x31, 0xfa, 0x80, 0x34, 0x99, 0x70, 0xa1, 0x91, 0xdb, 0x2b, 0xcd, 0x6f,
	0x56, 0xf2, 0xd8, 0x4c, 0x0c, 0x82, 0x6f, 0x67, 0xa4, 0xd5, 0x34, 0xcb, 0xed, 0x2b, 0xae, 0xb8,
	0xe0, 0xf3, 0x20, 0xfa, 0x01, 0x21, 0xcf, 0xf8, 0x44, 0xe4, 0x19, 0x07, 0xb3, 0xf5, 0xa5, 0x3b,
	0x94, 0x4c, 0xbc, 0x83, 0x27, 0x0d, 0xa5, 0x74, 0x57, 0x9c, 0xca, 0x58, 0x14, 0xad, 0xf2, 0xa6,
	0xa7, 0xe8, 0x38, 0x45, 0x29, 0x45, 0x39, 0x7a, 0x9f, 0xac, 0x0e, 0x44, 0x1c, 0xab, 0x49, 0x86,
	0x4d, 0x92, 0x7a, 0x2a, 0xc8, 0x61, 0x85, 0x08, 0xbd, 0x4f, 0x6e, 0x42, 0x4c, 0x1f, 0xe7, 0x7d,
	0xad, 0x32, 0x3e, 0x72, 0x19, 0xd4, 0xb4, 0x97, 0x58, 0x66, 0xc0, 0x65, 0xf7, 0x79, 0x7e, 0x22,
	0x86, 0x70, 0x31, 0x68, 0x9b, 0xb6, 0x2e, 0x78, 0x10, 0xbd, 0x47, 0xd6, 0x8a, 0xb8, 0x77, 0x32,
	0x2d, 0x2b, 0x33, 0x0f, 0xd2, 0x36, 0x21, 0x36, 0x75, 0xfd, 0xb2, 0xeb, 0x21, 0x74, 0x8b, 0x34,
	0xba, 0xa9, 0x11, 0x09, 0x1b, 0x9a, 0x70, 0xcd, 0x5e, 0xe2, 0x2d, 0xdf, 0xe9, 0xc8, 0x62, 0xa5,
	0xd0, 0x9d, 0x6f, 0x91, 0x96, 0xe7, 0xd0, 0x37, 0xea, 0xce, 0xef, 0x96, 0x63, 0x00, 0x08, 0x0d,
	0xa7, 0x93, 0x49, 0xa1, 0xe8, 0x08, 0x10, 0x28, 0x46, 0x86, 0xcb, 0x05, 0x3e, 0x21, 0xd7, 0xe6,
	0x83, 0xd1, 0x76, 0x0b, 0x95, 0x9b, 0xb2, 0xf4, 0x23, 0x65, 0x83, 0xa5, 0x18, 0x18, 0xcb, 0x2e,
	0xe0, 0x43, 0xb6, 0xd0, 0x41, 0xf3, 0xaf, 0x5a, 0x96, 0x5d, 0x47, 0xef, 0xa3, 0xfd, 0x32, 0x2e,
	0x5e, 0x57, 0x36, 0x6d, 0x04, 0x56, 0x66, 0x79, 0x1c, 0xfd, 0x22, 0x20, 0x2d, 0x2f, 0x54, 0x5e,
	0x97, 0xeb, 0xd6, 0x56, 0xc5, 0xb3, 0x75, 0x8b, 0xac, 0xec, 0xf3, 0x4f, 0x95, 0x9b, 0x2e, 0xaa,
	0xcc, 0x11, 0x16, 0x95, 0xa9, 0xd2, 0x98, 0xed, 0x8e, 0x80, 0xca, 0xf7, 0x58, 0x26, 0x62, 0x5f,
	0x0d, 0x85, 0x8d, 0xfe, 0x35, 0x56, 0xd2, 0x45, 0xff, 0xab, 0x2f, 0xf5, 0xbf, 0xd5, 0xb2, 0xff,
	0x45, 0x7f, 0xab, 0xe0, 0xf5, 0x66, 0x39, 0xf5, 0xcd, 0x59, 0xd4, 0x07, 0x4b, 0x99, 0xeb, 0x38,
	0x2e, 0xc1, 0x16, 0x63, 0x1f, 0x66, 0x55, 0x31, 0x51, 0xfa, 0x1c, 0x87, 0x27, 0x3f, 0x5b, 0x1c,
	0x83, 0xa1, 0x00, 0x5d, 0x27, 0xd5, 0x9d, 0xfe, 0x21, 0x8e, 0x4f, 0xd7, 0xfc, 0xc1, 0xa6, 0x7f,
	0xc8, 0x80, 0x45, 0x3f, 0x47, 0x6a, 0x7d, 0x68, 0xc7, 0xae, 0x10, 0x5c, 0xf7, 0x44, 0x00, 0x66,
	0x96, 0x09, 0xd9, 0xb6, 0x9d, 0xa8, 0xf8, 0xa4, 0xdb, 0xb3, 0x97, 0x9f, 0xcf, 0x36, 0xe4, 0xb0,
	0x42, 0x84, 0x3e, 0x26, 0xd7, 0xf6, 0xa6, 0x23, 0x91, 0xf1, 0x91, 0x78, 0xea, 0x06, 0x24, 0x57,
	0x0e, 0x42, 0x4f, 0x69, 0x4e, 0x00, 0x2f, 0xb8, 0xa0, 0x05, 0xbb, 0x3e, 0x13, 0xe6, 0x4c, 0xe9,
	0x13, 0x9c, 0xcc, 0xfc, 0x5d, 0x91, 0xc3, 0x0a, 0x91, 0xe8, 0x2f, 0x45, 0x14, 0xe0, 0xd5, 0x6f,
	0x41, 0x71, 0x9e, 0x48, 0x37, 0xca, 0x54, 0x99, 0x23, 0x20, 0x36, 0x99, 0xc8, 0x85, 0x3e, 0x75,
	0x35, 0xa0, 0xe2, 0xc6, 0x25, 0x0f, 0xb2, 0xb1, 0x79, 0xc6, 0x33, 0x0c, 0x0a, 0xbb, 0x86, 0x48,
	0xff, 0x50, 0xe8, 0x54, 0x24, 0x18, 0x14, 0x48, 0xc1, 0x7c, 0xe0, 0x56, 0x07, 0x3b, 0x7d, 0xfb,
	0x32, 0x55, 0x36, 0x03, 0x20, 0xff, 0x41, 0x3b, 0x93, 0x29, 0x7c, 0xbb, 0xd4, 0x6d, 0x53, 0xf7,
	0x10, 0xfa, 0x25, 0x72, 0x63, 0x57, 0xe6, 0x30, 0x68, 0xf4, 0x7a, 0xfb, 0x1f, 0xca, 0x24, 0x11,
	0xda, 0x5e, 0xb4, 0xc1, 0x96, 0xf0, 0xe8, 0x8f, 0x01, 0x69, 0x14, 0x8e, 0x83, 0xe3, 0x0c, 0xc6,
	0x5c, 0xdb, 0xc0, 0x01, 0xa3, 0x48, 0xc1, 0x95, 0xbf, 0x3f, 0x55, 0x86, 0xe3, 0xb5, 0x1c, 0x01,
	0xd2, 0x7d, 0xa1, 0xa5, 0x1a, 0xe2, 0x5c, 0x81, 0x14, 0xcc, 0x98, 0x4c, 0xf0, 0xc4, 0xc8, 0x89,
	0x60, 0xd3, 0x14, 0x7e, 0xf0, 0x76, 0x8b, 0x30, 0x0c, 0x6f, 0x05, 0x84, 0x96, 0x56, 0xac, 0xa5,
	0x05, 0x14, 0x9e, 0x6e, 0x27, 0x9b, 0xe6, 0x38, 0x62, 0xdb, 0x35, 0x60, 0xfb, 0x62, 0xe2, 0x66,
	0xeb, 0x26, 0xb3, 0xeb, 0xe8, 0x0c, 0xe7, 0xb8, 0xe7, 0x76, 0xba, 0xc4, 0xac, 0x2d, 0xb3, 0x31,
	0xb8, 0x34, 0x1b, 0x2b, 0x7e, 0x36, 0xde, 0x26, 0x75, 0xa7, 0x8b, 0x15, 0x04, 0x29, 0x78, 0xf1,
	0xa7, 0x82, 0x1f, 0x23, 0xaf, 0x66, 0x79, 0x1e, 0x12, 0x1d, 0x92, 0xb7, 0xec, 0xc6, 0x07, 0x63,
	0xad, 0x8c, 0x49, 0xc4, 0x7f, 0xb1, 0x35, 0x25, 0x35, 0xc6, 0x8d, 0x28, 0x66, 0x34, 0x58, 0x47,
	0xff, 0xa8, 0x92, 0xab, 0x7e, 0x2a, 0x78, 0xe7, 0x0b, 0xfe, 0xcd, 0xf9, 0x2a, 0x8b, 0xe7, 0xa3,
	0x1d, 0x72, 0xd5, 0x7f, 0x93, 0x4b, 0x3a, 0xba, 0xcf, 0xc6, 0xb4, 0x99, 0x53, 0xa1, 0x87, 0xe4,
	0xed, 0xe2, 0x76, 0xd0, 0x8d, 0xb6, 0xb3, 0x1c, 0x6d, 0xd5, 0xac, 0xad, 0xff, 0xf3, 0x6c, 0xcd,
	0xbf, 0x02, 0x5a, 0xbb, 0x5c, 0x9b, 0x3e, 0x27, 0xb7, 0x0b, 0xc6, 0x73, 0x2d, 0x8d, 0x98, 0xd9,
	0x5d, 0xf9, 0x6c, 0x76, 0x5f, 0xa3, 0xee, 0x1b, 0x86, 0x1d, 0xbb, 0xbd, 0xfe, 0x00, 0x0d, 0xd7,
	0xdf, 0xd0, 0xf0, 0xbc, 0x3a, 0xfd, 0x21, 0x79, 0x67, 0x6e, 0x4b, 0xcf, 0xf2, 0xea, 0x67, 0xb3,
	0xfc, 0x3a, 0xfd, 0xe8, 0x3d, 0xd2, 0x2c, 0x2b, 0xe4, 0xe5, 0x75, 0x26, 0xfa, 0x49, 0xf1, 0xad,
	0xe2, 0x17, 0x72, 0x90, 0xed, 0x24, 0x89, 0x3a, 0xc3, 0x8f, 0x62, 0x47, 0xfc, 0xcf, 0xbd, 0xe9,
	0x36, 0xa9, 0x77, 0x62, 0xfb, 0xff, 0x88, 0x9b, 0xcb, 0x90, 0x8a, 0x12, 0x8c, 0x4a, 0xac, 0x90,
	0x30, 0xc9, 0xee, 0x24, 0x3c, 0xcf, 0xcb, 0x86, 0x5d, 0x90, 0x74, 0x9b, 0x90, 0xbe, 0x96, 0x4a,
	0xbb, 0xcf, 0x60, 0x37, 0x80, 0xde, 0x5d, 0x98, 0x45, 0xf4, 0x31, 0x8f, 0x05, 0x4a, 0x9d, 0x17,
	0x43, 0xdc, 0x4c, 0x2b, 0x7a, 0x4c, 0xe8, 0x72, 0x65, 0x87, 0xbe, 0xd9, 0xe7, 0x23, 0x91, 0x43,
	0xb7, 0x77, 0xfd, 0xb8, 0xa4, 0x67, 0x2f, 0xe7, 0xbe, 0x81, 0xf0, 0xe5, 0xf6, 0xc8, 0xed, 0xcb,
	0xf7, 0x84, 0x77, 0x82, 0xe1, 0xa0, 0xe8, 0xeb, 0xb0, 0xb6, 0xf6, 0x91, 0x8f, 0xf9, 0x54, 0xd2,
	0xd1, 0x2f, 0x03, 0x7c, 0x80, 0x62, 0x0c, 0xbc, 0x47, 0xd6, 0x76, 0xc5, 0x31, 0x9f, 0x26, 0xa6,
	0x13, 0x7b, 0x1f, 0x51, 0xf3, 0x20, 0x48, 0x75, 0x74, 0x3c, 0x96, 0x46, 0xc4, 0x66, 0xaa, 0x45,
	0xf1, 0x7d, 0x30, 0x0f, 0xc2, 0xe1, 0x1f, 0x27, 0x7c, 0x94, 0xe3, 0xa7, 0x82, 0x23, 0xe8, 0xd7,
	0x48, 0x03, 0x26, 0x34, 0x9e, 0x24, 0x39, 0x26, 0xdc, 0xdc, 0x5c, 0xea, 0x58, 0xc5, 0x47, 0x4a,
	0x21, 0x19, 0x49, 0x72, 0xdd, 0x3f, 0x67, 0x47, 0x8f, 0xc0, 0x7c, 0x37, 0x1d, 0x8a, 0x17, 0x58,
	0xe1, 0x1d, 0x01, 0xe8, 0x47, 0xe5, 0x7c, 0x57, 0x63, 0x8e, 0x80, 0x37, 0xb0, 0x8b, 0x83, 0x33,
	0x85, 0x65, 0xa9, 0xa4, 0xe9, 0x35, 0x52, 0xe9, 0x65, 0xf8, 0x25, 0x5d, 0xe9, 0x65, 0xd1, 0xcf,
	0xcb, 0x37, 0x71, 0x9b, 0x83, 0x49, 0x3b, 0x71, 0xe1, 0xb7, 0xb3, 0x23, 0x5c, 0x48, 0x95, 0x1d,
	0xd2, 0x86, 0x94, 0x7d, 0x9b, 0xbb, 0xa4, 0x21, 0xb4, 0x4e, 0x95, 0x16, 0x58, 0x7a, 0xf7, 0xae,
	0xb0, 0x12, 0xa1, 0x5b, 0xde, 0xff, 0x30, 0xad, 0x07, 0x6f, 0x2f, 0x4f, 0xe4, 0x1d, 0x5d, 0x7c,
	0xc2, 0x58, 0xc1, 0x6d, 0x42, 0x1a, 0x8f, 0x40, 0x99, 0x09, 0x13, 0x7d, 0x9d, 0xac, 0xcd, 0xcd,
	0xbd, 0xe0, 0x87, 0xa7, 0x0f, 0x77, 0x78, 0x3c, 0x16, 0x83, 0x78, 0x2c, 0x26, 0xbc, 0xf0, 0xd6,
	0x1c, 0xb8, 0xfd, 0xd3, 0xe0, 0xe5, 0xab, 0xf6, 0x95, 0x3f, 0xbf, 0x6a, 0x5f, 0xf9, 0xe7, 0xab,
	0x76, 0xf0, 0xe3, 0x8b, 0x76, 0xf0, 0xeb, 0x8b, 0x76, 0xf0, 0xdb, 0x8b, 0x76, 0xf0, 0xfb, 0x8b,
	0x76, 0xf0, 0xf2, 0xa2, 0x1d, 0xfc, 0xe9, 0xa2, 0x1d, 0xfc, 0xfd, 0xa2, 0x1d, 0x7c, 0xfc, 0xc9,
	0x1b, 0xfe, 0xcd, 0xa9, 0x5d, 0xfb, 0xdb, 0x3a, 0x95, 0xda, 0x78, 0xac, 0xec, 0x64, 0xb4, 0xf4,
	0x0f, 0x28, 0xdc, 0xf4, 0xa8, 0x6e, 0xe9, 0x87, 0xff, 0x0a, 0x00, 0x00, 0xff, 0xff, 0xfb, 0x3e,
	0xc9, 0x10, 0x4f, 0x15, 0x00, 0x00,
}

func (this *Spec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Spec)
	if !ok {
		that2, ok := that.(Spec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if !this.Process.Equal(that1.Process) {
		return false
	}
	if !this.Root.Equal(that1.Root) {
		return false
	}
	if this.Hostname != that1.Hostname {
		return false
	}
	if len(this.Mounts) != len(that1.Mounts) {
		return false
	}
	for i := range this.Mounts {
		if !this.Mounts[i].Equal(&that1.Mounts[i]) {
			return false
		}
	}
	if !this.Hooks.Equal(that1.Hooks) {
		return false
	}
	if len(this.Annotations) != len(that1.Annotations) {
		return false
	}
	for i := range this.Annotations {
		if this.Annotations[i] != that1.Annotations[i] {
			return false
		}
	}
	if !this.Linux.Equal(that1.Linux) {
		return false
	}
	if !this.Solaris.Equal(that1.Solaris) {
		return false
	}
	if !this.Windows.Equal(that1.Windows) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Process) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Process)
	if !ok {
		that2, ok := that.(Process)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Terminal != that1.Terminal {
		return false
	}
	if !this.ConsoleSize.Equal(that1.ConsoleSize) {
		return false
	}
	if !this.User.Equal(&that1.User) {
		return false
	}
	if len(this.Args) != len(that1.Args) {
		return false
	}
	for i := range this.Args {
		if this.Args[i] != that1.Args[i] {
			return false
		}
	}
	if len(this.Env) != len(that1.Env) {
		return false
	}
	for i := range this.Env {
		if this.Env[i] != that1.Env[i] {
			return false
		}
	}
	if this.Cwd != that1.Cwd {
		return false
	}
	if !this.Capabilities.Equal(that1.Capabilities) {
		return false
	}
	if len(this.Rlimits) != len(that1.Rlimits) {
		return false
	}
	for i := range this.Rlimits {
		if !this.Rlimits[i].Equal(&that1.Rlimits[i]) {
			return false
		}
	}
	if this.NoNewPrivileges != that1.NoNewPrivileges {
		return false
	}
	if this.ApparmorProfile != that1.ApparmorProfile {
		return false
	}
	if this.OOMScoreAdj != that1.OOMScoreAdj {
		return false
	}
	if this.SelinuxLabel != that1.SelinuxLabel {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Box) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Box)
	if !ok {
		that2, ok := that.(Box)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Height != that1.Height {
		return false
	}
	if this.Width != that1.Width {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *User) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*User)
	if !ok {
		that2, ok := that.(User)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.UID != that1.UID {
		return false
	}
	if this.GID != that1.GID {
		return false
	}
	if len(this.AdditionalGids) != len(that1.AdditionalGids) {
		return false
	}
	for i := range this.AdditionalGids {
		if this.AdditionalGids[i] != that1.AdditionalGids[i] {
			return false
		}
	}
	if this.Username != that1.Username {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxCapabilities) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxCapabilities)
	if !ok {
		that2, ok := that.(LinuxCapabilities)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Bounding) != len(that1.Bounding) {
		return false
	}
	for i := range this.Bounding {
		if this.Bounding[i] != that1.Bounding[i] {
			return false
		}
	}
	if len(this.Effective) != len(that1.Effective) {
		return false
	}
	for i := range this.Effective {
		if this.Effective[i] != that1.Effective[i] {
			return false
		}
	}
	if len(this.Inheritable) != len(that1.Inheritable) {
		return false
	}
	for i := range this.Inheritable {
		if this.Inheritable[i] != that1.Inheritable[i] {
			return false
		}
	}
	if len(this.Permitted) != len(that1.Permitted) {
		return false
	}
	for i := range this.Permitted {
		if this.Permitted[i] != that1.Permitted[i] {
			return false
		}
	}
	if len(this.Ambient) != len(that1.Ambient) {
		return false
	}
	for i := range this.Ambient {
		if this.Ambient[i] != that1.Ambient[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *POSIXRlimit) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*POSIXRlimit)
	if !ok {
		that2, ok := that.(POSIXRlimit)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Hard != that1.Hard {
		return false
	}
	if this.Soft != that1.Soft {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Mount) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Mount)
	if !ok {
		that2, ok := that.(Mount)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Destination != that1.Destination {
		return false
	}
	if this.Source != that1.Source {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if len(this.Options) != len(that1.Options) {
		return false
	}
	for i := range this.Options {
		if this.Options[i] != that1.Options[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Root) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Root)
	if !ok {
		that2, ok := that.(Root)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.Readonly != that1.Readonly {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Hooks) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Hooks)
	if !ok {
		that2, ok := that.(Hooks)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Prestart) != len(that1.Prestart) {
		return false
	}
	for i := range this.Prestart {
		if !this.Prestart[i].Equal(&that1.Prestart[i]) {
			return false
		}
	}
	if len(this.Poststart) != len(that1.Poststart) {
		return false
	}
	for i := range this.Poststart {
		if !this.Poststart[i].Equal(&that1.Poststart[i]) {
			return false
		}
	}
	if len(this.Poststop) != len(that1.Poststop) {
		return false
	}
	for i := range this.Poststop {
		if !this.Poststop[i].Equal(&that1.Poststop[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Hook) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Hook)
	if !ok {
		that2, ok := that.(Hook)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if len(this.Args) != len(that1.Args) {
		return false
	}
	for i := range this.Args {
		if this.Args[i] != that1.Args[i] {
			return false
		}
	}
	if len(this.Env) != len(that1.Env) {
		return false
	}
	for i := range this.Env {
		if this.Env[i] != that1.Env[i] {
			return false
		}
	}
	if this.Timeout != that1.Timeout {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Linux) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Linux)
	if !ok {
		that2, ok := that.(Linux)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.UIDMappings) != len(that1.UIDMappings) {
		return false
	}
	for i := range this.UIDMappings {
		if !this.UIDMappings[i].Equal(&that1.UIDMappings[i]) {
			return false
		}
	}
	if len(this.GIDMappings) != len(that1.GIDMappings) {
		return false
	}
	for i := range this.GIDMappings {
		if !this.GIDMappings[i].Equal(&that1.GIDMappings[i]) {
			return false
		}
	}
	if len(this.Sysctl) != len(that1.Sysctl) {
		return false
	}
	for i := range this.Sysctl {
		if this.Sysctl[i] != that1.Sysctl[i] {
			return false
		}
	}
	if !this.Resources.Equal(that1.Resources) {
		return false
	}
	if this.CgroupsPath != that1.CgroupsPath {
		return false
	}
	if len(this.Namespaces) != len(that1.Namespaces) {
		return false
	}
	for i := range this.Namespaces {
		if !this.Namespaces[i].Equal(&that1.Namespaces[i]) {
			return false
		}
	}
	if len(this.Devices) != len(that1.Devices) {
		return false
	}
	for i := range this.Devices {
		if !this.Devices[i].Equal(&that1.Devices[i]) {
			return false
		}
	}
	if !this.Seccomp.Equal(that1.Seccomp) {
		return false
	}
	if this.RootfsPropagation != that1.RootfsPropagation {
		return false
	}
	if len(this.MaskedPaths) != len(that1.MaskedPaths) {
		return false
	}
	for i := range this.MaskedPaths {
		if this.MaskedPaths[i] != that1.MaskedPaths[i] {
			return false
		}
	}
	if len(this.ReadonlyPaths) != len(that1.ReadonlyPaths) {
		return false
	}
	for i := range this.ReadonlyPaths {
		if this.ReadonlyPaths[i] != that1.ReadonlyPaths[i] {
			return false
		}
	}
	if this.MountLabel != that1.MountLabel {
		return false
	}
	if !this.IntelRdt.Equal(that1.IntelRdt) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Windows) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Windows)
	if !ok {
		that2, ok := that.(Windows)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Dummy != that1.Dummy {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Solaris) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Solaris)
	if !ok {
		that2, ok := that.(Solaris)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Dummy != that1.Dummy {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxIDMapping) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxIDMapping)
	if !ok {
		that2, ok := that.(LinuxIDMapping)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HostID != that1.HostID {
		return false
	}
	if this.ContainerID != that1.ContainerID {
		return false
	}
	if this.Size_ != that1.Size_ {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxNamespace) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxNamespace)
	if !ok {
		that2, ok := that.(LinuxNamespace)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxDevice) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxDevice)
	if !ok {
		that2, ok := that.(LinuxDevice)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Major != that1.Major {
		return false
	}
	if this.Minor != that1.Minor {
		return false
	}
	if this.FileMode != that1.FileMode {
		return false
	}
	if this.UID != that1.UID {
		return false
	}
	if this.GID != that1.GID {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxResources) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxResources)
	if !ok {
		that2, ok := that.(LinuxResources)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Devices) != len(that1.Devices) {
		return false
	}
	for i := range this.Devices {
		if !this.Devices[i].Equal(&that1.Devices[i]) {
			return false
		}
	}
	if !this.Memory.Equal(that1.Memory) {
		return false
	}
	if !this.CPU.Equal(that1.CPU) {
		return false
	}
	if !this.Pids.Equal(that1.Pids) {
		return false
	}
	if !this.BlockIO.Equal(that1.BlockIO) {
		return false
	}
	if len(this.HugepageLimits) != len(that1.HugepageLimits) {
		return false
	}
	for i := range this.HugepageLimits {
		if !this.HugepageLimits[i].Equal(&that1.HugepageLimits[i]) {
			return false
		}
	}
	if !this.Network.Equal(that1.Network) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxMemory) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxMemory)
	if !ok {
		that2, ok := that.(LinuxMemory)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Limit != that1.Limit {
		return false
	}
	if this.Reservation != that1.Reservation {
		return false
	}
	if this.Swap != that1.Swap {
		return false
	}
	if this.Kernel != that1.Kernel {
		return false
	}
	if this.KernelTCP != that1.KernelTCP {
		return false
	}
	if this.Swappiness != that1.Swappiness {
		return false
	}
	if this.DisableOOMKiller != that1.DisableOOMKiller {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxCPU) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxCPU)
	if !ok {
		that2, ok := that.(LinuxCPU)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Shares != that1.Shares {
		return false
	}
	if this.Quota != that1.Quota {
		return false
	}
	if this.Period != that1.Period {
		return false
	}
	if this.RealtimeRuntime != that1.RealtimeRuntime {
		return false
	}
	if this.RealtimePeriod != that1.RealtimePeriod {
		return false
	}
	if this.Cpus != that1.Cpus {
		return false
	}
	if this.Mems != that1.Mems {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxWeightDevice) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxWeightDevice)
	if !ok {
		that2, ok := that.(LinuxWeightDevice)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Major != that1.Major {
		return false
	}
	if this.Minor != that1.Minor {
		return false
	}
	if this.Weight != that1.Weight {
		return false
	}
	if this.LeafWeight != that1.LeafWeight {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxThrottleDevice) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxThrottleDevice)
	if !ok {
		that2, ok := that.(LinuxThrottleDevice)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Major != that1.Major {
		return false
	}
	if this.Minor != that1.Minor {
		return false
	}
	if this.Rate != that1.Rate {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxBlockIO) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxBlockIO)
	if !ok {
		that2, ok := that.(LinuxBlockIO)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Weight != that1.Weight {
		return false
	}
	if this.LeafWeight != that1.LeafWeight {
		return false
	}
	if len(this.WeightDevice) != len(that1.WeightDevice) {
		return false
	}
	for i := range this.WeightDevice {
		if !this.WeightDevice[i].Equal(&that1.WeightDevice[i]) {
			return false
		}
	}
	if len(this.ThrottleReadBpsDevice) != len(that1.ThrottleReadBpsDevice) {
		return false
	}
	for i := range this.ThrottleReadBpsDevice {
		if !this.ThrottleReadBpsDevice[i].Equal(&that1.ThrottleReadBpsDevice[i]) {
			return false
		}
	}
	if len(this.ThrottleWriteBpsDevice) != len(that1.ThrottleWriteBpsDevice) {
		return false
	}
	for i := range this.ThrottleWriteBpsDevice {
		if !this.ThrottleWriteBpsDevice[i].Equal(&that1.ThrottleWriteBpsDevice[i]) {
			return false
		}
	}
	if len(this.ThrottleReadIOPSDevice) != len(that1.ThrottleReadIOPSDevice) {
		return false
	}
	for i := range this.ThrottleReadIOPSDevice {
		if !this.ThrottleReadIOPSDevice[i].Equal(&that1.ThrottleReadIOPSDevice[i]) {
			return false
		}
	}
	if len(this.ThrottleWriteIOPSDevice) != len(that1.ThrottleWriteIOPSDevice) {
		return false
	}
	for i := range this.ThrottleWriteIOPSDevice {
		if !this.ThrottleWriteIOPSDevice[i].Equal(&that1.ThrottleWriteIOPSDevice[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxPids) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxPids)
	if !ok {
		that2, ok := that.(LinuxPids)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Limit != that1.Limit {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxDeviceCgroup) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxDeviceCgroup)
	if !ok {
		that2, ok := that.(LinuxDeviceCgroup)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Allow != that1.Allow {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Major != that1.Major {
		return false
	}
	if this.Minor != that1.Minor {
		return false
	}
	if this.Access != that1.Access {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxNetwork) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxNetwork)
	if !ok {
		that2, ok := that.(LinuxNetwork)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ClassID != that1.ClassID {
		return false
	}
	if len(this.Priorities) != len(that1.Priorities) {
		return false
	}
	for i := range this.Priorities {
		if !this.Priorities[i].Equal(&that1.Priorities[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxHugepageLimit) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxHugepageLimit)
	if !ok {
		that2, ok := that.(LinuxHugepageLimit)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Pagesize != that1.Pagesize {
		return false
	}
	if this.Limit != that1.Limit {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxInterfacePriority) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxInterfacePriority)
	if !ok {
		that2, ok := that.(LinuxInterfacePriority)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Priority != that1.Priority {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxSeccomp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxSeccomp)
	if !ok {
		that2, ok := that.(LinuxSeccomp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.DefaultAction != that1.DefaultAction {
		return false
	}
	if len(this.Architectures) != len(that1.Architectures) {
		return false
	}
	for i := range this.Architectures {
		if this.Architectures[i] != that1.Architectures[i] {
			return false
		}
	}
	if len(this.Flags) != len(that1.Flags) {
		return false
	}
	for i := range this.Flags {
		if this.Flags[i] != that1.Flags[i] {
			return false
		}
	}
	if len(this.Syscalls) != len(that1.Syscalls) {
		return false
	}
	for i := range this.Syscalls {
		if !this.Syscalls[i].Equal(&that1.Syscalls[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxSeccompArg) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxSeccompArg)
	if !ok {
		that2, ok := that.(LinuxSeccompArg)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Index != that1.Index {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if this.ValueTwo != that1.ValueTwo {
		return false
	}
	if this.Op != that1.Op {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxSyscall) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxSyscall)
	if !ok {
		that2, ok := that.(LinuxSyscall)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Names) != len(that1.Names) {
		return false
	}
	for i := range this.Names {
		if this.Names[i] != that1.Names[i] {
			return false
		}
	}
	if this.Action != that1.Action {
		return false
	}
	if that1.ErrnoRet == nil {
		if this.ErrnoRet != nil {
			return false
		}
	} else if this.ErrnoRet == nil {
		return false
	} else if !this.ErrnoRet.Equal(that1.ErrnoRet) {
		return false
	}
	if len(this.Args) != len(that1.Args) {
		return false
	}
	for i := range this.Args {
		if !this.Args[i].Equal(&that1.Args[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LinuxSyscall_Errnoret) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxSyscall_Errnoret)
	if !ok {
		that2, ok := that.(LinuxSyscall_Errnoret)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Errnoret != that1.Errnoret {
		return false
	}
	return true
}
func (this *LinuxIntelRdt) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LinuxIntelRdt)
	if !ok {
		that2, ok := that.(LinuxIntelRdt)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.L3CacheSchema != that1.L3CacheSchema {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (m *Spec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Spec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Spec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Windows != nil {
		{
			size, err := m.Windows.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.Solaris != nil {
		{
			size, err := m.Solaris.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.Linux != nil {
		{
			size, err := m.Linux.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintOci(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintOci(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintOci(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Hooks != nil {
		{
			size, err := m.Hooks.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Mounts) > 0 {
		for iNdEx := len(m.Mounts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Mounts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Hostname) > 0 {
		i -= len(m.Hostname)
		copy(dAtA[i:], m.Hostname)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Hostname)))
		i--
		dAtA[i] = 0x22
	}
	if m.Root != nil {
		{
			size, err := m.Root.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Process != nil {
		{
			size, err := m.Process.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Process) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Process) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Process) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SelinuxLabel) > 0 {
		i -= len(m.SelinuxLabel)
		copy(dAtA[i:], m.SelinuxLabel)
		i = encodeVarintOci(dAtA, i, uint64(len(m.SelinuxLabel)))
		i--
		dAtA[i] = 0x62
	}
	if m.OOMScoreAdj != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.OOMScoreAdj))
		i--
		dAtA[i] = 0x58
	}
	if len(m.ApparmorProfile) > 0 {
		i -= len(m.ApparmorProfile)
		copy(dAtA[i:], m.ApparmorProfile)
		i = encodeVarintOci(dAtA, i, uint64(len(m.ApparmorProfile)))
		i--
		dAtA[i] = 0x52
	}
	if m.NoNewPrivileges {
		i--
		if m.NoNewPrivileges {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if len(m.Rlimits) > 0 {
		for iNdEx := len(m.Rlimits) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Rlimits[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if m.Capabilities != nil {
		{
			size, err := m.Capabilities.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Cwd) > 0 {
		i -= len(m.Cwd)
		copy(dAtA[i:], m.Cwd)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Cwd)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Env) > 0 {
		for iNdEx := len(m.Env) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Env[iNdEx])
			copy(dAtA[i:], m.Env[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Env[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Args) > 0 {
		for iNdEx := len(m.Args) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Args[iNdEx])
			copy(dAtA[i:], m.Args[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Args[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	{
		size, err := m.User.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintOci(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	if m.ConsoleSize != nil {
		{
			size, err := m.ConsoleSize.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Terminal {
		i--
		if m.Terminal {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Box) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Box) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Box) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Width != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Width))
		i--
		dAtA[i] = 0x10
	}
	if m.Height != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *User) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *User) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *User) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.AdditionalGids) > 0 {
		dAtA11 := make([]byte, len(m.AdditionalGids)*10)
		var j10 int
		for _, num := range m.AdditionalGids {
			for num >= 1<<7 {
				dAtA11[j10] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j10++
			}
			dAtA11[j10] = uint8(num)
			j10++
		}
		i -= j10
		copy(dAtA[i:], dAtA11[:j10])
		i = encodeVarintOci(dAtA, i, uint64(j10))
		i--
		dAtA[i] = 0x1a
	}
	if m.GID != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.GID))
		i--
		dAtA[i] = 0x10
	}
	if m.UID != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.UID))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxCapabilities) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxCapabilities) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxCapabilities) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ambient) > 0 {
		for iNdEx := len(m.Ambient) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Ambient[iNdEx])
			copy(dAtA[i:], m.Ambient[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Ambient[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Permitted) > 0 {
		for iNdEx := len(m.Permitted) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Permitted[iNdEx])
			copy(dAtA[i:], m.Permitted[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Permitted[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Inheritable) > 0 {
		for iNdEx := len(m.Inheritable) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Inheritable[iNdEx])
			copy(dAtA[i:], m.Inheritable[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Inheritable[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Effective) > 0 {
		for iNdEx := len(m.Effective) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Effective[iNdEx])
			copy(dAtA[i:], m.Effective[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Effective[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Bounding) > 0 {
		for iNdEx := len(m.Bounding) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Bounding[iNdEx])
			copy(dAtA[i:], m.Bounding[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Bounding[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *POSIXRlimit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *POSIXRlimit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *POSIXRlimit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Soft != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Soft))
		i--
		dAtA[i] = 0x18
	}
	if m.Hard != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Hard))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Mount) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mount) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Mount) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Options) > 0 {
		for iNdEx := len(m.Options) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Options[iNdEx])
			copy(dAtA[i:], m.Options[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Options[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Destination) > 0 {
		i -= len(m.Destination)
		copy(dAtA[i:], m.Destination)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Destination)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Root) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Root) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Root) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Readonly {
		i--
		if m.Readonly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Hooks) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Hooks) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Hooks) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Poststop) > 0 {
		for iNdEx := len(m.Poststop) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Poststop[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Poststart) > 0 {
		for iNdEx := len(m.Poststart) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Poststart[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Prestart) > 0 {
		for iNdEx := len(m.Prestart) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Prestart[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Hook) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Hook) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Hook) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Timeout != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Env) > 0 {
		for iNdEx := len(m.Env) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Env[iNdEx])
			copy(dAtA[i:], m.Env[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Env[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Args) > 0 {
		for iNdEx := len(m.Args) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Args[iNdEx])
			copy(dAtA[i:], m.Args[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Args[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Linux) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Linux) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Linux) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IntelRdt != nil {
		{
			size, err := m.IntelRdt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if len(m.MountLabel) > 0 {
		i -= len(m.MountLabel)
		copy(dAtA[i:], m.MountLabel)
		i = encodeVarintOci(dAtA, i, uint64(len(m.MountLabel)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.ReadonlyPaths) > 0 {
		for iNdEx := len(m.ReadonlyPaths) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ReadonlyPaths[iNdEx])
			copy(dAtA[i:], m.ReadonlyPaths[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.ReadonlyPaths[iNdEx])))
			i--
			dAtA[i] = 0x5a
		}
	}
	if len(m.MaskedPaths) > 0 {
		for iNdEx := len(m.MaskedPaths) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.MaskedPaths[iNdEx])
			copy(dAtA[i:], m.MaskedPaths[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.MaskedPaths[iNdEx])))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.RootfsPropagation) > 0 {
		i -= len(m.RootfsPropagation)
		copy(dAtA[i:], m.RootfsPropagation)
		i = encodeVarintOci(dAtA, i, uint64(len(m.RootfsPropagation)))
		i--
		dAtA[i] = 0x4a
	}
	if m.Seccomp != nil {
		{
			size, err := m.Seccomp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.Devices) > 0 {
		for iNdEx := len(m.Devices) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Devices[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Namespaces) > 0 {
		for iNdEx := len(m.Namespaces) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Namespaces[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.CgroupsPath) > 0 {
		i -= len(m.CgroupsPath)
		copy(dAtA[i:], m.CgroupsPath)
		i = encodeVarintOci(dAtA, i, uint64(len(m.CgroupsPath)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Resources != nil {
		{
			size, err := m.Resources.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Sysctl) > 0 {
		for k := range m.Sysctl {
			v := m.Sysctl[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintOci(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintOci(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintOci(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.GIDMappings) > 0 {
		for iNdEx := len(m.GIDMappings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.GIDMappings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.UIDMappings) > 0 {
		for iNdEx := len(m.UIDMappings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.UIDMappings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Windows) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Windows) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Windows) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Dummy) > 0 {
		i -= len(m.Dummy)
		copy(dAtA[i:], m.Dummy)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Dummy)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Solaris) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Solaris) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Solaris) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Dummy) > 0 {
		i -= len(m.Dummy)
		copy(dAtA[i:], m.Dummy)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Dummy)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinuxIDMapping) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxIDMapping) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxIDMapping) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Size_ != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Size_))
		i--
		dAtA[i] = 0x18
	}
	if m.ContainerID != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.ContainerID))
		i--
		dAtA[i] = 0x10
	}
	if m.HostID != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.HostID))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxNamespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxNamespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxNamespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinuxDevice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxDevice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxDevice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.GID != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.GID))
		i--
		dAtA[i] = 0x38
	}
	if m.UID != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.UID))
		i--
		dAtA[i] = 0x30
	}
	if m.FileMode != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.FileMode))
		i--
		dAtA[i] = 0x28
	}
	if m.Minor != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Minor))
		i--
		dAtA[i] = 0x20
	}
	if m.Major != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Major))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinuxResources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxResources) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxResources) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Network != nil {
		{
			size, err := m.Network.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.HugepageLimits) > 0 {
		for iNdEx := len(m.HugepageLimits) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HugepageLimits[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.BlockIO != nil {
		{
			size, err := m.BlockIO.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Pids != nil {
		{
			size, err := m.Pids.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.CPU != nil {
		{
			size, err := m.CPU.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Memory != nil {
		{
			size, err := m.Memory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintOci(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Devices) > 0 {
		for iNdEx := len(m.Devices) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Devices[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LinuxMemory) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxMemory) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxMemory) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DisableOOMKiller {
		i--
		if m.DisableOOMKiller {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.Swappiness != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Swappiness))
		i--
		dAtA[i] = 0x30
	}
	if m.KernelTCP != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.KernelTCP))
		i--
		dAtA[i] = 0x28
	}
	if m.Kernel != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Kernel))
		i--
		dAtA[i] = 0x20
	}
	if m.Swap != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Swap))
		i--
		dAtA[i] = 0x18
	}
	if m.Reservation != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Reservation))
		i--
		dAtA[i] = 0x10
	}
	if m.Limit != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxCPU) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxCPU) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxCPU) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Mems) > 0 {
		i -= len(m.Mems)
		copy(dAtA[i:], m.Mems)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Mems)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Cpus) > 0 {
		i -= len(m.Cpus)
		copy(dAtA[i:], m.Cpus)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Cpus)))
		i--
		dAtA[i] = 0x32
	}
	if m.RealtimePeriod != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.RealtimePeriod))
		i--
		dAtA[i] = 0x28
	}
	if m.RealtimeRuntime != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.RealtimeRuntime))
		i--
		dAtA[i] = 0x20
	}
	if m.Period != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Period))
		i--
		dAtA[i] = 0x18
	}
	if m.Quota != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Quota))
		i--
		dAtA[i] = 0x10
	}
	if m.Shares != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Shares))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxWeightDevice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxWeightDevice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxWeightDevice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LeafWeight != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.LeafWeight))
		i--
		dAtA[i] = 0x20
	}
	if m.Weight != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Weight))
		i--
		dAtA[i] = 0x18
	}
	if m.Minor != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Minor))
		i--
		dAtA[i] = 0x10
	}
	if m.Major != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Major))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxThrottleDevice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxThrottleDevice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxThrottleDevice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Rate != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Rate))
		i--
		dAtA[i] = 0x18
	}
	if m.Minor != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Minor))
		i--
		dAtA[i] = 0x10
	}
	if m.Major != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Major))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxBlockIO) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxBlockIO) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxBlockIO) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ThrottleWriteIOPSDevice) > 0 {
		for iNdEx := len(m.ThrottleWriteIOPSDevice) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ThrottleWriteIOPSDevice[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.ThrottleReadIOPSDevice) > 0 {
		for iNdEx := len(m.ThrottleReadIOPSDevice) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ThrottleReadIOPSDevice[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.ThrottleWriteBpsDevice) > 0 {
		for iNdEx := len(m.ThrottleWriteBpsDevice) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ThrottleWriteBpsDevice[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.ThrottleReadBpsDevice) > 0 {
		for iNdEx := len(m.ThrottleReadBpsDevice) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ThrottleReadBpsDevice[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.WeightDevice) > 0 {
		for iNdEx := len(m.WeightDevice) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.WeightDevice[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.LeafWeight != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.LeafWeight))
		i--
		dAtA[i] = 0x10
	}
	if m.Weight != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Weight))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxPids) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxPids) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxPids) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Limit != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxDeviceCgroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxDeviceCgroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxDeviceCgroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Access) > 0 {
		i -= len(m.Access)
		copy(dAtA[i:], m.Access)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Access)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Minor != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Minor))
		i--
		dAtA[i] = 0x20
	}
	if m.Major != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Major))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x12
	}
	if m.Allow {
		i--
		if m.Allow {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxNetwork) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxNetwork) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxNetwork) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Priorities) > 0 {
		for iNdEx := len(m.Priorities) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Priorities[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.ClassID != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.ClassID))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxHugepageLimit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxHugepageLimit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxHugepageLimit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Limit != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Pagesize) > 0 {
		i -= len(m.Pagesize)
		copy(dAtA[i:], m.Pagesize)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Pagesize)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinuxInterfacePriority) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxInterfacePriority) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxInterfacePriority) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Priority != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Priority))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinuxSeccomp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxSeccomp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxSeccomp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Syscalls) > 0 {
		for iNdEx := len(m.Syscalls) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Syscalls[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Flags) > 0 {
		for iNdEx := len(m.Flags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Flags[iNdEx])
			copy(dAtA[i:], m.Flags[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Flags[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Architectures) > 0 {
		for iNdEx := len(m.Architectures) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Architectures[iNdEx])
			copy(dAtA[i:], m.Architectures[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Architectures[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.DefaultAction) > 0 {
		i -= len(m.DefaultAction)
		copy(dAtA[i:], m.DefaultAction)
		i = encodeVarintOci(dAtA, i, uint64(len(m.DefaultAction)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinuxSeccompArg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxSeccompArg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxSeccompArg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Op) > 0 {
		i -= len(m.Op)
		copy(dAtA[i:], m.Op)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Op)))
		i--
		dAtA[i] = 0x22
	}
	if m.ValueTwo != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.ValueTwo))
		i--
		dAtA[i] = 0x18
	}
	if m.Value != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x10
	}
	if m.Index != 0 {
		i = encodeVarintOci(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxSyscall) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxSyscall) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxSyscall) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Args) > 0 {
		for iNdEx := len(m.Args) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Args[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintOci(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.ErrnoRet != nil {
		{
			size := m.ErrnoRet.Size()
			i -= size
			if _, err := m.ErrnoRet.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Action) > 0 {
		i -= len(m.Action)
		copy(dAtA[i:], m.Action)
		i = encodeVarintOci(dAtA, i, uint64(len(m.Action)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Names) > 0 {
		for iNdEx := len(m.Names) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Names[iNdEx])
			copy(dAtA[i:], m.Names[iNdEx])
			i = encodeVarintOci(dAtA, i, uint64(len(m.Names[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LinuxSyscall_Errnoret) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxSyscall_Errnoret) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintOci(dAtA, i, uint64(m.Errnoret))
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}
func (m *LinuxIntelRdt) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxIntelRdt) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxIntelRdt) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.L3CacheSchema) > 0 {
		i -= len(m.L3CacheSchema)
		copy(dAtA[i:], m.L3CacheSchema)
		i = encodeVarintOci(dAtA, i, uint64(len(m.L3CacheSchema)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintOci(dAtA []byte, offset int, v uint64) int {
	offset -= sovOci(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedSpec(r randyOci, easy bool) *Spec {
	this := &Spec{}
	this.Version = string(randStringOci(r))
	if r.Intn(5) != 0 {
		this.Process = NewPopulatedProcess(r, easy)
	}
	if r.Intn(5) != 0 {
		this.Root = NewPopulatedRoot(r, easy)
	}
	this.Hostname = string(randStringOci(r))
	if r.Intn(5) != 0 {
		v1 := r.Intn(5)
		this.Mounts = make([]Mount, v1)
		for i := 0; i < v1; i++ {
			v2 := NewPopulatedMount(r, easy)
			this.Mounts[i] = *v2
		}
	}
	if r.Intn(5) != 0 {
		this.Hooks = NewPopulatedHooks(r, easy)
	}
	if r.Intn(5) != 0 {
		v3 := r.Intn(10)
		this.Annotations = make(map[string]string)
		for i := 0; i < v3; i++ {
			this.Annotations[randStringOci(r)] = randStringOci(r)
		}
	}
	if r.Intn(5) != 0 {
		this.Linux = NewPopulatedLinux(r, easy)
	}
	if r.Intn(5) != 0 {
		this.Solaris = NewPopulatedSolaris(r, easy)
	}
	if r.Intn(5) != 0 {
		this.Windows = NewPopulatedWindows(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 11)
	}
	return this
}

func NewPopulatedProcess(r randyOci, easy bool) *Process {
	this := &Process{}
	this.Terminal = bool(bool(r.Intn(2) == 0))
	if r.Intn(5) != 0 {
		this.ConsoleSize = NewPopulatedBox(r, easy)
	}
	v4 := NewPopulatedUser(r, easy)
	this.User = *v4
	v5 := r.Intn(10)
	this.Args = make([]string, v5)
	for i := 0; i < v5; i++ {
		this.Args[i] = string(randStringOci(r))
	}
	v6 := r.Intn(10)
	this.Env = make([]string, v6)
	for i := 0; i < v6; i++ {
		this.Env[i] = string(randStringOci(r))
	}
	this.Cwd = string(randStringOci(r))
	if r.Intn(5) != 0 {
		this.Capabilities = NewPopulatedLinuxCapabilities(r, easy)
	}
	if r.Intn(5) != 0 {
		v7 := r.Intn(5)
		this.Rlimits = make([]POSIXRlimit, v7)
		for i := 0; i < v7; i++ {
			v8 := NewPopulatedPOSIXRlimit(r, easy)
			this.Rlimits[i] = *v8
		}
	}
	this.NoNewPrivileges = bool(bool(r.Intn(2) == 0))
	this.ApparmorProfile = string(randStringOci(r))
	this.OOMScoreAdj = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.OOMScoreAdj *= -1
	}
	this.SelinuxLabel = string(randStringOci(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 13)
	}
	return this
}

func NewPopulatedBox(r randyOci, easy bool) *Box {
	this := &Box{}
	this.Height = uint32(r.Uint32())
	this.Width = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 3)
	}
	return this
}

func NewPopulatedUser(r randyOci, easy bool) *User {
	this := &User{}
	this.UID = uint32(r.Uint32())
	this.GID = uint32(r.Uint32())
	v9 := r.Intn(10)
	this.AdditionalGids = make([]uint32, v9)
	for i := 0; i < v9; i++ {
		this.AdditionalGids[i] = uint32(r.Uint32())
	}
	this.Username = string(randStringOci(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 5)
	}
	return this
}

func NewPopulatedLinuxCapabilities(r randyOci, easy bool) *LinuxCapabilities {
	this := &LinuxCapabilities{}
	v10 := r.Intn(10)
	this.Bounding = make([]string, v10)
	for i := 0; i < v10; i++ {
		this.Bounding[i] = string(randStringOci(r))
	}
	v11 := r.Intn(10)
	this.Effective = make([]string, v11)
	for i := 0; i < v11; i++ {
		this.Effective[i] = string(randStringOci(r))
	}
	v12 := r.Intn(10)
	this.Inheritable = make([]string, v12)
	for i := 0; i < v12; i++ {
		this.Inheritable[i] = string(randStringOci(r))
	}
	v13 := r.Intn(10)
	this.Permitted = make([]string, v13)
	for i := 0; i < v13; i++ {
		this.Permitted[i] = string(randStringOci(r))
	}
	v14 := r.Intn(10)
	this.Ambient = make([]string, v14)
	for i := 0; i < v14; i++ {
		this.Ambient[i] = string(randStringOci(r))
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 6)
	}
	return this
}

func NewPopulatedPOSIXRlimit(r randyOci, easy bool) *POSIXRlimit {
	this := &POSIXRlimit{}
	this.Type = string(randStringOci(r))
	this.Hard = uint64(uint64(r.Uint32()))
	this.Soft = uint64(uint64(r.Uint32()))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 4)
	}
	return this
}

func NewPopulatedMount(r randyOci, easy bool) *Mount {
	this := &Mount{}
	this.Destination = string(randStringOci(r))
	this.Source = string(randStringOci(r))
	this.Type = string(randStringOci(r))
	v15 := r.Intn(10)
	this.Options = make([]string, v15)
	for i := 0; i < v15; i++ {
		this.Options[i] = string(randStringOci(r))
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 5)
	}
	return this
}

func NewPopulatedRoot(r randyOci, easy bool) *Root {
	this := &Root{}
	this.Path = string(randStringOci(r))
	this.Readonly = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 3)
	}
	return this
}

func NewPopulatedHooks(r randyOci, easy bool) *Hooks {
	this := &Hooks{}
	if r.Intn(5) != 0 {
		v16 := r.Intn(5)
		this.Prestart = make([]Hook, v16)
		for i := 0; i < v16; i++ {
			v17 := NewPopulatedHook(r, easy)
			this.Prestart[i] = *v17
		}
	}
	if r.Intn(5) != 0 {
		v18 := r.Intn(5)
		this.Poststart = make([]Hook, v18)
		for i := 0; i < v18; i++ {
			v19 := NewPopulatedHook(r, easy)
			this.Poststart[i] = *v19
		}
	}
	if r.Intn(5) != 0 {
		v20 := r.Intn(5)
		this.Poststop = make([]Hook, v20)
		for i := 0; i < v20; i++ {
			v21 := NewPopulatedHook(r, easy)
			this.Poststop[i] = *v21
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 4)
	}
	return this
}

func NewPopulatedHook(r randyOci, easy bool) *Hook {
	this := &Hook{}
	this.Path = string(randStringOci(r))
	v22 := r.Intn(10)
	this.Args = make([]string, v22)
	for i := 0; i < v22; i++ {
		this.Args[i] = string(randStringOci(r))
	}
	v23 := r.Intn(10)
	this.Env = make([]string, v23)
	for i := 0; i < v23; i++ {
		this.Env[i] = string(randStringOci(r))
	}
	this.Timeout = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Timeout *= -1
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 5)
	}
	return this
}

func NewPopulatedLinux(r randyOci, easy bool) *Linux {
	this := &Linux{}
	if r.Intn(5) != 0 {
		v24 := r.Intn(5)
		this.UIDMappings = make([]LinuxIDMapping, v24)
		for i := 0; i < v24; i++ {
			v25 := NewPopulatedLinuxIDMapping(r, easy)
			this.UIDMappings[i] = *v25
		}
	}
	if r.Intn(5) != 0 {
		v26 := r.Intn(5)
		this.GIDMappings = make([]LinuxIDMapping, v26)
		for i := 0; i < v26; i++ {
			v27 := NewPopulatedLinuxIDMapping(r, easy)
			this.GIDMappings[i] = *v27
		}
	}
	if r.Intn(5) != 0 {
		v28 := r.Intn(10)
		this.Sysctl = make(map[string]string)
		for i := 0; i < v28; i++ {
			this.Sysctl[randStringOci(r)] = randStringOci(r)
		}
	}
	if r.Intn(5) != 0 {
		this.Resources = NewPopulatedLinuxResources(r, easy)
	}
	this.CgroupsPath = string(randStringOci(r))
	if r.Intn(5) != 0 {
		v29 := r.Intn(5)
		this.Namespaces = make([]LinuxNamespace, v29)
		for i := 0; i < v29; i++ {
			v30 := NewPopulatedLinuxNamespace(r, easy)
			this.Namespaces[i] = *v30
		}
	}
	if r.Intn(5) != 0 {
		v31 := r.Intn(5)
		this.Devices = make([]LinuxDevice, v31)
		for i := 0; i < v31; i++ {
			v32 := NewPopulatedLinuxDevice(r, easy)
			this.Devices[i] = *v32
		}
	}
	if r.Intn(5) != 0 {
		this.Seccomp = NewPopulatedLinuxSeccomp(r, easy)
	}
	this.RootfsPropagation = string(randStringOci(r))
	v33 := r.Intn(10)
	this.MaskedPaths = make([]string, v33)
	for i := 0; i < v33; i++ {
		this.MaskedPaths[i] = string(randStringOci(r))
	}
	v34 := r.Intn(10)
	this.ReadonlyPaths = make([]string, v34)
	for i := 0; i < v34; i++ {
		this.ReadonlyPaths[i] = string(randStringOci(r))
	}
	this.MountLabel = string(randStringOci(r))
	if r.Intn(5) != 0 {
		this.IntelRdt = NewPopulatedLinuxIntelRdt(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 14)
	}
	return this
}

func NewPopulatedWindows(r randyOci, easy bool) *Windows {
	this := &Windows{}
	this.Dummy = string(randStringOci(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 2)
	}
	return this
}

func NewPopulatedSolaris(r randyOci, easy bool) *Solaris {
	this := &Solaris{}
	this.Dummy = string(randStringOci(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 2)
	}
	return this
}

func NewPopulatedLinuxIDMapping(r randyOci, easy bool) *LinuxIDMapping {
	this := &LinuxIDMapping{}
	this.HostID = uint32(r.Uint32())
	this.ContainerID = uint32(r.Uint32())
	this.Size_ = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 4)
	}
	return this
}

func NewPopulatedLinuxNamespace(r randyOci, easy bool) *LinuxNamespace {
	this := &LinuxNamespace{}
	this.Type = string(randStringOci(r))
	this.Path = string(randStringOci(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 3)
	}
	return this
}

func NewPopulatedLinuxDevice(r randyOci, easy bool) *LinuxDevice {
	this := &LinuxDevice{}
	this.Path = string(randStringOci(r))
	this.Type = string(randStringOci(r))
	this.Major = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Major *= -1
	}
	this.Minor = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Minor *= -1
	}
	this.FileMode = uint32(r.Uint32())
	this.UID = uint32(r.Uint32())
	this.GID = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 8)
	}
	return this
}

func NewPopulatedLinuxResources(r randyOci, easy bool) *LinuxResources {
	this := &LinuxResources{}
	if r.Intn(5) != 0 {
		v35 := r.Intn(5)
		this.Devices = make([]LinuxDeviceCgroup, v35)
		for i := 0; i < v35; i++ {
			v36 := NewPopulatedLinuxDeviceCgroup(r, easy)
			this.Devices[i] = *v36
		}
	}
	if r.Intn(5) != 0 {
		this.Memory = NewPopulatedLinuxMemory(r, easy)
	}
	if r.Intn(5) != 0 {
		this.CPU = NewPopulatedLinuxCPU(r, easy)
	}
	if r.Intn(5) != 0 {
		this.Pids = NewPopulatedLinuxPids(r, easy)
	}
	if r.Intn(5) != 0 {
		this.BlockIO = NewPopulatedLinuxBlockIO(r, easy)
	}
	if r.Intn(5) != 0 {
		v37 := r.Intn(5)
		this.HugepageLimits = make([]LinuxHugepageLimit, v37)
		for i := 0; i < v37; i++ {
			v38 := NewPopulatedLinuxHugepageLimit(r, easy)
			this.HugepageLimits[i] = *v38
		}
	}
	if r.Intn(5) != 0 {
		this.Network = NewPopulatedLinuxNetwork(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 8)
	}
	return this
}

func NewPopulatedLinuxMemory(r randyOci, easy bool) *LinuxMemory {
	this := &LinuxMemory{}
	this.Limit = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Limit *= -1
	}
	this.Reservation = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Reservation *= -1
	}
	this.Swap = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Swap *= -1
	}
	this.Kernel = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Kernel *= -1
	}
	this.KernelTCP = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.KernelTCP *= -1
	}
	this.Swappiness = uint64(uint64(r.Uint32()))
	this.DisableOOMKiller = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 8)
	}
	return this
}

func NewPopulatedLinuxCPU(r randyOci, easy bool) *LinuxCPU {
	this := &LinuxCPU{}
	this.Shares = uint64(uint64(r.Uint32()))
	this.Quota = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Quota *= -1
	}
	this.Period = uint64(uint64(r.Uint32()))
	this.RealtimeRuntime = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.RealtimeRuntime *= -1
	}
	this.RealtimePeriod = uint64(uint64(r.Uint32()))
	this.Cpus = string(randStringOci(r))
	this.Mems = string(randStringOci(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 8)
	}
	return this
}

func NewPopulatedLinuxWeightDevice(r randyOci, easy bool) *LinuxWeightDevice {
	this := &LinuxWeightDevice{}
	this.Major = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Major *= -1
	}
	this.Minor = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Minor *= -1
	}
	this.Weight = uint32(r.Uint32())
	this.LeafWeight = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 5)
	}
	return this
}

func NewPopulatedLinuxThrottleDevice(r randyOci, easy bool) *LinuxThrottleDevice {
	this := &LinuxThrottleDevice{}
	this.Major = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Major *= -1
	}
	this.Minor = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Minor *= -1
	}
	this.Rate = uint64(uint64(r.Uint32()))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 4)
	}
	return this
}

func NewPopulatedLinuxBlockIO(r randyOci, easy bool) *LinuxBlockIO {
	this := &LinuxBlockIO{}
	this.Weight = uint32(r.Uint32())
	this.LeafWeight = uint32(r.Uint32())
	if r.Intn(5) != 0 {
		v39 := r.Intn(5)
		this.WeightDevice = make([]LinuxWeightDevice, v39)
		for i := 0; i < v39; i++ {
			v40 := NewPopulatedLinuxWeightDevice(r, easy)
			this.WeightDevice[i] = *v40
		}
	}
	if r.Intn(5) != 0 {
		v41 := r.Intn(5)
		this.ThrottleReadBpsDevice = make([]LinuxThrottleDevice, v41)
		for i := 0; i < v41; i++ {
			v42 := NewPopulatedLinuxThrottleDevice(r, easy)
			this.ThrottleReadBpsDevice[i] = *v42
		}
	}
	if r.Intn(5) != 0 {
		v43 := r.Intn(5)
		this.ThrottleWriteBpsDevice = make([]LinuxThrottleDevice, v43)
		for i := 0; i < v43; i++ {
			v44 := NewPopulatedLinuxThrottleDevice(r, easy)
			this.ThrottleWriteBpsDevice[i] = *v44
		}
	}
	if r.Intn(5) != 0 {
		v45 := r.Intn(5)
		this.ThrottleReadIOPSDevice = make([]LinuxThrottleDevice, v45)
		for i := 0; i < v45; i++ {
			v46 := NewPopulatedLinuxThrottleDevice(r, easy)
			this.ThrottleReadIOPSDevice[i] = *v46
		}
	}
	if r.Intn(5) != 0 {
		v47 := r.Intn(5)
		this.ThrottleWriteIOPSDevice = make([]LinuxThrottleDevice, v47)
		for i := 0; i < v47; i++ {
			v48 := NewPopulatedLinuxThrottleDevice(r, easy)
			this.ThrottleWriteIOPSDevice[i] = *v48
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 8)
	}
	return this
}

func NewPopulatedLinuxPids(r randyOci, easy bool) *LinuxPids {
	this := &LinuxPids{}
	this.Limit = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Limit *= -1
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 2)
	}
	return this
}

func NewPopulatedLinuxDeviceCgroup(r randyOci, easy bool) *LinuxDeviceCgroup {
	this := &LinuxDeviceCgroup{}
	this.Allow = bool(bool(r.Intn(2) == 0))
	this.Type = string(randStringOci(r))
	this.Major = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Major *= -1
	}
	this.Minor = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Minor *= -1
	}
	this.Access = string(randStringOci(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 6)
	}
	return this
}

func NewPopulatedLinuxNetwork(r randyOci, easy bool) *LinuxNetwork {
	this := &LinuxNetwork{}
	this.ClassID = uint32(r.Uint32())
	if r.Intn(5) != 0 {
		v49 := r.Intn(5)
		this.Priorities = make([]LinuxInterfacePriority, v49)
		for i := 0; i < v49; i++ {
			v50 := NewPopulatedLinuxInterfacePriority(r, easy)
			this.Priorities[i] = *v50
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 3)
	}
	return this
}

func NewPopulatedLinuxHugepageLimit(r randyOci, easy bool) *LinuxHugepageLimit {
	this := &LinuxHugepageLimit{}
	this.Pagesize = string(randStringOci(r))
	this.Limit = uint64(uint64(r.Uint32()))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 3)
	}
	return this
}

func NewPopulatedLinuxInterfacePriority(r randyOci, easy bool) *LinuxInterfacePriority {
	this := &LinuxInterfacePriority{}
	this.Name = string(randStringOci(r))
	this.Priority = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 3)
	}
	return this
}

func NewPopulatedLinuxSeccomp(r randyOci, easy bool) *LinuxSeccomp {
	this := &LinuxSeccomp{}
	this.DefaultAction = string(randStringOci(r))
	v51 := r.Intn(10)
	this.Architectures = make([]string, v51)
	for i := 0; i < v51; i++ {
		this.Architectures[i] = string(randStringOci(r))
	}
	v52 := r.Intn(10)
	this.Flags = make([]string, v52)
	for i := 0; i < v52; i++ {
		this.Flags[i] = string(randStringOci(r))
	}
	if r.Intn(5) != 0 {
		v53 := r.Intn(5)
		this.Syscalls = make([]LinuxSyscall, v53)
		for i := 0; i < v53; i++ {
			v54 := NewPopulatedLinuxSyscall(r, easy)
			this.Syscalls[i] = *v54
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 5)
	}
	return this
}

func NewPopulatedLinuxSeccompArg(r randyOci, easy bool) *LinuxSeccompArg {
	this := &LinuxSeccompArg{}
	this.Index = uint64(uint64(r.Uint32()))
	this.Value = uint64(uint64(r.Uint32()))
	this.ValueTwo = uint64(uint64(r.Uint32()))
	this.Op = string(randStringOci(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 5)
	}
	return this
}

func NewPopulatedLinuxSyscall(r randyOci, easy bool) *LinuxSyscall {
	this := &LinuxSyscall{}
	v55 := r.Intn(10)
	this.Names = make([]string, v55)
	for i := 0; i < v55; i++ {
		this.Names[i] = string(randStringOci(r))
	}
	this.Action = string(randStringOci(r))
	oneofNumber_ErrnoRet := []int32{3}[r.Intn(1)]
	switch oneofNumber_ErrnoRet {
	case 3:
		this.ErrnoRet = NewPopulatedLinuxSyscall_Errnoret(r, easy)
	}
	if r.Intn(5) != 0 {
		v56 := r.Intn(5)
		this.Args = make([]LinuxSeccompArg, v56)
		for i := 0; i < v56; i++ {
			v57 := NewPopulatedLinuxSeccompArg(r, easy)
			this.Args[i] = *v57
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 5)
	}
	return this
}

func NewPopulatedLinuxSyscall_Errnoret(r randyOci, easy bool) *LinuxSyscall_Errnoret {
	this := &LinuxSyscall_Errnoret{}
	this.Errnoret = uint32(r.Uint32())
	return this
}
func NewPopulatedLinuxIntelRdt(r randyOci, easy bool) *LinuxIntelRdt {
	this := &LinuxIntelRdt{}
	this.L3CacheSchema = string(randStringOci(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedOci(r, 2)
	}
	return this
}

type randyOci interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneOci(r randyOci) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringOci(r randyOci) string {
	v58 := r.Intn(100)
	tmps := make([]rune, v58)
	for i := 0; i < v58; i++ {
		tmps[i] = randUTF8RuneOci(r)
	}
	return string(tmps)
}
func randUnrecognizedOci(r randyOci, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldOci(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldOci(dAtA []byte, r randyOci, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateOci(dAtA, uint64(key))
		v59 := r.Int63()
		if r.Intn(2) == 0 {
			v59 *= -1
		}
		dAtA = encodeVarintPopulateOci(dAtA, uint64(v59))
	case 1:
		dAtA = encodeVarintPopulateOci(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateOci(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateOci(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateOci(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateOci(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Spec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Process != nil {
		l = m.Process.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Root != nil {
		l = m.Root.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if len(m.Mounts) > 0 {
		for _, e := range m.Mounts {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.Hooks != nil {
		l = m.Hooks.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovOci(uint64(len(k))) + 1 + len(v) + sovOci(uint64(len(v)))
			n += mapEntrySize + 1 + sovOci(uint64(mapEntrySize))
		}
	}
	if m.Linux != nil {
		l = m.Linux.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Solaris != nil {
		l = m.Solaris.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Windows != nil {
		l = m.Windows.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Process) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Terminal {
		n += 2
	}
	if m.ConsoleSize != nil {
		l = m.ConsoleSize.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	l = m.User.Size()
	n += 1 + l + sovOci(uint64(l))
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Env) > 0 {
		for _, s := range m.Env {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	l = len(m.Cwd)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Capabilities != nil {
		l = m.Capabilities.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if len(m.Rlimits) > 0 {
		for _, e := range m.Rlimits {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.NoNewPrivileges {
		n += 2
	}
	l = len(m.ApparmorProfile)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.OOMScoreAdj != 0 {
		n += 1 + sovOci(uint64(m.OOMScoreAdj))
	}
	l = len(m.SelinuxLabel)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Box) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovOci(uint64(m.Height))
	}
	if m.Width != 0 {
		n += 1 + sovOci(uint64(m.Width))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *User) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UID != 0 {
		n += 1 + sovOci(uint64(m.UID))
	}
	if m.GID != 0 {
		n += 1 + sovOci(uint64(m.GID))
	}
	if len(m.AdditionalGids) > 0 {
		l = 0
		for _, e := range m.AdditionalGids {
			l += sovOci(uint64(e))
		}
		n += 1 + sovOci(uint64(l)) + l
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxCapabilities) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Bounding) > 0 {
		for _, s := range m.Bounding {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Effective) > 0 {
		for _, s := range m.Effective {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Inheritable) > 0 {
		for _, s := range m.Inheritable {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Permitted) > 0 {
		for _, s := range m.Permitted {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Ambient) > 0 {
		for _, s := range m.Ambient {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *POSIXRlimit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Hard != 0 {
		n += 1 + sovOci(uint64(m.Hard))
	}
	if m.Soft != 0 {
		n += 1 + sovOci(uint64(m.Soft))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Mount) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Destination)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Root) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Readonly {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Hooks) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Prestart) > 0 {
		for _, e := range m.Prestart {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Poststart) > 0 {
		for _, e := range m.Poststart {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Poststop) > 0 {
		for _, e := range m.Poststop {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Hook) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Env) > 0 {
		for _, s := range m.Env {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.Timeout != 0 {
		n += 1 + sovOci(uint64(m.Timeout))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Linux) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.UIDMappings) > 0 {
		for _, e := range m.UIDMappings {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.GIDMappings) > 0 {
		for _, e := range m.GIDMappings {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Sysctl) > 0 {
		for k, v := range m.Sysctl {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovOci(uint64(len(k))) + 1 + len(v) + sovOci(uint64(len(v)))
			n += mapEntrySize + 1 + sovOci(uint64(mapEntrySize))
		}
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	l = len(m.CgroupsPath)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if len(m.Namespaces) > 0 {
		for _, e := range m.Namespaces {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Devices) > 0 {
		for _, e := range m.Devices {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.Seccomp != nil {
		l = m.Seccomp.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	l = len(m.RootfsPropagation)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if len(m.MaskedPaths) > 0 {
		for _, s := range m.MaskedPaths {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.ReadonlyPaths) > 0 {
		for _, s := range m.ReadonlyPaths {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	l = len(m.MountLabel)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.IntelRdt != nil {
		l = m.IntelRdt.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Windows) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Dummy)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Solaris) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Dummy)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxIDMapping) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HostID != 0 {
		n += 1 + sovOci(uint64(m.HostID))
	}
	if m.ContainerID != 0 {
		n += 1 + sovOci(uint64(m.ContainerID))
	}
	if m.Size_ != 0 {
		n += 1 + sovOci(uint64(m.Size_))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxNamespace) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxDevice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Major != 0 {
		n += 1 + sovOci(uint64(m.Major))
	}
	if m.Minor != 0 {
		n += 1 + sovOci(uint64(m.Minor))
	}
	if m.FileMode != 0 {
		n += 1 + sovOci(uint64(m.FileMode))
	}
	if m.UID != 0 {
		n += 1 + sovOci(uint64(m.UID))
	}
	if m.GID != 0 {
		n += 1 + sovOci(uint64(m.GID))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxResources) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Devices) > 0 {
		for _, e := range m.Devices {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.Memory != nil {
		l = m.Memory.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if m.CPU != nil {
		l = m.CPU.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Pids != nil {
		l = m.Pids.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if m.BlockIO != nil {
		l = m.BlockIO.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if len(m.HugepageLimits) > 0 {
		for _, e := range m.HugepageLimits {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.Network != nil {
		l = m.Network.Size()
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxMemory) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Limit != 0 {
		n += 1 + sovOci(uint64(m.Limit))
	}
	if m.Reservation != 0 {
		n += 1 + sovOci(uint64(m.Reservation))
	}
	if m.Swap != 0 {
		n += 1 + sovOci(uint64(m.Swap))
	}
	if m.Kernel != 0 {
		n += 1 + sovOci(uint64(m.Kernel))
	}
	if m.KernelTCP != 0 {
		n += 1 + sovOci(uint64(m.KernelTCP))
	}
	if m.Swappiness != 0 {
		n += 1 + sovOci(uint64(m.Swappiness))
	}
	if m.DisableOOMKiller {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxCPU) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Shares != 0 {
		n += 1 + sovOci(uint64(m.Shares))
	}
	if m.Quota != 0 {
		n += 1 + sovOci(uint64(m.Quota))
	}
	if m.Period != 0 {
		n += 1 + sovOci(uint64(m.Period))
	}
	if m.RealtimeRuntime != 0 {
		n += 1 + sovOci(uint64(m.RealtimeRuntime))
	}
	if m.RealtimePeriod != 0 {
		n += 1 + sovOci(uint64(m.RealtimePeriod))
	}
	l = len(m.Cpus)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	l = len(m.Mems)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxWeightDevice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Major != 0 {
		n += 1 + sovOci(uint64(m.Major))
	}
	if m.Minor != 0 {
		n += 1 + sovOci(uint64(m.Minor))
	}
	if m.Weight != 0 {
		n += 1 + sovOci(uint64(m.Weight))
	}
	if m.LeafWeight != 0 {
		n += 1 + sovOci(uint64(m.LeafWeight))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxThrottleDevice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Major != 0 {
		n += 1 + sovOci(uint64(m.Major))
	}
	if m.Minor != 0 {
		n += 1 + sovOci(uint64(m.Minor))
	}
	if m.Rate != 0 {
		n += 1 + sovOci(uint64(m.Rate))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxBlockIO) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Weight != 0 {
		n += 1 + sovOci(uint64(m.Weight))
	}
	if m.LeafWeight != 0 {
		n += 1 + sovOci(uint64(m.LeafWeight))
	}
	if len(m.WeightDevice) > 0 {
		for _, e := range m.WeightDevice {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.ThrottleReadBpsDevice) > 0 {
		for _, e := range m.ThrottleReadBpsDevice {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.ThrottleWriteBpsDevice) > 0 {
		for _, e := range m.ThrottleWriteBpsDevice {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.ThrottleReadIOPSDevice) > 0 {
		for _, e := range m.ThrottleReadIOPSDevice {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.ThrottleWriteIOPSDevice) > 0 {
		for _, e := range m.ThrottleWriteIOPSDevice {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxPids) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Limit != 0 {
		n += 1 + sovOci(uint64(m.Limit))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxDeviceCgroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Allow {
		n += 2
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Major != 0 {
		n += 1 + sovOci(uint64(m.Major))
	}
	if m.Minor != 0 {
		n += 1 + sovOci(uint64(m.Minor))
	}
	l = len(m.Access)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxNetwork) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClassID != 0 {
		n += 1 + sovOci(uint64(m.ClassID))
	}
	if len(m.Priorities) > 0 {
		for _, e := range m.Priorities {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxHugepageLimit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Pagesize)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Limit != 0 {
		n += 1 + sovOci(uint64(m.Limit))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxInterfacePriority) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.Priority != 0 {
		n += 1 + sovOci(uint64(m.Priority))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxSeccomp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DefaultAction)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if len(m.Architectures) > 0 {
		for _, s := range m.Architectures {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Flags) > 0 {
		for _, s := range m.Flags {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if len(m.Syscalls) > 0 {
		for _, e := range m.Syscalls {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxSeccompArg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Index != 0 {
		n += 1 + sovOci(uint64(m.Index))
	}
	if m.Value != 0 {
		n += 1 + sovOci(uint64(m.Value))
	}
	if m.ValueTwo != 0 {
		n += 1 + sovOci(uint64(m.ValueTwo))
	}
	l = len(m.Op)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxSyscall) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, s := range m.Names {
			l = len(s)
			n += 1 + l + sovOci(uint64(l))
		}
	}
	l = len(m.Action)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.ErrnoRet != nil {
		n += m.ErrnoRet.Size()
	}
	if len(m.Args) > 0 {
		for _, e := range m.Args {
			l = e.Size()
			n += 1 + l + sovOci(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinuxSyscall_Errnoret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovOci(uint64(m.Errnoret))
	return n
}
func (m *LinuxIntelRdt) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.L3CacheSchema)
	if l > 0 {
		n += 1 + l + sovOci(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovOci(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozOci(x uint64) (n int) {
	return sovOci(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Spec) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForMounts := "[]Mount{"
	for _, f := range this.Mounts {
		repeatedStringForMounts += strings.Replace(strings.Replace(f.String(), "Mount", "Mount", 1), `&`, ``, 1) + ","
	}
	repeatedStringForMounts += "}"
	keysForAnnotations := make([]string, 0, len(this.Annotations))
	for k, _ := range this.Annotations {
		keysForAnnotations = append(keysForAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAnnotations)
	mapStringForAnnotations := "map[string]string{"
	for _, k := range keysForAnnotations {
		mapStringForAnnotations += fmt.Sprintf("%v: %v,", k, this.Annotations[k])
	}
	mapStringForAnnotations += "}"
	s := strings.Join([]string{`&Spec{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`Process:` + strings.Replace(this.Process.String(), "Process", "Process", 1) + `,`,
		`Root:` + strings.Replace(this.Root.String(), "Root", "Root", 1) + `,`,
		`Hostname:` + fmt.Sprintf("%v", this.Hostname) + `,`,
		`Mounts:` + repeatedStringForMounts + `,`,
		`Hooks:` + strings.Replace(this.Hooks.String(), "Hooks", "Hooks", 1) + `,`,
		`Annotations:` + mapStringForAnnotations + `,`,
		`Linux:` + strings.Replace(this.Linux.String(), "Linux", "Linux", 1) + `,`,
		`Solaris:` + strings.Replace(this.Solaris.String(), "Solaris", "Solaris", 1) + `,`,
		`Windows:` + strings.Replace(this.Windows.String(), "Windows", "Windows", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Process) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForRlimits := "[]POSIXRlimit{"
	for _, f := range this.Rlimits {
		repeatedStringForRlimits += strings.Replace(strings.Replace(f.String(), "POSIXRlimit", "POSIXRlimit", 1), `&`, ``, 1) + ","
	}
	repeatedStringForRlimits += "}"
	s := strings.Join([]string{`&Process{`,
		`Terminal:` + fmt.Sprintf("%v", this.Terminal) + `,`,
		`ConsoleSize:` + strings.Replace(this.ConsoleSize.String(), "Box", "Box", 1) + `,`,
		`User:` + strings.Replace(strings.Replace(this.User.String(), "User", "User", 1), `&`, ``, 1) + `,`,
		`Args:` + fmt.Sprintf("%v", this.Args) + `,`,
		`Env:` + fmt.Sprintf("%v", this.Env) + `,`,
		`Cwd:` + fmt.Sprintf("%v", this.Cwd) + `,`,
		`Capabilities:` + strings.Replace(this.Capabilities.String(), "LinuxCapabilities", "LinuxCapabilities", 1) + `,`,
		`Rlimits:` + repeatedStringForRlimits + `,`,
		`NoNewPrivileges:` + fmt.Sprintf("%v", this.NoNewPrivileges) + `,`,
		`ApparmorProfile:` + fmt.Sprintf("%v", this.ApparmorProfile) + `,`,
		`OOMScoreAdj:` + fmt.Sprintf("%v", this.OOMScoreAdj) + `,`,
		`SelinuxLabel:` + fmt.Sprintf("%v", this.SelinuxLabel) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Box) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Box{`,
		`Height:` + fmt.Sprintf("%v", this.Height) + `,`,
		`Width:` + fmt.Sprintf("%v", this.Width) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *User) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&User{`,
		`UID:` + fmt.Sprintf("%v", this.UID) + `,`,
		`GID:` + fmt.Sprintf("%v", this.GID) + `,`,
		`AdditionalGids:` + fmt.Sprintf("%v", this.AdditionalGids) + `,`,
		`Username:` + fmt.Sprintf("%v", this.Username) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxCapabilities) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxCapabilities{`,
		`Bounding:` + fmt.Sprintf("%v", this.Bounding) + `,`,
		`Effective:` + fmt.Sprintf("%v", this.Effective) + `,`,
		`Inheritable:` + fmt.Sprintf("%v", this.Inheritable) + `,`,
		`Permitted:` + fmt.Sprintf("%v", this.Permitted) + `,`,
		`Ambient:` + fmt.Sprintf("%v", this.Ambient) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *POSIXRlimit) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&POSIXRlimit{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Hard:` + fmt.Sprintf("%v", this.Hard) + `,`,
		`Soft:` + fmt.Sprintf("%v", this.Soft) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mount) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Mount{`,
		`Destination:` + fmt.Sprintf("%v", this.Destination) + `,`,
		`Source:` + fmt.Sprintf("%v", this.Source) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Options:` + fmt.Sprintf("%v", this.Options) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Root) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Root{`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`Readonly:` + fmt.Sprintf("%v", this.Readonly) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Hooks) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForPrestart := "[]Hook{"
	for _, f := range this.Prestart {
		repeatedStringForPrestart += strings.Replace(strings.Replace(f.String(), "Hook", "Hook", 1), `&`, ``, 1) + ","
	}
	repeatedStringForPrestart += "}"
	repeatedStringForPoststart := "[]Hook{"
	for _, f := range this.Poststart {
		repeatedStringForPoststart += strings.Replace(strings.Replace(f.String(), "Hook", "Hook", 1), `&`, ``, 1) + ","
	}
	repeatedStringForPoststart += "}"
	repeatedStringForPoststop := "[]Hook{"
	for _, f := range this.Poststop {
		repeatedStringForPoststop += strings.Replace(strings.Replace(f.String(), "Hook", "Hook", 1), `&`, ``, 1) + ","
	}
	repeatedStringForPoststop += "}"
	s := strings.Join([]string{`&Hooks{`,
		`Prestart:` + repeatedStringForPrestart + `,`,
		`Poststart:` + repeatedStringForPoststart + `,`,
		`Poststop:` + repeatedStringForPoststop + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Hook) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Hook{`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`Args:` + fmt.Sprintf("%v", this.Args) + `,`,
		`Env:` + fmt.Sprintf("%v", this.Env) + `,`,
		`Timeout:` + fmt.Sprintf("%v", this.Timeout) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Linux) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForUIDMappings := "[]LinuxIDMapping{"
	for _, f := range this.UIDMappings {
		repeatedStringForUIDMappings += strings.Replace(strings.Replace(f.String(), "LinuxIDMapping", "LinuxIDMapping", 1), `&`, ``, 1) + ","
	}
	repeatedStringForUIDMappings += "}"
	repeatedStringForGIDMappings := "[]LinuxIDMapping{"
	for _, f := range this.GIDMappings {
		repeatedStringForGIDMappings += strings.Replace(strings.Replace(f.String(), "LinuxIDMapping", "LinuxIDMapping", 1), `&`, ``, 1) + ","
	}
	repeatedStringForGIDMappings += "}"
	repeatedStringForNamespaces := "[]LinuxNamespace{"
	for _, f := range this.Namespaces {
		repeatedStringForNamespaces += strings.Replace(strings.Replace(f.String(), "LinuxNamespace", "LinuxNamespace", 1), `&`, ``, 1) + ","
	}
	repeatedStringForNamespaces += "}"
	repeatedStringForDevices := "[]LinuxDevice{"
	for _, f := range this.Devices {
		repeatedStringForDevices += strings.Replace(strings.Replace(f.String(), "LinuxDevice", "LinuxDevice", 1), `&`, ``, 1) + ","
	}
	repeatedStringForDevices += "}"
	keysForSysctl := make([]string, 0, len(this.Sysctl))
	for k, _ := range this.Sysctl {
		keysForSysctl = append(keysForSysctl, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSysctl)
	mapStringForSysctl := "map[string]string{"
	for _, k := range keysForSysctl {
		mapStringForSysctl += fmt.Sprintf("%v: %v,", k, this.Sysctl[k])
	}
	mapStringForSysctl += "}"
	s := strings.Join([]string{`&Linux{`,
		`UIDMappings:` + repeatedStringForUIDMappings + `,`,
		`GIDMappings:` + repeatedStringForGIDMappings + `,`,
		`Sysctl:` + mapStringForSysctl + `,`,
		`Resources:` + strings.Replace(this.Resources.String(), "LinuxResources", "LinuxResources", 1) + `,`,
		`CgroupsPath:` + fmt.Sprintf("%v", this.CgroupsPath) + `,`,
		`Namespaces:` + repeatedStringForNamespaces + `,`,
		`Devices:` + repeatedStringForDevices + `,`,
		`Seccomp:` + strings.Replace(this.Seccomp.String(), "LinuxSeccomp", "LinuxSeccomp", 1) + `,`,
		`RootfsPropagation:` + fmt.Sprintf("%v", this.RootfsPropagation) + `,`,
		`MaskedPaths:` + fmt.Sprintf("%v", this.MaskedPaths) + `,`,
		`ReadonlyPaths:` + fmt.Sprintf("%v", this.ReadonlyPaths) + `,`,
		`MountLabel:` + fmt.Sprintf("%v", this.MountLabel) + `,`,
		`IntelRdt:` + strings.Replace(this.IntelRdt.String(), "LinuxIntelRdt", "LinuxIntelRdt", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Windows) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Windows{`,
		`Dummy:` + fmt.Sprintf("%v", this.Dummy) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Solaris) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Solaris{`,
		`Dummy:` + fmt.Sprintf("%v", this.Dummy) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxIDMapping) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxIDMapping{`,
		`HostID:` + fmt.Sprintf("%v", this.HostID) + `,`,
		`ContainerID:` + fmt.Sprintf("%v", this.ContainerID) + `,`,
		`Size_:` + fmt.Sprintf("%v", this.Size_) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxNamespace) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxNamespace{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxDevice) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxDevice{`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Major:` + fmt.Sprintf("%v", this.Major) + `,`,
		`Minor:` + fmt.Sprintf("%v", this.Minor) + `,`,
		`FileMode:` + fmt.Sprintf("%v", this.FileMode) + `,`,
		`UID:` + fmt.Sprintf("%v", this.UID) + `,`,
		`GID:` + fmt.Sprintf("%v", this.GID) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxResources) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForDevices := "[]LinuxDeviceCgroup{"
	for _, f := range this.Devices {
		repeatedStringForDevices += strings.Replace(strings.Replace(f.String(), "LinuxDeviceCgroup", "LinuxDeviceCgroup", 1), `&`, ``, 1) + ","
	}
	repeatedStringForDevices += "}"
	repeatedStringForHugepageLimits := "[]LinuxHugepageLimit{"
	for _, f := range this.HugepageLimits {
		repeatedStringForHugepageLimits += strings.Replace(strings.Replace(f.String(), "LinuxHugepageLimit", "LinuxHugepageLimit", 1), `&`, ``, 1) + ","
	}
	repeatedStringForHugepageLimits += "}"
	s := strings.Join([]string{`&LinuxResources{`,
		`Devices:` + repeatedStringForDevices + `,`,
		`Memory:` + strings.Replace(this.Memory.String(), "LinuxMemory", "LinuxMemory", 1) + `,`,
		`CPU:` + strings.Replace(this.CPU.String(), "LinuxCPU", "LinuxCPU", 1) + `,`,
		`Pids:` + strings.Replace(this.Pids.String(), "LinuxPids", "LinuxPids", 1) + `,`,
		`BlockIO:` + strings.Replace(this.BlockIO.String(), "LinuxBlockIO", "LinuxBlockIO", 1) + `,`,
		`HugepageLimits:` + repeatedStringForHugepageLimits + `,`,
		`Network:` + strings.Replace(this.Network.String(), "LinuxNetwork", "LinuxNetwork", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxMemory) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxMemory{`,
		`Limit:` + fmt.Sprintf("%v", this.Limit) + `,`,
		`Reservation:` + fmt.Sprintf("%v", this.Reservation) + `,`,
		`Swap:` + fmt.Sprintf("%v", this.Swap) + `,`,
		`Kernel:` + fmt.Sprintf("%v", this.Kernel) + `,`,
		`KernelTCP:` + fmt.Sprintf("%v", this.KernelTCP) + `,`,
		`Swappiness:` + fmt.Sprintf("%v", this.Swappiness) + `,`,
		`DisableOOMKiller:` + fmt.Sprintf("%v", this.DisableOOMKiller) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxCPU) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxCPU{`,
		`Shares:` + fmt.Sprintf("%v", this.Shares) + `,`,
		`Quota:` + fmt.Sprintf("%v", this.Quota) + `,`,
		`Period:` + fmt.Sprintf("%v", this.Period) + `,`,
		`RealtimeRuntime:` + fmt.Sprintf("%v", this.RealtimeRuntime) + `,`,
		`RealtimePeriod:` + fmt.Sprintf("%v", this.RealtimePeriod) + `,`,
		`Cpus:` + fmt.Sprintf("%v", this.Cpus) + `,`,
		`Mems:` + fmt.Sprintf("%v", this.Mems) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxWeightDevice) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxWeightDevice{`,
		`Major:` + fmt.Sprintf("%v", this.Major) + `,`,
		`Minor:` + fmt.Sprintf("%v", this.Minor) + `,`,
		`Weight:` + fmt.Sprintf("%v", this.Weight) + `,`,
		`LeafWeight:` + fmt.Sprintf("%v", this.LeafWeight) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxThrottleDevice) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxThrottleDevice{`,
		`Major:` + fmt.Sprintf("%v", this.Major) + `,`,
		`Minor:` + fmt.Sprintf("%v", this.Minor) + `,`,
		`Rate:` + fmt.Sprintf("%v", this.Rate) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxBlockIO) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForWeightDevice := "[]LinuxWeightDevice{"
	for _, f := range this.WeightDevice {
		repeatedStringForWeightDevice += strings.Replace(strings.Replace(f.String(), "LinuxWeightDevice", "LinuxWeightDevice", 1), `&`, ``, 1) + ","
	}
	repeatedStringForWeightDevice += "}"
	repeatedStringForThrottleReadBpsDevice := "[]LinuxThrottleDevice{"
	for _, f := range this.ThrottleReadBpsDevice {
		repeatedStringForThrottleReadBpsDevice += strings.Replace(strings.Replace(f.String(), "LinuxThrottleDevice", "LinuxThrottleDevice", 1), `&`, ``, 1) + ","
	}
	repeatedStringForThrottleReadBpsDevice += "}"
	repeatedStringForThrottleWriteBpsDevice := "[]LinuxThrottleDevice{"
	for _, f := range this.ThrottleWriteBpsDevice {
		repeatedStringForThrottleWriteBpsDevice += strings.Replace(strings.Replace(f.String(), "LinuxThrottleDevice", "LinuxThrottleDevice", 1), `&`, ``, 1) + ","
	}
	repeatedStringForThrottleWriteBpsDevice += "}"
	repeatedStringForThrottleReadIOPSDevice := "[]LinuxThrottleDevice{"
	for _, f := range this.ThrottleReadIOPSDevice {
		repeatedStringForThrottleReadIOPSDevice += strings.Replace(strings.Replace(f.String(), "LinuxThrottleDevice", "LinuxThrottleDevice", 1), `&`, ``, 1) + ","
	}
	repeatedStringForThrottleReadIOPSDevice += "}"
	repeatedStringForThrottleWriteIOPSDevice := "[]LinuxThrottleDevice{"
	for _, f := range this.ThrottleWriteIOPSDevice {
		repeatedStringForThrottleWriteIOPSDevice += strings.Replace(strings.Replace(f.String(), "LinuxThrottleDevice", "LinuxThrottleDevice", 1), `&`, ``, 1) + ","
	}
	repeatedStringForThrottleWriteIOPSDevice += "}"
	s := strings.Join([]string{`&LinuxBlockIO{`,
		`Weight:` + fmt.Sprintf("%v", this.Weight) + `,`,
		`LeafWeight:` + fmt.Sprintf("%v", this.LeafWeight) + `,`,
		`WeightDevice:` + repeatedStringForWeightDevice + `,`,
		`ThrottleReadBpsDevice:` + repeatedStringForThrottleReadBpsDevice + `,`,
		`ThrottleWriteBpsDevice:` + repeatedStringForThrottleWriteBpsDevice + `,`,
		`ThrottleReadIOPSDevice:` + repeatedStringForThrottleReadIOPSDevice + `,`,
		`ThrottleWriteIOPSDevice:` + repeatedStringForThrottleWriteIOPSDevice + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxPids) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxPids{`,
		`Limit:` + fmt.Sprintf("%v", this.Limit) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxDeviceCgroup) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxDeviceCgroup{`,
		`Allow:` + fmt.Sprintf("%v", this.Allow) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Major:` + fmt.Sprintf("%v", this.Major) + `,`,
		`Minor:` + fmt.Sprintf("%v", this.Minor) + `,`,
		`Access:` + fmt.Sprintf("%v", this.Access) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxNetwork) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForPriorities := "[]LinuxInterfacePriority{"
	for _, f := range this.Priorities {
		repeatedStringForPriorities += strings.Replace(strings.Replace(f.String(), "LinuxInterfacePriority", "LinuxInterfacePriority", 1), `&`, ``, 1) + ","
	}
	repeatedStringForPriorities += "}"
	s := strings.Join([]string{`&LinuxNetwork{`,
		`ClassID:` + fmt.Sprintf("%v", this.ClassID) + `,`,
		`Priorities:` + repeatedStringForPriorities + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxHugepageLimit) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxHugepageLimit{`,
		`Pagesize:` + fmt.Sprintf("%v", this.Pagesize) + `,`,
		`Limit:` + fmt.Sprintf("%v", this.Limit) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxInterfacePriority) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxInterfacePriority{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Priority:` + fmt.Sprintf("%v", this.Priority) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxSeccomp) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForSyscalls := "[]LinuxSyscall{"
	for _, f := range this.Syscalls {
		repeatedStringForSyscalls += strings.Replace(strings.Replace(f.String(), "LinuxSyscall", "LinuxSyscall", 1), `&`, ``, 1) + ","
	}
	repeatedStringForSyscalls += "}"
	s := strings.Join([]string{`&LinuxSeccomp{`,
		`DefaultAction:` + fmt.Sprintf("%v", this.DefaultAction) + `,`,
		`Architectures:` + fmt.Sprintf("%v", this.Architectures) + `,`,
		`Flags:` + fmt.Sprintf("%v", this.Flags) + `,`,
		`Syscalls:` + repeatedStringForSyscalls + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxSeccompArg) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxSeccompArg{`,
		`Index:` + fmt.Sprintf("%v", this.Index) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`ValueTwo:` + fmt.Sprintf("%v", this.ValueTwo) + `,`,
		`Op:` + fmt.Sprintf("%v", this.Op) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxSyscall) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForArgs := "[]LinuxSeccompArg{"
	for _, f := range this.Args {
		repeatedStringForArgs += strings.Replace(strings.Replace(f.String(), "LinuxSeccompArg", "LinuxSeccompArg", 1), `&`, ``, 1) + ","
	}
	repeatedStringForArgs += "}"
	s := strings.Join([]string{`&LinuxSyscall{`,
		`Names:` + fmt.Sprintf("%v", this.Names) + `,`,
		`Action:` + fmt.Sprintf("%v", this.Action) + `,`,
		`ErrnoRet:` + fmt.Sprintf("%v", this.ErrnoRet) + `,`,
		`Args:` + repeatedStringForArgs + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxSyscall_Errnoret) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxSyscall_Errnoret{`,
		`Errnoret:` + fmt.Sprintf("%v", this.Errnoret) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxIntelRdt) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxIntelRdt{`,
		`L3CacheSchema:` + fmt.Sprintf("%v", this.L3CacheSchema) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringOci(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Spec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Spec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Spec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Process", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Process == nil {
				m.Process = &Process{}
			}
			if err := m.Process.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Root", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Root == nil {
				m.Root = &Root{}
			}
			if err := m.Root.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mounts = append(m.Mounts, Mount{})
			if err := m.Mounts[len(m.Mounts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hooks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hooks == nil {
				m.Hooks = &Hooks{}
			}
			if err := m.Hooks.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOci
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOci
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthOci
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthOci
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOci
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthOci
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthOci
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipOci(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthOci
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Linux", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Linux == nil {
				m.Linux = &Linux{}
			}
			if err := m.Linux.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Solaris", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Solaris == nil {
				m.Solaris = &Solaris{}
			}
			if err := m.Solaris.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Windows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Windows == nil {
				m.Windows = &Windows{}
			}
			if err := m.Windows.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Process) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Process: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Process: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Terminal", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Terminal = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsoleSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConsoleSize == nil {
				m.ConsoleSize = &Box{}
			}
			if err := m.ConsoleSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.User.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cwd", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cwd = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capabilities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Capabilities == nil {
				m.Capabilities = &LinuxCapabilities{}
			}
			if err := m.Capabilities.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rlimits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rlimits = append(m.Rlimits, POSIXRlimit{})
			if err := m.Rlimits[len(m.Rlimits)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoNewPrivileges", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoNewPrivileges = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApparmorProfile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApparmorProfile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OOMScoreAdj", wireType)
			}
			m.OOMScoreAdj = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OOMScoreAdj |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SelinuxLabel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SelinuxLabel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Box) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Box: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Box: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Width", wireType)
			}
			m.Width = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Width |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *User) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: User: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: User: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UID", wireType)
			}
			m.UID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UID |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GID", wireType)
			}
			m.GID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GID |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOci
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AdditionalGids = append(m.AdditionalGids, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOci
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOci
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthOci
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.AdditionalGids) == 0 {
					m.AdditionalGids = make([]uint32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOci
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.AdditionalGids = append(m.AdditionalGids, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalGids", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxCapabilities) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxCapabilities: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxCapabilities: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bounding", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bounding = append(m.Bounding, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Effective", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Effective = append(m.Effective, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inheritable", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Inheritable = append(m.Inheritable, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permitted", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Permitted = append(m.Permitted, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ambient", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ambient = append(m.Ambient, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *POSIXRlimit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: POSIXRlimit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: POSIXRlimit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hard", wireType)
			}
			m.Hard = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Hard |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Soft", wireType)
			}
			m.Soft = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Soft |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mount) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mount: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mount: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destination", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Destination = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = append(m.Options, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Root) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Root: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Root: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Readonly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Readonly = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Hooks) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Hooks: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Hooks: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prestart", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prestart = append(m.Prestart, Hook{})
			if err := m.Prestart[len(m.Prestart)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Poststart", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Poststart = append(m.Poststart, Hook{})
			if err := m.Poststart[len(m.Poststart)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Poststop", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Poststop = append(m.Poststop, Hook{})
			if err := m.Poststop[len(m.Poststop)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Hook) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Hook: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Hook: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			m.Timeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timeout |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Linux) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Linux: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Linux: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UIDMappings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UIDMappings = append(m.UIDMappings, LinuxIDMapping{})
			if err := m.UIDMappings[len(m.UIDMappings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GIDMappings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GIDMappings = append(m.GIDMappings, LinuxIDMapping{})
			if err := m.GIDMappings[len(m.GIDMappings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sysctl", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Sysctl == nil {
				m.Sysctl = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOci
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOci
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthOci
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthOci
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOci
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthOci
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthOci
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipOci(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthOci
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Sysctl[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &LinuxResources{}
			}
			if err := m.Resources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CgroupsPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CgroupsPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespaces", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespaces = append(m.Namespaces, LinuxNamespace{})
			if err := m.Namespaces[len(m.Namespaces)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Devices", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Devices = append(m.Devices, LinuxDevice{})
			if err := m.Devices[len(m.Devices)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seccomp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Seccomp == nil {
				m.Seccomp = &LinuxSeccomp{}
			}
			if err := m.Seccomp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RootfsPropagation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RootfsPropagation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaskedPaths", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MaskedPaths = append(m.MaskedPaths, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadonlyPaths", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReadonlyPaths = append(m.ReadonlyPaths, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MountLabel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MountLabel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntelRdt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IntelRdt == nil {
				m.IntelRdt = &LinuxIntelRdt{}
			}
			if err := m.IntelRdt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Windows) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Windows: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Windows: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dummy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dummy = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Solaris) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Solaris: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Solaris: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dummy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dummy = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxIDMapping) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxIDMapping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxIDMapping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostID", wireType)
			}
			m.HostID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HostID |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			m.ContainerID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ContainerID |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			m.Size_ = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size_ |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxNamespace) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxNamespace: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxNamespace: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxDevice) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxDevice: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxDevice: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Major", wireType)
			}
			m.Major = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Major |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Minor", wireType)
			}
			m.Minor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Minor |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileMode", wireType)
			}
			m.FileMode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FileMode |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UID", wireType)
			}
			m.UID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UID |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GID", wireType)
			}
			m.GID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GID |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxResources) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxResources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxResources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Devices", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Devices = append(m.Devices, LinuxDeviceCgroup{})
			if err := m.Devices[len(m.Devices)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Memory == nil {
				m.Memory = &LinuxMemory{}
			}
			if err := m.Memory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CPU", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CPU == nil {
				m.CPU = &LinuxCPU{}
			}
			if err := m.CPU.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pids", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Pids == nil {
				m.Pids = &LinuxPids{}
			}
			if err := m.Pids.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockIO", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BlockIO == nil {
				m.BlockIO = &LinuxBlockIO{}
			}
			if err := m.BlockIO.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HugepageLimits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HugepageLimits = append(m.HugepageLimits, LinuxHugepageLimit{})
			if err := m.HugepageLimits[len(m.HugepageLimits)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Network == nil {
				m.Network = &LinuxNetwork{}
			}
			if err := m.Network.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxMemory) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxMemory: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxMemory: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reservation", wireType)
			}
			m.Reservation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reservation |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Swap", wireType)
			}
			m.Swap = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Swap |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kernel", wireType)
			}
			m.Kernel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Kernel |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelTCP", wireType)
			}
			m.KernelTCP = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KernelTCP |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Swappiness", wireType)
			}
			m.Swappiness = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Swappiness |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableOOMKiller", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableOOMKiller = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxCPU) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxCPU: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxCPU: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Shares", wireType)
			}
			m.Shares = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Shares |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quota", wireType)
			}
			m.Quota = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Quota |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Period", wireType)
			}
			m.Period = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Period |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RealtimeRuntime", wireType)
			}
			m.RealtimeRuntime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RealtimeRuntime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RealtimePeriod", wireType)
			}
			m.RealtimePeriod = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RealtimePeriod |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cpus", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cpus = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mems", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mems = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxWeightDevice) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxWeightDevice: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxWeightDevice: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Major", wireType)
			}
			m.Major = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Major |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Minor", wireType)
			}
			m.Minor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Minor |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			m.Weight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Weight |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeafWeight", wireType)
			}
			m.LeafWeight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeafWeight |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxThrottleDevice) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxThrottleDevice: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxThrottleDevice: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Major", wireType)
			}
			m.Major = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Major |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Minor", wireType)
			}
			m.Minor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Minor |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rate", wireType)
			}
			m.Rate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Rate |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxBlockIO) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxBlockIO: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxBlockIO: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			m.Weight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Weight |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeafWeight", wireType)
			}
			m.LeafWeight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeafWeight |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WeightDevice", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WeightDevice = append(m.WeightDevice, LinuxWeightDevice{})
			if err := m.WeightDevice[len(m.WeightDevice)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ThrottleReadBpsDevice", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ThrottleReadBpsDevice = append(m.ThrottleReadBpsDevice, LinuxThrottleDevice{})
			if err := m.ThrottleReadBpsDevice[len(m.ThrottleReadBpsDevice)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ThrottleWriteBpsDevice", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ThrottleWriteBpsDevice = append(m.ThrottleWriteBpsDevice, LinuxThrottleDevice{})
			if err := m.ThrottleWriteBpsDevice[len(m.ThrottleWriteBpsDevice)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ThrottleReadIOPSDevice", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ThrottleReadIOPSDevice = append(m.ThrottleReadIOPSDevice, LinuxThrottleDevice{})
			if err := m.ThrottleReadIOPSDevice[len(m.ThrottleReadIOPSDevice)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ThrottleWriteIOPSDevice", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ThrottleWriteIOPSDevice = append(m.ThrottleWriteIOPSDevice, LinuxThrottleDevice{})
			if err := m.ThrottleWriteIOPSDevice[len(m.ThrottleWriteIOPSDevice)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxPids) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxPids: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxPids: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxDeviceCgroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxDeviceCgroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxDeviceCgroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Allow", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Allow = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Major", wireType)
			}
			m.Major = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Major |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Minor", wireType)
			}
			m.Minor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Minor |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Access", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Access = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxNetwork) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxNetwork: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxNetwork: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClassID", wireType)
			}
			m.ClassID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClassID |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priorities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Priorities = append(m.Priorities, LinuxInterfacePriority{})
			if err := m.Priorities[len(m.Priorities)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxHugepageLimit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxHugepageLimit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxHugepageLimit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pagesize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pagesize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxInterfacePriority) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxInterfacePriority: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxInterfacePriority: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxSeccomp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxSeccomp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxSeccomp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultAction", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultAction = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Architectures", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Architectures = append(m.Architectures, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Flags = append(m.Flags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Syscalls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Syscalls = append(m.Syscalls, LinuxSyscall{})
			if err := m.Syscalls[len(m.Syscalls)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxSeccompArg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxSeccompArg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxSeccompArg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValueTwo", wireType)
			}
			m.ValueTwo = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValueTwo |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Op = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxSyscall) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxSyscall: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxSyscall: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Names", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Names = append(m.Names, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Action = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errnoret", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ErrnoRet = &LinuxSyscall_Errnoret{v}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, LinuxSeccompArg{})
			if err := m.Args[len(m.Args)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxIntelRdt) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOci
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxIntelRdt: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxIntelRdt: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field L3CacheSchema", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOci
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOci
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOci
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.L3CacheSchema = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOci(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthOci
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipOci(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowOci
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowOci
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowOci
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthOci
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupOci
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthOci
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthOci        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowOci          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupOci = fmt.Errorf("proto: unexpected end of group")
)
