; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

target datalayout = "p:32:32:32"

declare void @llvm.assume(i1)

define i1 @gep_idx_implicit_truncate(ptr %dst, i64 %off) {
; CHECK-LABEL: @gep_idx_implicit_truncate(
; CHECK-NEXT:    [[POS:%.*]] = icmp sge i64 [[OFF:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[POS]])
; CHECK-NEXT:    [[GEP_OFF:%.*]] = getelementptr inbounds i8, ptr [[DST:%.*]], i64 [[OFF]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule ptr [[DST]], [[GEP_OFF]]
; CHECK-NEXT:    ret i1 true
;
  %pos = icmp sge i64 %off, 0
  call void @llvm.assume(i1 %pos)
  %gep.off = getelementptr inbounds i8, ptr %dst, i64 %off
  %cmp = icmp ule ptr %dst, %gep.off
  ret i1 %cmp
}

define i1 @gep_idx_explicit_truncate(ptr %dst, i64 %off) {
; CHECK-LABEL: @gep_idx_explicit_truncate(
; CHECK-NEXT:    [[POS:%.*]] = icmp sge i64 [[OFF:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[POS]])
; CHECK-NEXT:    [[T:%.*]] = trunc i64 [[OFF]] to i32
; CHECK-NEXT:    [[GEP_OFF:%.*]] = getelementptr inbounds i8, ptr [[DST:%.*]], i32 [[T]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule ptr [[DST]], [[GEP_OFF]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %pos = icmp sge i64 %off, 0
  call void @llvm.assume(i1 %pos)
  %t = trunc i64 %off to i32
  %gep.off = getelementptr inbounds i8, ptr %dst, i32 %t
  %cmp = icmp ule ptr %dst, %gep.off
  ret i1 %cmp
}
