#!/usr/local/bin/perl
##
## Silly little tester for the SERVER_CONFIG version of lookup.
## First run the server, such as 'lookup_server -port 9000 file2Bsearched',
## then run this test program, such as 'perl test.pl -port 9000'.
##

##
## If 'localhost' doesn't work on your machine, try putting in the hostname
## directly. I've found 'localhost' and perl don't get along on some Linux
## distributions.  ##
##
$SERVER = 'localhost';
$PORT = 9827; ## same default as in lookup.h -- can change with '-port'n

##
## network.pl is available at http://www.wg.omron.co.jp/~jfriedl/perl/
##
require "network.pl";

##
## use '-port ####' to use other than the default port.
##
if (@ARGV[0] eq '-port') {
    shift;
    $PORT = shift;
}

$error = &network'connect_to(*SERVER, $SERVER, $PORT);
die "$error\n" if defined $error;

##
## Make sure nothing is buffered.
##
select SERVER;
$| = 1;
select STDOUT;
$| = 1;

##
## Tell the server not to drop the connection after the first reply.
##
print SERVER "--continuous--";
$i = <SERVER>;  ## expect the "--ok--\n" response


while (1)
{
   print "Search Pattern: ";
   chop($i = <STDIN>);

   print SERVER $i;

   while (<SERVER>) {
      print;
      last if $_ eq "--done--\n"; ## server tells us we're done.
   }
}

