/* ----- decode/857x3, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_857x3_checksums[] = {
  "98a770141d432110843494413c1710397aa6bad5b837bae4731ad814be38b81e",
  "f8ad21eb2d86da185a45a6ccb32899e039b561a40c5a5654ab396414d19cd494",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_857x3_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_857x3_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_857x3_ITEMBYTES

static void *storage_decode_857x3_x;
static unsigned char *test_decode_857x3_x;
static void *storage_decode_857x3_s;
static unsigned char *test_decode_857x3_s;
static void *storage_decode_857x3_x2;
static unsigned char *test_decode_857x3_x2;
static void *storage_decode_857x3_s2;
static unsigned char *test_decode_857x3_s2;

#define precomputed_decode_857x3_NUM 4

static const unsigned char precomputed_decode_857x3_x[precomputed_decode_857x3_NUM][crypto_decode_ITEMS] = {
  {0,1,2,1,-1,2,0,2,-1,1,1,2,1,0,-1,1,-1,2,1,2,2,-1,0,0,0,2,2,-1,1,0,2,0,2,1,-1,2,2,0,2,1,1,1,0,2,0,2,-1,0,0,1,1,-1,1,0,-1,0,2,-1,0,0,0,-1,-1,-1,0,0,2,0,0,-1,2,0,1,2,2,0,2,0,2,2,0,2,0,2,2,1,2,0,-1,-1,-1,1,2,0,-1,2,1,2,-1,-1,2,2,0,2,1,0,1,0,-1,-1,0,2,0,-1,0,2,1,2,2,-1,2,2,1,1,1,0,0,-1,2,1,2,1,1,2,2,1,-1,1,0,-1,1,1,2,2,1,1,-1,0,1,0,-1,0,2,0,-1,2,0,0,2,0,0,2,2,1,0,2,0,1,0,-1,-1,1,-1,0,2,-1,1,0,0,1,2,0,-1,-1,-1,0,-1,1,1,-1,0,1,-1,2,1,2,1,-1,0,0,1,-1,2,-1,2,0,0,0,1,0,-1,1,0,2,1,1,0,1,-1,2,-1,0,-1,0,0,1,1,0,-1,2,0,2,-1,2,2,1,0,2,-1,0,2,-1,1,1,0,2,1,2,2,0,2,-1,2,1,0,0,-1,2,-1,-1,1,1,1,0,1,0,1,0,-1,0,0,0,1,-1,0,2,-1,2,0,-1,1,-1,-1,0,1,0,0,2,0,1,2,0,2,0,-1,1,-1,1,2,-1,1,0,2,1,0,0,-1,1,2,0,1,1,0,2,-1,1,-1,2,0,-1,0,0,-1,1,0,0,2,0,-1,1,-1,1,2,2,0,2,1,-1,2,1,0,2,0,2,2,2,-1,2,1,2,-1,1,0,1,-1,1,-1,-1,0,0,-1,0,2,-1,0,1,0,1,2,-1,0,1,1,-1,1,2,2,2,-1,-1,0,-1,1,1,-1,0,-1,-1,2,-1,0,1,0,-1,0,-1,0,2,-1,2,2,1,0,2,0,-1,1,0,-1,1,2,2,-1,2,2,2,0,1,2,2,2,-1,-1,-1,-1,0,0,1,1,0,0,1,-1,1,-1,1,0,1,-1,-1,1,1,1,0,1,1,-1,2,0,1,1,2,2,-1,1,1,2,0,-1,2,1,0,1,-1,-1,-1,0,2,1,2,1,0,1,2,2,-1,2,0,2,1,-1,2,1,-1,1,-1,1,1,1,-1,1,0,0,1,2,1,0,1,0,0,2,1,-1,1,1,2,-1,0,-1,0,0,0,-1,0,2,0,-1,-1,2,1,2,2,1,0,1,2,1,-1,1,2,-1,0,-1,2,-1,1,1,2,0,2,2,-1,1,2,2,1,-1,2,-1,-1,2,-1,2,-1,2,-1,0,1,2,2,2,1,1,1,2,0,-1,-1,2,0,1,1,2,-1,-1,0,2,-1,-1,-1,0,0,0,-1,-1,2,0,2,1,2,1,2,2,-1,-1,-1,1,2,0,0,0,-1,2,0,2,2,0,1,-1,1,-1,0,2,0,2,-1,2,1,-1,-1,0,1,-1,0,1,1,0,0,1,0,1,2,-1,1,2,0,1,0,2,-1,0,-1,-1,1,0,2,0,2,0,1,-1,2,-1,0,0,-1,2,-1,2,-1,2,2,2,1,-1,-1,-1,-1,2,1,1,-1,-1,2,0,-1,1,0,0,2,1,1,2,0,0,0,2,0,0,-1,0,-1,2,0,0,1,-1,0,2,1,0,1,2,1,1,1,-1,2,0,0,1,2,2,2,2,2,2,0,0,2,1,-1,1,0,-1,-1,0,-1,1,-1,0,2,-1,0,1,-1,2,0,2,2,1,-1,2,0,1,-1,2,0,1,0,-1,1,0,2,2,2,-1,1,2,-1,1,0,1,0,-1,1,0,1,-1,1,2,2,1,-1,-1,0,1,-1,2,-1,2,2,1,2,1,0,1,-1,1,0,2,0,2,0,0,1,-1,0,1,0,1,-1,-1,1,2,0,0,0,0,0,-1,2,-1,0,2,1,0,1,-1,1,1,-1,2,0,2,0,-1,2,1,-1,2,1,2,-1,1,2,-1,0,2,2,0,0,0,2,1,-1,2,0,0,-1,1,1,0,-1,-1,-1,2},
  {-1,0,2,-1,-1,0,0,0,-1,1,2,-1,-1,2,2,0,1,2,-1,2,2,-1,1,0,2,1,0,-1,2,-1,-1,0,-1,0,1,-1,2,2,-1,0,1,1,1,2,0,1,0,2,1,-1,2,0,0,0,2,2,1,-1,0,1,2,2,2,2,0,2,1,-1,0,1,-1,1,-1,0,2,0,0,2,-1,-1,0,-1,2,1,1,1,2,2,0,2,-1,-1,1,0,1,0,2,1,-1,0,-1,1,1,-1,2,-1,-1,0,2,-1,-1,0,0,0,1,0,1,-1,-1,2,1,-1,-1,2,-1,1,-1,0,0,1,2,2,2,2,-1,2,-1,0,-1,2,-1,-1,2,1,1,2,1,0,2,2,1,-1,1,1,2,2,0,2,-1,-1,0,2,0,0,2,-1,1,-1,-1,1,0,2,1,1,0,2,-1,1,1,0,2,-1,-1,0,1,0,0,2,-1,1,-1,2,2,-1,0,0,0,-1,-1,1,-1,2,0,-1,1,-1,0,1,-1,0,-1,1,0,2,0,0,2,0,0,1,0,0,-1,-1,1,-1,-1,-1,0,-1,2,1,-1,2,-1,2,-1,0,2,-1,1,-1,-1,2,-1,1,1,2,-1,0,1,1,0,-1,-1,-1,2,-1,0,1,2,2,0,2,0,0,-1,2,2,1,2,1,1,0,0,0,2,0,-1,1,0,0,1,-1,1,-1,2,0,-1,0,2,-1,1,2,1,0,0,0,2,0,1,1,2,-1,-1,0,0,0,-1,1,-1,0,-1,1,2,0,0,0,0,2,1,2,1,0,0,2,-1,1,1,0,2,-1,0,2,2,-1,1,0,-1,-1,0,1,2,0,-1,1,0,2,2,0,2,-1,1,-1,-1,-1,2,0,-1,0,0,2,-1,0,-1,0,2,2,0,1,0,2,-1,1,1,0,-1,2,-1,1,0,1,0,0,-1,1,0,2,-1,0,-1,-1,-1,0,0,0,0,2,0,0,0,0,0,0,1,0,0,0,1,-1,0,1,-1,0,2,2,2,1,2,1,1,0,2,2,-1,0,-1,2,1,1,2,2,-1,0,-1,2,0,1,1,2,0,0,-1,-1,1,1,1,1,1,1,0,-1,0,2,-1,-1,2,1,-1,1,2,1,0,-1,2,0,2,0,1,2,0,1,0,2,0,1,0,2,0,-1,-1,2,0,0,0,0,0,-1,0,1,2,-1,-1,1,0,-1,2,2,1,-1,2,1,2,0,0,-1,2,-1,-1,0,-1,-1,2,1,0,-1,1,1,-1,1,-1,2,1,0,0,0,1,2,1,1,1,-1,1,-1,2,-1,2,1,0,2,2,1,1,2,-1,2,-1,2,2,1,-1,2,-1,1,-1,1,1,1,-1,1,-1,0,-1,1,2,2,2,2,0,0,1,0,0,0,-1,2,0,0,2,-1,0,1,-1,-1,1,2,-1,0,-1,0,-1,1,2,-1,0,0,2,0,-1,-1,2,0,-1,-1,2,2,1,-1,1,0,-1,1,2,0,0,2,1,2,2,0,0,-1,2,-1,-1,2,2,2,0,-1,0,-1,-1,0,1,-1,1,1,0,0,1,1,1,0,0,-1,1,2,2,2,-1,-1,0,2,0,2,0,1,1,1,2,1,0,-1,0,2,-1,0,1,2,-1,-1,0,0,0,2,-1,-1,0,-1,1,0,0,0,-1,-1,-1,-1,1,0,1,2,0,-1,1,1,0,0,0,-1,0,1,-1,-1,-1,2,0,0,1,-1,0,0,2,-1,1,0,2,0,-1,-1,2,1,2,2,1,0,-1,-1,0,1,-1,2,1,1,1,0,-1,0,0,2,1,0,1,1,1,0,2,2,2,1,0,1,-1,2,0,-1,0,0,0,2,-1,1,-1,2,1,1,1,-1,2,-1,2,-1,1,0,-1,0,0,1,2,1,0,-1,0,0,0,-1,1,0,0,0,0,1,0,2,0,-1,1,0,1,2,2,2,1,2,-1,-1,2,2,2,-1,1,2,2,0,0,2,0,-1,0,1,0,1,0,0,-1,2,-1,0,2,1,0,2,1,-1,-1,1,1,0,-1,1,0,1,0,0,-1,2,0,2,2,2,1,1,1,-1,-1,2,1},
  {2,0,0,1,0,1,0,-1,2,1,2,2,1,1,2,1,0,-1,1,2,-1,1,0,-1,1,2,1,1,1,2,-1,-1,2,2,2,0,-1,0,0,2,-1,0,0,-1,2,0,-1,0,-1,0,2,0,0,-1,0,2,2,0,0,-1,2,1,-1,2,0,-1,0,2,1,2,0,1,0,0,1,1,0,2,-1,-1,2,2,-1,1,2,2,0,1,0,2,2,-1,2,-1,1,1,0,2,1,-1,1,2,2,1,-1,0,2,2,2,-1,0,0,1,2,0,0,2,1,2,2,1,1,0,2,0,-1,0,1,-1,-1,1,1,2,1,1,2,1,1,0,0,0,1,0,-1,-1,0,2,-1,0,-1,1,0,2,-1,2,1,-1,2,1,-1,1,0,1,2,-1,2,-1,-1,0,0,0,-1,-1,-1,0,-1,2,2,-1,2,-1,1,2,0,0,2,0,-1,-1,1,0,-1,1,2,-1,-1,1,-1,-1,0,-1,0,-1,0,2,0,-1,-1,1,1,0,2,2,1,-1,1,-1,-1,2,-1,-1,0,-1,0,2,0,2,2,2,2,-1,2,-1,-1,1,1,2,0,2,0,0,2,0,0,1,2,2,2,0,0,0,1,1,1,-1,0,2,-1,2,1,0,0,-1,2,1,-1,1,2,2,-1,-1,-1,1,0,-1,0,2,1,-1,0,2,0,2,2,2,2,0,-1,-1,-1,-1,0,-1,-1,1,2,2,-1,2,-1,-1,-1,-1,1,-1,-1,1,1,0,2,0,0,0,-1,2,2,-1,0,-1,-1,2,2,1,1,1,2,-1,2,-1,-1,-1,-1,0,-1,0,1,0,0,2,-1,2,0,2,2,-1,-1,1,0,-1,1,-1,0,-1,1,-1,2,0,0,-1,-1,0,0,1,1,0,0,0,2,-1,0,2,0,2,-1,-1,0,0,0,-1,2,1,0,1,0,2,1,-1,0,1,2,0,-1,1,1,0,0,1,2,1,0,0,-1,2,1,1,-1,-1,1,-1,2,2,1,0,1,0,-1,2,2,-1,-1,1,-1,-1,2,0,-1,0,2,-1,1,2,2,-1,1,-1,-1,-1,-1,0,1,-1,-1,-1,0,0,1,0,2,2,-1,2,2,1,-1,2,2,2,1,0,0,-1,1,2,2,2,1,1,-1,1,1,-1,2,0,2,1,0,0,-1,1,0,-1,-1,-1,2,2,1,0,-1,2,2,1,-1,2,-1,1,0,1,0,2,1,1,0,2,0,2,0,-1,0,0,-1,2,-1,0,-1,1,2,1,0,1,-1,0,-1,1,0,-1,2,2,2,2,-1,0,2,-1,2,2,0,0,0,-1,-1,-1,-1,-1,1,2,2,1,1,2,0,0,1,1,0,1,0,1,-1,1,-1,2,0,0,2,0,-1,1,-1,2,-1,-1,0,0,2,-1,0,2,-1,1,0,-1,0,0,0,1,-1,-1,2,1,2,0,2,-1,1,1,2,-1,0,0,1,1,1,-1,0,2,2,0,1,-1,-1,-1,1,1,0,-1,2,0,2,2,1,0,1,0,1,1,2,1,0,-1,-1,1,0,2,2,1,2,2,0,-1,2,1,-1,0,-1,-1,0,1,-1,2,2,2,0,0,-1,2,1,1,-1,-1,1,1,1,2,0,0,0,-1,1,-1,2,1,2,2,1,1,-1,-1,1,0,0,1,-1,1,2,1,1,-1,-1,0,2,-1,1,2,0,-1,1,0,1,0,-1,2,1,2,1,-1,1,0,2,2,0,-1,-1,2,1,1,0,2,0,2,2,2,0,1,-1,1,2,0,2,2,0,2,1,0,0,0,-1,2,1,1,-1,-1,2,-1,-1,-1,2,0,-1,-1,2,2,-1,1,2,0,0,0,2,-1,1,1,2,2,1,2,0,-1,0,1,0,1,0,-1,0,0,0,1,-1,2,0,2,0,0,-1,2,-1,2,-1,2,1,1,-1,0,-1,2,2,0,-1,0,0,1,-1,1,-1,2,-1,0,1,2,1,-1,2,0,0,-1,2,2,0,2,-1,2,-1,0,-1,0,2,1,-1,2,1,-1,0,1,1,1,1,2,0,1,1,1,-1,2,-1,-1,2,0,1,-1,0,1,0,2,0,1,2,1},
  {1,1,2,1,2,2,2,-1,2,-1,-1,2,1,1,0,1,0,-1,2,1,1,-1,-1,-1,-1,2,2,-1,-1,-1,2,-1,1,1,0,1,0,2,2,0,2,2,-1,2,2,0,0,1,-1,-1,-1,2,1,2,-1,0,-1,0,0,0,1,0,1,1,0,-1,0,-1,-1,1,-1,0,1,0,1,2,0,-1,0,1,2,0,2,1,2,1,-1,0,-1,1,-1,1,-1,1,1,-1,-1,1,0,-1,-1,0,1,0,0,0,-1,0,0,1,2,0,-1,0,0,2,2,0,2,-1,0,2,-1,-1,-1,1,0,-1,2,2,0,2,2,2,0,0,1,0,2,-1,-1,2,1,0,1,2,2,0,1,0,0,1,1,1,2,2,2,0,-1,0,2,2,-1,1,1,-1,1,0,0,1,0,0,1,0,-1,2,1,2,0,2,2,1,-1,2,0,-1,1,1,-1,-1,-1,1,-1,2,1,-1,2,2,0,0,0,-1,-1,0,1,2,-1,1,1,-1,0,-1,-1,0,2,2,0,2,-1,2,-1,0,1,-1,2,0,0,1,1,-1,0,0,-1,0,2,0,1,2,2,0,1,0,1,2,0,2,0,2,2,1,0,2,2,0,-1,-1,1,2,-1,1,2,1,0,1,2,1,2,-1,-1,-1,1,0,2,-1,2,2,-1,2,0,2,2,1,0,2,-1,-1,2,2,0,2,1,1,2,0,-1,2,0,1,-1,1,-1,2,2,0,0,0,0,1,-1,1,0,0,2,1,2,0,2,0,0,2,-1,2,1,0,0,0,0,-1,-1,1,1,0,0,2,1,-1,2,-1,2,1,1,2,1,2,2,2,1,2,0,0,-1,-1,1,0,2,-1,1,2,-1,-1,0,-1,2,1,0,-1,-1,2,1,0,-1,2,0,0,0,-1,2,0,2,-1,1,-1,-1,0,0,-1,1,2,-1,-1,-1,2,0,0,1,-1,2,2,0,0,-1,2,0,2,-1,0,2,1,1,-1,2,-1,0,0,-1,1,1,1,-1,1,0,2,-1,-1,2,0,0,-1,0,0,1,-1,0,1,1,0,2,-1,2,1,1,-1,-1,-1,-1,1,-1,2,-1,1,2,2,1,1,2,0,1,1,-1,-1,-1,2,2,1,2,0,-1,0,2,1,1,-1,1,2,1,1,0,1,1,0,2,1,0,0,2,0,2,2,0,0,1,2,0,2,0,-1,-1,-1,2,0,1,-1,1,1,-1,1,-1,-1,-1,0,-1,1,-1,1,2,-1,-1,2,1,2,-1,0,0,2,2,2,0,1,0,2,1,2,-1,2,-1,2,2,-1,1,0,2,2,2,-1,1,-1,0,0,1,0,2,-1,2,0,1,0,0,2,-1,2,2,-1,-1,2,2,1,2,1,1,2,1,2,1,2,1,-1,2,2,-1,2,1,2,1,0,2,0,1,2,-1,2,-1,2,1,1,1,1,2,2,2,1,2,1,2,2,2,-1,2,0,-1,2,1,2,-1,1,1,1,0,1,-1,2,2,1,0,2,2,2,2,2,0,2,-1,2,-1,-1,0,0,-1,2,-1,2,-1,2,2,1,-1,1,0,0,0,1,-1,2,0,2,-1,-1,-1,2,0,1,1,0,-1,0,1,1,2,0,2,2,1,1,-1,-1,-1,-1,-1,0,2,-1,0,-1,1,1,0,-1,2,2,0,-1,0,2,2,1,2,0,0,1,1,1,-1,1,2,0,0,1,0,1,0,-1,1,0,2,-1,0,-1,1,2,-1,1,1,2,-1,1,2,1,2,2,0,-1,-1,1,2,2,1,0,1,0,2,2,1,0,-1,-1,2,0,2,0,2,-1,-1,2,1,0,0,2,1,0,0,0,-1,0,2,2,1,2,-1,-1,2,1,1,1,2,-1,0,0,1,0,-1,0,0,0,2,1,-1,-1,1,0,-1,2,0,1,2,0,1,0,2,-1,0,1,-1,-1,-1,1,0,-1,-1,1,2,-1,0,2,1,2,-1,-1,2,1,-1,-1,2,1,-1,2,1,2,1,0,-1,2,2,2,0,2,0,2,2,2,1,-1,1,-1,1,0,1,0,-1,-1,1,1,-1,2,0,0,0,-1,0},
} ;

static const unsigned char precomputed_decode_857x3_s[precomputed_decode_857x3_NUM][crypto_decode_STRBYTES] = {
  {185,220,232,134,236,83,61,118,203,183,218,77,41,70,83,1,117,113,126,247,221,123,128,199,14,223,102,208,209,62,175,22,187,190,24,250,74,70,199,117,189,157,129,52,150,7,132,146,236,82,50,87,134,173,201,68,105,220,188,77,163,237,55,91,12,106,102,84,210,28,66,214,121,135,56,182,133,167,141,28,133,117,136,223,178,221,207,142,137,80,52,153,147,226,15,161,4,147,17,205,219,97,248,252,249,3,148,150,136,9,106,202,233,163,199,38,208,110,62,183,44,162,98,185,89,139,78,84,116,176,111,46,78,140,222,227,203,48,51,249,171,7,167,67,3,21,220,238,3,94,113,159,72,55,11,73,90,230,120,54,129,221,201,20,51,191,0,43,28,214,122,117,17,151,180,185,202,229,255,215,98,16,210,36,247,114,114,134,253,56,102,152,248,66,50,239,38,118,151,100,130,87,197,180,137,114,199,178,227,244,213,114,161,1,63},
  {52,84,56,124,206,99,27,67,36,79,234,217,114,245,146,255,45,137,116,13,177,250,13,102,75,40,67,67,101,194,194,72,249,207,196,176,110,47,250,13,93,35,216,218,104,67,214,200,83,129,28,146,132,93,151,5,2,177,204,52,194,232,164,1,147,223,197,187,86,135,37,114,52,110,117,58,84,72,120,213,110,141,54,61,6,121,216,55,2,71,77,244,217,104,140,89,216,4,84,93,85,86,146,244,187,246,196,250,196,233,5,170,26,13,139,27,119,158,157,29,92,21,57,24,47,123,49,4,27,138,108,229,42,50,219,235,204,203,136,138,132,255,101,197,53,9,78,132,83,7,7,47,134,215,126,49,252,17,36,90,106,225,15,221,169,27,77,14,213,16,86,0,230,161,21,9,92,82,99,7,251,6,201,106,212,166,246,155,28,213,200,42,51,70,185,81,97,149,29,230,239,240,227,215,145,89,76,219,130,134,89,220,175,194,242},
  {151,25,251,186,225,24,174,14,127,212,20,71,116,209,23,203,209,158,165,13,143,159,61,163,45,190,244,83,94,251,218,145,160,235,90,25,52,97,179,44,230,12,21,16,207,120,29,24,14,66,68,7,218,139,48,68,247,207,160,119,93,254,149,74,179,197,226,3,70,75,247,31,64,224,51,128,160,93,241,4,175,206,0,145,53,247,96,72,200,5,165,213,116,67,197,102,75,30,90,110,177,130,188,25,15,194,209,248,8,144,64,217,243,242,91,248,43,202,109,97,192,27,47,99,182,118,71,49,225,38,97,252,211,124,5,128,175,151,102,34,215,33,67,77,99,84,194,222,232,148,74,159,128,198,189,153,110,96,239,199,18,36,127,177,130,122,133,236,43,88,226,10,141,135,25,187,216,7,107,247,39,222,183,21,43,12,28,60,94,141,190,71,102,84,114,23,51,43,241,81,34,147,203,197,55,19,45,75,170,167,50,156,100,231,210},
  {186,63,195,154,177,2,60,48,154,125,207,151,192,78,84,166,17,72,230,145,183,75,136,40,24,100,69,121,212,55,13,24,223,95,54,108,126,150,250,71,143,98,89,198,222,203,161,128,44,95,65,142,18,244,205,36,151,82,116,126,230,221,219,7,142,155,59,96,243,220,219,240,173,199,137,124,149,88,123,215,108,21,104,45,179,238,239,5,54,14,177,193,198,21,55,66,225,192,37,95,220,180,50,133,138,13,23,37,105,179,2,200,248,122,10,188,71,43,174,105,91,247,229,29,112,162,8,132,56,236,212,159,237,204,99,63,82,54,103,205,195,187,238,46,207,110,231,204,170,191,251,115,236,168,201,219,255,205,80,204,188,88,201,13,156,70,122,175,0,52,161,241,209,123,169,120,153,97,19,142,142,251,129,111,246,6,119,195,214,86,244,14,171,83,70,181,96,156,103,147,128,129,211,14,11,203,110,252,221,47,98,6,202,21,69},
} ;

static void test_decode_857x3_impl(long long impl)
{
  unsigned char *x = test_decode_857x3_x;
  unsigned char *s = test_decode_857x3_s;
  unsigned char *x2 = test_decode_857x3_x2;
  unsigned char *s2 = test_decode_857x3_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_857x3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_857x3(impl);
    printf("decode_857x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_857x3_implementation(impl),ntruprime_dispatch_decode_857x3_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_857x3;
    printf("decode_857x3 selected implementation %s compiler %s\n",ntruprime_decode_857x3_implementation(),ntruprime_decode_857x3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_857x3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_857x3_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_857x3_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_857x3_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_857x3_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_857x3_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_857x3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"857x3")) return;
  storage_decode_857x3_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_857x3_x = aligned(storage_decode_857x3_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_857x3_s = callocplus(crypto_decode_STRBYTES);
  test_decode_857x3_s = aligned(storage_decode_857x3_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_857x3_x2 = callocplus(maxalloc);
  test_decode_857x3_x2 = aligned(storage_decode_857x3_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_857x3_s2 = callocplus(maxalloc);
  test_decode_857x3_s2 = aligned(storage_decode_857x3_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_857x3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_857x3();++impl)
      forked(test_decode_857x3_impl,impl);
    ++test_decode_857x3_x;
    ++test_decode_857x3_s;
    ++test_decode_857x3_x2;
    ++test_decode_857x3_s2;
  }
  free(storage_decode_857x3_s2);
  free(storage_decode_857x3_x2);
  free(storage_decode_857x3_s);
  free(storage_decode_857x3_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

