### NAME

ntruprime-speed - run some libntruprime speed tests

### SYNOPSIS

    ntruprime-speed

### DESCRIPTION

`ntruprime-speed`
runs some tests of the speed of
the libntruprime implementation of the Streamlined NTRU Prime cryptosystem.

The `ntruprime-speed` output format is subject to change.
Examples of output lines with the current format,
from a `ntruprime-speed` run on an Intel Skylake CPU core,
include the following:

    kem_sntrup761 selected implementation factored compiler clang -Wall -fPIC -fwrapv -Qunused-arguments -O2; Ubuntu clang version 14.0.0-1ubuntu1.1; Target: x86_64-pc-linux-gnu; Thread model: posix; InstalledDir: /usr/bin
    kem_sntrup761_keypair selected 1158 779846 +112137+5141+1312+565-207-153+66-18+35+1650-109+4-144+414-119-69-243+66+82-110-1-16+174+864+741-52-1+57-180-538-312-116
    kem_sntrup761_enc selected 1039 40275 +8153+1104+323-39+36-1-107-27-99-17-15-65+74-33-102-24-30+69+99-106+7+33+59-5+175-60-29+152+21-82+90-78
    kem_sntrup761_dec selected 32 52834 +36240+2014+438+165+96+109+62-8-78+20+67-30-112-59+27-25-3+31+15-118+102-64-84+19-121+57-35+120-125-147-80-75

These lines say that the automatically selected implementation for the `sntrup761` parameter set
was the `factored` implementation compiled with the `clang` options shown,
taking an interquartile mean (IQM) of 779846 CPU cycles to generate a key pair,
40275 CPU cycles to encapsulate a session key,
and
52834 CPU cycles to decapsulate a session key.
The numbers `52834 +36240+2014+...` show the timings for a series of consecutive operations:
the IQM was 52834 cycles,
the first run took 36240 cycles more than the IQM,
the second run took 2014 cycles more than the IQM,
etc.

The numbers immediately after `selected`
on the `keypair`, `enc`, and `dec` lines
say that a public key has 1158 bytes,
a ciphertext has 1039 bytes,
and a session key has 3 bytes.

### SEE ALSO

**sntrup**(1),
**sntrup**(3)
