# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.implicit_function import ImplicitFunction


class ImplicitWindowFunction(ImplicitFunction):
    r"""
    ImplicitWindowFunction - implicit function maps another implicit
    function to lie within a specified range
    
    Superclass: ImplicitFunction
    
    ImplicitWindowFunction is used to modify the output of another
    implicit function to lie within a specified "window", or function
    range. This can be used to add "thickness" to cutting or clipping
    functions.
    
    This class works as follows. First, it evaluates the function value
    of the user-specified implicit function. Then, based on the window
    range specified, it maps the function value into the window values
    specified.
    
    @sa
    ImplicitFunction
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImplicitWindowFunction, obj, update, **traits)
    
    def _get_implicit_function(self):
        return wrap_vtk(self._vtk_obj.GetImplicitFunction())
    def _set_implicit_function(self, arg):
        old_val = self._get_implicit_function()
        self._wrap_call(self._vtk_obj.SetImplicitFunction,
                        deref_vtk(arg))
        self.trait_property_changed('implicit_function', old_val, arg)
    implicit_function = traits.Property(_get_implicit_function, _set_implicit_function, desc=\
        r"""
        
        """
    )

    window_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 1.0), cols=2, desc=\
        r"""
        Specify the range of function values which are considered to lie
        within the window. window_range[0] is assumed to be less than
        window_range[1].
        """
    )

    def _window_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWindowRange,
                        self.window_range)

    window_values = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 1.0), cols=2, desc=\
        r"""
        Specify the range of output values that the window range is
        mapped into. This is effectively a scaling and shifting of the
        original function values.
        """
    )

    def _window_values_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWindowValues,
                        self.window_values)

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('window_range', 'GetWindowRange'),
    ('window_values', 'GetWindowValues'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'window_range', 'window_values'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImplicitWindowFunction, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImplicitWindowFunction properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['window_range', 'window_values']),
            title='Edit ImplicitWindowFunction properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImplicitWindowFunction properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

