// Copyright 2022 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Hanifi_Rohingya`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v15.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x010D00, 0x010D27],
    [0x010D30, 0x010D39]
  ]
});
testPropertyEscapes(
  /^\p{Script=Hanifi_Rohingya}+$/u,
  matchSymbols,
  "\\p{Script=Hanifi_Rohingya}"
);
testPropertyEscapes(
  /^\p{Script=Rohg}+$/u,
  matchSymbols,
  "\\p{Script=Rohg}"
);
testPropertyEscapes(
  /^\p{sc=Hanifi_Rohingya}+$/u,
  matchSymbols,
  "\\p{sc=Hanifi_Rohingya}"
);
testPropertyEscapes(
  /^\p{sc=Rohg}+$/u,
  matchSymbols,
  "\\p{sc=Rohg}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x010CFF],
    [0x010D28, 0x010D2F],
    [0x010D3A, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Hanifi_Rohingya}+$/u,
  nonMatchSymbols,
  "\\P{Script=Hanifi_Rohingya}"
);
testPropertyEscapes(
  /^\P{Script=Rohg}+$/u,
  nonMatchSymbols,
  "\\P{Script=Rohg}"
);
testPropertyEscapes(
  /^\P{sc=Hanifi_Rohingya}+$/u,
  nonMatchSymbols,
  "\\P{sc=Hanifi_Rohingya}"
);
testPropertyEscapes(
  /^\P{sc=Rohg}+$/u,
  nonMatchSymbols,
  "\\P{sc=Rohg}"
);

reportCompare(0, 0);
