/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.AbstractBasisSetToXml;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToAcesiiInput
extends AbstractBasisSetXmlToText {
    protected String mTitle = "";

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        this.enableSplitSP();
        return this.readBasisSet(data, elementList, false);
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        this.mTitle = root.getChildText("title", BSEProperties.mDcNs);
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        String elementName = this.mPertable.atomicSymbol(this.mPertable.atomicNumber(element));
        output.append(elementName.toUpperCase() + ":" + this.mTitle + "\n");
        output.append("EMSL BASIS SET LIBRARY\n\n");
        try {
            String[] parts;
            int idx;
            String cdesc = AbstractBasisSetToXml.generateContractionDescription(contractions);
            cdesc = cdesc.indexOf("->") < 0 ? cdesc + "," + cdesc : cdesc.replaceAll("->", ",");
            cdesc = cdesc.replaceAll("[ \\(\\)\\[\\]]", "");
            String[] tokens = cdesc.split(",");
            int numShells = tokens.length / 2;
            output.append(this.formatInteger(numShells, 3) + "\n");
            for (idx = 0; idx < numShells; ++idx) {
                try {
                    String shell = tokens[idx].substring(tokens[idx].length() - 1);
                    output.append(this.formatInteger(this.getShellValue(shell), 5));
                    continue;
                }
                catch (FormatException ex) {
                    ex.printStackTrace();
                }
            }
            output.append("\n");
            for (idx = 0; idx < numShells; ++idx) {
                parts = tokens[numShells + idx].split("[a-z]");
                output.append(this.formatInteger(parts[0], 5));
            }
            output.append("\n");
            for (idx = 0; idx < numShells; ++idx) {
                parts = tokens[idx].split("[a-z]");
                output.append(this.formatInteger(parts[0], 5));
            }
            output.append("\n");
            output.append("\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        Matrix associationMatrix = this.buildAssociationMatrix(matrices);
        int rows = associationMatrix.getNumRows();
        int columns = associationMatrix.getNumColumns();
        try {
            int i;
            int nCols = 5;
            for (i = 0; i < rows; ++i) {
                String value = this.fixedFormatValue(associationMatrix.getValue(i, 0), 14, 7);
                output.append(value);
                if (i <= 0 || (i + 1) % nCols != 0) continue;
                output.append("\n");
            }
            if (rows % nCols != 0) {
                output.append("\n");
            }
            output.append("\n");
            nCols = 7;
            for (i = 0; i < rows; ++i) {
                for (int j = 1; j < columns; ++j) {
                    String value = this.fixedFormatValue(associationMatrix.getValue(i, j), 10, 7);
                    output.append(value + " ");
                    if (j <= 0 || j % nCols != 0) continue;
                    output.append("\n");
                }
                if (columns <= nCols) {
                    output.append("\n");
                    continue;
                }
                if ((columns - 1) % nCols == 0) continue;
                output.append("\n");
            }
            output.append("\n");
        }
        catch (IndexOutOfBoundsException ie) {
            throw new FormatException(ie.getMessage());
        }
    }

    public static void main(String[] args) {
        BasisXmlToAcesiiInput xlator = new BasisXmlToAcesiiInput();
        try {
            String dir = "/msrc/tmp/karen/gaussian/";
            String bsname = "WTBS.xml";
            bsname = "AHLRICHS_TZV.xml";
            bsname = "CC-PVDZ.xml";
            bsname = "LANL2DZ.xml";
            String outfile = "/tmp/" + bsname + ".acesii";
            File file = new File(dir + bsname);
            FileInputStream fis = new FileInputStream(file);
            int numBytes = fis.available();
            byte[] b = new byte[numBytes];
            fis.read(b);
            String data = new String(b);
            Vector<String> elements = new Vector<String>();
            elements.add("Cu");
            String result = xlator.convert(data, elements, false);
            System.out.println(result);
            File ofile = new File(outfile);
            FileOutputStream fos = new FileOutputStream(ofile);
            fos.write(result.getBytes());
        }
        catch (Exception ex) {
            System.out.println("Exception" + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

