open Import

val syntax : Syntax.t

type t =
  { merge_into : string option
  ; flags : Ordered_set_lang.Unexpanded.t
  ; modules : string list
  ; mode : Rule.Mode.t
  ; loc : Loc.t
  ; infer : bool
  ; enabled_if : Blang.t
  ; explain : Blang.t option
  ; menhir_syntax : Syntax.Version.t
  }

val modules : t -> string list

(** Return the list of targets that are generated by this stanza. This list of
    targets is used by the code that computes the list of modules in the
    directory. *)
val targets : t -> string list

include Stanza.S with type t := t
