# Plugin Migration      {#PluginMigration}

ParaView had a lot of work done to it for the 5.7 release. This involved lots
of changes to the CMake Plugin API that ParaView provides to make it easier to
build plugins. This document covers the major changes that need to be done in
order to migrate to the new API. Specifics of the new CMake API is describled
in the [Plugin HowTo](PluginHowto.md) document.

## Metadata

Metadata is now stored in a `paraview.plugin` file rather than a `plugin.cmake`
file. Instead of being actual CMake code, these files are basically the
arguments to a CMake function. Not being CMake code itself allows the new build
system to ensure that no extra CMake logic is going on behind its back when
it's trying to gather information about the available plugins. Note that this
is a default that is supported by the [paraview_plugin_scan][] function. It
does not need to be used and the actual files can be named anything as long as
the format is valid.

The major change is that instead of hiding the `pv_plugin` call with a CMake
conditional, one may be written in the `CONDITION` argument which will be used
to "hide" the plugin if necessary.

Plugins required by the plugin may be listed in the `REQUIRES_MODULES` list so
that the module system can ensure that all of them are provided.

[paraview_plugin_scan]: @ref paraview_plugin_scan

## Plugins

The old `add_paraview_plugin` function has been replaced by
[paraview_add_plugin][]. The name change is because the API has been refined.
It more consistently uses keyword arguments (e.g., `VERSION 1.0` rather than a
hard-coded `1.0` second argument). It is also stricter in its argument parsing
so that unrecognized arguments are properly called out. Major changes:

  - The `DESCRIPTION` has been removed in preference for the `paraview.plugin`
    entry to remove the duplication it presented.
  - Due to the new CMake APIs for ClientServer wrapping, filters and classes
    used in Server Manager XML files (the old `SERVER_MANAGER_SOURCES`
    argument) must be in a VTK module. These may be added by simply telling the
    plugin to build some modules using the `MODULE_FILES` and `MODULES`
    arguments.
  - `GUI_INTERFACES` is renamed to `UI_INTERFACES` since not all of them are
    actually graphical in nature.
  - `GUI_RESOURCES` is renamed to `UI_RESOURCES` for the same reason.
  - `GUI_SOURCES` is renamed to `SOURCES` since whether they are UI-related or
    not is immaterial.
  - `UI_FILES` is provided for Qt's `.ui` interface files.
  - CMake's AutoGen functionality is used to manage Qt's preprocessing tools
    (`moc`, `uic`, and `rcc`) rather than the `qt5_wrap_*` functions. It will
    be enabled for the sources generated by the plugin macro automatically, but
    any other sources using these should set the associated variables
    (`CMAKE_AUTOMOC`, `CMAKE_AUTOUIC`, and `CMAKE_AUTORCC`) to ensure it is
    performed.
  - `FORCE_STATIC` is provided to force a plugin to be built static or not.

[paraview_add_plugin]: @ref paraview_add_plugin

## Interfaces

All of the `add_paraview_*` functions which created interfaces for use in the
old `add_paraview_plugin(GUI_INTERFACES)` argument have been changed.
Generally, names have changed from `add_paraview_X` to `paraview_plugin_add_X`.

THe positional arguments for the list of interfaces and sources have been
replaced with keyword arguments (`INTERFACES` and `SOURCES` respectively). The
new functions also all strictly check their arguments.

A full list of the new interface functions:

  - [paraview_plugin_add_property_widget](@ref paraview_plugin_add_property_widget)
  - [paraview_plugin_add_dock_window](@ref paraview_plugin_add_dock_window)
  - [paraview_plugin_add_action_group](@ref paraview_plugin_add_action_group)
  - [paraview_plugin_add_toolbar](@ref paraview_plugin_add_toolbar)
  - [paraview_plugin_add_view_frame_action_group](@ref paraview_plugin_add_view_frame_action_group)
  - [paraview_plugin_add_autostart](@ref paraview_plugin_add_autostart)
  - [paraview_plugin_add_tree_layout_strategy](@ref paraview_plugin_add_tree_layout_strategy)
  - [paraview_plugin_add_proxy](@ref paraview_plugin_add_proxy)

## Modules

Modules are now required to have plugin-local classes wrapped for use in Server
Manager XML files. This replaces the old `SERVER_MANAGER_SOURCES` argument.
Plugin-local modules are installed right beside the plugin library so that they
can be moved as a single unit.

## Building Plugins

Building plugins now follows a similar pattern as the new VTK module system.
Plugins must first be scanned using [paraview_plugin_scan][] to gather all of the
metadata and then built using `paraview_plugin_build`.

Enable/disable defaults are no longer controlled by the `pv_plugin` function,
but instead by the building project. Setting the
`_paraview_plugin_default_<PLUGIN_NAME>` variable will select a default enable
state for the given plugin.

## Installing Plugins

Plugins are installed by [paraview_add_plugin][] using information passed from
[paraview_plugin_build][], namely the `INSTALL_EXPORT`, `CMAKE_DESTINATION`,
`PLUGINS_COMPONENT`, `TARGET_COMPONENT`, `INSTALL_HEADERS`, the various
`_DESTINATION`, and `ADD_INSTALL_RPATHS` arguments. Sets of plugins may be made
using [paraview_plugin_build][] now create an interface target (named according
to the `TARGET` argument) which may be used by clients to use the plugins in
the plugin set.

[paraview_plugin_build]: @ref paraview_plugin_build

## Using plugins

When building a ParaView client, plugin targets made by
[paraview_plugin_build][] may be passed to the [paraview_add_client][]
function's `PLUGINS_TARGETS` argument. The client will initialize any static
plugins in the set and load plugins marked for auto-loading (via the
[paraview_plugin_build][] function's `AUTOLOAD` argument). The plugin target
knows where its associated plugin xml file is located and it will be used by
the client.

[paraview_add_client]: @ref paraview_add_client
