%feature("docstring") PERSALYS::FMIPhysicalModel
"Physical model defined by a FMI scheme.

Parameters
----------
name : str
    Model name
inputs : sequence of :class:`~persalys.Input`
    Input variables (optional)
outputs : sequence of :class:`~persalys.Output`
    Output variables (optional)
fmuFile : str
    FMU file name
fmuType : str, default='auto'
    FMU type, either one of auto, ME or CS

Notes
-----
When only the file name is provided, only variables marked with *Input* FMI
causality are set as model input variables, and only variables marked with
*Output* FMI causality are set as model output variables.

The implementation is based on `OTFMI <https://github.com/openturns/otfmi>`_."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMIPhysicalModel::getFMUFileName
"FMU file name accessor.

Returns
-------
fileName : str
    FMU file name containing the FMI scheme"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMIPhysicalModel::setFMUFileName
"FMU file name accessor.

Parameters
----------
fileName : str
    FMU file name containing the FMI scheme"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMIPhysicalModel::getFMUInfo
"FMU infos accessor.

Returns
-------
fmuInfo : :class:`~persalys.FMUInfo`
    FMU infos"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMIPhysicalModel::setFMUType
"FMU type accessor.

Parameters
----------
fmuType : str, default='auto'
    FMU type, either one of auto, ME or CS"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMIPhysicalModel::getFMUType
"FMU type accessor.

Returns
-------
fmuType : str, default='auto'
    FMU type, either one of auto, ME or CS"
