--TEST--
WKBReader tests
--SKIPIF--
<?php if (!extension_loaded('geos')) { print "geos extension not loaded\n"; exit(1); } ?>
--FILE--
<?php

require './tests/TestHelper.php';

class WKBReaderTest extends GEOSTest
{
    public function testValidWKB()
    {
        $reader = new GEOSWKBReader();
        $writer = new GEOSWKTWriter();
        $writer->setRoundingPrecision(1);
        $writer->setOutputDimension(3);

        foreach ($this->providerValidWKB() as $test) {
            list ($wkb, $wkt, $srid) = $test;

            $geometry = $reader->readHEX($wkb);
            $this->assertEquals($wkt, $writer->write($geometry));
            $this->assertEquals($srid, $geometry->getSRID());

            $geometry = $reader->read(hex2bin($wkb));
            $this->assertEquals($wkt, $writer->write($geometry));
            $this->assertEquals($srid, $geometry->getSRID());
        }
    }

    private function providerValidWKB()
    {
        return array(
            array('0101000020e6100000000000000000f03f0000000000000040', 'POINT (1.0 2.0)', 4326),
            array('01010000a0e6100000333333333333f33f3333333333330b406666666666661640', 'POINT Z (1.2 3.4 5.6)', 4326),
            array('0104000000030000000101000000000000000000f03f0000000000000040010100000000000000000008400000000000001040010100000000000000000014400000000000001840', 'MULTIPOINT (1.0 2.0, 3.0 4.0, 5.0 6.0)', 0),
            array('0104000080030000000101000080000000000000f03f00000000000000400000000000000840010100008000000000000010400000000000001440000000000000184001010000800000000000001c4000000000000020400000000000002240', 'MULTIPOINT Z (1.0 2.0 3.0, 4.0 5.0 6.0, 7.0 8.0 9.0)', 0),
            array('01040000207b00000000000000', 'MULTIPOINT EMPTY', 123),
            array('0102000020c801000003000000000000000000f03f00000000000000400000000000000840000000000000104000000000000008400000000000000040', 'LINESTRING (1.0 2.0, 3.0 4.0, 3.0 2.0)', 456),
            array('01020000a0db03000003000000000000000000f03f000000000000004000000000000008400000000000001040000000000000144000000000000018400000000000001c4000000000000020400000000000002240', 'LINESTRING Z (1.0 2.0 3.0, 4.0 5.0 6.0, 7.0 8.0 9.0)', 987),
            array('01020000201503000000000000', 'LINESTRING EMPTY', 789),
            array('0105000020d204000002000000010200000002000000000000000000f03f0000000000000000000000000000044000000000000000400102000000020000009a9999999999174000000000000020409a99999999990d40000000000000f03f', 'MULTILINESTRING ((1.0 0.0, 2.5 2.0), (5.9 8.0, 3.7 1.0))', 1234),
            array('01050000a0e110000002000000010200008002000000000000000000f03f0000000000000000000000000000f03f00000000000004400000000000000040000000000000f03f0102000080020000009a99999999991740000000000000204000000000000008409a99999999990d40000000000000f03f0000000000000840', 'MULTILINESTRING Z ((1.0 0.0 1.0, 2.5 2.0 1.0), (5.9 8.0 3.0, 3.7 1.0 3.0))', 4321),
            array('01050000203930000000000000', 'MULTILINESTRING EMPTY', 12345),
            array('0103000020f40100000100000004000000000000000000f03f000000000000f03f000000000000f03f000000000000f83f000000000000f83f000000000000f03f000000000000f03f000000000000f03f', 'POLYGON ((1.0 1.0, 1.0 1.5, 1.5 1.0, 1.0 1.0))', 500),
            array('0103000020f30100000200000005000000000000000000000000000000000000000000000000000000000000000000084000000000000008400000000000000840000000000000084000000000000000000000000000000000000000000000000005000000000000000000f03f000000000000f03f000000000000f03f0000000000000040000000000000004000000000000000400000000000000040000000000000f03f000000000000f03f000000000000f03f', 'POLYGON ((0.0 0.0, 0.0 3.0, 3.0 3.0, 3.0 0.0, 0.0 0.0), (1.0 1.0, 1.0 2.0, 2.0 2.0, 2.0 1.0, 1.0 1.0))', 499),
            array('01030000a06300000001000000040000009a9999999999f13f9a9999999999014000000000000000009a999999999901403333333333331d409a9999999999f13f00000000000021409a999999999901409a9999999999f13f9a9999999999f13f9a999999999901400000000000000000', 'POLYGON Z ((1.1 2.2 0.0, 2.2 7.3 1.1, 8.5 2.2 1.1, 1.1 2.2 0.0))', 99),
            array('01030000200100000000000000', 'POLYGON EMPTY', 1),
            array('0106000020020000000100000001030000000200000005000000000000000000000000000000000000000000000000000000000000000000084000000000000008400000000000000840000000000000084000000000000000000000000000000000000000000000000005000000000000000000f03f000000000000f03f000000000000f03f0000000000000040000000000000004000000000000000400000000000000040000000000000f03f000000000000f03f000000000000f03f', 'MULTIPOLYGON (((0.0 0.0, 0.0 3.0, 3.0 3.0, 3.0 0.0, 0.0 0.0), (1.0 1.0, 1.0 2.0, 2.0 2.0, 2.0 1.0, 1.0 1.0)))', 2),
            array('01060000a003000000010000000103000080020000000500000000000000000000000000000000000000000000000000000000000000000000000000000000000840000000000000000000000000000008400000000000000840000000000000000000000000000008400000000000000000000000000000000000000000000000000000000000000000000000000000000005000000000000000000f03f000000000000f03f9a9999999999f13f000000000000f03f00000000000000409a9999999999f13f000000000000004000000000000000409a9999999999f13f0000000000000040000000000000f03f9a9999999999f13f000000000000f03f000000000000f03f9a9999999999f13f', 'MULTIPOLYGON Z (((0.0 0.0 0.0, 0.0 3.0 0.0, 3.0 3.0 0.0, 3.0 0.0 0.0, 0.0 0.0 0.0), (1.0 1.0 1.1, 1.0 2.0 1.1, 2.0 2.0 1.1, 2.0 1.0 1.1, 1.0 1.0 1.1)))', 3),
            array('01060000200400000000000000', 'MULTIPOLYGON EMPTY', 4),
            array('01070000200f270000060000000101000000000000000000f03f00000000000000400104000000030000000101000000000000000000f03f0000000000000040010100000000000000000008400000000000001040010100000000000000000014400000000000001840010200000003000000000000000000f03f00000000000000400000000000000840000000000000104000000000000008400000000000000040010500000002000000010200000002000000000000000000f03f0000000000000000000000000000044000000000000000400102000000020000009a9999999999174000000000000020409a99999999990d40000000000000f03f01030000000200000005000000000000000000000000000000000000000000000000000000000000000000084000000000000008400000000000000840000000000000084000000000000000000000000000000000000000000000000005000000000000000000f03f000000000000f03f000000000000f03f0000000000000040000000000000004000000000000000400000000000000040000000000000f03f000000000000f03f000000000000f03f01060000000100000001030000000200000005000000000000000000000000000000000000000000000000000000000000000000084000000000000008400000000000000840000000000000084000000000000000000000000000000000000000000000000005000000000000000000f03f000000000000f03f000000000000f03f0000000000000040000000000000004000000000000000400000000000000040000000000000f03f000000000000f03f000000000000f03f', 'GEOMETRYCOLLECTION (POINT (1.0 2.0), MULTIPOINT (1.0 2.0, 3.0 4.0, 5.0 6.0), LINESTRING (1.0 2.0, 3.0 4.0, 3.0 2.0), MULTILINESTRING ((1.0 0.0, 2.5 2.0), (5.9 8.0, 3.7 1.0)), POLYGON ((0.0 0.0, 0.0 3.0, 3.0 3.0, 3.0 0.0, 0.0 0.0), (1.0 1.0, 1.0 2.0, 2.0 2.0, 2.0 1.0, 1.0 1.0)), MULTIPOLYGON (((0.0 0.0, 0.0 3.0, 3.0 3.0, 3.0 0.0, 0.0 0.0), (1.0 1.0, 1.0 2.0, 2.0 2.0, 2.0 1.0, 1.0 1.0))))', 9999),
            array('01070000200903000000000000', 'GEOMETRYCOLLECTION EMPTY', 777),
        );
    }

    public function testBogusWKB()
    {
        $reader = new GEOSWKBReader();

        try {
            $reader->read(hex2bin('1234567890abcdef'));
            $this->assertTrue(FALSE); # this is just to fail if we get here
        } catch (Exception $e) {
            $this->assertContains('ParseException', $e->getMessage());
        }
    }

    public function testBogusHexWKB()
    {
        $reader = new GEOSWKBReader();

        try {
            $reader->readHEX('1234567890abcdef');
            $this->assertTrue(FALSE); # this is just to fail if we get here
        } catch (Exception $e) {
            $this->assertContains('ParseException', $e->getMessage());
        }
    }
}

WKBReaderTest::run();

?>
--EXPECT--
WKBReaderTest->testValidWKB	OK
WKBReaderTest->testBogusWKB	OK
WKBReaderTest->testBogusHexWKB	OK
