/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public final class CucaDiagramFileMakerSvek2InternalImage
extends AbstractTextBlock
implements IEntityImage {
    private final List<IEntityImage> inners;
    private final Separator separator;
    private final ISkinParam skinParam;
    private final Stereotype stereotype;

    private HColor getColor(ColorParam colorParam, Stereotype stereotype) {
        return new Rose().getHtmlColor(this.skinParam, stereotype, colorParam);
    }

    public CucaDiagramFileMakerSvek2InternalImage(List<IEntityImage> inners, char concurrentSeparator, ISkinParam skinParam, Stereotype stereotype) {
        this.separator = Separator.fromChar(concurrentSeparator);
        this.skinParam = skinParam;
        this.stereotype = stereotype;
        this.inners = inners;
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor dotColor = this.getColor(ColorParam.stateBorder, this.stereotype);
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        for (int i = 0; i < this.inners.size(); ++i) {
            IEntityImage inner = this.inners.get(i);
            inner.drawU(ug);
            Dimension2D dim = inner.calculateDimension(stringBounder);
            ug = ug.apply(this.separator.move(dim));
            if (i >= this.inners.size() - 1) continue;
            this.separator.drawSeparator(ug.apply(dotColor), dimTotal);
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D result = new Dimension2DDouble(0.0, 0.0);
        for (IEntityImage inner : this.inners) {
            Dimension2D dim = inner.calculateDimension(stringBounder);
            result = this.separator.add(result, dim);
        }
        return result;
    }

    @Override
    public HColor getBackcolor() {
        return this.skinParam.getBackgroundColor(false);
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    static enum Separator {
        VERTICAL,
        HORIZONTAL;


        static Separator fromChar(char sep) {
            if (sep == '|') {
                return VERTICAL;
            }
            if (sep == '-') {
                return HORIZONTAL;
            }
            throw new IllegalArgumentException();
        }

        UTranslate move(Dimension2D dim) {
            if (this == VERTICAL) {
                return UTranslate.dx(dim.getWidth());
            }
            return UTranslate.dy(dim.getHeight());
        }

        Dimension2D add(Dimension2D orig, Dimension2D other) {
            if (this == VERTICAL) {
                return new Dimension2DDouble(orig.getWidth() + other.getWidth(), Math.max(orig.getHeight(), other.getHeight()));
            }
            return new Dimension2DDouble(Math.max(orig.getWidth(), other.getWidth()), orig.getHeight() + other.getHeight());
        }

        void drawSeparator(UGraphic ug, Dimension2D dimTotal) {
            double THICKNESS_BORDER = 1.5;
            int DASH = 8;
            ug = ug.apply(new UStroke(8.0, 10.0, 1.5));
            if (this == VERTICAL) {
                ug.draw(ULine.vline(dimTotal.getHeight() + 8.0));
            } else {
                ug.draw(ULine.hline(dimTotal.getWidth() + 8.0));
            }
        }
    }
}

