# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datafactory import DataFactoryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataFactoryManagementFactoriesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataFactoryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_factories_list(self, resource_group):
        response = self.client.factories.list(
            api_version="2018-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_factories_configure_factory_repo(self, resource_group):
        response = self.client.factories.configure_factory_repo(
            location_id="str",
            factory_repo_update={"factoryResourceId": "str", "repoConfiguration": "factory_repo_configuration"},
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_factories_list_by_resource_group(self, resource_group):
        response = self.client.factories.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2018-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_factories_create_or_update(self, resource_group):
        response = self.client.factories.create_or_update(
            resource_group_name=resource_group.name,
            factory_name="str",
            factory={
                "createTime": "2020-02-20 00:00:00",
                "eTag": "str",
                "encryption": {
                    "keyName": "str",
                    "vaultBaseUrl": "str",
                    "identity": {"userAssignedIdentity": "str"},
                    "keyVersion": "str",
                },
                "globalParameters": {"str": {"type": "str", "value": {}}},
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {}},
                },
                "location": "str",
                "name": "str",
                "provisioningState": "str",
                "publicNetworkAccess": "str",
                "purviewConfiguration": {"purviewResourceId": "str"},
                "repoConfiguration": "factory_repo_configuration",
                "tags": {"str": "str"},
                "type": "str",
                "version": "str",
            },
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_factories_update(self, resource_group):
        response = self.client.factories.update(
            resource_group_name=resource_group.name,
            factory_name="str",
            factory_update_parameters={
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {}},
                },
                "publicNetworkAccess": "str",
                "tags": {"str": "str"},
            },
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_factories_get(self, resource_group):
        response = self.client.factories.get(
            resource_group_name=resource_group.name,
            factory_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_factories_delete(self, resource_group):
        response = self.client.factories.delete(
            resource_group_name=resource_group.name,
            factory_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_factories_get_git_hub_access_token(self, resource_group):
        response = self.client.factories.get_git_hub_access_token(
            resource_group_name=resource_group.name,
            factory_name="str",
            git_hub_access_token_request={
                "gitHubAccessCode": "str",
                "gitHubAccessTokenBaseUrl": "str",
                "gitHubClientId": "str",
                "gitHubClientSecret": {"byoaSecretAkvUrl": "str", "byoaSecretName": "str"},
            },
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_factories_get_data_plane_access(self, resource_group):
        response = self.client.factories.get_data_plane_access(
            resource_group_name=resource_group.name,
            factory_name="str",
            policy={
                "accessResourcePath": "str",
                "expireTime": "str",
                "permissions": "str",
                "profileName": "str",
                "startTime": "str",
            },
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...
