# PyTorch Ignite Logo Guidelines
These guidelines are meant to help keep the PyTorch Ignite logo (as developed in [#1221](https://github.com/pytorch/ignite/issues/1221)) consistent and recognizable across all its uses. They also provide a common language for referring to the logos and their components.

The primary logo is the combination of the logomark and wordmark next to each other. The logomark is the flame alone (no text) and the wordmark is only the text. It's preferable to use the primary logo whenever possible, and the logomark when a smaller version is needed.

## Color
The full color options are a combonation of PyTorch's main orange (`#ee4c2c`) with yellow details (`#eaa700`). Light options are white (`#FFFFFF`) and dark options dark grey (`#2a2a2a`). The alternate "mixed" logo uses the full color logomark with a dark grey wordmark.

Whenever possible, use the full color logos. One color logos (light or dark) are to be used when full color will not have enough contrast, usually when logos must be on colored backgrounds or are being reproduced somewhere that doesn't support color.

Please note: The orange (`#ee4c2c`) and yellow (`#eaa700`) do not meet WCAG 2.1 color contrast recommendations for text or UI when used with white or other light colors. Make sure to use these colors primarily as decorative elements or with a dark color for text and/or UI. Accessibility should not be overlooked.

## Type
The PyTorch Ignite wordmark is made from Oxygen (by Vernon Adams @vernnobile). 

## Minimum Size
For consistent legibility, please do not display the primary logo at less than 60px wide or the logomark at less than 15px wide.

## Logo Integrity 
A few other notes to keep in mind when using the logo:
- Make sure to scale the logo proportionally.
- Maintain a good amount of space around the logo. Don’t let it overlap with text, images, or other elements.
- Do not try and recreate or modify the logo. For example, do not use the logomark and then try to write PyTorch Ignite in another font.