# Helper function for coupling add_feature_info(), option(), and add_definitions()

function(optional_compile_definitions _name)
    set(options FEATURE)
    set(oneValueArgs DESCRIPTION DEFAULT)
    set(multiValueArgs ENABLED DISABLED)
    cmake_parse_arguments(OCD "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})
    option(${_name} "${OCD_DESCRIPTION}" ${OCD_DEFAULT})
    if (${${_name}})
        set_property(DIRECTORY "${CMAKE_CURRENT_SOURCE_DIR}" APPEND PROPERTY COMPILE_DEFINITIONS ${OCD_ENABLED})
    else()
        set_property(DIRECTORY "${CMAKE_CURRENT_SOURCE_DIR}" APPEND PROPERTY COMPILE_DEFINITIONS ${OCD_DISABLED})
    endif()
    if(${OCD_FEATURE})
        add_feature_info(${_name} ${_name} "${OCD_DESCRIPTION}")
    endif()
endfunction()

macro(feature_option _name _description _default)
    option(${_name} "${_description}" ${_default})
    add_feature_info(${_name} ${_name} "${_description}")
endmacro()
