# Quaternion

![status](https://img.shields.io/badge/status-beta-yellow.svg)
[![release](https://img.shields.io/github/release/quotient-im/quaternion/all.svg)](https://github.com/quotient-im/Quaternion/releases/latest)
[![OpenSSF Best Practices](https://www.bestpractices.dev/projects/1663/badge)](https://www.bestpractices.dev/projects/1663)
[![](https://img.shields.io/matrix/quotient:matrix.org.svg)](https://matrix.to/#/#quotient:matrix.org)
[![CI builds hosted by: Cloudsmith](https://img.shields.io/badge/OSS%20hosting%20by-cloudsmith-blue?logo=cloudsmith&style=flat-square)](https://cloudsmith.com)

Quaternion is a cross-platform desktop IM client for the
[Matrix](https://matrix.org) protocol. You can find general information about
application usage and settings here. See [BUILDING.md](./BUILDING.md) for
building instructions.

## Contacts
Most of talking around Quaternion happens in the room of its parent project,
Quotient: [#quotient:matrix.org](https://matrix.to/#/#quotient:matrix.org).
You can file issues at
[the project's issue tracker](https://github.com/quotient-im/Quaternion/issues).
If you find what looks like a security issue, please follow
[special instructions](./SECURITY.md).


## Downloading and installing

The recommended way to install Quaternion is as follows (make sure to read
the notes below depending to your environment):

- on GNU/Linux - using your distribution's package manager;
- on macOS - from Homebrew;
- on Windows - from an archive at the project's
  [GitHub Releases page](https://github.com/quotient-im/Quaternion/releases).

The source code is [hosted at GitHub](https://github.com/quotient-im/Quaternion).

### Requirements

Quaternion 0.0.97.1 needs Qt version 6.4 or higher.

### Linux
Quaternion is packaged for many distributions, including various versions of
Debian, Ubuntu and OpenSUSE, as well as Arch Linux, NixOS and FreeBSD.
A pretty comprehensive up-to-date list can be found at
[Repology](https://repology.org/project/quaternion/versions). Popular
distributions satisfying the mentioned Qt requirement are Debian 12 (Bookworm),
Ubuntu 24.04 (noble), Fedora 39, OpenSUSE Leap 15.6; anything newer than that
should be fine, too.

On top of the Quaternion package, you should not normally need to install anything in addition;
if something is not working due to a missing dependency, it's a bug in the package - please
report it to your distribution's Quaternion packager, _not_ to this repository.

There are also flatpaks for Quaternion available from Flathub. To install, use:

```
flatpak install https://flathub.org/repo/appstream/io.github.quotient_im.Quaternion.flatpakref
```

These packages are built with a suitable KDE runtime. You can install them on
any distribution that has Flatpak - even if it's older than mentioned above.
Please file issues at https://github.com/flathub/io.github.quotient_im.Quaternion
if you believe there's a problem specific to the Flatpak package of Quaternion.

### Windows
Since there's no established package management on Windows to resolve
dependencies, all needed libraries and a C++ runtime are packaged/installed
together with Quaternion - except OpenSSL. Unless you already have OpenSSL
around (e.g., it is a part of any Qt development installation), you should
install it yourself.
[OpenSSL's Wiki](https://wiki.openssl.org/index.php/Binaries) lists a few links
to OpenSSL installers. They come in different build configurations; current
Quaternion builds distributed from GitHub Releases need OpenSSL 3.x made
with/for Visual Studio (not MinGW).

### macOS
If you use Homebrew (you should!), `brew install quaternion` installs Quaternion
along with its dependencies. Otherwise, packages published at
[GitHub Releases](https://github.com/quotient-im/Quaternion/releases/latest)
come with everything necessary already bundled.

### Development builds

Thanks to generous and supportive folks at [Cloudsmith](https://cloudsmith.io)
who provide free hosting to OSS projects, those who want to check out the latest
(not necessarily the greatest, see below) code can find packages produced by
continuous integration (CI) in the
[Quaternion repo there](https://cloudsmith.io/~quotient/repos/quaternion/groups/).

A few important notes on these packages in case you're new to them:
- All of them come bundled with fairly recent (not necessarily latest) Qt 6.
- They are only provided for testing; feedback on _any_ release is welcome
  as long as you know which build you run, but do not expect the developers
  to address issues in older snapshots.
- In case it's still unclear: these builds are UNSTABLE by default; some may
  not run at all, and if they do, they may ~~tell you obscenities in your
  local language, steal your smartphone, and share your private photos~~
  scramble the messages you send, interfere with or even break other clients
  including Element ones, and generally corrupt your account in ways unexpected
  and hard to fix (all of that actually happened in the past). Do NOT run these
  builds if you're not prepared to deal with the problems.
- If you understand the above, have your backups in order and are still willing to try things out
  or just generally help with the project - make sure to `/join #quotient:matrix.org` and have
  the URL you downloaded Quaternion from. In case of trouble, ~~show this label to your doctor~~
  send the URL to the binary you used in the chat room (you may have to use another client or
  Quaternion version for that), describe what happened and we'll try to pull you out of it.

If you want to build Quaternion from sources, see [BUILDING.md](./BUILDING.md).


## Running
Just start the executable in your most preferred way - either from the build
directory or from the installed location. If you're interested in tweaking
configuration beyond what's available in the UI, read the "Configuration"
section further below.


## Translation
Quaternion uses [Lokalise.co](https://lokalise.co) for the translation effort.
It's easy to participate:
[join the project at Lokalise.co](https://lokalise.co/public/730769035bbc328c31e863.62506391/);
if your language is not there, ask to add it (either in
[#quotient:matrix.org](https://matrix.to/#/#quotient:matrix.org) or in
the Lokalise project chat); and start translating! Many languages are still
longing for contributors.


## Configuration
The only non-trivial command-line option available so far is `--locale` - it
allows you to override the locale Quaternion uses (an equivalent of setting
`LC_ALL` variable on UNIX-based systems). German, Russian, Polish, and Spanish translations are
either complete or mostly complete, as of this writing.

Quaternion stores its configuration in a way standard for Qt applications, as
described below. It will read and write the configuration in the user-specific
location (creating it if non-existent) and will only read the system-wide
location with reasonable defaults if the configuration is not found at
the user-specific one.

- Linux:
  - user-specific: `$HOME/.config/Quotient/quaternion.conf`
  - system-wide: `$XDG_CONFIG_DIR/Quotient/quaternion` or
    `/etc/xdg/Quotient/quaternion`
- macOS:
  - user-specific: `$HOME/Library/Preferences/im.quotient.quaternion.plist`
  - system-wide: `/Library/Preferences/im.quotient.quaternion.plist`
- Windows: registry keys under
  - user-specific: `HKEY_CURRENT_USER\Software\Quotient\quaternion`
  - system-wide: `HKEY_LOCAL_MACHINE\Software\Quotient\quaternion`

ALL settings listed below reside in `UI` section of the configuration file
or (for Windows) registry.

Some settings exposed in the user interface (Settings and View menus) are:

- `notifications` - a general setting whether Quaternion should distract
  the user with notifications and how.
  - `none` suppresses notifications entirely (rooms and messages are still
    hightlighted but the tray icon is muted);
  - `non-intrusive` allows the tray icon show notification popups;
  - `intrusive` (default) adds to that activation of Quaternion window
    (i.e. the application blinking in the task bar, or getting raised,
    or otherwise demands attention in an environment-specific way).
- `timeline_layout` - this allows to choose the timeline layout. If this is
  set to "xchat", Quaternion will show the author to the left of each message,
  in an xchat/hexchat style. Any other value will select the "default" layout,
  with author labels above blocks of messages.
- `use_shuttle_dial` - Quaternion will use a shuttle dial instead of a classic scrollbar for
  the timeline's vertical scrolling control. To start scrolling move the shuttle dial away from its
  neutral position in the middle; the further away you move it, the faster you scroll in that
  direction. Releasing the dial resets it back to the neutral position and stops scrolling.
  This is more convenient than the classic scrollbar when you need to move around with bounds of
  the timeline constantly changing, as is the case of a Matrix timeline (older messages get loaded
  as you scroll back, and new messages can come from sync too, making the classic scrollbar jump
  around); with that said, the control is somewhat unconventional and not all people like it.
  The shuttle dial is enabled by default; set this to false (or 0) to use the classic scrollbar.
- `autoload_images` - whether full-size images should be loaded immediately once the message is
  shown on the screen. The default is to automatically load full-size images; set this to false
  (or 0) to disable that and only load a thumbnail in the timeline (with the full image downloaded
  after you click "Save as" or "Open" in the context menu) but be aware that if a message doesn't
  have a thumbnail at all you won't see anything (see also
  https://github.com/quotient-im/Quaternion/issues/601).
- `show_spammy` ("Show no-effect activity" in the menu) - when set to `false`, this setting tries
  to clean up the timeline from events that don't contribute to conversation in any reasonable way,
  such as messages from a recently joined user that are all redacted - a typical case of moderation
  applied to spam.
- `RoomsDock/tags_order` - allows to alter the order of tags in the room
  list. This is a comma-separated list of tags/namespaces;
  a few characters have special meaning as described below. If a tag is
  not mentioned and does not fit any namespace, it will be put at the end of
  the room list in lexicographic order. Tags within the same namespace are
  also ordered lexicographically.
  
  `.*` (only recognised at the end of the string) means the whole namespace;
  strings that don't end with this are treated as fully specified tags.
  
  `-` in front of the tag/namespace means it should not be used for grouping;
  e.g., if you don't want People group you can add `-im.quotient.direct`
  anywhere in the list. `im.quotient.none` ("Rooms") always exists and
  cannot be disabled, only its position in the list is taken into account.
  
  The default tags order is as follows:
  `m.favourite,u.*,im.quotient.direct,im.quotient.none,m.lowpriority`,
  meaning: Favourites, followed by all user custom tags, then People,
  rooms with no enabled tags (the "Rooms" group) and finally Low priority
  rooms. If Quaternion doesn't find the setting in the configuration it
  will write down this line to the configuration so that you don't need
  to enter it from scratch.

Settings not exposed in UI:

- `show_author_avatars` - set this to 1 (or true) to show author avatars in
  the timeline (default if the timeline layout is set to default); setting this
  to 0 (or false) will suppress avatars (default for the XChat timeline layout).
- `suppress_local_echo` - set this to 1 (or true) to suppress showing local
  echo (events sent from the current application but not yet confirmed by
  the server). By default local echo is shown.
- `animations_duration_ms` - defines the base duration (in milliseconds) of
  animation effects in the timline. The default is 400; set it to 0 to disable
  animation.
- `outgoing_color` - set this to the name or hex code (3- or 6-digit) of the colour you prefer
  for text you sent; by default it's `#4A8780` (a brownish tint of teal - no science behind that,
  just an arbitrary shot in a color picker).
- `highlight_color` - set this to the name or hex code (3- or 6-digit) of the colour you prefer
  for highlighted rooms/messages; by default it's `orange`.
- `highlight_mode` - set this to `text` if you prefer to use the text color
  for highlighting; the default is to use the background for highlighting.
- `use_human_friendly_dates` - set this to false (or 0) if you do NOT want
  usage of human-friendly dates ("Today", "Monday" instead of the standard
  day-month-year triad) in the UI; the default is true.
- `show_noop_events` - set this to 1 to show state events that do not alter
  the state (you'll see "(repeated)" next to most of those).
- `quote_style` - the quote template. `\\1` means the quoted string; by default it's `> \\1\n`
  (i.e., `> ` prepended before each line of the quoted string).
- `quote_regex` - set to `^([\\s\\S]*)` to add `UI/quote_style` only at the beginning and the end
  of the quote; by default it's `(.+)(?:\n|$)`, meaning that each line is quoted with `quote_style`
  separately.
- `Fonts/render_type` - select how to render fonts in Quaternion timeline;
  possible values are "NativeRendering" (default) and "QtRendering".
- `Fonts/family` - override the font family for the whole application.
  If not specified, the default font for your environment is used.
- `Fonts/pointSize` - override the font size (in points) for the whole
  application. If not specified, the default size for your environment is used.
- `Fonts/timeline_family` - font family (for example `Monospace`) to
  display messages in the timeline. If not specified, the application-wide font
  family is used.
- `Fonts/timeline_pointSize` - font size (in points) to display messages
  in the timeline. If not specified, the application-wide point size is used.
- `maybe_read_timer` - threshold time interval in milliseconds for a displayed
  message to be considered as read if it's still displayed after that interval.
- `hyperlink_users` - set this to false (or 0) if you do NOT want to hyperlink matrix user IDs
  in messages; by default it's true, meaning that user IDs will be turned to hyperlinks
- `auto_markdown` (EXPERIMENTAL) - since version 0.0.95 Quaternion has experimental support for
  Markdown when entering messages. Normally, Quaternion only treats the message as Markdown if
  it is prepended by `/md` command (the command itself is removed from the message before sending).
  Setting `auto_markdown` to `true` enables Markdown parsing in all messages unless you prepend
  `/plain`. By default, this setting is `false` since the current support of Markdown by Qt is
  buggy, and the implementation in Quaternion has its own quirks on top of that. If you have it
  enabled (or use `/md` command) feel free to report any bugs with it at the usual place.
- `paste_plaintext_by_default` - set this to false (or 0) if you want to paste
  formatted text by default.

Quaternion uses Qt Keychain to store access tokens and database pickles. If
the secure storage supported by Qt Keychain is not available, Quaternion
will not be able to store your access token(s) and pickles and will
automatically disable E2EE to avoid unrecoverable encrypted messages.
The fallback file used by Quaternion pre-0.0.96 is no more used.

Quaternion caches the rooms state and user/room avatars on the file system
in a conventional location for your platform, as follows:

- Linux: `$HOME/.cache/Quotient/quaternion`
- macOS: `$HOME/Library/Cache/Quotient/quaternion`
- Windows: `%LOCALAPPDATA%/Quotient/quaternion/cache`

Cache files are safe to delete at any time but Quaternion only looks for them
when starting up and overwrites them regularly while running; so it only
makes sense to delete cache files when Quaternion is not running. If Quaternion
doesn't find or cannot fully load cache files at startup it downloads
the whole state from Matrix servers. It tries to optimise this process by
lazy-loading room members if the server supports that; in an unlucky case when
the server cannot do lazy-loading, initial sync can take much time (up to
a minute and even more, depending on the number of rooms and the number of users
in them).

Deleting cache files may help with problems such as missing avatars,
rooms stuck in a wrong state etc.


## Troubleshooting

Quaternion uses libQuotient under the hood; some Quaternion problems are
actually problems of libQuotient. If you haven't found your case below, check
also the troubleshooting section in libQuotient README.md.

#### Failure to start on Windows
If you try to start Quaternion from a path that is in your `%PATH%` variable it's very likely to
miss all the libraries that reside in subdirectories of the package. Make sure that you start
Quaternion (either from the command line or Explorer) with the current directory being that of
`quaternion.exe` binary.

#### Some older messages don't get decrypted in E2EE rooms
Unfortunately, this is a limitation in the libQuotient code. The E2EE backend of libQuotient is
currently being ported from Olm to matrix-rust-sdk - aside from being maintained, unlike Olm,
matrix-rust-sdk provides higher-level API withh all necessary bits and pieces to decrypt messages,
so libQuotient won't have to reimplement it. Subscribe to
[the respective pull request](https://github.com/quotient-im/libQuotient/pull/820)
if you want to be updated on the progress of this work.

#### No messages in the timeline
If Quaternion runs but you can't see any messages in the chat (though you can
type them in) - you might not have Qt Quick libraries and/or plugins installed.
On Linux, this may be a case when you are not using the official packages for
your distro. Check the stdout/stderr logs, they are quite clear in such cases.
On Windows, Mac, and when using Flatpak, just open an issue (see "Contacts"
in the beginning of this file) because most likely not all necessary Qt parts
were packaged along with Quaternion.

#### SSL problems
Especially on Windows, if Quaternion starts up but upon an attempt to connect
returns a message like "Failed to make SSL context" - correct SSL libraries
are not reachable by the Quaternion binary. Re-read the chapter "Requirements",
section "Windows" in the beginning of this file and do as it advises (make sure
in particular that you use the correct version of OpenSSL - it should be 3.x,
not 1.x).

#### Logging
If you want to see log messages in the command-line console (by default,
they are sent to system log on Windows and some but not all Linux systems with
journald), set `QT_ASSUME_STDERR_HAS_CONSOLE=1` to force the output to be
redirected to the console.

When chasing bugs and investigating crashes, it helps to run Quaternion from
the command line with increased logging level. Both libQuotient and (since
0.0.96 beta 4) Quaternion use
[logging categories](https://doc.qt.io/qt-6/qloggingcategory.html#configuring-categories)
to allow fine-grained switching of logs for a given part of the code. Quaternion
and libQuotient use different categories; this text only describes those for
Quaternion, make sure to also check [lib/README.md](lib/README.md) for
libQuotient logging categories. The most practical way to configure logging in
order to debug a problem is via the `QT_LOGGING_RULES` environment variable;
the Qt documentation (see the link above) lists a few other methods. In all
cases, you need to provide one or several clauses that look as follows:
```
quaternion.<category>.<level>=<flag>
```
where
- `<category>` is one of (see also `client/logging_categories.h`):
  - `main`
  - `accountselector`
  - `models` (Quaternion backend for user and room lists)
  - `models.events` (same for events)
  - `timeline` (C++ code for timeline visuals - very few log lines and not very
    informative unless you know what to look for)
  - `timeline.qml` (QML code for timeline visuals - this is what you likely
    need to figure out why the timeline looks wrong)
  - `htmlfilter` (conversions between Qt and Matrix subsets of HTML as well
    as HTML import from other applications)
  - `messageinput` (message entry box)
  - `thumbnails` (the code to supply images for the timeline)
- `<level>` is one of `debug`, `info`, and `warning`;
- `<flag>` is either `true` or `false`.

Bear in mind that all logging categories for Quaternion start with `quaternion`
while logging categories for libQuotient always start with `quotient`.

You can use `*` (asterisk) as a wildcard for any part between two dots, and
a semicolon is used for a separator. Latter statements override former ones, so
if you want Quaternion to log at debug level except, e.g., `timeline.qml`, set
```shell script
QT_LOGGING_RULES="quaternion.*.debug=true;quaternion.timeline.qml.debug=false"
```

You may also want to set `QT_MESSAGE_PATTERN` to make logs slightly more
informative (see https://doc.qt.io/qt-6/qtlogging.html#qSetMessagePattern
for the format description). My (@kitsune's) `QT_MESSAGE_PATTERN` looks as
follows:
```
`%{time h:mm:ss.zzz}|%{category}|%{if-debug}D%{endif}%{if-info}I%{endif}%{if-warning}W%{endif}%{if-critical}C%{endif}%{if-fatal}F%{endif}|%{message}`
```
(the scary `%{if}`s are just encoding the logging level into its initial letter).

## Screenshot
![Screenshot](Screenshot.png)
