% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createRawArraySeed.R
\name{createRawArraySeed}
\alias{createRawArraySeed}
\alias{.createRawArraySeed}
\alias{.extractArrayDimnames}
\title{Array loading utilities}
\usage{
.createRawArraySeed(info, project, names = TRUE)

.extractArrayDimnames(path, group, ndim)
}
\arguments{
\item{info}{A named list of metadata for this array.}

\item{project}{Any argument accepted by the acquisition functions, see \code{?\link{acquireFile}}. 
By default, this should be a string containing the path to a staging directory.}

\item{names}{Logical scalar indicating whether the seed should be annotated with dimnames (if available).}

\item{path}{String containing the path to the file containing said array.}

\item{group}{String containing the name of the group with the dimnames.}

\item{ndim}{Integer scalar specifying the number of dimensions.}
}
\value{
\code{.createRawArraySeed} returns a seed that can be used in the \code{\link{DelayedArray}} constructor.

\code{.extractArrayDimnames} returns a list of character vectors or \code{NULL}, containing the dimnames.
}
\description{
Utilities for loading an array saved by \code{\link{stageObject}}.
}
\details{
For \code{.createArraySeed}, the array should be one of:
\itemize{
\item \code{hdf5_dense_array}
\item \code{hdf5_sparse_matrix}
\item \code{hdf5_delayed_array}
\item \code{amalgamated_array}
}

For delayed arrays, the file may contain a seed array with the \code{"custom alabaster local array"} type.
This should have a \code{path} dataset containing a relative path to another array in the same \code{project}, which is loaded and used as the seed for this delayed array.
Callers can overwrite this behavior by setting \code{"custom alabaster local array"} in the \code{knownArrays} from \pkg{chihaya} before calling \code{.createRawArraySeed}.

For \code{.extractArrayDimnames}, \code{path} is expected to be a HDF5 file with a group specified by \code{group}.
Each child of this group is a string dataset named after a (0-indexed) dimension, containing the names for that dimension.
}
\examples{
# Staging an array as an example:
dir <- tempfile()
dir.create(dir)
mat <- array(rpois(10000, 10), c(50, 20, 10))
meta <- stageObject(mat, dir, "whee")

# Loading it back as a DelayedArray seed:
.createRawArraySeed(meta, project=dir)

}
\author{
Aaron Lun
}
