% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MbkmeansParam.R
\docType{class}
\name{MbkmeansParam-class}
\alias{MbkmeansParam-class}
\alias{show,MbkmeansParam-method}
\alias{MbkmeansParam}
\alias{clusterRows,ANY,MbkmeansParam-method}
\title{Mini-batch k-means clustering}
\usage{
MbkmeansParam(
  centers,
  batch_size = NULL,
  max_iters = 100,
  num_init = 1,
  init_fraction = NULL,
  initializer = "kmeans++",
  calc_wcss = FALSE,
  early_stop_iter = 10,
  tol = 1e-04,
  BPPARAM = SerialParam()
)

\S4method{clusterRows}{ANY,MbkmeansParam}(x, BLUSPARAM, full = FALSE)
}
\arguments{
\item{centers}{An integer scalar specifying the number of centers.
Alternatively, a function that takes the number of observations and returns the number of centers.}

\item{batch_size, max_iters, num_init, init_fraction, initializer, calc_wcss, early_stop_iter, tol, BPPARAM}{Further arguments to pass to \code{\link[mbkmeans]{mbkmeans}}.}

\item{x}{A numeric matrix-like object where rows represent observations and columns represent variables.}

\item{BLUSPARAM}{A \linkS4class{MbkmeansParam} object.}

\item{full}{Logical scalar indicating whether the full mini-batch k-means statistics should be returned.}
}
\value{
The \code{MbkmeansParam} constructor will return a \linkS4class{MbkmeansParam} object with the specified parameters.

The \code{clusterRows} method will return a factor of length equal to \code{nrow(x)} containing the cluster assignments.
If \code{full=TRUE}, a list is returned with \code{clusters} (the factor, as above) and \code{objects}
(a list containing \code{mbkmeans}, the direct output of \code{\link[mbkmeans]{mbkmeans}}).
}
\description{
Run the mini-batch k-means \code{\link[mbkmeans]{mbkmeans}} function with the specified number of centers within \code{\link{clusterRows}}.
This sacrifices some accuracy for speed compared to the standard k-means algorithm.
Note that this requires installation of the \pkg{mbkmeans} package.
}
\details{
This class usually requires the user to specify the number of clusters beforehand.
However, we can also allow the number of clusters to vary as a function of the number of observations.
The latter is occasionally useful, e.g., to allow the clustering to automatically become more granular for large datasets.

To modify an existing MbkmeansParam object \code{x},
users can simply call \code{x[[i]]} or \code{x[[i]] <- value} where \code{i} is any argument used in the constructor.

For \code{batch_size} and \code{init_fraction}, a value of \code{NULL} means that the default arguments in the \code{\link[mbkmeans]{mbkmeans}} function signature are used.
These defaults are data-dependent and so cannot be specified during construction of the MbkmeansParam object, but instead are defined within the \code{clusterRows} method.
}
\examples{
clusterRows(iris[,1:4], MbkmeansParam(centers=3))
clusterRows(iris[,1:4], MbkmeansParam(centers=3, batch_size=10))
clusterRows(iris[,1:4], MbkmeansParam(centers=3, init_fraction=0.5))
}
\seealso{
\code{\link[mbkmeans]{mbkmeans}} from the \pkg{mbkmeans} package, which actually does all the heavy lifting.

\linkS4class{KmeansParam}, for dispatch to the standard k-means algorithm.
}
\author{
Stephanie Hicks
}
