% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetBy-methods.R,
%   R/MultiAssayExperiment-subset.R
\name{subsetBy}
\alias{subsetBy}
\alias{[,MultiAssayExperiment,ANY-method}
\alias{subsetByColData}
\alias{subsetByRow}
\alias{subsetByColumn}
\alias{subsetByAssay}
\alias{subset}
\alias{subsetByRow,ExperimentList,ANY-method}
\alias{subsetByRow,ExperimentList,list-method}
\alias{subsetByRow,ExperimentList,List-method}
\alias{subsetByRow,ExperimentList,logical-method}
\alias{subsetByColumn,ExperimentList,list-method}
\alias{subsetByColumn,ExperimentList,List-method}
\alias{subsetByColumn,ExperimentList,logical-method}
\alias{subsetByAssay,ExperimentList-method}
\alias{subsetByColData,MultiAssayExperiment,ANY-method}
\alias{subsetByColData,MultiAssayExperiment,character-method}
\alias{subsetByRow,MultiAssayExperiment,ANY-method}
\alias{subsetByColumn,MultiAssayExperiment,ANY-method}
\alias{subsetByAssay,MultiAssayExperiment-method}
\alias{[,MultiAssayExperiment,ANY,ANY,ANY-method}
\alias{[[,MultiAssayExperiment,ANY,ANY-method}
\alias{[[<-,MultiAssayExperiment,ANY,ANY-method}
\alias{[<-,MultiAssayExperiment,ANY,ANY,ANY-method}
\title{Subsetting a MultiAssayExperiment object}
\usage{
subsetByRow(x, y, ...)

subsetByColData(x, y)

subsetByColumn(x, y)

subsetByAssay(x, y)

\S4method{subsetByRow}{ExperimentList,ANY}(x, y, ...)

\S4method{subsetByRow}{ExperimentList,list}(x, y)

\S4method{subsetByRow}{ExperimentList,List}(x, y)

\S4method{subsetByRow}{ExperimentList,logical}(x, y)

\S4method{subsetByColumn}{ExperimentList,list}(x, y)

\S4method{subsetByColumn}{ExperimentList,List}(x, y)

\S4method{subsetByColumn}{ExperimentList,logical}(x, y)

\S4method{subsetByAssay}{ExperimentList}(x, y)

\S4method{subsetByColData}{MultiAssayExperiment,ANY}(x, y)

\S4method{subsetByColData}{MultiAssayExperiment,character}(x, y)

\S4method{subsetByRow}{MultiAssayExperiment,ANY}(x, y, ...)

\S4method{subsetByColumn}{MultiAssayExperiment,ANY}(x, y)

\S4method{subsetByAssay}{MultiAssayExperiment}(x, y)

\S4method{[}{MultiAssayExperiment,ANY,ANY,ANY}(x, i, j, k, ..., drop = TRUE)

\S4method{[[}{MultiAssayExperiment,ANY,ANY}(x, i, j, ...)

\S4method{[[}{MultiAssayExperiment,ANY,ANY}(x, i, j, ...) <- value

\S4method{[}{MultiAssayExperiment,ANY,ANY,ANY}(x, i, j, ...) <- value
}
\arguments{
\item{x}{A \code{MultiAssayExperiment} or \code{ExperimentList}}

\item{y}{Any argument used for subsetting, can be a \code{character},
\code{logical}, \code{integer}, \code{list} or \code{List} vector}

\item{...}{Additional arguments passed on to lower level functions.}

\item{i}{Either a \code{character}, \code{integer}, \code{logical} or
\code{GRanges} object for subsetting by rows}

\item{j}{Either a \code{character}, \code{logical}, or \code{numeric} vector
for subsetting by \code{colData} rows. See details for more information.}

\item{k}{Either a \code{character}, \code{logical}, or \code{numeric} vector
for subsetting by assays}

\item{drop}{logical (default TRUE) whether to drop empty assay elements
in the \code{ExperimentList}}

\item{value}{An assay compatible with the MultiAssayExperiment API}
}
\value{
\code{subsetBy*} operations are endomorphic and return either
\code{MultiAssayExperiment} or \code{ExperimentList} depending on the
input.
}
\description{
A set of functions for extracting and dividing a
\code{MultiAssayExperiment}
}
\details{
Subsetting a MultiAssayExperiment by the \strong{j} index can yield a call
to either \code{subsetByColData} or \code{subsetByColumn}. For vector inputs,
the subset will be applied to the \code{colData} rows. For \code{List}-type
inputs, the List will be applied to each of the elements in the
\code{ExperimentList}.
The order of the subsetting elements in the
\code{List} must match that of the \code{ExperimentList} in the
\code{MultiAssayExperiment}.

\itemize{
\item subsetBycolData: Select biological units by vector input types
\item subsetByColumn: Select observations by assay or for each assay
\item subsetByRow: Select rows by assay or for each assay
\item subsetByAssay: Select experiments
}
}
\examples{
## Load the example MultiAssayExperiment
example("MultiAssayExperiment")

## Using experiment names
subsetByAssay(mae, "Affy")

## Using numeric indices
subsetByAssay(mae, 1:2)

## Using a logical vector
subsetByAssay(mae, c(TRUE, FALSE, TRUE))

## Subset by character vector (Jack)
subsetByColData(mae, "Jack")

## Subset by numeric index of colData rows (Jack and Bob)
subsetByColData(mae, c(1, 3))

## Subset by logical indicator of colData rows (Jack and Jill)
subsetByColData(mae, c(TRUE, TRUE, FALSE, FALSE))

subsetByColumn(mae, list(Affy = 1:2,
    Methyl450k = c(3,5,2), RNASeqGene = 2:4, GISTIC = 1))

subsetWith <- S4Vectors::mendoapply(`[`, colnames(mae),
    MoreArgs = list(1:2))
subsetByColumn(mae, subsetWith)

## Use a GRanges object to subset rows where ranged data present
egr <- GenomicRanges::GRanges(seqnames = "chr2",
    IRanges::IRanges(start = 11, end = 13), strand = "-")
subsetByRow(mae, egr)

## Use a logical vector (recycling used)
subsetByRow(mae, c(TRUE, FALSE))

## Use a character vector
subsetByRow(mae, "ENST00000355076")

}
