% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-addr.R
\name{as.cell_addr}
\alias{as.cell_addr}
\alias{as.cell_addr.character}
\alias{as.cell_addr.ra_ref}
\alias{as.cell_addr_v}
\alias{as.cell_addr_v.character}
\alias{as.cell_addr_v.list}
\title{Convert to a cell_addr object}
\usage{
as.cell_addr(x, ...)

as.cell_addr_v(x, ...)

\method{as.cell_addr}{ra_ref}(x, ...)

\method{as.cell_addr_v}{list}(x, ...)

\method{as.cell_addr}{character}(x, fo = NULL, strict = TRUE, ...)

\method{as.cell_addr_v}{character}(x, fo = NULL, strict = TRUE, ...)
}
\arguments{
\item{x}{a cell reference}

\item{...}{further arguments passed to or from other methods}

\item{fo}{either \code{"R1C1"} (the default) or \code{"A1"} specifying the
cell reference format; in many contexts, it can be inferred and is optional}

\item{strict}{logical, affects reading and writing of A1 formatted cell
references. When \code{strict = TRUE}, references must be declared absolute
through the use of dollar signs, e.g., \code{$A$1},  for parsing. When
making a string, \code{strict = TRUE} requests dollar signs for absolute
reference. When \code{strict = FALSE}, pure relative reference strings will
be interpreted as absolute, i.e. \code{A1} and \code{$A$1} are treated the
same. When making a string, \code{strict = FALSE} will cause dollars signs
to be omitted in the reference string.}
}
\value{
a \code{\link{cell_addr}} object
}
\description{
Convert various representations of a cell reference into an object of class
\code{\link{cell_addr}}. Recall that \code{\link{cell_addr}} objects hold
absolute row and column location, so \code{\link{ra_ref}} objects or cell
reference strings with relative or mixed references will raise a warning and
generate \code{NA}s.
}
\examples{
as.cell_addr(ra_ref())
rar <- ra_ref(2, TRUE, 5, TRUE)
as.cell_addr(rar)
## mixed reference
rar <- ra_ref(2, FALSE, 5, TRUE)
as.cell_addr(rar)
ra_ref_list <-
  list(ra_ref(), ra_ref(2, TRUE, 5, TRUE), ra_ref(2, FALSE, 5, TRUE))
as.cell_addr_v(ra_ref_list)
as.cell_addr("$D$12")
as.cell_addr("R4C3")
as.cell_addr(c("$C$4", "$D$12"))
as.cell_addr("$F2")
as.cell_addr("R[-4]C3")
as.cell_addr("F2", strict = FALSE)
}

