% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics-package.R
\docType{package}
\name{generics-package}
\alias{generics}
\alias{generics-package}
\title{generics: common S3 generics}
\description{
These are generic functions that can be used to minimize
package dependencies when multiple packages have the same
method.
}
\details{
An attempt was made to use generic class signatures that were
consistent with existing code. For example, \pkg{dplyr} and
\pkg{lime} both have \code{explain()} methods that do very different
things but both take \code{x} as their main object. Even though \code{x}
would be different in those cases, this package provides access
to the S3 generic so that other packages that may want to create
\code{explain()} methods for their objects can do so without loading
either of the other packages.

For example, if a new \code{tidy()} method is being developed for a
package, this lightweight package can be the required dependency
to have access to the generic method (instead of depending on
\pkg{broom} and installing its dependencies).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://generics.r-lib.org}
  \item \url{https://github.com/r-lib/generics}
  \item Report bugs at \url{https://github.com/r-lib/generics/issues}
}

}
\author{
\strong{Maintainer}: Hadley Wickham \email{hadley@rstudio.com}

Authors:
\itemize{
  \item Max Kuhn \email{max@rstudio.com}
  \item Davis Vaughan \email{davis@rstudio.com}
}

Other contributors:
\itemize{
  \item RStudio [copyright holder]
}

}
\keyword{internal}
