% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptype.R
\name{extract_ptype}
\alias{extract_ptype}
\title{Extract a prototype}
\usage{
extract_ptype(data)
}
\arguments{
\item{data}{A data frame or matrix.}
}
\value{
A 0 row slice of \code{data} after converting it to a tibble.
}
\description{
\code{extract_ptype()} extracts a tibble with 0 rows from \code{data}. This contains
all of the required information about column names, classes, and factor
levels that are required to check the structure of new data at prediction
time.
}
\details{
\code{extract_ptype()} is useful when creating a new preprocessing \code{blueprint}. It
extracts the required information that will be used by the validation checks
at prediction time.
}
\examples{

hardhat:::extract_ptype(iris)
}
\keyword{internal}
