% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.jinjar_template}
\alias{print.jinjar_template}
\title{Print a template}
\usage{
\method{print}{jinjar_template}(x, ..., n = 10)
}
\arguments{
\item{x}{A parsed template (use \code{\link[=parse_template]{parse_template()}}).}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{Number of lines to show. If \code{Inf}, will print all lines. Default: \code{10}.}
}
\description{
Once a template has been parsed, it can be printed with color highlighting of
the templating blocks.
}
\examples{
input <- '<!DOCTYPE html>
<html lang="en">
<head>
    <title>{{ title }}</title>
</head>
<body>
    <ul id="navigation">
    {\% for item in navigation -\%}
        <li><a href="{{ item.href }}">{{ item.caption }}</a></li>
    {\% endfor -\%}
    </ul>
{# a comment #}
</body>
</html>'

x <- parse_template(input)

print(x)

print(x, n = Inf)
}
