% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_lines_rgbwt.R
\name{scatter_lines_rgbwt}
\alias{scatter_lines_rgbwt}
\title{scatter_lines_rgbwt}
\usage{
scatter_lines_rgbwt(
  xy,
  xlim = c(min(xy[, c(1, 3)]), max(xy[, c(1, 3)])),
  ylim = c(min(xy[, c(2, 4)]), max(xy[, c(2, 4)])),
  out_size = c(512L, 512L),
  RGBA = c(0, 0, 0, 255),
  skip_start_pixel = FALSE,
  skip_end_pixel = TRUE
)
}
\arguments{
\item{xy}{4-column matrix with point coordinates.
Each row contains X and Y coordinates of line start and X and Y coordinates of line end, in this order.}

\item{xlim, ylim}{2-element vector of rendered area limits (position of the first pixel on the
left/top, and the last pixel on the right/bottom).
You can flip the image coordinate system by flipping the \verb{*lim} vectors.}

\item{out_size}{2-element vector size of the result raster, defaults to \code{c(512L,512L)}.}

\item{RGBA}{Vector of 4 elements with integral RGBA color for the lines, defaults to \code{c(0,0,0,255)}.}

\item{skip_start_pixel}{TRUE if the start pixel of the lines should be omitted, defaults to \code{FALSE}.}

\item{skip_end_pixel}{TRUE if the end pixel of a line should be omitted, defaults to \code{TRUE}.
(When plotting long ribbons of connected lines, this prevents counting the connecting pixels twice.)}
}
\value{
Lines plotted in RGBWT bitmap.
}
\description{
Render lines into a RGBWT bitmap.
}
