% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-interact-opts.R
\name{clickOpts}
\alias{clickOpts}
\alias{dblclickOpts}
\alias{hoverOpts}
\title{Control interactive plot point events}
\usage{
clickOpts(id, clip = TRUE)

dblclickOpts(id, clip = TRUE, delay = 400)

hoverOpts(
  id,
  delay = 300,
  delayType = c("debounce", "throttle"),
  clip = TRUE,
  nullOutside = TRUE
)
}
\arguments{
\item{id}{Input value name. For example, if the value is \code{"plot_click"},
then the event data will be available as \code{input$plot_click}.}

\item{clip}{Should the click area be clipped to the plotting area? If
\code{FALSE}, then the server will receive click events even when the mouse is
outside the plotting area, as long as it is still inside the image.}

\item{delay}{For \code{dblClickOpts()}: the maximum delay (in ms) between a
pair clicks for them to be counted as a double-click.

For \code{hoverOpts()}: how long to delay (in ms) when debouncing or throttling
before sending the mouse location to the server.}

\item{delayType}{The type of algorithm for limiting the number of hover
events. Use \code{"throttle"} to limit the number of hover events to one
every \code{delay} milliseconds. Use \code{"debounce"} to suspend events
while the cursor is moving, and wait until the cursor has been at rest for
\code{delay} milliseconds before sending an event.}

\item{nullOutside}{If \code{TRUE} (the default), the value will be set to
\code{NULL} when the mouse exits the plotting area. If \code{FALSE}, the
value will stop changing when the cursor exits the plotting area.}
}
\description{
These functions give control over the \code{click}, \code{dblClick} and
\code{hover} events generated by \code{\link[=imageOutput]{imageOutput()}} and \code{\link[=plotOutput]{plotOutput()}}.
}
\seealso{
\code{\link[=brushOpts]{brushOpts()}} for brushing events.
}
