% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.utilities.R
\name{paste.and}
\alias{paste.and}
\title{Concatenates the elements of a vector (optionaly enclosing them in quotation
marks or parentheses) adding appropriate punctuation and conjunctions.}
\usage{
paste.and(x, oq = "", cq = "", con = "and")
}
\arguments{
\item{x}{A vector.}

\item{oq}{Opening quotation symbol. (Defaults to none.)}

\item{cq}{Closing quotation symbol. (Defaults to none.)}

\item{con}{Conjunction to be used if \code{length(x)>1}. (Defaults to "and".)}
}
\value{
A string with the output.
}
\description{
A vector \code{x} becomes "\code{x[1]}", "\code{x[1]} and \code{x[2]}", or
"\code{x[1]}, \code{x[2]}, and \code{x[3]}", depending on the langth of
\code{x}.
}
\examples{

print(paste.and(c()))

print(paste.and(1))

print(paste.and(1:2))

print(paste.and(1:3))

print(paste.and(1:4,con='or'))
}
\seealso{
paste, cat
}
\keyword{utilities}
