// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk_sys;
use glib::translate::*;
use std::fmt;
use std::mem;
use ByteOrder;
use Screen;
use VisualType;

glib_wrapper! {
    pub struct Visual(Object<gdk_sys::GdkVisual, VisualClass>);

    match fn {
        get_type => || gdk_sys::gdk_visual_get_type(),
    }
}

impl Visual {
    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn get_bits_per_rgb(&self) -> i32 {
        unsafe { gdk_sys::gdk_visual_get_bits_per_rgb(self.to_glib_none().0) }
    }

    pub fn get_blue_pixel_details(&self) -> (u32, i32, i32) {
        unsafe {
            let mut mask = mem::uninitialized();
            let mut shift = mem::uninitialized();
            let mut precision = mem::uninitialized();
            gdk_sys::gdk_visual_get_blue_pixel_details(
                self.to_glib_none().0,
                &mut mask,
                &mut shift,
                &mut precision,
            );
            (mask, shift, precision)
        }
    }

    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn get_byte_order(&self) -> ByteOrder {
        unsafe { from_glib(gdk_sys::gdk_visual_get_byte_order(self.to_glib_none().0)) }
    }

    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn get_colormap_size(&self) -> i32 {
        unsafe { gdk_sys::gdk_visual_get_colormap_size(self.to_glib_none().0) }
    }

    pub fn get_depth(&self) -> i32 {
        unsafe { gdk_sys::gdk_visual_get_depth(self.to_glib_none().0) }
    }

    pub fn get_green_pixel_details(&self) -> (u32, i32, i32) {
        unsafe {
            let mut mask = mem::uninitialized();
            let mut shift = mem::uninitialized();
            let mut precision = mem::uninitialized();
            gdk_sys::gdk_visual_get_green_pixel_details(
                self.to_glib_none().0,
                &mut mask,
                &mut shift,
                &mut precision,
            );
            (mask, shift, precision)
        }
    }

    pub fn get_red_pixel_details(&self) -> (u32, i32, i32) {
        unsafe {
            let mut mask = mem::uninitialized();
            let mut shift = mem::uninitialized();
            let mut precision = mem::uninitialized();
            gdk_sys::gdk_visual_get_red_pixel_details(
                self.to_glib_none().0,
                &mut mask,
                &mut shift,
                &mut precision,
            );
            (mask, shift, precision)
        }
    }

    pub fn get_screen(&self) -> Screen {
        unsafe { from_glib_none(gdk_sys::gdk_visual_get_screen(self.to_glib_none().0)) }
    }

    pub fn get_visual_type(&self) -> VisualType {
        unsafe { from_glib(gdk_sys::gdk_visual_get_visual_type(self.to_glib_none().0)) }
    }

    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn get_best() -> Visual {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(gdk_sys::gdk_visual_get_best()) }
    }

    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn get_best_depth() -> i32 {
        assert_initialized_main_thread!();
        unsafe { gdk_sys::gdk_visual_get_best_depth() }
    }

    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn get_best_type() -> VisualType {
        assert_initialized_main_thread!();
        unsafe { from_glib(gdk_sys::gdk_visual_get_best_type()) }
    }

    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn get_best_with_both(depth: i32, visual_type: VisualType) -> Option<Visual> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(gdk_sys::gdk_visual_get_best_with_both(
                depth,
                visual_type.to_glib(),
            ))
        }
    }

    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn get_best_with_depth(depth: i32) -> Option<Visual> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(gdk_sys::gdk_visual_get_best_with_depth(depth)) }
    }

    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn get_best_with_type(visual_type: VisualType) -> Option<Visual> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(gdk_sys::gdk_visual_get_best_with_type(
                visual_type.to_glib(),
            ))
        }
    }

    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn get_system() -> Visual {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(gdk_sys::gdk_visual_get_system()) }
    }
}

impl fmt::Display for Visual {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Visual")
    }
}
