// -----------------------------------------------------------------------------------------------------
// Copyright (c) 2006-2022, Knut Reinert & Freie Universität Berlin
// Copyright (c) 2016-2022, Knut Reinert & MPI für molekulare Genetik
// This file may be used, modified and/or redistributed under the terms of the 3-clause BSD-License
// shipped with this file and also available at: https://github.com/seqan/seqan3/blob/master/LICENSE.md
// -----------------------------------------------------------------------------------------------------

/*!\file
 * \brief Meta-header for the \cond DEV \link utility_parallel Utility / Parallel submodule \endlink \endcond.
 * \author Rene Rahn <rene.rahn AT fu-berlin.de>
 */

//!\cond DEV

/*!\defgroup utility_parallel Parallel
 * \brief This module contains types and utilities for concurrent execution of algorithms in SeqAn.
 * \ingroup utility
 * \see utility
 *
 * \details
 *
 * ### Execution policies
 *
 * Here are currently only implementations which are part of detail and therefore not of interest for the common user.
 *
 * ### Concurrency support
 *
 * This module contains helper classes to synchronise threads in concurrent environments.
 */
//!\endcond

#pragma once

#include <seqan3/core/platform.hpp>
