/* Copyright (C) 2011 Atsushi Togo */
/* All rights reserved. */

/* This file is part of spglib. */

/* Redistribution and use in source and binary forms, with or without */
/* modification, are permitted provided that the following conditions */
/* are met: */

/* * Redistributions of source code must retain the above copyright */
/*   notice, this list of conditions and the following disclaimer. */

/* * Redistributions in binary form must reproduce the above copyright */
/*   notice, this list of conditions and the following disclaimer in */
/*   the documentation and/or other materials provided with the */
/*   distribution. */

/* * Neither the name of the spglib project nor the names of its */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission. */

/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE */
/* COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, */
/* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, */
/* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; */
/* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER */
/* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT */
/* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN */
/* ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE */
/* POSSIBILITY OF SUCH DAMAGE. */

#include "sitesym_database.h"

#include "spg_database.h"

/* This gives number of Wyckoff positions. */
/* Space group No. 1: 1 = 2-1 */
/* Space group No. 2: 9 = 11-2 */
/* Space group No. 3: 5 = 16-11 */
static const int position_wyckoff[] = {
    0,    1,    2,    11,   16,   21,   26,   27,   28,   29,   32,   35,
    38,   41,   44,   47,   50,   53,   56,   59,   62,   65,   66,   67,
    68,   69,   70,   71,   72,   73,   74,   76,   78,   80,   82,   84,
    86,   88,   90,   92,   93,   94,   95,   96,   97,   98,   99,   100,
    101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  125,  140,
    155,  161,  167,  173,  183,  193,  203,  213,  223,  233,  243,  253,
    263,  270,  277,  284,  291,  298,  305,  312,  319,  326,  331,  336,
    341,  346,  351,  356,  361,  366,  371,  377,  383,  389,  395,  401,
    407,  413,  419,  425,  431,  437,  443,  449,  455,  461,  467,  473,
    479,  500,  505,  510,  515,  518,  521,  524,  525,  528,  531,  534,
    546,  558,  570,  581,  592,  596,  605,  614,  623,  626,  629,  632,
    635,  638,  641,  646,  651,  656,  660,  664,  668,  672,  676,  680,
    681,  682,  683,  684,  685,  686,  689,  692,  695,  698,  701,  704,
    706,  708,  710,  712,  714,  716,  719,  722,  725,  726,  727,  728,
    729,  730,  731,  734,  737,  740,  746,  752,  758,  760,  762,  764,
    766,  768,  770,  774,  778,  782,  788,  794,  800,  806,  812,  818,
    822,  826,  830,  834,  838,  842,  845,  848,  851,  854,  857,  860,
    862,  864,  866,  868,  870,  872,  877,  882,  887,  889,  891,  893,
    898,  903,  908,  911,  914,  917,  920,  923,  926,  929,  932,  935,
    962,  975,  988,  1006, 1024, 1042, 1055, 1068, 1081, 1094, 1107, 1120,
    1132, 1144, 1156, 1168, 1180, 1192, 1197, 1202, 1207, 1212, 1217, 1222,
    1231, 1240, 1249, 1258, 1267, 1276, 1282, 1288, 1294, 1300, 1306, 1312,
    1321, 1330, 1339, 1344, 1349, 1354, 1359, 1364, 1369, 1374, 1379, 1384,
    1392, 1400, 1408, 1415, 1422, 1429, 1436, 1443, 1450, 1454, 1458, 1462,
    1466, 1470, 1474, 1477, 1480, 1484, 1488, 1492, 1496, 1500, 1504, 1512,
    1520, 1528, 1536, 1544, 1552, 1559, 1566, 1573, 1580, 1587, 1594, 1612,
    1630, 1648, 1661, 1674, 1687, 1702, 1717, 1732, 1747, 1762, 1777, 1786,
    1795, 1804, 1813, 1822, 1831, 1840, 1849, 1858, 1867, 1876, 1885, 1901,
    1909, 1917, 1932, 1943, 1954, 1965, 1971, 1977, 1987, 1997, 2007, 2017,
    2027, 2037, 2041, 2042, 2046, 2047, 2050, 2052, 2060, 2067, 2079, 2090,
    2097, 2104, 2111, 2118, 2127, 2133, 2139, 2155, 2162, 2166, 2168, 2184,
    2191, 2195, 2197, 2208, 2215, 2222, 2226, 2231, 2235, 2239, 2242, 2248,
    2251, 2256, 2260, 2263, 2265, 2280, 2294, 2300, 2305, 2317, 2327, 2336,
    2345, 2355, 2364, 2374, 2379, 2400, 2414, 2428, 2442, 2453, 2464, 2476,
    2485, 2496, 2507, 2514, 2521, 2539, 2555, 2566, 2577, 2591, 2605, 2614,
    2625, 2633, 2641, 2651, 2661, 2676, 2689, 2698, 2707, 2714, 2721, 2725,
    2726, 2727, 2729, 2731, 2738, 2744, 2750, 2762, 2769, 2772, 2775, 2778,
    2781, 2787, 2793, 2798, 2802, 2806, 2809, 2812, 2815, 2817, 2819, 2831,
    2840, 2850, 2857, 2866, 2875, 2881, 2887, 2891, 2892, 2893, 2896, 2899,
    2902, 2914, 2926, 2935, 2949, 2952, 2955, 2966, 2977, 2986, 2992, 2996,
    3000, 3004, 3019, 3031, 3043, 3052, 3070, 3083, 3095, 3107, 3117, 3125,
    3131, 3133, 3136, 3148, 3156, 3164, 3173, 3180, 3187, 3195, 3199, 3204,
    3215, 3228, 3238, 3246, 3256, 3261, 3266, 3275, 3285, 3294, 3302, 3311,
    3319, 3324, 3338, 3347, 3356, 3368, 3380, 3392, 3404, 3414, 3423, 3432,
    3440, 3448, 3460, 3468,
};

static const int position_layer_wyckoff[] = {
    0,    3468, 3469, 3474, 3479, 3481, 3482, 3483, 3484, 3494, 3499, 3504,
    3509, 3512, 3515, 3516, 3517, 3519, 3521, 3524, 3527, 3528, 3529, 3531,
    3533, 3542, 3551, 3555, 3559, 3563, 3567, 3570, 3573, 3579, 3585, 3598,
    3602, 3606, 3609, 3617, 3626, 3630, 3634, 3637, 3643, 3649, 3655, 3658,
    3661, 3663, 3665, 3668, 3671, 3674, 3677, 3679, 3681, 3682, 3683, 3685,
    3687, 3691, 3695, 3698, 3701, 3719, 3730, 3741, 3749, 3757, 3765, 3774,
    3783, 3789, 3795, 3799, 3803, 3809, 3813, 3817, 3823, 3835, 3845, 3849,
    3855, 3863, 3868, 3873, 3883, 3888, 3895, 3899, 3909, 3914, 3923, 3929,
    3943, 3952, 3961, 3969, 3977, 3985, 3989, 3994, 4002, 4007, 4012, 4016,
    4024, 4031, 4035, 4043, 4051, 4060, 4066, 4076, 4084, 4096,
};

/* Each number gives 'Coordinates' of first element of each Wyckoff position. */
/* Space group No. 1 (1 elem): 63923 */
/* Space group No. 2 (9 elems): 63923, 657239062,  27383062, 630995062, .., */
/* Each number contains r=3x3 and t=3x1 matrices that are used as */
/* x' = rx + t, where x is a point coordinates of atoms. */
/* If x is at the 'Coordinates', x'=x (mod Z). */
/* 63923 is decoded to identity and (0, 0, 0) matrices, respectively. */
/* See ssmdb_get_coordinate. */
static const int coordinates_first[] = {
    0,          63923,     63923,     657239062,  27383062,   630995062,
    656145562,  629901562, 26289562,  1139062,    45562,      63923,
    630995197,  629901697, 1139197,   45697,      63923,      656145563,
    26289563,   629901563, 45563,     63923,      27401287,   1157287,
    26307787,   63787,     63923,     63923,      63923,      63923,
    1139197,    45697,     63923,     629901697,  45697,      63923,
    629901697,  45697,     63923,     629901563,  45563,      63923,
    26289563,   45563,     63923,     26289563,   45563,      63923,
    26307787,   63787,     63923,     1157287,    63787,      63923,
    1157287,    63787,     63923,     26307788,   63788,      63923,
    1157422,    63922,     63923,     629901698,  45698,      63923,
    63923,      63923,     63923,     63923,      63923,      63923,
    63923,      63923,     63923,     63788,      63923,      63788,
    63923,      63788,     63923,     63922,      63923,      63922,
    63923,      63922,     63923,     45698,      63923,      45698,
    63923,      45698,     63923,     63923,      63923,      63923,
    63923,      63923,     63923,     63923,      63923,      63923,
    63923,      63923,     63923,     63923,      63923,      63923,
    63923,      63923,     63923,     26307788,   63788,      630995197,
    1139197,    629901697, 45697,     657239062,  630995062,  27383062,
    656145562,  629901562, 1139062,   26289562,   45562,      63923,
    1157422,    63922,     656145563, 629901563,  26289563,   45563,
    657239062,  656145562, 630995062, 27383062,   26289562,   629901562,
    1139062,    45562,     63923,     629901698,  45698,      27401287,
    26307787,   1157287,   63787,     657239062,  27383062,   656145562,
    630995062,  1139062,   26289562,  629901562,  45562,      63923,
    13185788,   630995062, 1139062,   629901562,  45562,      63923,
    610672,     656145562, 629901562, 26289562,   45562,      63923,
    314973698,  27383062,  26289562,  1139062,    45562,      63923,
    63788,      1139197,   45697,     329189062,  328095562,  27383062,
    1139062,    26289562,  45562,     63923,      63788,      629901697,
    45697,      643570312, 13714312,  656145562,  629901562,  26289562,
    45562,      63923,     63788,     1139197,    45697,      329735812,
    328642312,  27383062,  1139062,   26289562,   45562,      63923,
    63922,      629901563, 45563,     643570312,  13714312,   630995062,
    629901562,  1139062,   45562,     63923,      63922,      26289563,
    45563,      341764312, 315520312, 27383062,   26289562,   1139062,
    45562,      63923,     63922,     629901563,  45563,      958498312,
    328642312,  630995062, 629901562, 1139062,    45562,      63923,
    45698,      26307787,  63787,     341764312,  315520312,  656145562,
    26289562,   629901562, 45562,     63923,      45698,      1157287,
    63787,      329189062, 328095562, 630995062,  1139062,    629901562,
    45562,      63923,     45698,     26307787,   63787,      354886312,
    328642312,  656145562, 26289562,  629901562,  45562,      63923,
    630448447,  592447,    629901562, 26289562,   656145562,  45562,
    63923,      945376447, 315520447, 629901562,  26289562,   656145562,
    45562,      63923,     945923197, 944829697,  1139062,    26289562,
    27383062,   45562,     63923,     341217563,  314973563,  26289562,
    1139062,    27383062,  45562,     63923,      354339563,  328095563,
    26289562,   1139062,   27383062,  45562,      63923,      669267563,
    39411563,   629901562, 1139062,   630995062,  45562,      63923,
    14279287,   13185787,  1139062,   629901562,  630995062,  45562,
    63923,      14826037,  13732537,  1139062,    629901562,  630995062,
    45562,      63923,     27948037,  1704037,    26289562,   629901562,
    656145562,  45562,     63923,     630995062,  1139062,    629901562,
    45562,      63923,     1139062,   630995062,  629901562,  45562,
    63923,      630995062, 629901562, 1139062,    45562,      63923,
    656145562,  629901562, 26289562,  45562,      63923,      629901562,
    656145562,  26289562,  45562,     63923,      656145562,  26289562,
    629901562,  45562,     63923,     27383062,   26289562,   1139062,
    45562,      63923,     26289562,  27383062,   1139062,    45562,
    63923,      27383062,  1139062,   26289562,   45562,      63923,
    592447,     329189062, 328095562, 26289562,   45562,      63923,
    315520447,  670907812, 39958312,  26289562,   45562,      63923,
    314973697,  984742312, 354886312, 26289562,   45562,      63923,
    944829697,  643570312, 13714312,  26289562,   45562,      63923,
    315520447,  959045062, 328095562, 26289562,   45562,      63923,
    592447,     329735812, 328642312, 26289562,   45562,      63923,
    314973563,  643570312, 13714312,  1139062,    45562,      63923,
    328095563,  972713812, 316613812, 1139062,    45562,      63923,
    13167563,   355979812, 329735812, 1139062,    45562,      63923,
    39411563,   341764312, 315520312, 1139062,    45562,      63923,
    328095563,  669814312, 13714312,  1139062,    45562,      63923,
    314973563,  958498312, 328642312, 1139062,    45562,      63923,
    13185787,   341764312, 315520312, 629901562,  45562,      63923,
    13732537,   985289062, 957951562, 629901562,  45562,      63923,
    610537,     959591812, 958498312, 629901562,  45562,      63923,
    1704037,    329189062, 328095562, 629901562,  45562,      63923,
    13732537,   342857812, 315520312, 629901562,  45562,      63923,
    13185787,   354886312, 328642312, 629901562,  45562,      63923,
    656145563,  26289563,  629901563, 45563,      630995197,  629901697,
    1139197,    45697,     27401287,  26307787,   1157287,    63787,
    657239062,  27383062,  630995062, 656145562,  1139062,    26289562,
    629901562,  45562,     63923,     630448447,  592447,     26307787,
    63787,      63923,     341217563, 314973563,  1139197,    45697,
    63923,      14279287,  13185787,  629901563,  45563,      63923,
    26289563,   45563,     63923,     1157287,    63787,      63923,
    629901697,  45697,     63923,     63923,      592447,     63787,
    63923,      314973563, 45697,     63923,      13185787,   45563,
    63923,      328095563, 26289563,  45563,      1139197,    45697,
    1157287,    63787,     1139062,   630995062,  26289562,   45562,
    63923,      13732537,  1157287,   63787,      629901563,  45563,
    629901697,  45697,     629901562, 656145562,  1139062,    45562,
    63923,      315520447, 629901697, 45697,      26307787,   63787,
    26289563,   45563,     26289562,  27383062,   629901562,  45562,
    63923,      13732537,  315520447, 328095563,  45563,      45697,
    63787,      329735812, 328642312, 1139062,    45562,      63923,
    26289563,   45563,     629901697, 45697,      1157287,    63787,
    26289562,   1139062,   629901562, 45562,      63923,      13167563,
    314973697,  610537,    63923,     629901698,  45698,      26307788,
    63788,      656145563, 629901563, 26289563,   45563,      63923,
    26307788,   63788,     1157422,   63922,      27401287,   26307787,
    1157287,    63787,     63923,     1157422,    63922,      629901698,
    45698,      630995197, 1139197,   629901697,  45697,      63923,
    629901698,  45698,     63923,     26307788,   63788,      63923,
    26307788,   63788,     63923,     1157422,    63922,      63923,
    1157422,    63922,     63923,     629901698,  45698,      63923,
    656145563,  629901563, 26289563,  45563,      63923,      27401287,
    26307787,   1157287,   63787,     63923,      630995197,  1139197,
    629901697,  45697,     63923,     314973698,  26289563,   45563,
    63923,      13185788,  629901563, 45563,      63923,      13185788,
    1157287,    63787,     63923,     610672,     26307787,   63787,
    63923,      610672,    629901697, 45697,      63923,      314973698,
    1139197,    45697,     63923,     63923,      63923,      63923,
    63923,      63923,     63923,     629901563,  45563,      63923,
    26289563,   45563,     63923,     26307787,   63787,      63923,
    1157287,    63787,     63923,     1139197,    45697,      63923,
    629901697,  45697,     63923,     45698,      63923,      63788,
    63923,      63788,     63923,     63922,      63923,      63922,
    63923,      45698,     63923,     26289563,   45563,      63923,
    1157287,    63787,     63923,     629901697,  45697,      63923,
    63923,      63923,     63923,     63923,      63923,      63923,
    26289563,   45563,     63923,     1157287,    63787,      63923,
    629901697,  45697,     63923,     45698,      63788,      328095563,
    26289563,   45563,     63923,     63788,      63922,      13732537,
    1157287,    63787,     63923,     63922,      45698,      315520447,
    629901697,  45697,     63923,     45698,      63923,      63788,
    63923,      63788,     63923,     63922,      63923,      63922,
    63923,      45698,     63923,     328095563,  26289563,   45563,
    63923,      13732537,  1157287,   63787,      63923,      315520447,
    629901697,  45697,     63923,     629901698,  45698,      63788,
    629901563,  45563,     63923,     26307788,   63788,      45698,
    26289563,   45563,     63923,     26307788,   63788,      63922,
    26307787,   63787,     63923,     1157422,    63922,      63788,
    1157287,    63787,     63923,     1157422,    63922,      45698,
    1139197,    45697,     63923,     629901698,  45698,      63922,
    629901697,  45697,     63923,     13185788,   629901563,  45563,
    63923,      314973698, 26289563,  45563,      63923,      610672,
    26307787,   63787,     63923,     13185788,   1157287,    63787,
    63923,      314973698, 1139197,   45697,      63923,      610672,
    629901697,  45697,     63923,     314973698,  45563,      63923,
    13185788,   45563,     63923,     13185788,   63787,      63923,
    610672,     63787,     63923,     610672,     45697,      63923,
    314973698,  45697,     63923,     45563,      63923,      45563,
    63923,      63787,     63923,     63787,      63923,      45697,
    63923,      45697,     63923,     63788,      45698,      328095563,
    45563,      63923,     63922,     63788,      13732537,   63787,
    63923,      45698,     63922,     315520447,  45697,      63923,
    45563,      63923,     63787,     63923,      45697,      63923,
    45698,      63788,     26289563,  45563,      63923,      63788,
    63922,      1157287,   63787,     63923,      63922,      45698,
    629901697,  45697,     63923,     26289563,   45563,      63923,
    1157287,    63787,     63923,     629901697,  45697,      63923,
    314973698,  45563,     63923,     13185788,   45563,      63923,
    13185788,   63787,     63923,     610672,     63787,      63923,
    610672,     45697,     63923,     314973698,  45697,      63923,
    1157422,    63922,     26307788,  63788,      629901698,  45698,
    656145563,  629901563, 26289563,  45563,      630995197,  629901697,
    1139197,    45697,     27401287,  26307787,   1157287,    63787,
    657239062,  27383062,  656145562, 26289562,   630995062,  1139062,
    629901562,  45562,     63923,     26289563,   45563,      629901697,
    45697,      1157287,   63787,     985835812,  328642312,  26289562,
    1139062,    629901562, 45562,     63923,      354339563,  328095563,
    945376447,  315520447, 14826037,  13732537,   45562,      657239062,
    354886312,  329735812, 958498312, 328642312,  63923,      63922,
    629901563,  26289563,  656145563, 45563,      630448447,  592447,
    26854537,   610537,    656692312, 26836312,   630448312,  592312,
    629901562,  26289562,  656145562, 45562,      63923,      45698,
    26307787,   1157287,   27401287,  63787,      341217563,  314973563,
    316067197,  314973697, 342311062, 316067062,  341217562,  314973562,
    26289562,   1139062,   27383062,  45562,      63923,      63788,
    1139197,    629901697, 630995197, 45697,      14279287,   13185787,
    643023563,  13167563,  644117062, 643023562,  14261062,   13167562,
    1139062,    629901562, 630995062, 45562,      63923,      26289563,
    45563,      1139197,   45697,     1157287,    63787,      329189062,
    328095562,  1139062,   630995062, 629901562,  45562,      63923,
    354339563,  328095563, 316067197, 314973697,  14279287,   13185787,
    1139062,    45562,     329189062, 959045062,  957951562,  328095562,
    63923,      1157287,   63787,     629901563,  45563,      629901697,
    45697,      643570312, 13714312,  629901562,  656145562,  26289562,
    45562,      63923,     14826037,  13732537,   643023563,  13167563,
    630448447,  592447,    629901562, 45562,      643570312,  669814312,
    39958312,   13714312,  63923,     629901697,  45697,      26307787,
    63787,      26289563,  45563,     341764312,  315520312,  26289562,
    27383062,   1139062,   45562,     63923,      945376447,  315520447,
    26854537,   610537,    341217563, 314973563,  26289562,   45562,
    341764312,  342857812, 316613812, 315520312,  63923,      314973698,
    26307788,   63788,     1139197,   45697,      341217563,  314973563,
    27383062,   1139062,   26289562,  45562,      63923,      13185788,
    629901698,  45698,     1157287,   63787,      643023563,  13167563,
    630995062,  1139062,   629901562, 45562,      63923,      13185788,
    1157422,    63922,     629901563, 45563,      14279287,   13185787,
    630995062,  629901562, 1139062,   45562,      63923,      610672,
    26307788,   63788,     629901697, 45697,      26854537,   610537,
    656145562,  629901562, 26289562,  45562,      63923,      610672,
    629901698,  45698,     26307787,  63787,      630448447,  592447,
    656145562,  26289562,  629901562, 45562,      63923,      314973698,
    1157422,    63922,     26289563,  45563,      316067197,  314973697,
    27383062,   26289562,  1139062,   45562,      63923,      13732537,
    314973563,  1139062,   45562,     63923,      316613947,  13167563,
    1139062,    45562,     63923,     315520447,  13185787,   629901562,
    45562,      63923,     957951563, 610537,     629901562,  45562,
    63923,      328095563, 592447,    26289562,   45562,      63923,
    39976537,   314973697, 26289562,  45562,      63923,      45698,
    315520447,  26307787,  63787,     26289562,   656145562,  629901562,
    45562,      63923,     63788,     14826037,   629901697,  45697,
    629901562,  656145562, 26289562,  45562,      63923,      63788,
    328095563,  1139197,   45697,     1139062,    27383062,   26289562,
    45562,      63923,     63922,     945376447,  26289563,   45563,
    26289562,   27383062,  1139062,   45562,      63923,      63922,
    13732537,   629901563, 45563,     629901562,  630995062,  1139062,
    45562,      63923,     45698,     354339563,  1157287,    63787,
    1139062,    630995062, 629901562, 45562,      63923,      341217563,
    314973563,  592447,    26289562,  45562,      63923,      643023563,
    13167563,   1704037,   629901562, 45562,      63923,      14279287,
    13185787,   314973563, 1139062,   45562,      63923,      26854537,
    610537,     944829697, 26289562,  45562,      63923,      630448447,
    592447,     13185787,  629901562, 45562,      63923,      316067197,
    314973697,  39411563,  1139062,   45562,      63923,      1157422,
    63922,      26289563,  45563,     27383062,   26289562,   1139062,
    45562,      63923,     629901698, 45698,      1157287,    63787,
    630995062,  1139062,   629901562, 45562,      63923,      26307788,
    63788,      629901697, 45697,     656145562,  629901562,  26289562,
    45562,      63923,     354339563, 328095563,  1139062,    45562,
    63923,      14826037,  13732537,  629901562,  45562,      63923,
    945376447,  315520447, 26289562,  45562,      63923,      610672,
    13185787,   629901562, 45562,     63923,      1704172,    314973697,
    26289562,   45562,     63923,     314973698,  592447,     26289562,
    45562,      63923,     944829698, 13167563,   1139062,    45562,
    63923,      13185788,  314973563, 1139062,    45562,      63923,
    39429788,   610537,    629901562, 45562,      63923,      63922,
    26289563,   45563,     27383062,  26289562,   1139062,    45562,
    63923,      45698,     1157287,   63787,      630995062,  1139062,
    629901562,  45562,     63923,     63788,      629901697,  45697,
    656145562,  629901562, 26289562,  45562,      63923,      63788,
    45698,      329189062, 328095562, 26289563,   45563,      63923,
    13185788,   314973698, 1139062,   45562,      354339563,  328095563,
    63923,      63922,     63788,     643570312,  13714312,   1157287,
    63787,      63923,     610672,    13185788,   629901562,  45562,
    14826037,   13732537,  63923,     45698,      63922,      341764312,
    315520312,  629901697, 45697,     63923,      314973698,  610672,
    26289562,   45562,     945376447, 315520447,  63923,      592447,
    26289562,   45562,     63923,     1704037,    629901562,  45562,
    63923,      314973563, 1139062,   45562,      63923,      944829697,
    26289562,   45562,     63923,     13185787,   629901562,  45562,
    63923,      39411563,  1139062,   45562,      63923,      1139062,
    45562,      63923,     1139062,   45562,      63923,      13185788,
    1139062,    45562,     63923,     314973698,  1139062,    45562,
    63923,      610672,    629901562, 45562,      63923,      13185788,
    629901562,  45562,     63923,     314973698,  26289562,   45562,
    63923,      610672,    26289562,  45562,      63923,      610672,
    45698,      63787,     328095562, 592447,     26289562,   45562,
    63923,      1704172,   63788,     45697,      328095562,  1704037,
    629901562,  45562,     63923,     314973698,  63788,      45697,
    13714312,   314973563, 1139062,   45562,      63923,      944829698,
    63922,      45563,     13714312,  944829697,  26289562,   45562,
    63923,      13185788,  63922,     45563,      315520312,  13185787,
    629901562,  45562,     63923,     39429788,   45698,      63787,
    315520312,  39411563,  1139062,   45562,      63923,      45698,
    315520447,  63787,     328095562, 629901562,  45562,      63923,
    63788,      14826037,  45697,     328095562,  26289562,   45562,
    63923,      63788,     328095563, 45697,      13714312,   26289562,
    45562,      63923,     63922,     945376447,  45563,      13714312,
    1139062,    45562,     63923,     63922,      13732537,   45563,
    315520312,  1139062,   45562,     63923,      45698,      354339563,
    63787,      315520312, 629901562, 45562,      63923,      1157422,
    63922,      63788,     45698,     328095563,  26289563,   45563,
    1139197,    45697,     1157287,   63787,      329189062,  328095562,
    1139062,    630995062, 629901562, 45562,      63923,      629901698,
    45698,      63922,     63788,     13732537,   1157287,    63787,
    629901563,  45563,     629901697, 45697,      643570312,  13714312,
    629901562,  656145562, 26289562,  45562,      63923,      26307788,
    63788,      45698,     63922,     315520447,  629901697,  45697,
    26307787,   63787,     26289563,  45563,      341764312,  315520312,
    26289562,   27383062,  1139062,   45562,      63923,      63922,
    328095563,  26289563,  45563,     592447,     610537,     354339562,
    328095562,  26289562,  45562,     26836312,   592312,     63923,
    45698,      13732537,  1157287,   63787,      314973563,  314973697,
    14807812,   13714312,  1139062,   45562,      316067062,  314973562,
    63923,      63788,     315520447, 629901697,  45697,      13185787,
    13167563,   945376312, 315520312, 629901562,  45562,      643023562,
    13167562,   63923,     13185788,  45698,      314973563,  316067197,
    314973697,  1157287,   63787,     13167563,   329189062,  328095562,
    1139062,    45562,     316067062, 314973562,  63923,      314973698,
    63788,      13167563,  14279287,  13185787,   1139197,    45697,
    314973563,  329189062, 328095562, 1139062,    45562,      14261062,
    13167562,   63923,     610672,    63788,      13185787,   643023563,
    13167563,   629901697, 45697,     610537,     643570312,  13714312,
    629901562,  45562,     643023562, 13167562,   63923,      13185788,
    63922,      610537,    630448447, 592447,     629901563,  45563,
    13185787,   643570312, 13714312,  629901562,  45562,      630448312,
    592312,     63923,     314973698, 63922,      592447,     26854537,
    610537,     26289563,  45563,     314973697,  341764312,  315520312,
    26289562,   45562,     26836312,  592312,     63923,      610672,
    45698,      314973697, 341217563, 314973563,  26307787,   63787,
    592447,     341764312, 315520312, 26289562,   45562,      341217562,
    314973562,  63923,     328095563, 45563,      45697,      63787,
    13714312,   315520312, 1139062,   45562,      63923,      314973563,
    13167563,   592447,    13732537,  45562,      354339562,  14807812,
    13714312,   63923,     328095563, 45563,      63787,      45697,
    316613812,  14807812,  1139062,   45562,      63923,      13167563,
    314973563,  1704037,   316613947, 45562,      957951562,  315520312,
    316613812,  63923,     13732537,  63787,      45563,      45697,
    315520312,  328095562, 629901562, 45562,      63923,      13185787,
    610537,     314973563, 315520447, 45562,      14807812,   945376312,
    315520312,  63923,     13732537,  63787,      45697,      45563,
    957951562,  945376312, 629901562, 45562,      63923,      610537,
    13185787,   944829697, 957951563, 45562,      39958312,   328095562,
    957951562,  63923,     315520447, 45697,      63787,      45563,
    328095562,  13714312,  26289562,  45562,      63923,      592447,
    314973697,  13185787,  328095563, 45562,      945376312,  354339562,
    328095562,  63923,     315520447, 45697,      45563,      63787,
    39958312,   354339562, 26289562,  45562,      63923,      314973697,
    592447,     39411563,  39976537,  45562,      316613812,  13714312,
    39958312,   63923,     63922,     63788,      45698,      13732537,
    315520447,  328095563, 45563,     45697,      63787,      328642312,
    328095562,  315520312, 13714312,  1139062,    45562,      63923,
    45563,      45697,     63787,     821537437,  164343937,  1139062,
    45562,      63923,     164070563, 157783072,  6898162,    657239062,
    45562,      165437437, 164343937, 63923,      63922,      63788,
    45698,      328642312, 629901563, 45563,      1139197,    45697,
    26307787,   63787,     630995062, 656145562,  27383062,   45562,
    63923,      63922,     26289563,  45563,      592447,     610537,
    328642312,  629901562, 45562,     630448312,  592312,     63923,
    45698,      1157287,   63787,     314973563,  314973697,  328642312,
    26289562,   45562,     341217562, 314973562,  63923,      63788,
    629901697,  45697,     13185787,  13167563,   328642312,  1139062,
    45562,      14261062,  13167562,  63923,      13167563,   314973697,
    610537,     328642312, 45562,     63923,      314973563,  13185787,
    1685947,    329735812, 45562,     63923,      13185788,   45698,
    315520447,  63787,     13167563,  329735812,  328642312,  1139062,
    45562,      63923,     314973698, 63788,      14826037,   45697,
    314973563,  328642312, 329735812, 1139062,    45562,      63923,
    610672,     63788,     328095563, 45697,      610537,     958498312,
    328642312,  629901562, 45562,     63923,      13185788,   63922,
    945376447,  45563,     13185787,  328642312,  958498312,  629901562,
    45562,      63923,     314973698, 63922,      13732537,   45563,
    314973697,  354886312, 328642312, 26289562,   45562,      63923,
    610672,     45698,     354339563, 63787,      592447,     328642312,
    354886312,  26289562,  45562,     63923,      26289563,   656145563,
    45563,      63923,     63923,     26289563,   656145563,  45563,
    63923,      63923,     26289563,  45563,      63923,      45563,
    63923,      26289563,  656145563, 45563,      657239062,  656145562,
    1139062,    45562,     63923,     26289563,   45563,      27929812,
    26836312,   1139062,   45562,     63923,      1157422,    63922,
    26289563,   656145563, 45563,     27383062,   26289562,   657239062,
    656145562,  1139062,   45562,     63923,      63922,      26289563,
    656145563,  45563,     656692312, 592312,     27383062,   26289562,
    656145562,  45562,     63923,     45563,      329189062,  328095562,
    26289563,   1139062,   45562,     63923,      354339563,  1139062,
    45562,      328095563, 355433062, 354339562,  63923,      45563,
    26289563,   329735812, 328642312, 1139062,    45562,      63923,
    328095563,  957951563, 1139062,   45562,      329735812,  328642312,
    63923,      63922,     26289563,  328642312,  45563,      26836312,
    26289562,   1139062,   45562,     63923,      45563,      14534437,
    13440937,   1139062,   45562,     63923,      13167563,   1139062,
    45562,      14534437,  13440937,  63923,      26307787,   1157287,
    27401287,   63787,     1157692,   64192,      26289563,   656145563,
    45563,      630995062, 629901562, 657239062,  656145562,  1139062,
    45562,      63923,     1157692,   64192,      45563,      26289563,
    1139062,    45562,     63923,     884317,     629901697,  45697,
    63923,      64192,     63923,     1704442,    610942,     26307787,
    1157287,    27401287,  63787,     26289563,   656145563,  45563,
    656692312,  592312,    27383062,  26289562,   656145562,  45562,
    63923,      1157692,   64192,     26289563,   45563,      1139062,
    45562,      63923,     1431067,   629901697,  45697,      63923,
    64192,      63923,     26854942,  1157287,    63787,      64192,
    26289563,   45563,     26836312,  26289562,   1139062,    45562,
    63923,      13459162,  63382,     64192,      45563,      1139062,
    45562,      63923,     26307788,  63788,      64193,      629901563,
    656145563,  45563,     63923,     26308193,   629901563,  45563,
    63923,      64193,     26289563,  656145563,  45563,      63923,
    64193,      26289563,  45563,     63923,      26289563,   656145563,
    45563,      63923,     26289563,  45563,      63923,      26307788,
    63788,      26289563,  656145563, 45563,      63923,      26289563,
    45563,      63923,     63788,     64193,      26289563,   45563,
    63923,      26308193,  629901563, 45563,      63923,      45698,
    45563,      63923,     45563,     63923,      64193,      26289563,
    26307787,   1157287,   27401287,  63787,      656145563,  45563,
    630995062,  629901562, 656145562, 1139062,    657239062,  45562,
    63923,      26289563,  656145563, 45563,      592447,     26854537,
    630448447,  610537,    656145562, 45562,      26836312,   656692312,
    630448312,  592312,    63923,     26308193,   45563,      26289563,
    1139062,    45562,     63923,     26289563,   45563,      1139062,
    45562,      63923,     26307788,  63788,      1157692,    64192,
    26289563,   656145563, 45563,     1139062,    657239062,  656145562,
    45562,      63923,     26289563,  656145563,  45563,      1704442,
    610942,     656145562, 45562,     656692312,  592312,     63923,
    27401692,   26308192,  26289563,  45563,      27383062,   26289562,
    1139062,    45562,     63923,     26289563,   26854942,   26854132,
    45563,      27929812,  26836312,  1139062,    45562,      63923,
    63788,      26854942,  64192,     26289563,   45563,      27929812,
    26836312,   1139062,   45562,     63923,      26308192,   26289563,
    45563,      610942,    26289562,  26836312,   45562,      592312,
    63923,      64193,     26289563,  1157287,    63787,      45563,
    26836312,   26289562,  1139062,   45562,      63923,      13459162,
    45563,      1139062,   45562,     63923,      26307788,   63788,
    64193,      1157422,   63922,     27401287,   26307787,   1157287,
    63787,      1157692,   64192,     26289563,   656145563,  45563,
    26289562,   27383062,  657239062, 656145562,  1139062,    45562,
    63923,      63922,     26854537,  610537,     610942,     26289563,
    656145563,  45563,     26836312,  26289562,   656145562,  656692312,
    45562,      592312,    63923,     26308193,   1157287,    63787,
    1157692,    64192,     26289563,  45563,      329189062,  328095562,
    27383062,   26289562,  1139062,   45562,      63923,      63383,
    14279287,   13185787,  1157692,   64192,      957951563,  328095563,
    1139062,    45562,     959045062, 957951562,  329189062,  328095562,
    63923,      1157287,   63787,     64192,      629901563,  328642312,
    45563,      630448312, 629901562, 1139062,    45562,      63923,
    39976537,   13732537,  610942,    354339563,  45562,      328095563,
    354339562,  355979812, 329735812, 328642312,  63923,      26308193,
    1157422,    63922,     27401692,  26308192,   26289563,   45563,
    26289562,   27383062,  1139062,   45562,      63923,      63922,
    26854942,   26289563,  45563,     26836312,   26289562,   1139062,
    45562,      63923,     26308193,  45698,      1157692,    64192,
    45563,      329189062, 328095562, 26289563,   1139062,    45562,
    63923,      64193,     314973698, 1156882,    63382,      957951563,
    1139062,    45562,     328095563, 959045062,  957951562,  63923,
    610942,     45563,     328095562, 26289563,   45562,      592312,
    63923,      610132,    957951563, 45562,      328095563,  957951562,
    958498312,  63923,     63922,     629901698,  45698,      610942,
    26307787,   1157287,   27401287,  63787,      26289563,   656145563,
    45563,      656692312, 592312,    27383062,   26289562,   656145562,
    45562,      63923,     64193,     63922,      26854537,   610537,
    26289563,   1157692,   64192,     656145563,  45563,      26289562,
    26836312,   656692312, 656145562, 592312,     45562,      63923,
    26308192,   1704037,   610537,    45563,      26289563,   328642312,
    45562,      26289562,  592312,    26836312,   63923,      610942,
    14279287,   13185787,  957951563, 328095563,  45562,      959591812,
    328642312,  957951562, 328095562, 63923,      64193,      27948442,
    26854942,   1157287,   63787,     26289563,   45563,      985835812,
    328642312,  26836312,  26289562,  1139062,    45562,      63923,
    63383,      1157692,   64192,     13732537,   14826037,   328095563,
    957951563,  45562,     1139062,   328095562,  328642312,  958498312,
    354886312,  63923,     63922,     26854942,   26289563,   45563,
    26836312,   26289562,  592312,    45562,      63923,      64193,
    63922,      26289563,  63382,     64192,      45563,      26836312,
    26289562,   1139062,   45562,     63923,      45698,      64192,
    328642312,  26289563,  45563,     1139062,    45562,      63923,
    314973698,  610132,    45562,     328095563,  957951563,  958498312,
    959591812,  63923,     26308193,  1704442,    610942,     45563,
    26289563,   329735812, 328642312, 45562,      592312,     63923,
    64193,      63382,     1156882,   957951563,  328095563,  45562,
    1139062,    959591812, 957951562, 63923,      45698,      64193,
    63922,      26854942,  26307787,  63787,      64192,      26289563,
    328642312,  45563,     26836312,  26289562,   1139062,    45562,
    63923,      26308193,  63922,     610537,     610942,     26308192,
    26289563,   45563,     328642312, 26289562,   45562,      26836312,
    592312,     63923,     45698,     64192,      13459162,   45563,
    14534437,   13440937,  1139062,   45562,      63923,      45698,
    15099817,   63787,     13167563,  1139062,    45562,      13987687,
    39684937,   63923,     610942,    315247072,  45563,      13440937,
    592312,     45562,     63923,     13459567,   610537,     13167563,
    45562,      13440937,  13987687,  63923,      857349563,  454941563,
    45563,      63923,     63923,     63923,      45563,      63923,
    64201,      63923,     630995062, 629901562,  454941563,  45563,
    1139062,    45562,     63923,     629901562,  630995062,  45563,
    1139062,    45562,     63923,     27383062,   629901562,  64201,
    657239062,  45562,     63923,     1156882,    63382,      857349563,
    454941563,  45563,     858443062, 857349562,  456035062,  454941562,
    1139062,    45562,     63923,     1157287,    63787,      454941563,
    45563,      1139062,   45562,     63923,      1885882,    792382,
    63923,      1886287,   792787,    63923,      427882,     1521382,
    63923,      428287,    1521787,   63923,      1157287,    63787,
    45563,      1139062,   45562,     63923,      629901694,  45694,
    64201,      657239062, 45562,     63923,      63383,      857349563,
    454941563,  45563,     63923,     63788,      454941563,  45563,
    63923,      857349563, 454941563, 45563,      63923,      454941563,
    45563,      63923,     63383,     45563,      63923,      64193,
    64201,      63923,     45563,     63923,      64201,      63923,
    63788,      1156882,   63382,     454941563,  630995062,  629901562,
    45563,      456035062, 454941562, 1139062,    45562,      63923,
    610132,     629901562, 454941563, 45563,      857896312,  455488312,
    45562,      592312,    63923,     63383,      1157287,    63787,
    630995062,  629901562, 454941563, 45563,      1139062,    45562,
    63923,      610537,    629901562, 454941563,  45563,      45562,
    592312,     63923,     63383,     1157287,    63787,      629901562,
    630995062,  45563,     1139062,   45562,      63923,      64193,
    1156882,    63382,     27383062,  629901562,  64201,      657239062,
    45562,      63923,     610537,    629901562,  45563,      45562,
    592312,     63923,     26854132,  629901562,  64201,      45562,
    328642312,  63923,     629901563, 454941563,  45563,      63923,
    63923,      63923,     656145563, 45563,      63923,      656145563,
    45563,      63923,     454941563, 45563,      63923,      1157422,
    63922,      857349563, 454941563, 45563,      858443062,  857349562,
    456035062,  454941562, 1139062,   45562,      63923,      1157422,
    63922,      629901563, 454941563, 630995062,  629901562,  45563,
    456035062,  454941562, 1139062,   45562,      63923,      610672,
    629901562,  454941563, 45563,     857896312,  455488312,  45562,
    592312,     63923,     1156882,   63382,      1157287,    63787,
    629901563,  454941563, 630995062, 629901562,  45563,      456035062,
    454941562,  1139062,   45562,     63923,      611347,     63787,
    63923,      1704847,   63787,     63923,      1158097,    64597,
    1157287,    63787,     629901563, 45563,      630995062,  629901562,
    1139062,    45562,     63923,     1158097,    64597,      1157287,
    63787,      629901563, 45563,     630995062,  629901562,  1139062,
    45562,      63923,     611347,    63787,      454941563,  45563,
    456581812,  455488312, 592312,    45562,      63923,      63383,
    63788,      629901563, 454941563, 45563,      63923,      629901563,
    454941563,  45563,     63923,     63788,      454941563,  45563,
    63923,      63383,     454941563, 45563,      63923,      63383,
    1157422,    63922,     1156882,   63382,      857349563,  454941563,
    45563,      858443062, 857349562, 456035062,  454941562,  1139062,
    45562,      63923,     610672,    63382,      857349563,  454941563,
    45563,      857896312, 857349562, 455488312,  454941562,  592312,
    45562,      63923,     1157422,   63922,      63788,      454941563,
    1157287,    63787,     45563,     456035062,  454941562,  1139062,
    45562,      63923,     610672,    63787,      454941563,  45563,
    857896312,  455488312, 592312,    45562,      63923,      1157422,
    63922,      64598,     63788,     1158097,    64597,      1157287,
    63787,      629901563, 454941563, 630995062,  629901562,  45563,
    456035062,  454941562, 1139062,   45562,      63923,      63922,
    611347,     610537,    629901563, 454941563,  629901562,  630448312,
    45563,      454941562, 455488312, 45562,      592312,     63923,
    63788,      610672,    64597,     454941563,  610537,     629901562,
    45563,      454941562, 455488312, 45562,      592312,     63923,
    64598,      610672,    63787,     611347,     629901562,  454941563,
    45563,      456581812, 455488312, 592312,     45562,      63923,
    27401287,   26307787,  1157287,   63787,      64201,      629901562,
    27383062,   657239062, 45562,     63923,      13732537,   63787,
    64201,      985835812, 328642312, 657239062,  45562,      63923,
    26307787,   63787,     64201,     27383062,   45562,      63923,
    64201,      63923,     610537,    64201,      63923,      629901698,
    45698,      64201,     27401287,  26307787,   1157287,    63787,
    629901562,  27383062,  657239062, 45562,      63923,      26307787,
    63787,      64201,     27383062,  985835812,  328642312,  45562,
    63923,      39976537,  13732537,  64201,      355979812,  657239062,
    45562,      328642312, 63923,     45698,      13732537,   64201,
    63787,      13714312,  328642312, 657239062,  45562,      63923,
    63787,      64201,     821537437, 164343937,  657239062,  45562,
    63923,      6898162,   64201,     657239062,  45562,      821537437,
    164343937,  63923,     45698,     64201,      1157287,    63787,
    328642312,  27383062,  45562,     63923,      64201,      657239062,
    45562,      63923,     610537,    64201,      328642312,  45562,
    63923,      629901700, 45700,     26307787,   64201,      27401287,
    63787,      629901562, 27383062,  657239062,  45562,      63923,
    316067200,  316067194, 26307787,  1157287,    63787,      64201,
    341217562,  316067062, 27383062,  985835812,  328642312,  45562,
    63923,      13732537,  629901700, 45700,      64201,      63787,
    13714312,   328642312, 657239062, 45562,      63923,      158056444,
    63787,      64201,     821537437, 164343937,  657239062,  45562,
    63923,      316067194, 45700,     26307787,   64201,      63787,
    341217562,  328642312, 27383062,  45562,      63923,      158056444,
    64201,      821537437, 164343937, 63923,      158056450,  64201,
    1150134187, 492940687, 63923,     158056444,  158056450,  610537,
    64201,      787912312, 158056312, 1150134187, 164343937,  63923,
    64193,      26307787,  27401287,  63787,      64201,      629901562,
    27383062,   657239062, 45562,     63923,      64193,      13732537,
    63787,      64201,     985835812, 328642312,  657239062,  45562,
    63923,      64193,     26307787,  63787,      341217562,  64201,
    27383062,   45562,     63923,     1157287,    26307787,   63787,
    64201,      316067062, 341217562, 27383062,   45562,      63923,
    13732537,   63787,     64201,     314973562,  13714312,   328642312,
    45562,      63923,     610537,    64201,      1102840312, 472984312,
    63923,      64193,     629901698, 45698,      629901700,  45700,
    26307787,   64201,     27401287,  63787,      629901562,  27383062,
    657239062,  45562,     63923,     45700,      1157287,    64201,
    63787,      316067062, 328642312, 27383062,   45562,      63923,
    314973700,  39976537,  64201,     13732537,   39958312,   45562,
    958498312,  328642312, 63923,     45698,      316067200,  64201,
    26307787,   1157287,   63787,     328642312,  341217562,  316067062,
    27383062,   45562,     63923,     64193,      316067200,  316067194,
    1157287,    63787,     316067062, 64201,      27383062,   985835812,
    328642312,  45562,     63923,     64193,      629901694,  630995200,
    14826037,   13732537,  644663812, 64201,      355979812,  657239062,
    45562,      328642312, 63923,     64193,      45698,      629901700,
    45700,      13732537,  64201,     63787,      13714312,   328642312,
    657239062,  45562,     63923,     45698,      314973700,  64201,
    13732537,   63787,     13714312,  314973562,  45562,      328642312,
    63923,      158056444, 64193,     63787,      64201,      821537437,
    164343937,  657239062, 45562,     63923,      45694,      64193,
    6898162,    64201,     657239062, 45562,      492940687,  164343937,
    63923,      158056444, 63787,     64201,      314973562,  492940687,
    164343937,  45562,     63923,     314973694,  6898162,    64201,
    1109127937, 45562,     328642312, 164343937,  63923,      64193,
    45698,      316067194, 45700,     1157287,    64201,      63787,
    316067062,  328642312, 27383062,  45562,      63923,      158056444,
    610537,     64201,     472984312, 158056312,  164343937,  45562,
    63923,      63923,     656145562, 629901562,  26289562,   45562,
    63923,      656145563, 629901563, 26289563,   45563,      63923,
    63922,      63923,     63923,     63923,      63923,      63922,
    656145563,  629901563, 26289563,  45563,      656145562,  26289562,
    629901562,  45562,     63923,     341217563,  314973563,  26289562,
    45562,      63923,     354339563, 984195563,  629901562,  45562,
    63923,      669267563, 13167563,  656145562,  45562,      63923,
    26307787,   63787,     63923,     629901697,  45697,      63923,
    63923,      63923,     63787,     63923,      45697,      63923,
    629901698,  45698,     63923,     26307788,   63788,      63923,
    63923,      63923,     45698,     63923,      63788,      63923,
    629901698,  45698,     26307787,  63787,      656145562,  26289562,
    629901562,  45562,     63923,     26307788,   63788,      629901697,
    45697,      656145562, 629901562, 26289562,   45562,      63923,
    314973698,  26289562,  45562,     63923,      39429788,   629901562,
    45562,      63923,     13185787,  629901562,  45562,      63923,
    314973697,  26289562,  45562,     63923,      26289562,   45562,
    63923,      629901562, 45562,     63923,      45698,      63787,
    328095562,  629901562, 45562,     63923,      63788,      45697,
    354339562,  26289562,  45562,     63923,      656145563,  26289563,
    629901563,  45563,     629901697, 45697,      26307787,   63787,
    656145562,  26289562,  629901562, 45562,      63923,      314973697,
    26289563,   45563,     63923,     39429787,   629901563,  45563,
    63923,      26289563,  45563,     63923,      328095563,  26289563,
    45563,      45697,     63787,     26289562,   45562,      63923,
    629901698,  45698,     26307788,  63788,      656145563,  629901563,
    26289563,   45563,     63923,     314973698,  26289563,   45563,
    63923,      39429788,  629901563, 45563,      63923,      26289563,
    45563,      63923,     45698,     63788,      328095563,  26289563,
    45563,      63923,     63922,     629901698,  45698,      629901697,
    45697,      63923,     63922,     26307788,   63788,      26307787,
    63787,      63923,     629901698, 45698,      63923,      26307788,
    63788,      63923,     63922,     63923,      63922,      63923,
    629901697,  45697,     63923,     26307787,   63787,      63923,
    314973698,  45697,     63923,     39429788,   63787,      63923,
    45698,      63923,     63788,     63923,      63923,      63923,
    45697,      63923,     63787,     63923,      63922,      45698,
    45697,      63923,     63922,     63788,      63787,      63923,
    314973698,  45697,     63923,     39429788,   63787,      63923,
    63922,      26307788,  63788,     629901698,  45698,      656145563,
    629901563,  26289563,  45563,     629901697,  45697,      26307787,
    63787,      656145562, 26289562,  629901562,  45562,      63923,
    45698,      26307787,  63787,     341217563,  314973563,  314973697,
    341217562,  314973562, 26289562,  45562,      63923,      63788,
    629901697,  45697,     669267563, 39411563,   39429787,   669267562,
    39411562,   629901562, 45562,     63923,      354339563,  328095563,
    314973697,  13185787,  45562,     957951562,  328095562,  63923,
    314973698,  63922,     26289563,  45563,      314973697,  26289562,
    45562,      63923,     39429788,  63922,      629901563,  45563,
    39429787,   629901562, 45562,     63923,      314973698,  26307788,
    63788,      45697,     341217563, 314973563,  26289562,   45562,
    63923,      39429788,  629901698, 45698,      63787,      669267563,
    39411563,   629901562, 45562,     63923,      45698,      328095563,
    63787,      629901562, 45562,     63923,      63788,      354339563,
    45697,      26289562,  45562,     63923,      13185787,   314973563,
    45562,      63923,     314973697, 39411563,   45562,      63923,
    63922,      26289563,  45563,     26289562,   45562,      63923,
    13185788,   314973563, 45562,     63923,      314973698,  39411563,
    45562,      63923,     13185788,  314973698,  45562,      354339563,
    328095563,  63923,     63922,     63788,      45698,      328095563,
    26289563,   45563,     45697,     63787,      328095562,  629901562,
    45562,      63923,     13185788,  45698,      314973563,  314973697,
    63787,      13167563,  328095562, 45562,      314973562,  63923,
    26289563,   656145563, 45563,     63923,      26289563,   656145563,
    45563,      656145562, 45562,     63923,      63922,      26289563,
    656145563,  45563,     26289562,  656145562,  45562,      63923,
    629901563,  328095562, 656145563, 629901562,  63923,      354339563,
    45562,      328095563, 354339562, 63923,      26307787,   63787,
    64192,      26289563,  656145563, 45563,      629901562,  656145562,
    45562,      63923,     26308192,  26289563,   45563,      26289562,
    63923,      26307788,  63788,     64193,      629901563,  656145563,
    45563,      63923,     26308193,  629901563,  45563,      63923,
    64193,      26289563,  26307787,  63787,      656145563,  45563,
    629901562,  656145562, 45562,     63923,      26308193,   45563,
    26289563,   45562,     63923,     26307788,   63788,      64192,
    26289563,   656145563, 45563,     656145562,  45562,      63923,
    26308192,   26289563,  45563,     26289562,   45562,      63923,
    26307788,   63788,     64193,     63922,      26307787,   63787,
    64192,      26289563,  656145563, 45563,      26289562,   656145562,
    45562,      63923,     26308193,  63787,      64192,      26289563,
    45563,      328095562, 26289562,  45562,      63923,      63383,
    13185787,   64192,     957951563, 328095563,  45562,      957951562,
    328095562,  63923,     26308193,  63922,      26308192,   26289563,
    45563,      26289562,  45562,     63923,      64193,      45698,
    26308192,   629901563, 328095562, 45563,      629901562,  63923,
    64193,      314973698, 63382,     957951563,  45562,      328095563,
    957951562,  63923,     857349563, 454941563,  45563,      63923,
    629901562,  454941563, 45563,     45562,      63923,      63382,
    857349563,  454941563, 45563,     857349562,  454941562,  45562,
    63923,      63787,     454941563, 45563,      45562,      63923,
    63383,      857349563, 454941563, 45563,      63923,      63788,
    454941563,  45563,     63923,     63788,      63382,      454941563,
    629901562,  45563,     454941562, 45562,      63923,      63383,
    63787,      629901562, 454941563, 45563,      45562,      63923,
    629901563,  454941563, 45563,     63923,      63922,      857349563,
    454941563,  45563,     857349562, 454941562,  45562,      63923,
    63922,      629901563, 454941563, 629901562,  45563,      454941562,
    45562,      63923,     63382,     63787,      629901563,  454941563,
    629901562,  45563,     454941562, 45562,      63923,      63383,
    63788,      629901563, 454941563, 45563,      63923,      63383,
    63922,      63382,     857349563, 454941563,  45563,      857349562,
    454941562,  45562,     63923,     63922,      63788,      454941563,
    63787,      45563,     454941562, 45562,      63923,      63922,
    64598,      63788,     64597,     63787,      629901563,  454941563,
    629901562,  45563,     454941562, 45562,
};

static const int multiplicities[] = {
    0,  1,  2,   1,   1,  1,  1,  1,  1,   1,  1,  2,  1,   1,  1,  1,  2,  1,
    1,  1,  1,   2,   1,  1,  1,  1,  2,   2,  2,  4,  2,   2,  4,  2,  2,  4,
    2,  2,  4,   2,   2,  4,  2,  2,  4,   2,  2,  4,  2,   2,  4,  2,  2,  4,
    2,  2,  2,   1,   1,  2,  1,  1,  2,   1,  1,  2,  2,   2,  2,  2,  2,  2,
    2,  2,  4,   2,   4,  2,  4,  2,  4,   2,  4,  2,  4,   2,  4,  2,  4,  2,
    4,  2,  4,   4,   4,  4,  4,  4,  4,   4,  4,  4,  4,   4,  4,  4,  4,  4,
    4,  4,  4,   2,   2,  2,  2,  2,  2,   1,  1,  1,  1,   1,  1,  1,  1,  4,
    2,  2,  2,   2,   2,  2,  1,  1,  1,   1,  1,  1,  1,   1,  4,  2,  2,  2,
    2,  2,  2,   1,   1,  1,  1,  1,  1,   1,  1,  4,  2,   2,  2,  2,  2,  4,
    2,  2,  2,   2,   2,  4,  2,  2,  2,   2,  2,  8,  4,   4,  4,  4,  4,  2,
    2,  2,  2,   8,   4,  4,  4,  4,  4,   2,  2,  2,  2,   8,  4,  4,  4,  4,
    4,  2,  2,   2,   2,  8,  4,  4,  4,   4,  4,  2,  2,   2,  2,  8,  4,  4,
    4,  4,  4,   2,   2,  2,  2,  8,  4,   4,  4,  4,  4,   2,  2,  2,  2,  8,
    4,  4,  4,   4,   4,  2,  2,  2,  2,   8,  4,  4,  4,   4,  4,  2,  2,  2,
    2,  8,  4,   4,   4,  4,  4,  2,  2,   2,  2,  4,  2,   2,  2,  2,  2,  2,
    4,  2,  2,   2,   2,  2,  2,  4,  2,   2,  2,  2,  2,   2,  4,  2,  2,  2,
    2,  2,  2,   4,   2,  2,  2,  2,  2,   2,  4,  2,  2,   2,  2,  2,  2,  4,
    2,  2,  2,   2,   2,  2,  4,  2,  2,   2,  2,  2,  2,   4,  2,  2,  2,  2,
    2,  2,  4,   2,   2,  2,  2,  4,  2,   2,  2,  2,  4,   2,  2,  2,  2,  4,
    2,  2,  2,   2,   4,  2,  2,  2,  2,   4,  2,  2,  2,   2,  4,  2,  2,  2,
    2,  4,  2,   2,   2,  2,  4,  2,  2,   2,  2,  8,  4,   4,  4,  4,  4,  8,
    4,  4,  4,   4,   4,  8,  4,  4,  4,   4,  4,  8,  4,   4,  4,  4,  4,  8,
    4,  4,  4,   4,   4,  8,  4,  4,  4,   4,  4,  8,  4,   4,  4,  4,  4,  8,
    4,  4,  4,   4,   4,  8,  4,  4,  4,   4,  4,  8,  4,   4,  4,  4,  4,  8,
    4,  4,  4,   4,   4,  8,  4,  4,  4,   4,  4,  8,  4,   4,  4,  4,  4,  8,
    4,  4,  4,   4,   4,  8,  4,  4,  4,   4,  4,  8,  4,   4,  4,  4,  4,  8,
    4,  4,  4,   4,   4,  8,  4,  4,  4,   4,  4,  4,  2,   2,  2,  2,  2,  2,
    2,  2,  2,   2,   2,  2,  1,  1,  1,   1,  1,  1,  1,   1,  4,  2,  2,  2,
    2,  4,  2,   2,   2,  2,  4,  2,  2,   2,  2,  4,  2,   2,  4,  2,  2,  4,
    2,  2,  4,   8,   4,  4,  8,  4,  4,   8,  4,  4,  8,   4,  4,  4,  4,  4,
    4,  4,  2,   2,   2,  2,  8,  4,  4,   4,  4,  4,  4,   4,  2,  2,  2,  2,
    8,  4,  4,   4,   4,  4,  4,  4,  2,   2,  2,  2,  16,  8,  8,  8,  8,  8,
    8,  4,  4,   4,   4,  8,  4,  4,  4,   4,  4,  4,  2,   2,  2,  2,  8,  4,
    4,  4,  4,   2,   2,  2,  2,  1,  1,   1,  1,  4,  2,   2,  2,  2,  1,  1,
    1,  1,  4,   2,   2,  2,  2,  1,  1,   1,  1,  4,  2,   2,  4,  2,  2,  4,
    2,  2,  4,   2,   2,  4,  2,  2,  4,   2,  2,  4,  2,   2,  2,  2,  4,  2,
    2,  2,  2,   4,   2,  2,  2,  2,  4,   2,  2,  2,  4,   2,  2,  2,  4,  2,
    2,  2,  4,   2,   2,  2,  4,  2,  2,   2,  4,  2,  2,   2,  4,  4,  4,  4,
    4,  4,  4,   2,   2,  4,  2,  2,  4,   2,  2,  4,  2,   2,  4,  2,  2,  4,
    2,  2,  4,   2,   4,  2,  4,  2,  4,   2,  4,  2,  4,   2,  4,  2,  2,  4,
    2,  2,  4,   2,   2,  4,  4,  4,  4,   4,  4,  4,  2,   2,  4,  2,  2,  4,
    2,  2,  8,   4,   4,  4,  2,  2,  8,   4,  4,  4,  2,   2,  8,  4,  4,  4,
    2,  2,  8,   4,   8,  4,  8,  4,  8,   4,  8,  4,  8,   4,  8,  4,  4,  4,
    8,  4,  4,   4,   8,  4,  4,  4,  8,   4,  4,  4,  2,   2,  8,  4,  4,  4,
    2,  2,  8,   4,   4,  4,  2,  2,  8,   4,  4,  4,  2,   2,  8,  4,  4,  4,
    2,  2,  8,   4,   4,  4,  2,  2,  8,   4,  4,  4,  8,   4,  4,  4,  8,  4,
    4,  4,  8,   4,   4,  4,  8,  4,  4,   4,  8,  4,  4,   4,  8,  4,  4,  8,
    4,  4,  8,   4,   4,  8,  4,  4,  8,   4,  4,  8,  4,   4,  8,  4,  8,  4,
    8,  4,  8,   4,   8,  4,  8,  4,  16,  8,  8,  8,  4,   16, 8,  8,  8,  4,
    16, 8,  8,   8,   4,  16, 8,  16, 8,   16, 8,  8,  4,   4,  2,  2,  8,  4,
    4,  2,  2,   8,   4,  4,  2,  2,  8,   4,  4,  8,  4,   4,  8,  4,  4,  8,
    4,  4,  8,   4,   4,  8,  4,  4,  8,   4,  4,  8,  4,   4,  8,  4,  4,  8,
    4,  4,  4,   4,   4,  4,  2,  2,  2,   2,  2,  2,  2,   2,  2,  2,  2,  2,
    1,  1,  1,   1,   1,  1,  1,  1,  8,   4,  4,  4,  4,   4,  4,  4,  4,  2,
    2,  2,  2,   8,   4,  4,  4,  4,  4,   4,  4,  4,  2,   2,  2,  2,  8,  4,
    4,  4,  4,   4,   4,  4,  4,  4,  2,   2,  2,  2,  2,   2,  2,  2,  8,  4,
    4,  4,  4,   4,   4,  4,  4,  4,  2,   2,  2,  2,  2,   2,  2,  2,  8,  4,
    4,  4,  4,   4,   4,  4,  4,  4,  2,   2,  2,  2,  2,   2,  2,  2,  8,  4,
    4,  4,  4,   4,   4,  4,  4,  2,  2,   2,  2,  8,  4,   4,  4,  4,  4,  4,
    4,  4,  2,   2,   2,  2,  8,  4,  4,   4,  4,  4,  4,   4,  4,  2,  2,  2,
    2,  8,  4,   4,   4,  4,  4,  4,  4,   4,  2,  2,  2,   2,  8,  4,  4,  4,
    4,  4,  4,   4,   4,  2,  2,  2,  2,   8,  4,  4,  4,   4,  4,  4,  4,  4,
    2,  2,  2,   2,   8,  4,  4,  4,  4,   4,  2,  2,  2,   2,  2,  2,  8,  4,
    4,  4,  4,   4,   2,  2,  2,  2,  2,   2,  8,  4,  4,   4,  4,  4,  2,  2,
    2,  2,  2,   2,   8,  4,  4,  4,  4,   4,  2,  2,  2,   2,  2,  2,  8,  4,
    4,  4,  4,   4,   2,  2,  2,  2,  2,   2,  8,  4,  4,   4,  4,  4,  2,  2,
    2,  2,  2,   2,   8,  4,  4,  4,  4,   8,  4,  4,  4,   4,  8,  4,  4,  4,
    4,  8,  4,   4,   4,  4,  8,  4,  4,   4,  4,  8,  4,   4,  4,  4,  8,  4,
    4,  4,  4,   2,   2,  2,  2,  8,  4,   4,  4,  4,  2,   2,  2,  2,  8,  4,
    4,  4,  4,   2,   2,  2,  2,  8,  4,   4,  4,  4,  2,   2,  2,  2,  8,  4,
    4,  4,  4,   2,   2,  2,  2,  8,  4,   4,  4,  4,  2,   2,  2,  2,  8,  4,
    4,  4,  4,   4,   8,  4,  4,  4,  4,   4,  8,  4,  4,   4,  4,  4,  8,  4,
    4,  4,  4,   4,   8,  4,  4,  4,  4,   4,  8,  4,  4,   4,  4,  4,  8,  4,
    4,  4,  4,   2,   2,  2,  2,  8,  4,   4,  4,  4,  2,   2,  2,  2,  8,  4,
    4,  4,  4,   2,   2,  2,  2,  8,  4,   4,  4,  4,  8,   4,  4,  4,  4,  8,
    4,  4,  4,   4,   8,  4,  4,  4,  4,   8,  4,  4,  4,   4,  8,  4,  4,  4,
    4,  8,  4,   4,   4,  4,  8,  4,  4,   4,  4,  8,  4,   4,  4,  4,  8,  4,
    4,  4,  2,   2,   2,  2,  8,  4,  4,   4,  2,  2,  2,   2,  8,  4,  4,  4,
    2,  2,  2,   2,   8,  4,  4,  4,  4,   2,  2,  8,  4,   4,  4,  4,  2,  2,
    8,  4,  4,   4,   4,  2,  2,  8,  4,   4,  4,  4,  2,   2,  8,  4,  4,  4,
    4,  2,  2,   8,   4,  4,  4,  4,  2,   2,  8,  4,  4,   4,  8,  4,  4,  4,
    8,  4,  4,   4,   8,  4,  4,  4,  8,   4,  4,  4,  8,   4,  4,  4,  8,  4,
    4,  8,  4,   4,   8,  4,  4,  4,  8,   4,  4,  4,  8,   4,  4,  4,  8,  4,
    4,  4,  8,   4,   4,  4,  8,  4,  4,   4,  16, 8,  8,   8,  8,  4,  4,  4,
    16, 8,  8,   8,   8,  4,  4,  4,  16,  8,  8,  8,  8,   4,  4,  4,  16, 8,
    8,  8,  8,   4,   4,  4,  16, 8,  8,   8,  8,  4,  4,   4,  16, 8,  8,  8,
    8,  4,  4,   4,   16, 8,  8,  8,  8,   4,  4,  16, 8,   8,  8,  8,  4,  4,
    16, 8,  8,   8,   8,  4,  4,  16, 8,   8,  8,  8,  4,   4,  16, 8,  8,  8,
    8,  4,  4,   16,  8,  8,  8,  8,  4,   4,  16, 8,  8,   8,  8,  8,  4,  4,
    4,  4,  4,   4,   4,  4,  2,  2,  2,   2,  16, 8,  8,   8,  8,  8,  4,  4,
    4,  4,  4,   4,   4,  4,  2,  2,  2,   2,  16, 8,  8,   8,  8,  8,  4,  4,
    4,  4,  4,   4,   4,  4,  2,  2,  2,   2,  16, 8,  8,   8,  8,  8,  8,  4,
    4,  4,  4,   4,   4,  16, 8,  8,  8,   8,  8,  8,  4,   4,  4,  4,  4,  4,
    16, 8,  8,   8,   8,  8,  8,  4,  4,   4,  4,  4,  4,   16, 8,  8,  8,  8,
    8,  8,  8,   4,   4,  4,  4,  4,  4,   4,  16, 8,  8,   8,  8,  8,  8,  8,
    4,  4,  4,   4,   4,  4,  4,  16, 8,   8,  8,  8,  8,   8,  8,  4,  4,  4,
    4,  4,  4,   4,   16, 8,  8,  8,  8,   8,  8,  8,  4,   4,  4,  4,  4,  4,
    4,  16, 8,   8,   8,  8,  8,  8,  8,   4,  4,  4,  4,   4,  4,  4,  16, 8,
    8,  8,  8,   8,   8,  8,  4,  4,  4,   4,  4,  4,  4,   16, 8,  8,  8,  8,
    8,  8,  4,   4,   16, 8,  8,  8,  8,   8,  8,  4,  4,   16, 8,  8,  8,  8,
    8,  8,  4,   4,   16, 8,  8,  8,  8,   8,  8,  4,  4,   16, 8,  8,  8,  8,
    8,  8,  4,   4,   16, 8,  8,  8,  8,   8,  8,  4,  4,   16, 8,  8,  8,  8,
    8,  8,  4,   4,   16, 8,  8,  8,  8,   8,  8,  4,  4,   16, 8,  8,  8,  8,
    8,  8,  4,   4,   16, 8,  8,  8,  8,   8,  8,  4,  4,   16, 8,  8,  8,  8,
    8,  8,  4,   4,   16, 8,  8,  8,  8,   8,  8,  4,  4,   32, 16, 16, 16, 16,
    16, 16, 8,   8,   8,  8,  8,  8,  8,   4,  4,  32, 16,  16, 16, 16, 16, 8,
    8,  32, 16,  16,  16, 16, 16, 8,  8,   16, 8,  8,  8,   8,  4,  4,  4,  4,
    4,  4,  2,   2,   2,  2,  16, 8,  8,   8,  8,  8,  8,   4,  4,  4,  4,  16,
    8,  8,  8,   8,   8,  8,  4,  4,  4,   4,  16, 8,  8,   8,  8,  8,  8,  4,
    4,  4,  4,   16,  8,  8,  8,  8,  8,   16, 8,  8,  8,   8,  8,  16, 8,  8,
    8,  8,  4,   4,   4,  4,  4,  16, 8,   8,  8,  8,  4,   4,  4,  4,  4,  16,
    8,  8,  8,   8,   4,  4,  4,  4,  4,   16, 8,  8,  8,   8,  4,  4,  4,  4,
    4,  16, 8,   8,   8,  8,  4,  4,  4,   4,  4,  16, 8,   8,  8,  8,  4,  4,
    4,  4,  4,   4,   2,  1,  1,  4,  4,   2,  2,  2,  4,   8,  4,  2,  8,  4,
    4,  2,  2,   2,   1,  1,  1,  1,  8,   4,  4,  2,  2,   2,  2,  8,  4,  4,
    4,  2,  2,   2,   2,  1,  1,  1,  1,   8,  4,  4,  4,   4,  2,  2,  2,  2,
    2,  2,  8,   4,   4,  4,  2,  2,  2,   8,  4,  4,  4,   2,  2,  2,  8,  4,
    4,  4,  4,   2,   2,  8,  4,  4,  4,   4,  2,  2,  16,  8,  8,  8,  4,  4,
    4,  2,  2,   16,  8,  8,  8,  4,  4,   16, 8,  8,  8,   4,  4,  8,  4,  4,
    4,  4,  4,   4,   4,  2,  2,  2,  2,   1,  1,  1,  1,   8,  4,  4,  4,  2,
    2,  2,  8,   4,   4,  4,  8,  4,  8,   4,  4,  4,  4,   4,  4,  4,  4,  4,
    2,  2,  2,   2,   2,  2,  8,  4,  4,   4,  4,  2,  2,   8,  4,  4,  4,  8,
    4,  16, 8,   8,   8,  8,  8,  4,  4,   4,  2,  2,  16,  8,  8,  8,  8,  4,
    4,  8,  4,   4,   4,  2,  1,  1,  8,   4,  2,  2,  8,   4,  4,  2,  2,  8,
    4,  4,  2,   8,   4,  2,  2,  8,  4,   2,  8,  4,  4,   2,  2,  2,  8,  4,
    4,  16, 8,   8,   4,  2,  16, 8,  4,   4,  16, 8,  4,   16, 8,  8,  4,  4,
    4,  4,  4,   4,   2,  2,  2,  2,  1,   1,  1,  1,  8,   4,  4,  4,  4,  4,
    4,  4,  2,   2,   2,  2,  2,  2,  8,   4,  4,  2,  2,   2,  8,  4,  4,  2,
    2,  8,  4,   4,   4,  4,  2,  2,  2,   1,  1,  1,  1,   8,  4,  4,  4,  4,
    4,  2,  2,   2,   2,  8,  4,  4,  4,   4,  2,  2,  2,   2,  8,  4,  4,  4,
    4,  2,  2,   2,   2,  16, 8,  8,  8,   4,  4,  2,  2,   2,  2,  16, 8,  8,
    8,  8,  4,   4,   4,  4,  16, 8,  8,   8,  8,  4,  4,   4,  2,  2,  16, 8,
    8,  4,  4,   16,  8,  8,  8,  8,  8,   4,  4,  4,  4,   4,  4,  4,  2,  2,
    2,  2,  1,   1,   1,  1,  16, 8,  8,   8,  8,  8,  4,   4,  4,  4,  2,  2,
    2,  2,  16,  8,   8,  8,  8,  8,  4,   4,  4,  4,  2,   2,  2,  2,  16, 8,
    8,  8,  8,   8,   4,  4,  4,  4,  2,   2,  2,  2,  16,  8,  8,  8,  8,  8,
    4,  4,  4,   2,   2,  16, 8,  8,  8,   8,  8,  4,  4,   4,  2,  2,  16, 8,
    8,  8,  4,   4,   4,  4,  2,  2,  2,   2,  16, 8,  8,   8,  4,  4,  4,  2,
    2,  16, 8,   8,   8,  8,  4,  4,  4,   2,  2,  2,  16,  8,  8,  8,  8,  4,
    4,  4,  2,   2,   2,  16, 8,  8,  8,   4,  4,  4,  16,  8,  8,  8,  4,  4,
    4,  16, 8,   8,   8,  8,  4,  4,  4,   4,  4,  4,  4,   2,  2,  2,  2,  2,
    2,  16, 8,   8,   8,  8,  8,  4,  4,   4,  4,  4,  4,   2,  2,  2,  2,  16,
    8,  8,  8,   8,   8,  8,  4,  4,  4,   4,  16, 8,  8,   8,  8,  8,  8,  4,
    4,  4,  4,   16,  8,  8,  8,  8,  8,   8,  4,  4,  4,   4,  4,  2,  2,  16,
    8,  8,  8,   8,   8,  8,  4,  4,  4,   4,  4,  2,  2,   16, 8,  8,  8,  8,
    4,  4,  4,   4,   16, 8,  8,  8,  4,   4,  4,  4,  4,   2,  2,  16, 8,  8,
    8,  4,  4,   2,   2,  16, 8,  8,  8,   4,  4,  2,  2,   16, 8,  8,  8,  8,
    4,  4,  4,   4,   4,  16, 8,  8,  8,   8,  4,  4,  4,   4,  4,  32, 16, 16,
    16, 16, 8,   8,   8,  8,  8,  4,  4,   4,  2,  2,  32,  16, 16, 16, 16, 8,
    8,  8,  8,   4,   4,  4,  4,  32, 16,  16, 16, 8,  8,   8,  4,  4,  32, 16,
    16, 16, 8,   8,   8,  4,  4,  32, 16,  16, 16, 16, 8,   8,  32, 16, 16, 16,
    16, 8,  8,   3,   1,  1,  1,  3,  3,   9,  3,  3,  1,   6,  3,  3,  2,  2,
    1,  1,  18,  9,   9,  6,  3,  3,  6,   3,  3,  2,  1,   1,  6,  3,  3,  2,
    2,  2,  1,   1,   1,  1,  1,  1,  6,   3,  3,  2,  2,   1,  1,  6,  3,  3,
    6,  3,  3,   6,   3,  3,  6,  3,  3,   18, 9,  9,  6,   3,  3,  6,  3,  3,
    2,  1,  1,   6,   3,  1,  1,  1,  6,   3,  2,  1,  6,   2,  2,  2,  6,  2,
    2,  18, 9,   3,   6,  3,  1,  18, 6,   6,  2,  12, 6,   6,  6,  4,  3,  3,
    2,  2,  2,   1,   1,  12, 6,  6,  4,   4,  2,  2,  2,   2,  12, 6,  6,  6,
    3,  3,  2,   2,   1,  1,  12, 6,  6,   4,  4,  2,  2,   36, 18, 18, 18, 9,
    9,  6,  3,   3,   12, 6,  6,  6,  3,   3,  2,  1,  1,   36, 18, 18, 12, 6,
    6,  12, 6,   6,   4,  2,  2,  6,  3,   2,  1,  6,  6,   6,  3,  3,  6,  3,
    3,  6,  2,   2,   6,  3,  3,  2,  2,   2,  1,  1,  1,   1,  1,  1,  12, 6,
    6,  6,  4,   3,   3,  2,  2,  2,  1,   1,  12, 6,  6,   4,  4,  2,  2,  2,
    2,  12, 6,   6,   6,  6,  6,  4,  3,   3,  2,  2,  2,   1,  1,  12, 6,  6,
    12, 6,  6,   12,  6,  6,  6,  6,  6,   6,  3,  3,  3,   3,  12, 6,  6,  6,
    6,  6,  6,   3,   3,  3,  3,  12, 6,   6,  4,  4,  2,   2,  2,  2,  12, 6,
    6,  3,  2,   1,   12, 6,  4,  2,  12,  6,  4,  2,  12,  6,  2,  2,  12, 6,
    6,  6,  3,   3,   2,  2,  2,  1,  1,   1,  1,  1,  1,   12, 6,  6,  4,  4,
    4,  2,  2,   2,   2,  2,  2,  12, 6,   6,  6,  4,  3,   3,  2,  2,  2,  1,
    1,  12, 6,   6,   4,  4,  2,  2,  2,   2,  24, 12, 12,  12, 12, 6,  6,  6,
    6,  6,  4,   3,   3,  2,  2,  2,  1,   1,  24, 12, 12,  12, 12, 8,  6,  6,
    4,  4,  4,   2,   2,  24, 12, 12, 12,  8,  6,  6,  4,   4,  4,  2,  2,  24,
    12, 12, 12,  6,   6,  4,  4,  2,  2,   2,  2,  12, 6,   6,  6,  6,  4,  3,
    3,  1,  1,   48,  24, 24, 16, 4,  4,   4,  4,  24, 12,  12, 8,  6,  2,  12,
    4,  24, 12,  8,   24, 12, 12, 8,  6,   6,  6,  6,  3,   3,  1,  1,  24, 12,
    12, 8,  6,   4,   4,  2,  24, 12, 12,  8,  6,  4,  4,   2,  96, 48, 48, 32,
    24, 24, 8,   4,   4,  96, 48, 32, 16,  16, 8,  8,  96,  48, 32, 16, 16, 8,
    8,  48, 24,  16,  12, 12, 8,  6,  2,   24, 8,  4,  4,   48, 24, 16, 8,  8,
    24, 12, 12,  12,  8,  6,  6,  3,  3,   1,  1,  24, 12,  12, 12, 12, 12, 8,
    6,  6,  6,   4,   4,  2,  96, 48, 48,  48, 32, 24, 24,  8,  4,  4,  96, 48,
    48, 32, 16,  16,  8,  8,  48, 24, 24,  24, 16, 12, 12,  8,  6,  2,  24, 12,
    8,  4,  4,   24,  12, 8,  4,  4,  48,  24, 24, 24, 16,  12, 12, 8,  8,  24,
    12, 12, 6,   6,   4,  3,  3,  1,  1,   96, 48, 24, 24,  16, 4,  4,  4,  4,
    48, 24, 24,  12,  12, 8,  6,  2,  24,  12, 12, 12, 8,   6,  6,  6,  2,  96,
    48, 48, 32,  24,  24, 8,  8,  48, 24,  16, 12, 12, 48,  24, 24, 24, 12, 12,
    12, 8,  6,   6,   3,  3,  1,  1,  48,  24, 24, 16, 12,  12, 8,  6,  2,  48,
    24, 24, 16,  12,  12, 8,  6,  2,  48,  24, 24, 16, 12,  12, 12, 8,  6,  6,
    6,  2,  48,  24,  24, 24, 24, 12, 12,  8,  6,  4,  4,   2,  48, 24, 24, 24,
    24, 12, 12,  8,   6,  4,  4,  2,  192, 96, 96, 48, 48,  48, 32, 24, 24, 8,
    4,  4,  192, 96,  96, 64, 48, 48, 24,  24, 8,  8,  192, 96, 96, 48, 32, 16,
    16, 8,  8,   192, 96, 96, 48, 32, 16,  16, 8,  8,  192, 96, 96, 64, 48, 32,
    32, 16, 192, 96,  96, 64, 48, 32, 32,  16, 96, 48, 48,  48, 24, 24, 16, 12,
    12, 8,  6,   2,   96, 48, 48, 32, 24,  24, 16, 16, 1,   2,  1,  1,  1,  1,
    2,  1,  1,   1,   1,  2,  1,  2,  2,   2,  4,  2,  2,   2,  2,  2,  1,  1,
    1,  1,  4,   2,   2,  2,  2,  4,  2,   2,  2,  2,  4,   2,  2,  2,  2,  2,
    1,  1,  2,   1,   1,  2,  2,  4,  2,   4,  2,  2,  1,   1,  2,  1,  1,  2,
    2,  4,  2,   4,   2,  4,  2,  2,  2,   2,  1,  1,  1,   1,  4,  2,  2,  2,
    2,  1,  1,   1,   1,  4,  2,  2,  2,   4,  2,  2,  2,   4,  2,  2,  2,  4,
    2,  2,  2,   4,   2,  2,  4,  2,  2,   8,  4,  4,  4,   2,  2,  8,  4,  4,
    4,  2,  2,   4,   2,  2,  2,  2,  2,   2,  2,  2,  1,   1,  1,  1,  4,  2,
    2,  2,  4,   2,   2,  2,  4,  2,  2,   8,  4,  4,  4,   4,  4,  2,  2,  4,
    2,  2,  2,   2,   1,  1,  1,  1,  4,   2,  2,  2,  4,   2,  2,  2,  4,  2,
    2,  8,  4,   4,   4,  2,  2,  4,  2,   2,  2,  1,  1,   4,  2,  2,  2,  1,
    1,  4,  2,   2,   4,  2,  2,  4,  2,   4,  2,  4,  2,   2,  4,  2,  2,  4,
    2,  2,  4,   2,   2,  4,  2,  4,  2,   4,  4,  4,  2,   4,  2,  8,  4,  4,
    2,  8,  4,   4,   2,  8,  4,  4,  8,   4,  4,  8,  4,   4,  4,  4,  4,  2,
    2,  2,  2,   2,   2,  2,  2,  1,  1,   1,  1,  8,  4,   4,  4,  4,  4,  4,
    2,  2,  2,   2,   8,  4,  4,  4,  4,   4,  4,  2,  2,   2,  2,  8,  4,  4,
    4,  4,  4,   2,   2,  8,  4,  4,  4,   4,  2,  2,  2,   8,  4,  4,  4,  4,
    2,  2,  2,   8,   4,  4,  4,  4,  2,   2,  2,  2,  8,   4,  4,  4,  4,  2,
    2,  2,  2,   8,   4,  4,  4,  2,  2,   8,  4,  4,  4,   2,  2,  8,  4,  4,
    4,  8,  4,   4,   4,  8,  4,  4,  4,   2,  2,  8,  4,   4,  4,  8,  4,  4,
    4,  8,  4,   4,   4,  2,  2,  16, 8,   8,  8,  8,  4,   4,  4,  4,  4,  2,
    2,  16, 8,   8,   8,  8,  8,  4,  4,   4,  4,  4,  2,   1,  1,  4,  2,  2,
    2,  1,  1,   8,   4,  4,  2,  2,  2,   1,  1,  8,  4,   4,  2,  2,  8,  4,
    4,  2,  2,   8,   4,  4,  4,  4,  2,   2,  2,  1,  1,   8,  4,  4,  2,  2,
    8,  4,  4,   4,   2,  1,  1,  8,  4,   2,  2,  8,  4,   4,  4,  4,  2,  2,
    2,  1,  1,   8,   4,  4,  2,  2,  8,   4,  4,  4,  2,   2,  2,  1,  1,  8,
    4,  4,  4,   2,   2,  16, 8,  8,  8,   8,  4,  4,  4,   4,  2,  2,  2,  1,
    1,  16, 8,   8,   8,  4,  4,  4,  2,   2,  16, 8,  8,   8,  4,  4,  4,  2,
    2,  16, 8,   8,   4,  4,  4,  2,  2,   16, 8,  8,  8,   4,  4,  2,  2,  16,
    8,  8,  8,   4,   4,  2,  2,  3,  1,   1,  1,  6,  3,   2,  2,  1,  6,  3,
    2,  2,  2,   1,   1,  1,  6,  3,  2,   2,  1,  6,  3,   1,  1,  1,  6,  3,
    2,  1,  12,  6,   6,  4,  3,  2,  2,   1,  12, 6,  6,   3,  2,  2,  1,  6,
    3,  2,  1,   6,   3,  2,  2,  2,  1,   1,  1,  12, 6,   6,  4,  3,  2,  2,
    1,  12, 6,   6,   6,  4,  3,  2,  2,   1,  12, 6,  6,   3,  2,  1,  12, 6,
    6,  3,  2,   2,   2,  1,  1,  1,  12,  6,  6,  4,  3,   2,  2,  1,  24, 12,
    12, 12, 6,   6,   6,  4,  3,  2,  2,   1,
};

static const char site_symmetry_symbols[][7] = {
    "      ", "1     ", "1     ", "-1    ", "-1    ", "-1    ", "-1    ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "2     ",
    "2     ", "2     ", "1     ", "2     ", "2     ", "2     ", "2     ",
    "1     ", "2     ", "2     ", "2     ", "2     ", "1     ", "1     ",
    "1     ", "1     ", "2     ", "2     ", "1     ", "2     ", "2     ",
    "1     ", "2     ", "2     ", "1     ", "2     ", "2     ", "1     ",
    "2     ", "2     ", "1     ", "2     ", "2     ", "1     ", "2     ",
    "2     ", "1     ", "2     ", "2     ", "1     ", "2     ", "2     ",
    "1     ", "m     ", "m     ", "1     ", "m     ", "m     ", "1     ",
    "m     ", "m     ", "1     ", "1     ", "1     ", "1     ", "1     ",
    "1     ", "1     ", "1     ", "1     ", "1     ", "m     ", "1     ",
    "m     ", "1     ", "m     ", "1     ", "m     ", "1     ", "m     ",
    "1     ", "m     ", "1     ", "m     ", "1     ", "m     ", "1     ",
    "m     ", "1     ", "1     ", "1     ", "1     ", "1     ", "1     ",
    "1     ", "1     ", "1     ", "1     ", "1     ", "1     ", "1     ",
    "1     ", "1     ", "1     ", "1     ", "1     ", "1     ", "m     ",
    "m     ", "2     ", "2     ", "2     ", "2     ", "2/m   ", "2/m   ",
    "2/m   ", "2/m   ", "2/m   ", "2/m   ", "2/m   ", "2/m   ", "1     ",
    "m     ", "m     ", "2     ", "2     ", "2     ", "2     ", "2/m   ",
    "2/m   ", "2/m   ", "2/m   ", "2/m   ", "2/m   ", "2/m   ", "2/m   ",
    "1     ", "m     ", "m     ", "2     ", "2     ", "2     ", "2     ",
    "2/m   ", "2/m   ", "2/m   ", "2/m   ", "2/m   ", "2/m   ", "2/m   ",
    "2/m   ", "1     ", "m     ", "-1    ", "-1    ", "-1    ", "-1    ",
    "1     ", "m     ", "-1    ", "-1    ", "-1    ", "-1    ", "1     ",
    "m     ", "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "m     ",
    "2     ", "2     ", "-1    ", "-1    ", "2/m   ", "2/m   ", "2/m   ",
    "2/m   ", "1     ", "m     ", "2     ", "2     ", "-1    ", "-1    ",
    "2/m   ", "2/m   ", "2/m   ", "2/m   ", "1     ", "m     ", "2     ",
    "2     ", "-1    ", "-1    ", "2/m   ", "2/m   ", "2/m   ", "2/m   ",
    "1     ", "m     ", "2     ", "2     ", "-1    ", "-1    ", "2/m   ",
    "2/m   ", "2/m   ", "2/m   ", "1     ", "m     ", "2     ", "2     ",
    "-1    ", "-1    ", "2/m   ", "2/m   ", "2/m   ", "2/m   ", "1     ",
    "m     ", "2     ", "2     ", "-1    ", "-1    ", "2/m   ", "2/m   ",
    "2/m   ", "2/m   ", "1     ", "m     ", "2     ", "2     ", "-1    ",
    "-1    ", "2/m   ", "2/m   ", "2/m   ", "2/m   ", "1     ", "m     ",
    "2     ", "2     ", "-1    ", "-1    ", "2/m   ", "2/m   ", "2/m   ",
    "2/m   ", "1     ", "m     ", "2     ", "2     ", "-1    ", "-1    ",
    "2/m   ", "2/m   ", "2/m   ", "2/m   ", "1     ", "2     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "-1    ", "-1    ",
    "-1    ", "-1    ", "1     ", "-1    ", "-1    ", "-1    ", "-1    ",
    "1     ", "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "-1    ",
    "-1    ", "-1    ", "-1    ", "1     ", "-1    ", "-1    ", "-1    ",
    "-1    ", "1     ", "-1    ", "-1    ", "-1    ", "-1    ", "1     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "-1    ", "-1    ",
    "-1    ", "-1    ", "1     ", "-1    ", "-1    ", "-1    ", "-1    ",
    "1     ", "2     ", "-1    ", "-1    ", "-1    ", "-1    ", "1     ",
    "2     ", "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "-1    ",
    "-1    ", "-1    ", "-1    ", "1     ", "2     ", "-1    ", "-1    ",
    "-1    ", "-1    ", "1     ", "2     ", "-1    ", "-1    ", "-1    ",
    "-1    ", "1     ", "2     ", "-1    ", "-1    ", "-1    ", "-1    ",
    "1     ", "2     ", "-1    ", "-1    ", "-1    ", "-1    ", "1     ",
    "2     ", "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "-1    ",
    "-1    ", "-1    ", "-1    ", "1     ", "2     ", "-1    ", "-1    ",
    "-1    ", "-1    ", "1     ", "2     ", "-1    ", "-1    ", "-1    ",
    "-1    ", "1     ", "2     ", "-1    ", "-1    ", "-1    ", "-1    ",
    "1     ", "2     ", "-1    ", "-1    ", "-1    ", "-1    ", "1     ",
    "2     ", "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ",
    "-1    ", "-1    ", "-1    ", "-1    ", "1     ", "2     ", "-1    ",
    "-1    ", "-1    ", "-1    ", "1     ", "..2   ", "..2   ", "..2   ",
    "..2   ", ".2.   ", ".2.   ", ".2.   ", ".2.   ", "2..   ", "2..   ",
    "2..   ", "2..   ", "222   ", "222   ", "222   ", "222   ", "222   ",
    "222   ", "222   ", "222   ", "1     ", ".2.   ", ".2.   ", "2..   ",
    "2..   ", "1     ", ".2.   ", ".2.   ", "2..   ", "2..   ", "1     ",
    ".2.   ", ".2.   ", "2..   ", "2..   ", "1     ", "..2   ", "..2   ",
    "1     ", "..2   ", "..2   ", "1     ", "..2   ", "..2   ", "1     ",
    "1     ", ".2.   ", "2..   ", "1     ", ".2.   ", "2..   ", "1     ",
    ".2.   ", "2..   ", "1     ", "..2   ", "..2   ", "..2   ", ".2.   ",
    ".2.   ", "2..   ", "2..   ", "222   ", "222   ", "222   ", "222   ",
    "1     ", "..2   ", "..2   ", "..2   ", ".2.   ", ".2.   ", "2..   ",
    "2..   ", "222   ", "222   ", "222   ", "222   ", "1     ", "..2   ",
    "..2   ", "..2   ", ".2.   ", ".2.   ", "2..   ", "2..   ", "222   ",
    "222   ", "222   ", "222   ", "1     ", "2..   ", ".2.   ", "..2   ",
    "..2   ", ".2.   ", "2..   ", "222   ", "222   ", "222   ", "222   ",
    "1     ", "..2   ", "..2   ", ".2.   ", ".2.   ", "2..   ", "2..   ",
    "222   ", "222   ", "222   ", "222   ", "1     ", "..2   ", ".2.   ",
    "2..   ", "1     ", "m..   ", "m..   ", ".m.   ", ".m.   ", "mm2   ",
    "mm2   ", "mm2   ", "mm2   ", "1     ", "m..   ", "m..   ", ".m.   ",
    ".m.   ", "mm2   ", "mm2   ", "mm2   ", "mm2   ", "1     ", "m..   ",
    "m..   ", ".m.   ", ".m.   ", "mm2   ", "mm2   ", "mm2   ", "mm2   ",
    "1     ", "m..   ", "m..   ", "1     ", "m..   ", "m..   ", "1     ",
    "m..   ", "m..   ", "1     ", "m..   ", "m..   ", "1     ", "m..   ",
    "m..   ", "1     ", "m..   ", "m..   ", "1     ", "..2   ", "..2   ",
    "..2   ", "..2   ", "1     ", "..2   ", "..2   ", "..2   ", "..2   ",
    "1     ", "..2   ", "..2   ", "..2   ", "..2   ", "1     ", "m..   ",
    "..2   ", "..2   ", "1     ", "m..   ", "..2   ", "..2   ", "1     ",
    "m..   ", "..2   ", "..2   ", "1     ", "m..   ", "..2   ", "..2   ",
    "1     ", "m..   ", "..2   ", "..2   ", "1     ", "m..   ", "..2   ",
    "..2   ", "1     ", "1     ", "1     ", "1     ", "1     ", "1     ",
    "1     ", "..2   ", "..2   ", "1     ", "..2   ", "..2   ", "1     ",
    "..2   ", "..2   ", "1     ", "..2   ", "..2   ", "1     ", "..2   ",
    "..2   ", "1     ", "..2   ", "..2   ", "1     ", "m..   ", "1     ",
    "m..   ", "1     ", "m..   ", "1     ", "m..   ", "1     ", "m..   ",
    "1     ", "m..   ", "1     ", "..2   ", "..2   ", "1     ", "..2   ",
    "..2   ", "1     ", "..2   ", "..2   ", "1     ", "1     ", "1     ",
    "1     ", "1     ", "1     ", "1     ", "..2   ", "..2   ", "1     ",
    "..2   ", "..2   ", "1     ", "..2   ", "..2   ", "1     ", "m..   ",
    ".m.   ", "..2   ", "mm2   ", "mm2   ", "1     ", "m..   ", ".m.   ",
    "..2   ", "mm2   ", "mm2   ", "1     ", "m..   ", ".m.   ", "..2   ",
    "mm2   ", "mm2   ", "1     ", "m..   ", "1     ", "m..   ", "1     ",
    "m..   ", "1     ", "m..   ", "1     ", "m..   ", "1     ", "m..   ",
    "1     ", "..2   ", "..2   ", "..2   ", "1     ", "..2   ", "..2   ",
    "..2   ", "1     ", "..2   ", "..2   ", "..2   ", "1     ", "m..   ",
    "m..   ", ".m.   ", "mm2   ", "mm2   ", "1     ", "m..   ", "m..   ",
    ".m.   ", "mm2   ", "mm2   ", "1     ", "m..   ", "m..   ", ".m.   ",
    "mm2   ", "mm2   ", "1     ", "m..   ", "m..   ", ".m.   ", "mm2   ",
    "mm2   ", "1     ", "m..   ", "m..   ", ".m.   ", "mm2   ", "mm2   ",
    "1     ", "m..   ", "m..   ", ".m.   ", "mm2   ", "mm2   ", "1     ",
    ".m.   ", "..2   ", "..2   ", "1     ", ".m.   ", "..2   ", "..2   ",
    "1     ", ".m.   ", "..2   ", "..2   ", "1     ", ".m.   ", "..2   ",
    "..2   ", "1     ", ".m.   ", "..2   ", "..2   ", "1     ", ".m.   ",
    "..2   ", "..2   ", "1     ", "m..   ", "..2   ", "1     ", "m..   ",
    "..2   ", "1     ", "m..   ", "..2   ", "1     ", "m..   ", "..2   ",
    "1     ", "m..   ", "..2   ", "1     ", "m..   ", "..2   ", "1     ",
    "..2   ", "1     ", "..2   ", "1     ", "..2   ", "1     ", "..2   ",
    "1     ", "..2   ", "1     ", "..2   ", "1     ", ".m.   ", "m..   ",
    "..2   ", "mm2   ", "1     ", ".m.   ", "m..   ", "..2   ", "mm2   ",
    "1     ", ".m.   ", "m..   ", "..2   ", "mm2   ", "1     ", "..2   ",
    "1     ", "..2   ", "1     ", "..2   ", "1     ", "m..   ", ".m.   ",
    "mm2   ", "mm2   ", "1     ", "m..   ", ".m.   ", "mm2   ", "mm2   ",
    "1     ", "m..   ", ".m.   ", "mm2   ", "mm2   ", "1     ", "..2   ",
    "..2   ", "1     ", "..2   ", "..2   ", "1     ", "..2   ", "..2   ",
    "1     ", "m..   ", "..2   ", "1     ", "m..   ", "..2   ", "1     ",
    "m..   ", "..2   ", "1     ", "m..   ", "..2   ", "1     ", "m..   ",
    "..2   ", "1     ", "m..   ", "..2   ", "1     ", "..m   ", "..m   ",
    ".m.   ", ".m.   ", "m..   ", "m..   ", "mm2   ", "mm2   ", "mm2   ",
    "mm2   ", "m2m   ", "m2m   ", "m2m   ", "m2m   ", "2mm   ", "2mm   ",
    "2mm   ", "2mm   ", "mmm   ", "mmm   ", "mmm   ", "mmm   ", "mmm   ",
    "mmm   ", "mmm   ", "mmm   ", "1     ", "..2   ", "..2   ", ".2.   ",
    ".2.   ", "2..   ", "2..   ", "-1    ", "-1    ", "222   ", "222   ",
    "222   ", "222   ", "1     ", "..2   ", "..2   ", ".2.   ", ".2.   ",
    "2..   ", "2..   ", "-1    ", "-1    ", "222   ", "222   ", "222   ",
    "222   ", "1     ", "..m   ", "..2   ", "..2   ", "..2   ", "..2   ",
    ".2.   ", ".2.   ", "2..   ", "2..   ", "222   ", "222   ", "222   ",
    "222   ", "..2/m ", "..2/m ", "..2/m ", "..2/m ", "1     ", "..m   ",
    "..2   ", "..2   ", "..2   ", "..2   ", ".2.   ", ".2.   ", "2..   ",
    "2..   ", "222   ", "222   ", "222   ", "222   ", "..2/m ", "..2/m ",
    "..2/m ", "..2/m ", "1     ", "..m   ", "..2   ", "..2   ", "..2   ",
    "..2   ", ".2.   ", ".2.   ", "2..   ", "2..   ", "222   ", "222   ",
    "222   ", "222   ", "..2/m ", "..2/m ", "..2/m ", "..2/m ", "1     ",
    "..2   ", "..2   ", ".2.   ", ".2.   ", "2..   ", "2..   ", "-1    ",
    "-1    ", "222   ", "222   ", "222   ", "222   ", "1     ", "..2   ",
    "..2   ", ".2.   ", ".2.   ", "2..   ", "2..   ", "-1    ", "-1    ",
    "222   ", "222   ", "222   ", "222   ", "1     ", "..2   ", "..2   ",
    ".2.   ", ".2.   ", "2..   ", "2..   ", "-1    ", "-1    ", "222   ",
    "222   ", "222   ", "222   ", "1     ", "..2   ", "..2   ", ".2.   ",
    ".2.   ", "2..   ", "2..   ", "-1    ", "-1    ", "222   ", "222   ",
    "222   ", "222   ", "1     ", "..2   ", "..2   ", ".2.   ", ".2.   ",
    "2..   ", "2..   ", "-1    ", "-1    ", "222   ", "222   ", "222   ",
    "222   ", "1     ", "..2   ", "..2   ", ".2.   ", ".2.   ", "2..   ",
    "2..   ", "-1    ", "-1    ", "222   ", "222   ", "222   ", "222   ",
    "1     ", "m..   ", ".m.   ", ".m.   ", ".2.   ", ".2.   ", "mm2   ",
    "mm2   ", ".2/m. ", ".2/m. ", ".2/m. ", ".2/m. ", "1     ", "m..   ",
    ".m.   ", ".m.   ", ".2.   ", ".2.   ", "mm2   ", "mm2   ", ".2/m. ",
    ".2/m. ", ".2/m. ", ".2/m. ", "1     ", "m..   ", ".m.   ", ".m.   ",
    ".2.   ", ".2.   ", "mm2   ", "mm2   ", ".2/m. ", ".2/m. ", ".2/m. ",
    ".2/m. ", "1     ", "m..   ", ".m.   ", ".m.   ", ".2.   ", ".2.   ",
    "mm2   ", "mm2   ", ".2/m. ", ".2/m. ", ".2/m. ", ".2/m. ", "1     ",
    "m..   ", ".m.   ", ".m.   ", ".2.   ", ".2.   ", "mm2   ", "mm2   ",
    ".2/m. ", ".2/m. ", ".2/m. ", ".2/m. ", "1     ", "m..   ", ".m.   ",
    ".m.   ", ".2.   ", ".2.   ", "mm2   ", "mm2   ", ".2/m. ", ".2/m. ",
    ".2/m. ", ".2/m. ", "1     ", "2..   ", "..2   ", "-1    ", "-1    ",
    "1     ", "2..   ", "..2   ", "-1    ", "-1    ", "1     ", "2..   ",
    "..2   ", "-1    ", "-1    ", "1     ", "2..   ", "..2   ", "-1    ",
    "-1    ", "1     ", "2..   ", "..2   ", "-1    ", "-1    ", "1     ",
    "2..   ", "..2   ", "-1    ", "-1    ", "1     ", "m..   ", ".2.   ",
    "2..   ", "2..   ", "2/m.. ", "2/m.. ", "2/m.. ", "2/m.. ", "1     ",
    "m..   ", ".2.   ", "2..   ", "2..   ", "2/m.. ", "2/m.. ", "2/m.. ",
    "2/m.. ", "1     ", "m..   ", ".2.   ", "2..   ", "2..   ", "2/m.. ",
    "2/m.. ", "2/m.. ", "2/m.. ", "1     ", "m..   ", ".2.   ", "2..   ",
    "2..   ", "2/m.. ", "2/m.. ", "2/m.. ", "2/m.. ", "1     ", "m..   ",
    ".2.   ", "2..   ", "2..   ", "2/m.. ", "2/m.. ", "2/m.. ", "2/m.. ",
    "1     ", "m..   ", ".2.   ", "2..   ", "2..   ", "2/m.. ", "2/m.. ",
    "2/m.. ", "2/m.. ", "1     ", "..2   ", "..2   ", ".2.   ", "-1    ",
    "-1    ", "1     ", "..2   ", "..2   ", ".2.   ", "-1    ", "-1    ",
    "1     ", "..2   ", "..2   ", ".2.   ", "-1    ", "-1    ", "1     ",
    "..2   ", "..2   ", ".2.   ", "-1    ", "-1    ", "1     ", "..2   ",
    "..2   ", ".2.   ", "-1    ", "-1    ", "1     ", "..2   ", "..2   ",
    ".2.   ", "-1    ", "-1    ", "1     ", "..m   ", "..m   ", "..2   ",
    "..2   ", "..2/m ", "..2/m ", "..2/m ", "..2/m ", "1     ", "..m   ",
    "..m   ", "..2   ", "..2   ", "..2/m ", "..2/m ", "..2/m ", "..2/m ",
    "1     ", "..m   ", "..m   ", "..2   ", "..2   ", "..2/m ", "..2/m ",
    "..2/m ", "..2/m ", "1     ", "..2   ", "..2   ", "-1    ", "-1    ",
    "1     ", "..2   ", "..2   ", "-1    ", "-1    ", "1     ", "..2   ",
    "..2   ", "-1    ", "-1    ", "1     ", "..m   ", "2..   ", "-1    ",
    "-1    ", "1     ", "..m   ", "2..   ", "-1    ", "-1    ", "1     ",
    "..m   ", "2..   ", "-1    ", "-1    ", "1     ", "..m   ", "2..   ",
    "-1    ", "-1    ", "1     ", "..m   ", "2..   ", "-1    ", "-1    ",
    "1     ", "..m   ", "2..   ", "-1    ", "-1    ", "1     ", "..m   ",
    "..2   ", "..2   ", "..2/m ", "..2/m ", "..2/m ", "..2/m ", "1     ",
    "..m   ", "..2   ", "..2   ", "..2/m ", "..2/m ", "..2/m ", "..2/m ",
    "1     ", "..m   ", "..2   ", "..2   ", "..2/m ", "..2/m ", "..2/m ",
    "..2/m ", "1     ", ".m.   ", "m..   ", "-1    ", "-1    ", "mm2   ",
    "mm2   ", "1     ", ".m.   ", "m..   ", "-1    ", "-1    ", "mm2   ",
    "mm2   ", "1     ", ".m.   ", "m..   ", "-1    ", "-1    ", "mm2   ",
    "mm2   ", "1     ", ".m.   ", "m..   ", "-1    ", "-1    ", "mm2   ",
    "mm2   ", "1     ", ".m.   ", "m..   ", "-1    ", "-1    ", "mm2   ",
    "mm2   ", "1     ", ".m.   ", "m..   ", "-1    ", "-1    ", "mm2   ",
    "mm2   ", "1     ", ".2.   ", "-1    ", "-1    ", "1     ", ".2.   ",
    "-1    ", "-1    ", "1     ", ".2.   ", "-1    ", "-1    ", "1     ",
    ".2.   ", "-1    ", "-1    ", "1     ", ".2.   ", "-1    ", "-1    ",
    "1     ", ".2.   ", "-1    ", "-1    ", "1     ", "-1    ", "-1    ",
    "1     ", "-1    ", "-1    ", "1     ", ".m.   ", "-1    ", "-1    ",
    "1     ", ".m.   ", "-1    ", "-1    ", "1     ", ".m.   ", "-1    ",
    "-1    ", "1     ", ".m.   ", "-1    ", "-1    ", "1     ", ".m.   ",
    "-1    ", "-1    ", "1     ", ".m.   ", "-1    ", "-1    ", "1     ",
    "..m   ", "m..   ", "2..   ", "-1    ", "m2m   ", "2/m.. ", "2/m.. ",
    "1     ", "..m   ", "m..   ", "2..   ", "-1    ", "m2m   ", "2/m.. ",
    "2/m.. ", "1     ", "..m   ", "m..   ", "2..   ", "-1    ", "m2m   ",
    "2/m.. ", "2/m.. ", "1     ", "..m   ", "m..   ", "2..   ", "-1    ",
    "m2m   ", "2/m.. ", "2/m.. ", "1     ", "..m   ", "m..   ", "2..   ",
    "-1    ", "m2m   ", "2/m.. ", "2/m.. ", "1     ", "..m   ", "m..   ",
    "2..   ", "-1    ", "m2m   ", "2/m.. ", "2/m.. ", "1     ", "m..   ",
    ".2.   ", "2..   ", "-1    ", "2/m.. ", "2/m.. ", "1     ", "m..   ",
    ".2.   ", "2..   ", "-1    ", "2/m.. ", "2/m.. ", "1     ", "m..   ",
    ".2.   ", "2..   ", "-1    ", "2/m.. ", "2/m.. ", "1     ", "m..   ",
    ".2.   ", "2..   ", "-1    ", "2/m.. ", "2/m.. ", "1     ", "m..   ",
    ".2.   ", "2..   ", "-1    ", "2/m.. ", "2/m.. ", "1     ", "m..   ",
    ".2.   ", "2..   ", "-1    ", "2/m.. ", "2/m.. ", "1     ", "..m   ",
    "..m   ", ".m.   ", "m..   ", "..2   ", "mm2   ", "mm2   ", "m2m   ",
    "m2m   ", "2mm   ", "2mm   ", "..2/m ", "..2/m ", "mmm   ", "mmm   ",
    "mmm   ", "mmm   ", "1     ", "..m   ", "..m   ", ".m.   ", "m..   ",
    "..2   ", "mm2   ", "mm2   ", "m2m   ", "m2m   ", "2mm   ", "2mm   ",
    "..2/m ", "..2/m ", "mmm   ", "mmm   ", "mmm   ", "mmm   ", "1     ",
    "..m   ", "..m   ", ".m.   ", "m..   ", "..2   ", "mm2   ", "mm2   ",
    "m2m   ", "m2m   ", "2mm   ", "2mm   ", "..2/m ", "..2/m ", "mmm   ",
    "mmm   ", "mmm   ", "mmm   ", "1     ", "..m   ", "..2   ", "..2   ",
    "..2   ", ".2.   ", "2..   ", "..2/m ", "..2/m ", "..2/m ", "..2/m ",
    "222   ", "222   ", "1     ", "..m   ", "..2   ", "..2   ", "..2   ",
    ".2.   ", "2..   ", "..2/m ", "..2/m ", "..2/m ", "..2/m ", "222   ",
    "222   ", "1     ", "..m   ", "..2   ", "..2   ", "..2   ", ".2.   ",
    "2..   ", "..2/m ", "..2/m ", "..2/m ", "..2/m ", "222   ", "222   ",
    "1     ", ".m.   ", "m..   ", "..2   ", ".2.   ", ".2.   ", "2..   ",
    "2..   ", "mm2   ", ".2/m. ", ".2/m. ", "2/m.. ", "2/m.. ", "222   ",
    "222   ", "1     ", ".m.   ", "m..   ", "..2   ", ".2.   ", ".2.   ",
    "2..   ", "2..   ", "mm2   ", ".2/m. ", ".2/m. ", "2/m.. ", "2/m.. ",
    "222   ", "222   ", "1     ", ".m.   ", "m..   ", "..2   ", ".2.   ",
    ".2.   ", "2..   ", "2..   ", "mm2   ", ".2/m. ", ".2/m. ", "2/m.. ",
    "2/m.. ", "222   ", "222   ", "1     ", ".m.   ", "m..   ", "..2   ",
    ".2.   ", ".2.   ", "2..   ", "2..   ", "mm2   ", ".2/m. ", ".2/m. ",
    "2/m.. ", "2/m.. ", "222   ", "222   ", "1     ", ".m.   ", "m..   ",
    "..2   ", ".2.   ", ".2.   ", "2..   ", "2..   ", "mm2   ", ".2/m. ",
    ".2/m. ", "2/m.. ", "2/m.. ", "222   ", "222   ", "1     ", ".m.   ",
    "m..   ", "..2   ", ".2.   ", ".2.   ", "2..   ", "2..   ", "mm2   ",
    ".2/m. ", ".2/m. ", "2/m.. ", "2/m.. ", "222   ", "222   ", "1     ",
    "..2   ", "..2   ", ".2.   ", "2..   ", "-1    ", "-1    ", "222   ",
    "222   ", "1     ", "..2   ", "..2   ", ".2.   ", "2..   ", "-1    ",
    "-1    ", "222   ", "222   ", "1     ", "..2   ", "..2   ", ".2.   ",
    "2..   ", "-1    ", "-1    ", "222   ", "222   ", "1     ", "..2   ",
    "..2   ", ".2.   ", "2..   ", "-1    ", "-1    ", "222   ", "222   ",
    "1     ", "..2   ", "..2   ", ".2.   ", "2..   ", "-1    ", "-1    ",
    "222   ", "222   ", "1     ", "..2   ", "..2   ", ".2.   ", "2..   ",
    "-1    ", "-1    ", "222   ", "222   ", "1     ", "..2   ", "..2   ",
    ".2.   ", "2..   ", "-1    ", "-1    ", "222   ", "222   ", "1     ",
    "..2   ", "..2   ", ".2.   ", "2..   ", "-1    ", "-1    ", "222   ",
    "222   ", "1     ", "..2   ", "..2   ", ".2.   ", "2..   ", "-1    ",
    "-1    ", "222   ", "222   ", "1     ", "..2   ", "..2   ", ".2.   ",
    "2..   ", "-1    ", "-1    ", "222   ", "222   ", "1     ", "..2   ",
    "..2   ", ".2.   ", "2..   ", "-1    ", "-1    ", "222   ", "222   ",
    "1     ", "..2   ", "..2   ", ".2.   ", "2..   ", "-1    ", "-1    ",
    "222   ", "222   ", "1     ", "..m   ", ".m.   ", "m..   ", "2..   ",
    ".2.   ", "..2   ", "mm2   ", "m2m   ", "2mm   ", "222   ", "..2/m ",
    ".2/m. ", "2/m.. ", "mmm   ", "mmm   ", "1     ", "..2   ", ".2.   ",
    "2..   ", "-1    ", "-1    ", "222   ", "222   ", "1     ", "..2   ",
    ".2.   ", "2..   ", "-1    ", "-1    ", "222   ", "222   ", "1     ",
    "..m   ", ".m.   ", "m..   ", "-1    ", "mm2   ", "mm2   ", "m2m   ",
    "m2m   ", "2mm   ", "2mm   ", "mmm   ", "mmm   ", "mmm   ", "mmm   ",
    "1     ", "..m   ", "..2   ", "..2   ", ".2.   ", "2..   ", "-1    ",
    "..2/m ", "..2/m ", "222   ", "222   ", "1     ", "..m   ", "..2   ",
    "..2   ", ".2.   ", "2..   ", "-1    ", "..2/m ", "..2/m ", "222   ",
    "222   ", "1     ", "..m   ", "..2   ", "..2   ", ".2.   ", "2..   ",
    "-1    ", "..2/m ", "..2/m ", "222   ", "222   ", "1     ", "..2   ",
    ".2.   ", "2..   ", "-1    ", "-1    ", "1     ", "..2   ", ".2.   ",
    "2..   ", "-1    ", "-1    ", "1     ", ".m.   ", "m..   ", ".2.   ",
    "2..   ", "mm2   ", ".2/m. ", ".2/m. ", "2/m.. ", "2/m.. ", "1     ",
    ".m.   ", "m..   ", ".2.   ", "2..   ", "mm2   ", ".2/m. ", ".2/m. ",
    "2/m.. ", "2/m.. ", "1     ", ".m.   ", "m..   ", ".2.   ", "2..   ",
    "mm2   ", ".2/m. ", ".2/m. ", "2/m.. ", "2/m.. ", "1     ", ".m.   ",
    "m..   ", ".2.   ", "2..   ", "mm2   ", ".2/m. ", ".2/m. ", "2/m.. ",
    "2/m.. ", "1     ", ".m.   ", "m..   ", ".2.   ", "2..   ", "mm2   ",
    ".2/m. ", ".2/m. ", "2/m.. ", "2/m.. ", "1     ", ".m.   ", "m..   ",
    ".2.   ", "2..   ", "mm2   ", ".2/m. ", ".2/m. ", "2/m.. ", "2/m.. ",
    "1     ", "2..   ", "4..   ", "4..   ", "1     ", "1     ", "2..   ",
    "2..   ", "2..   ", "1     ", "1     ", "2..   ", "4..   ", "1     ",
    "2..   ", "1     ", "2..   ", "2..   ", "2..   ", "-4..  ", "-4..  ",
    "-4..  ", "-4..  ", "1     ", "2..   ", "2..   ", "-4..  ", "-4..  ",
    "-4..  ", "-4..  ", "1     ", "m..   ", "m..   ", "2..   ", "4..   ",
    "4..   ", "2/m.. ", "2/m.. ", "4/m.. ", "4/m.. ", "4/m.. ", "4/m.. ",
    "1     ", "m..   ", "2..   ", "2..   ", "2..   ", "-4..  ", "-4..  ",
    "2/m.. ", "2/m.. ", "2/m.. ", "2/m.. ", "1     ", "2..   ", "-1    ",
    "-1    ", "4..   ", "-4..  ", "-4..  ", "1     ", "2..   ", "-1    ",
    "-1    ", "4..   ", "-4..  ", "-4..  ", "1     ", "2..   ", "2..   ",
    "-1    ", "-1    ", "-4..  ", "-4..  ", "1     ", "2..   ", "2..   ",
    "-1    ", "-1    ", "-4..  ", "-4..  ", "1     ", "m..   ", "2..   ",
    "-1    ", "4..   ", "-4..  ", "2/m.. ", "4/m.. ", "4/m.. ", "1     ",
    "2..   ", "-1    ", "-1    ", "-4..  ", "-4..  ", "1     ", "2..   ",
    "-1    ", "-1    ", "-4..  ", "-4..  ", "1     ", ".2.   ", ".2.   ",
    ".2.   ", ".2.   ", "..2   ", "..2   ", "2..   ", "4..   ", "4..   ",
    "222.  ", "222.  ", "422   ", "422   ", "422   ", "422   ", "1     ",
    "..2   ", "..2   ", "2..   ", "4..   ", "2.22  ", "2.22  ", "1     ",
    "..2   ", ".2.   ", ".2.   ", "1     ", "..2   ", "1     ", "..2   ",
    "..2   ", ".2.   ", ".2.   ", ".2.   ", ".2.   ", "2..   ", "2..   ",
    "2..   ", "2.22  ", "2.22  ", "222.  ", "222.  ", "222.  ", "222.  ",
    "1     ", "..2   ", "..2   ", "2..   ", "2..   ", "2.22  ", "2.22  ",
    "1     ", "..2   ", ".2.   ", ".2.   ", "1     ", "..2   ", "1     ",
    "..2   ", ".2.   ", ".2.   ", "..2   ", "2..   ", "4..   ", "2.22  ",
    "222.  ", "422   ", "422   ", "1     ", ".2.   ", "..2   ", "..2   ",
    "2..   ", "2.22  ", "2.22  ", "1     ", ".m.   ", ".m.   ", "..m   ",
    "2mm.  ", "4mm   ", "4mm   ", "1     ", "..m   ", "2.mm  ", "4..   ",
    "1     ", "..m   ", "2..   ", "2.mm  ", "2.mm  ", "1     ", "..m   ",
    "2..   ", "2.mm  ", "1     ", "2..   ", "4..   ", "4..   ", "1     ",
    "2..   ", "4..   ", "1     ", ".m.   ", ".m.   ", "2mm.  ", "2mm.  ",
    "2mm.  ", "1     ", "2..   ", "2..   ", "1     ", ".m.   ", "..m   ",
    "2mm.  ", "4mm   ", "1     ", "..m   ", "2.mm  ", "4..   ", "1     ",
    ".m.   ", "2mm.  ", "1     ", "2..   ", "1     ", "..m   ", "2..   ",
    ".2.   ", ".2.   ", ".2.   ", ".2.   ", "2.mm  ", "2.mm  ", "222.  ",
    "222.  ", "-42m  ", "-42m  ", "-42m  ", "-42m  ", "1     ", "2..   ",
    "2..   ", "2..   ", ".2.   ", ".2.   ", ".2.   ", ".2.   ", "-4..  ",
    "-4..  ", "222.  ", "222.  ", "222.  ", "222.  ", "1     ", "..m   ",
    "2..   ", "2.mm  ", "-4..  ", "-4..  ", "1     ", "2..   ", "2..   ",
    "-4..  ", "-4..  ", "1     ", ".m.   ", ".m.   ", "..2   ", "..2   ",
    "2mm.  ", "2mm.  ", "2mm.  ", "-4m2  ", "-4m2  ", "-4m2  ", "-4m2  ",
    "1     ", "2..   ", "2..   ", "2..   ", "..2   ", "..2   ", "-4..  ",
    "-4..  ", "2.22  ", "2.22  ", "1     ", "..2   ", "..2   ", "2..   ",
    "2..   ", "2.22  ", "2.22  ", "-4..  ", "-4..  ", "1     ", "2..   ",
    "..2   ", "..2   ", "2..   ", "2.22  ", "2.22  ", "-4..  ", "-4..  ",
    "1     ", ".m.   ", "..2   ", "..2   ", "2mm.  ", "2mm.  ", "-4m2  ",
    "-4m2  ", "-4m2  ", "-4m2  ", "1     ", "..2   ", "2..   ", "2..   ",
    "..2   ", "2.22  ", "-4..  ", "-4..  ", "2.22  ", "1     ", "..m   ",
    "2..   ", ".2.   ", ".2.   ", "2.mm  ", "-4..  ", "222.  ", "-42m  ",
    "-42m  ", "1     ", ".2.   ", "2..   ", "-4..  ", "-4..  ", "1     ",
    ".m.   ", ".m.   ", "..m   ", "m..   ", "m..   ", "m2m.  ", "m2m.  ",
    "m2m.  ", "m2m.  ", "m.2m  ", "m.2m  ", "2mm.  ", "4mm   ", "4mm   ",
    "mmm.  ", "mmm.  ", "4/mmm ", "4/mmm ", "4/mmm ", "4/mmm ", "1     ",
    "m..   ", ".2.   ", ".2.   ", "..2   ", "2..   ", "4..   ", "4..   ",
    "222.  ", "2/m.. ", "4/m.. ", "422   ", "4/m.. ", "422   ", "1     ",
    "..m   ", ".2.   ", ".2.   ", "..2   ", "..2   ", "2.mm  ", "4..   ",
    "..2/m ", "..2/m ", "-42m  ", "-42m  ", "422   ", "422   ", "1     ",
    "..m   ", ".2.   ", ".2.   ", "..2   ", "..2   ", "2.mm  ", "4..   ",
    "..2/m ", "..2/m ", "-42m  ", "-42m  ", "422   ", "422   ", "1     ",
    ".2.   ", ".2.   ", "..2   ", "2..   ", "-1    ", "4..   ", "-4..  ",
    "222.  ", "422   ", "422   ", "1     ", ".2.   ", ".2.   ", "..2   ",
    "2..   ", "-1    ", "4..   ", "-4..  ", "222.  ", "422   ", "422   ",
    "1     ", "..m   ", "m..   ", "m..   ", "m.2m  ", "m.2m  ", "2.mm  ",
    "4..   ", "m.mm  ", "m.mm  ", "4/m.. ", "4/m.. ", "1     ", "m..   ",
    "..2   ", "2..   ", "4..   ", "2.22  ", "2/m.. ", "4/m.. ", "4/m.. ",
    "1     ", "..m   ", ".m.   ", "..2   ", "..2   ", "2mm.  ", "..2/m ",
    "..2/m ", "4mm   ", "-4m2  ", "-4m2  ", "1     ", "..m   ", ".m.   ",
    "..2   ", "..2   ", "2mm.  ", "..2/m ", "..2/m ", "4mm   ", "-4m2  ",
    "-4m2  ", "1     ", "..2   ", "2..   ", "-1    ", "4..   ", "-4..  ",
    "2.22  ", "1     ", "..2   ", "2..   ", "-1    ", "4..   ", "-4..  ",
    "2.22  ", "1     ", "m..   ", ".m.   ", ".m.   ", "..2   ", "m2m.  ",
    "m2m.  ", "m2m.  ", "m2m.  ", "2mm.  ", "2mm.  ", "2mm.  ", "-4m2  ",
    "-4m2  ", "mmm.  ", "mmm.  ", "mmm.  ", "mmm.  ", "1     ", "..m   ",
    "m..   ", ".2.   ", ".2.   ", "2..   ", "m.2m  ", "m.2m  ", "2.mm  ",
    "2.mm  ", "2/m.. ", "222.  ", "-42m  ", "m.mm  ", "-42m  ", "m.mm  ",
    "1     ", "..2   ", ".2.   ", ".2.   ", "2..   ", "2..   ", "-1    ",
    "-4..  ", "2.22  ", "222.  ", "222.  ", "1     ", "..2   ", ".2.   ",
    ".2.   ", "2..   ", "2..   ", "-1    ", "-4..  ", "2.22  ", "222.  ",
    "222.  ", "1     ", "..m   ", "..2   ", "..2   ", ".2.   ", ".2.   ",
    "2..   ", "2.mm  ", "..2/m ", "..2/m ", "2.22  ", "222.  ", "-42m  ",
    "-42m  ", "1     ", "..m   ", "..2   ", "..2   ", ".2.   ", ".2.   ",
    "2..   ", "2.mm  ", "..2/m ", "..2/m ", "2.22  ", "222.  ", "-42m  ",
    "-42m  ", "1     ", "m..   ", "..2   ", "2..   ", "2..   ", "2.22  ",
    "2/m.. ", "-4..  ", "2/m.. ", "1     ", "..m   ", "m..   ", "2..   ",
    "m.2m  ", "m.2m  ", "2.mm  ", "-4..  ", "2/m.. ", "m.mm  ", "m.mm  ",
    "1     ", ".m.   ", "..2   ", "-1    ", "2mm.  ", "2mm.  ", "-4m2  ",
    "-4m2  ", "1     ", ".m.   ", "..2   ", "-1    ", "2mm.  ", "2mm.  ",
    "-4m2  ", "-4m2  ", "1     ", "..m   ", "..2   ", "..2   ", "2..   ",
    "2.mm  ", "..2/m ", "..2/m ", "-4..  ", "2.22  ", "1     ", "..m   ",
    "..2   ", "..2   ", "2..   ", "2.mm  ", "..2/m ", "..2/m ", "-4..  ",
    "2.22  ", "1     ", ".m.   ", "..m   ", "m..   ", "..2   ", "m2m.  ",
    "m2m.  ", "m.2m  ", "2mm.  ", "..2/m ", "4mm   ", "-4m2  ", "mmm.  ",
    "4/mmm ", "4/mmm ", "1     ", "..m   ", "m..   ", ".2.   ", "..2   ",
    "m.2m  ", "2.mm  ", "4..   ", "..2/m ", "m.mm  ", "4/m.. ", "-42m  ",
    "422   ", "1     ", ".m.   ", "..2   ", ".2.   ", "2mm.  ", ".2/m. ",
    ".2/m. ", "-4m2  ", "-4m2  ", "1     ", ".m.   ", "..2   ", ".2.   ",
    "2mm.  ", ".2/m. ", ".2/m. ", "-4m2  ", "-4m2  ", "1     ", "..2   ",
    ".2.   ", "2..   ", "-1    ", "2.22  ", "-4..  ", "1     ", "..2   ",
    ".2.   ", "2..   ", "-1    ", "2.22  ", "-4..  ", "1     ", "3..   ",
    "3..   ", "3..   ", "1     ", "1     ", "1     ", "3.    ", "1     ",
    "3.    ", "1     ", "-1    ", "-1    ", "3..   ", "3..   ", "-3..  ",
    "-3..  ", "1     ", "-1    ", "-1    ", "3.    ", "-3.   ", "-3.   ",
    "1     ", "-1    ", "-1    ", "3.    ", "-3.   ", "-3.   ", "1     ",
    "..2   ", "..2   ", "3..   ", "3..   ", "3..   ", "3.2   ", "3.2   ",
    "3.2   ", "3.2   ", "3.2   ", "3.2   ", "1     ", ".2.   ", ".2.   ",
    "3..   ", "3..   ", "32.   ", "32.   ", "1     ", "..2   ", "..2   ",
    "1     ", ".2.   ", ".2.   ", "1     ", "..2   ", "..2   ", "1     ",
    ".2.   ", ".2.   ", "1     ", ".2    ", ".2    ", "3.    ", "32    ",
    "32    ", "1     ", ".2    ", ".2    ", "3.    ", "32    ", "32    ",
    "1     ", ".m.   ", "3m.   ", "3m.   ", "3m.   ", "1     ", "..m   ",
    "3..   ", "3.m   ", "1     ", "3..   ", "3..   ", "3..   ", "1     ",
    "3..   ", "3..   ", "1     ", ".m    ", "3m    ", "1     ", ".m    ",
    "3m    ", "1     ", "3.    ", "1     ", "3.    ", "1     ", "..m   ",
    "..2   ", "..2   ", "3..   ", "..2/m ", "..2/m ", "3.m   ", "3.2   ",
    "3.2   ", "-3.m  ", "-3.m  ", "1     ", "..2   ", "-1    ", "3..   ",
    "3..   ", "3.2   ", "3.2   ", "-3..  ", "3.2   ", "1     ", ".m.   ",
    ".2.   ", ".2.   ", ".2/m. ", ".2/m. ", "3m.   ", "3m.   ", "-3m.  ",
    "-3m.  ", "1     ", ".2.   ", "-1    ", "3..   ", "3..   ", "-3..  ",
    "32.   ", "1     ", ".m    ", ".2    ", ".2    ", ".2/m  ", ".2/m  ",
    "3m    ", "-3m   ", "-3m   ", "1     ", ".m    ", ".2    ", ".2    ",
    ".2/m  ", ".2/m  ", "3m    ", "-3m   ", "-3m   ", "1     ", ".2    ",
    "-1    ", "3.    ", "-3.   ", "32    ", "1     ", ".2    ", "-1    ",
    "3.    ", "-3.   ", "32    ", "1     ", "2..   ", "3..   ", "6..   ",
    "1     ", "1     ", "1     ", "2..   ", "2..   ", "1     ", "2..   ",
    "2..   ", "1     ", "3..   ", "3..   ", "1     ", "m..   ", "m..   ",
    "3..   ", "3..   ", "3..   ", "-6..  ", "-6..  ", "-6..  ", "-6..  ",
    "-6..  ", "-6..  ", "1     ", "m..   ", "m..   ", "2..   ", "3..   ",
    "2/m.. ", "2/m.. ", "6..   ", "-6..  ", "-6..  ", "6/m.. ", "6/m.. ",
    "1     ", "m..   ", "-1    ", "3..   ", "3..   ", "-6..  ", "-6..  ",
    "-3..  ", "-6..  ", "1     ", "..2   ", "..2   ", ".2.   ", ".2.   ",
    "2..   ", "3..   ", "222   ", "222   ", "6..   ", "3.2   ", "3.2   ",
    "622   ", "622   ", "1     ", "..2   ", ".2.   ", "1     ", "..2   ",
    ".2.   ", "1     ", "..2   ", "..2   ", ".2.   ", ".2.   ", "2..   ",
    "2..   ", "222   ", "222   ", "222   ", "222   ", "1     ", "..2   ",
    "..2   ", ".2.   ", ".2.   ", "2..   ", "2..   ", "222   ", "222   ",
    "222   ", "222   ", "1     ", "..2   ", ".2.   ", "3..   ", "3..   ",
    "3.2   ", "3.2   ", "3.2   ", "32.   ", "1     ", ".m.   ", "..m   ",
    "2mm   ", "3m.   ", "6mm   ", "1     ", "2..   ", "3..   ", "6..   ",
    "1     ", "..m   ", "3..   ", "3.m   ", "1     ", ".m.   ", "3m.   ",
    "3m.   ", "1     ", ".m.   ", "m..   ", "m..   ", "mm2   ", "mm2   ",
    "3m.   ", "3m.   ", "3m.   ", "-6m2  ", "-6m2  ", "-6m2  ", "-6m2  ",
    "-6m2  ", "-6m2  ", "1     ", "m..   ", "..2   ", "3..   ", "3..   ",
    "3..   ", "-6..  ", "3.2   ", "-6..  ", "3.2   ", "-6..  ", "3.2   ",
    "1     ", "m..   ", "m..   ", "..m   ", "3..   ", "m2m   ", "m2m   ",
    "3.m   ", "-6..  ", "-6..  ", "-62m  ", "-62m  ", "1     ", "m..   ",
    ".2.   ", "3..   ", "3..   ", "-6..  ", "-6..  ", "-6..  ", "32.   ",
    "1     ", "m..   ", "m..   ", ".m.   ", "..m   ", "mm2   ", "mm2   ",
    "m2m   ", "m2m   ", "2mm   ", "3m.   ", "mmm   ", "mmm   ", "6mm   ",
    "-6m2  ", "-6m2  ", "6/mmm ", "6/mmm ", "1     ", "m..   ", "..2   ",
    ".2.   ", "2..   ", "3..   ", "2/m.. ", "222   ", "6..   ", "-6..  ",
    "3.2   ", "6/m.. ", "622   ", "1     ", "..m   ", "m..   ", "..2   ",
    "3..   ", "m2m   ", "..2/m ", "3.m   ", "3.2   ", "-6..  ", "-3.m  ",
    "-62m  ", "1     ", ".m.   ", "m..   ", ".2.   ", "mm2   ", ".2/m. ",
    "3m.   ", "3m.   ", "-6m2  ", "-6m2  ", "-6m2  ", "-3m.  ", "1     ",
    "2..   ", "2..   ", "2..   ", "2..   ", ".3.   ", "222.. ", "222.. ",
    "23.   ", "23.   ", "1     ", "2..   ", "2..   ", ".3.   ", "23.   ",
    "23.   ", "23.   ", "23.   ", "1     ", "2..   ", "2..   ", ".3.   ",
    "222.. ", "23.   ", "1     ", ".3.   ", "1     ", "2..   ", ".3.   ",
    "1     ", "m..   ", "m..   ", ".3.   ", "mm2.. ", "mm2.. ", "mm2.. ",
    "mm2.. ", "mmm.. ", "mmm.. ", "m-3.  ", "m-3.  ", "1     ", "2..   ",
    "2..   ", ".3.   ", "222.. ", ".-3.  ", ".-3.  ", "23.   ", "1     ",
    "2..   ", "2..   ", ".3.   ", "222.. ", ".-3.  ", ".-3.  ", "23.   ",
    "1     ", "m..   ", "2..   ", ".3.   ", "mm2.. ", "2/m.. ", "23.   ",
    "m-3.  ", "m-3.  ", "1     ", "2..   ", ".3.   ", ".-3.  ", ".-3.  ",
    "23.   ", "23.   ", "1     ", "2..   ", ".3.   ", ".-3.  ", ".-3.  ",
    "23.   ", "23.   ", "1     ", "m..   ", ".3.   ", "mm2.. ", "mm2.. ",
    ".-3.  ", "mmm.. ", "m-3.  ", "1     ", ".3.   ", ".-3.  ", ".-3.  ",
    "1     ", "2..   ", ".3.   ", ".-3.  ", ".-3.  ", "1     ", "..2   ",
    "..2   ", "2..   ", ".3.   ", "4..   ", "4..   ", "42.2  ", "42.2  ",
    "432   ", "432   ", "1     ", "..2   ", "..2   ", "2..   ", "2..   ",
    "2..   ", ".3.   ", "2.22  ", "2.22  ", "222.. ", ".32   ", ".32   ",
    "23.   ", "1     ", "2..   ", "..2   ", "..2   ", ".3.   ", "4..   ",
    "2.22  ", "23.   ", "432   ", "432   ", "1     ", "..2   ", "2..   ",
    ".3.   ", ".32   ", ".32   ", "23.   ", "23.   ", "1     ", "..2   ",
    "..2   ", "2..   ", ".3.   ", "4..   ", "2.22  ", ".32   ", "42.2  ",
    "432   ", "1     ", "..2   ", ".3.   ", ".32   ", ".32   ", "1     ",
    "..2   ", ".3.   ", ".32   ", ".32   ", "1     ", "..2   ", "..2   ",
    "2..   ", ".3.   ", "2.22  ", "2.22  ", ".32   ", ".32   ", "1     ",
    "..m   ", "2..   ", "2.mm  ", "2.mm  ", ".3m   ", "-42.m ", "-42.m ",
    "-43m  ", "-43m  ", "1     ", "..m   ", "2.mm  ", "2.mm  ", ".3m   ",
    "-43m  ", "-43m  ", "-43m  ", "-43m  ", "1     ", "..m   ", "2..   ",
    "2.mm  ", "-4..  ", ".3m   ", "-42.m ", "-43m  ", "1     ", "2..   ",
    "2..   ", "2..   ", ".3.   ", "-4..  ", "-4..  ", "222.. ", "23.   ",
    "1     ", "2..   ", "2..   ", ".3.   ", "-4..  ", "-4..  ", "23.   ",
    "23.   ", "1     ", "2..   ", ".3.   ", "-4..  ", "-4..  ", "1     ",
    "..m   ", "m..   ", "m..   ", "m.m2  ", "m.m2  ", "mm2.. ", ".3m   ",
    "4m.m  ", "4m.m  ", "4/mm.m", "4/mm.m", "m-3m  ", "m-3m  ", "1     ",
    "..2   ", "2..   ", ".3.   ", "4..   ", "-4..  ", ".-3.  ", "42.2  ",
    "432   ", "1     ", "..2   ", "2..   ", ".3.   ", "4..   ", "-4..  ",
    ".-3.  ", "42.2  ", "432   ", "1     ", "m..   ", "..2   ", ".3.   ",
    "mm2.. ", "mm2.. ", "mm2.. ", ".32   ", "-4m.2 ", "-4m.2 ", "mmm.. ",
    "m-3.  ", "1     ", "..m   ", "..2   ", "..2   ", "2..   ", "2.mm  ",
    "2.22  ", ".3m   ", "-42.m ", ".-3m  ", ".-3m  ", "-43m  ", "1     ",
    "..m   ", "..2   ", "..2   ", "2..   ", "2.mm  ", "2.22  ", ".3m   ",
    "-42.m ", ".-3m  ", ".-3m  ", "-43m  ", "1     ", "..m   ", "m..   ",
    "m.m2  ", "m.m2  ", "2.mm  ", ".3m   ", "4m.m  ", "m.mm  ", "-43m  ",
    "m-3m  ", "m-3m  ", "1     ", "m..   ", "..2   ", ".3.   ", "4..   ",
    "mm2.. ", "4/m.. ", "-4m.2 ", "m-3.  ", "432   ", "1     ", "..2   ",
    "..m   ", "2.mm  ", ".3m   ", ".-3m  ", ".-3m  ", "-43m  ", "-43m  ",
    "1     ", "..2   ", "..m   ", "2.mm  ", ".3m   ", ".-3m  ", ".-3m  ",
    "-43m  ", "-43m  ", "1     ", "..2   ", "2..   ", ".3.   ", "-4..  ",
    ".-3.  ", ".32   ", "23.   ", "1     ", "..2   ", "2..   ", ".3.   ",
    "-4..  ", ".-3.  ", ".32   ", "23.   ", "1     ", "..m   ", "m..   ",
    "..2   ", "m.m2  ", "mm2.. ", ".3m   ", "4m.m  ", "-4m.2 ", ".-3m  ",
    "4/mm.m", "m-3m  ", "1     ", "..2   ", "2..   ", ".3.   ", "-4..  ",
    "2.22  ", ".32   ", ".-3.  ", "1     ", "1     ", "-1    ", "-1    ",
    "-1    ", "-1    ", "1     ", "2     ", "2     ", "2     ", "2     ",
    "1     ", "m     ", "1     ", "1     ", "1     ", "1     ", "m     ",
    "2     ", "2     ", "2     ", "2     ", "2/m   ", "2/m   ", "2/m   ",
    "2/m   ", "1     ", "2     ", "2     ", "-1    ", "-1    ", "1     ",
    "2     ", "2     ", "-1    ", "-1    ", "1     ", "2     ", "2     ",
    "-1    ", "-1    ", "1     ", "2     ", "2     ", "1     ", "2     ",
    "2     ", "1     ", "1     ", "1     ", "2     ", "1     ", "2     ",
    "1     ", "m     ", "m     ", "1     ", "m     ", "m     ", "1     ",
    "1     ", "1     ", "m     ", "1     ", "m     ", "1     ", "m     ",
    "m     ", "2     ", "2     ", "2/m   ", "2/m   ", "2/m   ", "2/m   ",
    "1     ", "m     ", "m     ", "2     ", "2     ", "2/m   ", "2/m   ",
    "2/m   ", "2/m   ", "1     ", "m     ", "-1    ", "-1    ", "1     ",
    "m     ", "-1    ", "-1    ", "1     ", "2     ", "-1    ", "-1    ",
    "1     ", "2     ", "-1    ", "-1    ", "1     ", "-1    ", "-1    ",
    "1     ", "-1    ", "-1    ", "1     ", "m     ", "2     ", "-1    ",
    "2/m   ", "2/m   ", "1     ", "m     ", "2     ", "-1    ", "2/m   ",
    "2/m   ", "1     ", "..2   ", "..2   ", "..2   ", "..2   ", ".2.   ",
    ".2.   ", "2..   ", "2..   ", "222   ", "222   ", "222   ", "222   ",
    "1     ", ".2.   ", "..2   ", "..2   ", "1     ", ".2.   ", "..2   ",
    "..2   ", "1     ", "..2   ", "..2   ", "1     ", "..2   ", "..2   ",
    "..2   ", ".2.   ", "2..   ", "222   ", "222   ", "1     ", "m..   ",
    "m..   ", ".m.   ", ".m.   ", "mm2   ", "mm2   ", "mm2   ", "mm2   ",
    "1     ", "m..   ", "..2   ", "..2   ", "1     ", "m..   ", "..2   ",
    "..2   ", "1     ", "..2   ", "..2   ", "1     ", "m..   ", ".m.   ",
    "..2   ", "mm2   ", "mm2   ", "1     ", "..m   ", "m..   ", "m..   ",
    "m2m   ", "m2m   ", "1     ", "..m   ", "m..   ", "m..   ", "m2m   ",
    "m2m   ", "1     ", "m..   ", "m..   ", "1     ", "m..   ", "m..   ",
    "1     ", "..m   ", "1     ", "..m   ", "1     ", ".2.   ", ".2.   ",
    "1     ", ".2.   ", ".2.   ", "1     ", "m..   ", ".2.   ", "1     ",
    "m..   ", ".2.   ", "1     ", "m..   ", "1     ", "m..   ", "1     ",
    "1     ", "1     ", ".2.   ", "1     ", ".2.   ", "1     ", "..m   ",
    "m..   ", "m2m   ", "1     ", "..m   ", "m..   ", "m2m   ", "1     ",
    "m..   ", ".2.   ", "1     ", "m..   ", ".2.   ", "1     ", "..m   ",
    ".m.   ", ".m.   ", "m..   ", "m..   ", "mm2   ", "mm2   ", "mm2   ",
    "mm2   ", "m2m   ", "m2m   ", "2mm   ", "2mm   ", "mmm   ", "mmm   ",
    "mmm   ", "mmm   ", "1     ", "m..   ", "2..   ", "2..   ", "..2   ",
    "..2   ", ".2.   ", "222   ", "222   ", "2/m.. ", "2/m.. ", "1     ",
    "m..   ", "2..   ", "2..   ", "..2   ", "..2   ", ".2.   ", "222   ",
    "222   ", "2/m.. ", "2/m.. ", "1     ", "..2   ", "..2   ", ".2.   ",
    "2..   ", "-1    ", "222   ", "222   ", "1     ", "m..   ", "..m   ",
    "..2   ", "..2   ", "m2m   ", "..2/m ", "..2/m ", "1     ", "m..   ",
    "..m   ", "..2   ", "..2   ", "m2m   ", "..2/m ", "..2/m ", "1     ",
    "m..   ", ".m.   ", ".m.   ", ".2.   ", "mm2   ", "mm2   ", ".2/m. ",
    ".2/m. ", "1     ", "m..   ", ".m.   ", ".m.   ", ".2.   ", "mm2   ",
    "mm2   ", ".2/m. ", ".2/m. ", "1     ", "m..   ", "..2   ", "2..   ",
    "2/m.. ", "2/m.. ", "1     ", "m..   ", "..2   ", "2..   ", "2/m.. ",
    "2/m.. ", "1     ", "2..   ", "..2   ", "-1    ", "1     ", "2..   ",
    "..2   ", "-1    ", "1     ", "..m   ", "..2   ", "..2   ", "..2/m ",
    "..2/m ", "1     ", ".m.   ", "..2   ", "-1    ", "1     ", ".m.   ",
    "..2   ", "-1    ", "1     ", ".m.   ", "m..   ", "-1    ", "mm2   ",
    "mm2   ", "1     ", "..m   ", ".m.   ", "m..   ", "..2   ", "mm2   ",
    "mm2   ", "m2m   ", "2mm   ", "..2/m ", "mmm   ", "mmm   ", "1     ",
    ".m.   ", "m..   ", "..2   ", ".2.   ", "2..   ", "mm2   ", ".2/m. ",
    "2/m.. ", "222   ", "1     ", "2..   ", "4..   ", "4..   ", "1     ",
    "2..   ", "2..   ", "2..   ", "-4..  ", "-4..  ", "1     ", "m..   ",
    "2..   ", "4..   ", "4..   ", "2/m.. ", "4/m.. ", "4/m.. ", "1     ",
    "2..   ", "-1    ", "4..   ", "-4..  ", "1     ", "2..   ", "-1    ",
    "4..   ", "-4..  ", "1     ", ".2.   ", ".2.   ", "..2   ", "2..   ",
    "4..   ", "4..   ", "222   ", "422   ", "422   ", "1     ", "..2   ",
    "2..   ", "4..   ", "2.22  ", "1     ", ".m.   ", ".m.   ", "..m   ",
    "2mm.  ", "4mm   ", "4mm   ", "1     ", "..m   ", "2.mm  ", "4..   ",
    "1     ", "..m   ", "2..   ", ".2.   ", ".2.   ", "2.mm  ", "2.mm  ",
    "222   ", "-42m  ", "-42m  ", "1     ", "..m   ", "2..   ", "2.mm  ",
    "-4..  ", "1     ", ".m.   ", ".m.   ", "..2   ", "2mm.  ", "2mm.  ",
    "2mm.  ", "-4m2  ", "-4m2  ", "1     ", "..2   ", "2..   ", "2..   ",
    "2.22  ", "-4..  ", "1     ", ".m.   ", ".m.   ", "..m   ", "m..   ",
    "m2m.  ", "m2m.  ", "m.2m  ", "2mm.  ", "4mm   ", "4mm   ", "mmm.  ",
    "4/mmm ", "4/mmm ", "1     ", "..m   ", ".2.   ", "..2   ", "2.mm  ",
    "4..   ", "..2/m ", "-42m  ", "422   ", "1     ", "..m   ", ".2.   ",
    "..2   ", "2.mm  ", "4..   ", "..2/m ", "-42m  ", "422   ", "1     ",
    "..m   ", "m..   ", "m.2m  ", "2.mm  ", "4..   ", "m.mm  ", "4/m.. ",
    "1     ", "..m   ", ".m.   ", "..2   ", "2mm.  ", "..2/m ", "4mm   ",
    "-4m2  ", "1     ", "..m   ", ".m.   ", "..2   ", "2mm.  ", "..2/m ",
    "4mm   ", "-4m2  ", "1     ", "3..   ", "3..   ", "3..   ", "1     ",
    "-1    ", "3..   ", "3..   ", "-3..  ", "1     ", "..2   ", "3..   ",
    "3..   ", "3..   ", "3.2   ", "3.2   ", "3.2   ", "1     ", ".2.   ",
    "3..   ", "3..   ", "32.   ", "1     ", ".m.   ", "3m.   ", "3m.   ",
    "3m.   ", "1     ", "..m   ", "3..   ", "3.m   ", "1     ", "..m   ",
    "..2   ", "3..   ", "..2/m ", "3.m   ", "3.2   ", "-3.m  ", "1     ",
    ".m.   ", ".2.   ", ".2/m. ", "3m.   ", "3m.   ", "-3m.  ", "1     ",
    "2..   ", "3..   ", "6..   ", "1     ", "m..   ", "3..   ", "3..   ",
    "3..   ", "-6..  ", "-6..  ", "-6..  ", "1     ", "m..   ", "2..   ",
    "3..   ", "2/m.. ", "6..   ", "-6..  ", "6/m.. ", "1     ", "..2   ",
    ".2.   ", "2..   ", "3..   ", "222   ", "6..   ", "3.2   ", "622   ",
    "1     ", ".m.   ", "..m   ", "2mm   ", "3m.   ", "6mm   ", "1     ",
    ".m.   ", "m..   ", "mm2   ", "3m.   ", "3m.   ", "3m.   ", "-6m2  ",
    "-6m2  ", "-6m2  ", "1     ", "m..   ", "..m   ", "3..   ", "m2m   ",
    "3.m   ", "-6..  ", "-62m  ", "1     ", "m..   ", ".m.   ", "..m   ",
    "mm2   ", "m2m   ", "2mm   ", "3m.   ", "mmm   ", "6mm   ", "-6m2  ",
    "6/mmm ",
};

int ssmdb_get_coordinate(int rot[3][3], double trans[3], const int index) {
    int i, rot_enc, trans_enc;
    int rows[3], trans_int[3];

    /* 'Coordinates' are compressed using ternary numerical system for */
    /* rotation and base-24 system for translation. Elements of the first column
     */
    /* of rotation matrix can be one of {-2,-1,0,1,2} and the other elements can
     */
    /* be one of {-1,0,1}. Translation can have one of */
    /* {0,2,3,4,6,8,9,10,12,14,15,16,18,20,21,22} */
    /* divided by 24. Therefore 45^3 * 24^3 = 1259712000 different values */
    /* are enough to map coordinates of Wyckoff positions. */

    rot_enc = coordinates_first[index] % 91125; /* = 45**3 */
    rows[0] = rot_enc / 2025;                   /* = 45**2 */
    rows[1] = (rot_enc % 2025) / 45;
    rows[2] = rot_enc % 45;

    for (i = 0; i < 3; i++) {
        rot[i][0] = rows[i] / 9 - 2;
        rot[i][1] = (rows[i] % 9) / 3 - 1;
        rot[i][2] = rows[i] % 3 - 1;
    }

    trans_enc = coordinates_first[index] / 91125; /* = 45**3 */
    trans_int[0] = trans_enc / 576;
    trans_int[1] = (trans_enc % 576) / 24;
    trans_int[2] = trans_enc % 24;
    for (i = 0; i < 3; i++) {
        trans[i] = ((double)trans_int[i]) / 24;
    }

    return multiplicities[index];
}

/* databases for layer group is directly added behind its spacegroup
 * counterparts */
void ssmdb_get_wyckoff_indices(int indices[2], const int index) {
    if (index > 0) {
        indices[0] = position_wyckoff[index];
        indices[1] = position_wyckoff[index + 1] - position_wyckoff[index];
    } else {
        indices[0] = position_layer_wyckoff[-index];
        indices[1] =
            position_layer_wyckoff[-index + 1] - position_layer_wyckoff[-index];
    }
}

void ssmdb_get_site_symmetry_symbol(char symbol[7], const int index) {
    int i;

    for (i = 0; i < 6; i++) {
        symbol[i] = site_symmetry_symbols[index][i];
    }
    symbol[6] = '\0';
    spgdb_remove_space(symbol, 7);
}
