/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_FENCE_H
#define VN_PROTOCOL_RENDERER_FENCE_H

#include "vn_protocol_renderer_structs.h"

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wunused-parameter"

/*
 * These structs/unions/commands are not included
 *
 *   vkGetFenceFdKHR
 *   vkImportFenceFdKHR
 */

/* struct VkExportFenceCreateInfo chain */

static inline void *
vn_decode_VkExportFenceCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkExportFenceCreateInfo_self_temp(struct vn_cs_decoder *dec, VkExportFenceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->handleTypes);
}

static inline void
vn_decode_VkExportFenceCreateInfo_temp(struct vn_cs_decoder *dec, VkExportFenceCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkExportFenceCreateInfo_pnext_temp(dec);
    vn_decode_VkExportFenceCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkExportFenceCreateInfo_handle_self(VkExportFenceCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->handleTypes */
}

static inline void
vn_replace_VkExportFenceCreateInfo_handle(VkExportFenceCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
            vn_replace_VkExportFenceCreateInfo_handle_self((VkExportFenceCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkFenceCreateInfo chain */

static inline void *
vn_decode_VkFenceCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkExportFenceCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkFenceCreateInfo_pnext_temp(dec);
            vn_decode_VkExportFenceCreateInfo_self_temp(dec, (VkExportFenceCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkFenceCreateInfo_self_temp(struct vn_cs_decoder *dec, VkFenceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
}

static inline void
vn_decode_VkFenceCreateInfo_temp(struct vn_cs_decoder *dec, VkFenceCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_FENCE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkFenceCreateInfo_pnext_temp(dec);
    vn_decode_VkFenceCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkFenceCreateInfo_handle_self(VkFenceCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
}

static inline void
vn_replace_VkFenceCreateInfo_handle(VkFenceCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_FENCE_CREATE_INFO:
            vn_replace_VkFenceCreateInfo_handle_self((VkFenceCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
            vn_replace_VkExportFenceCreateInfo_handle_self((VkExportFenceCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkCreateFence_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateFence *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pCreateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCreateInfo));
        if (!args->pCreateInfo) return;
        vn_decode_VkFenceCreateInfo_temp(dec, (VkFenceCreateInfo *)args->pCreateInfo);
    } else {
        args->pCreateInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pFence = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFence));
        if (!args->pFence) return;
        vn_decode_VkFence(dec, args->pFence);
    } else {
        args->pFence = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCreateFence_args_handle(struct vn_command_vkCreateFence *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pCreateInfo)
        vn_replace_VkFenceCreateInfo_handle((VkFenceCreateInfo *)args->pCreateInfo);
    /* skip args->pAllocator */
    /* skip args->pFence */
}

static inline void vn_encode_vkCreateFence_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateFence *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateFence_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pCreateInfo */
    /* skip args->pAllocator */
    if (vn_encode_simple_pointer(enc, args->pFence))
        vn_encode_VkFence(enc, args->pFence);
}

static inline void vn_decode_vkDestroyFence_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDestroyFence *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkFence_lookup(dec, &args->fence);
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
}

static inline void vn_replace_vkDestroyFence_args_handle(struct vn_command_vkDestroyFence *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkFence_handle(&args->fence);
    /* skip args->pAllocator */
}

static inline void vn_encode_vkDestroyFence_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDestroyFence *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDestroyFence_EXT});

    /* skip args->device */
    /* skip args->fence */
    /* skip args->pAllocator */
}

static inline void vn_decode_vkResetFences_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkResetFences *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_uint32_t(dec, &args->fenceCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->fenceCount);
        args->pFences = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFences) * iter_count);
        if (!args->pFences) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkFence_lookup(dec, &((VkFence *)args->pFences)[i]);
    } else {
        vn_decode_array_size(dec, args->fenceCount);
        args->pFences = NULL;
    }
}

static inline void vn_replace_vkResetFences_args_handle(struct vn_command_vkResetFences *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->fenceCount */
    if (args->pFences) {
       for (uint32_t i = 0; i < args->fenceCount; i++)
            vn_replace_VkFence_handle(&((VkFence *)args->pFences)[i]);
    }
}

static inline void vn_encode_vkResetFences_reply(struct vn_cs_encoder *enc, const struct vn_command_vkResetFences *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkResetFences_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->fenceCount */
    /* skip args->pFences */
}

static inline void vn_decode_vkGetFenceStatus_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetFenceStatus *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkFence_lookup(dec, &args->fence);
}

static inline void vn_replace_vkGetFenceStatus_args_handle(struct vn_command_vkGetFenceStatus *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkFence_handle(&args->fence);
}

static inline void vn_encode_vkGetFenceStatus_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetFenceStatus *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetFenceStatus_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->fence */
}

static inline void vn_decode_vkWaitForFences_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkWaitForFences *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_uint32_t(dec, &args->fenceCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->fenceCount);
        args->pFences = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFences) * iter_count);
        if (!args->pFences) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkFence_lookup(dec, &((VkFence *)args->pFences)[i]);
    } else {
        vn_decode_array_size(dec, args->fenceCount);
        args->pFences = NULL;
    }
    vn_decode_VkBool32(dec, &args->waitAll);
    vn_decode_uint64_t(dec, &args->timeout);
}

static inline void vn_replace_vkWaitForFences_args_handle(struct vn_command_vkWaitForFences *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->fenceCount */
    if (args->pFences) {
       for (uint32_t i = 0; i < args->fenceCount; i++)
            vn_replace_VkFence_handle(&((VkFence *)args->pFences)[i]);
    }
    /* skip args->waitAll */
    /* skip args->timeout */
}

static inline void vn_encode_vkWaitForFences_reply(struct vn_cs_encoder *enc, const struct vn_command_vkWaitForFences *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkWaitForFences_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->fenceCount */
    /* skip args->pFences */
    /* skip args->waitAll */
    /* skip args->timeout */
}

static inline void vn_decode_vkResetFenceResource100000MESA_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkResetFenceResource100000MESA *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkFence_lookup(dec, &args->fence);
}

static inline void vn_replace_vkResetFenceResource100000MESA_args_handle(struct vn_command_vkResetFenceResource100000MESA *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkFence_handle(&args->fence);
}

static inline void vn_encode_vkResetFenceResource100000MESA_reply(struct vn_cs_encoder *enc, const struct vn_command_vkResetFenceResource100000MESA *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkResetFenceResource100000MESA_EXT});

    /* skip args->device */
    /* skip args->fence */
}

static inline void vn_dispatch_vkCreateFence(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateFence args;

    if (!ctx->dispatch_vkCreateFence) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateFence_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateFence(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCreateFence returned %d", args.ret);
#endif

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCreateFence_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkDestroyFence(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDestroyFence args;

    if (!ctx->dispatch_vkDestroyFence) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDestroyFence_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDestroyFence(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkDestroyFence_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkResetFences(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkResetFences args;

    if (!ctx->dispatch_vkResetFences) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkResetFences_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkResetFences(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkResetFences returned %d", args.ret);
#endif

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkResetFences_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetFenceStatus(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetFenceStatus args;

    if (!ctx->dispatch_vkGetFenceStatus) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetFenceStatus_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetFenceStatus(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkGetFenceStatus returned %d", args.ret);
#endif

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetFenceStatus_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkWaitForFences(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkWaitForFences args;

    if (!ctx->dispatch_vkWaitForFences) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkWaitForFences_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkWaitForFences(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkWaitForFences returned %d", args.ret);
#endif

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkWaitForFences_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkResetFenceResource100000MESA(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkResetFenceResource100000MESA args;

    if (!ctx->dispatch_vkResetFenceResource100000MESA) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkResetFenceResource100000MESA_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkResetFenceResource100000MESA(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkResetFenceResource100000MESA_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#pragma GCC diagnostic pop

#endif /* VN_PROTOCOL_RENDERER_FENCE_H */
