// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_FSUB_D_TRACE_AARCH64_H_
#define VIXL_SIM_FSUB_D_TRACE_AARCH64_H_

const uint64_t kExpected_fsub_d[] = {
  0x0000000000000000,
  0x8010000000000000,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff8000000000000,
  0xc024000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x800123456789abcd,
  0x800fffffffffffff,
  0x8000000000000001,
  0x0000000000000000,
  0x0010000000000000,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x4024000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x000123456789abcd,
  0x000fffffffffffff,
  0x0000000000000001,
  0x0010000000000000,
  0x0000000000000000,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff8000000000000,
  0xc024000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x000edcba98765433,
  0x0000000000000001,
  0x000fffffffffffff,
  0x0010000000000000,
  0x0020000000000000,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x4024000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x001123456789abcd,
  0x001fffffffffffff,
  0x0010000000000001,
  0x3fdfffffffffffff,
  0x3fdfffffffffffff,
  0x0000000000000000,
  0xbc90000000000000,
  0xbca8000000000000,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000002,
  0xbff0000000000000,
  0xc023000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x3fdfffffffffffff,
  0x3fdfffffffffffff,
  0x3fdfffffffffffff,
  0x3fdfffffffffffff,
  0x3fdfffffffffffff,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3ff7ffffffffffff,
  0x3ff8000000000000,
  0x3ff8000000000001,
  0x4000000000000000,
  0x4025000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x3fdfffffffffffff,
  0x3fdfffffffffffff,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000000,
  0x3c90000000000000,
  0x0000000000000000,
  0xbca0000000000000,
  0xbfdffffffffffffe,
  0xbfe0000000000000,
  0xbfe0000000000002,
  0xbff0000000000000,
  0xc023000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x3fe0000000000000,
  0x3fe0000000000000,
  0x3fe0000000000000,
  0x3fe0000000000000,
  0x3fe0000000000000,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x3ff8000000000001,
  0x4000000000000000,
  0x4025000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x3fe0000000000000,
  0x3fe0000000000000,
  0x3fe0000000000000,
  0x3fe0000000000001,
  0x3fe0000000000001,
  0x3ca8000000000000,
  0x3ca0000000000000,
  0x0000000000000000,
  0xbfdffffffffffffc,
  0xbfdffffffffffffe,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xc023000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x3fe0000000000001,
  0x3fe0000000000001,
  0x3fe0000000000001,
  0x3fe0000000000001,
  0x3fe0000000000001,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x3ff8000000000002,
  0x4000000000000000,
  0x4025000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x3fe0000000000001,
  0x3fe0000000000001,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x3fefffffffffffff,
  0x3fdfffffffffffff,
  0x3fdffffffffffffe,
  0x3fdffffffffffffc,
  0x0000000000000000,
  0xbca0000000000000,
  0xbcb8000000000000,
  0xbfe0000000000001,
  0xc022000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x3fefffffffffffff,
  0x3fefffffffffffff,
  0x3fefffffffffffff,
  0x3fefffffffffffff,
  0x3fefffffffffffff,
  0x3ff7ffffffffffff,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x3fffffffffffffff,
  0x4000000000000000,
  0x4000000000000000,
  0x4004000000000000,
  0x4026000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x3fefffffffffffff,
  0x3fefffffffffffff,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3fe0000000000000,
  0x3fe0000000000000,
  0x3fdffffffffffffe,
  0x3ca0000000000000,
  0x0000000000000000,
  0xbcb0000000000000,
  0xbfe0000000000000,
  0xc022000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x4000000000000000,
  0x4000000000000000,
  0x4000000000000000,
  0x4004000000000000,
  0x4026000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff0000000000001,
  0x3fe0000000000002,
  0x3fe0000000000002,
  0x3fe0000000000001,
  0x3cb8000000000000,
  0x3cb0000000000000,
  0x0000000000000000,
  0xbfdffffffffffffc,
  0xc022000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x3ff0000000000001,
  0x3ff0000000000001,
  0x3ff0000000000001,
  0x3ff0000000000001,
  0x3ff0000000000001,
  0x3ff8000000000001,
  0x3ff8000000000001,
  0x3ff8000000000002,
  0x4000000000000000,
  0x4000000000000000,
  0x4000000000000001,
  0x4004000000000000,
  0x4026000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x3ff0000000000001,
  0x3ff0000000000001,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x3ff0000000000000,
  0x3ff0000000000000,
  0x3fefffffffffffff,
  0x3fe0000000000001,
  0x3fe0000000000000,
  0x3fdffffffffffffc,
  0x0000000000000000,
  0xc021000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x4000000000000000,
  0x4000000000000000,
  0x4000000000000000,
  0x4004000000000000,
  0x4004000000000000,
  0x4004000000000000,
  0x4008000000000000,
  0x4027000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x3ff8000000000000,
  0x4024000000000000,
  0x4024000000000000,
  0x4023000000000000,
  0x4023000000000000,
  0x4023000000000000,
  0x4022000000000000,
  0x4022000000000000,
  0x4022000000000000,
  0x4021000000000000,
  0x0000000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x4024000000000000,
  0x4024000000000000,
  0x4024000000000000,
  0x4024000000000000,
  0x4024000000000000,
  0x4025000000000000,
  0x4025000000000000,
  0x4025000000000000,
  0x4026000000000000,
  0x4026000000000000,
  0x4026000000000000,
  0x4027000000000000,
  0x4034000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x4024000000000000,
  0x4024000000000000,
  0x4024000000000000,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x0000000000000000,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0xfff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0xfff923456789abcd,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff923456789abcd,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x7ff0000000000000,
  0x000123456789abcd,
  0x800edcba98765433,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff8000000000000,
  0xc024000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x0000000000000000,
  0x800edcba98765432,
  0x000123456789abcc,
  0x000123456789abcd,
  0x001123456789abcd,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x4024000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x0002468acf13579a,
  0x001123456789abcc,
  0x000123456789abce,
  0x000fffffffffffff,
  0x8000000000000001,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff8000000000000,
  0xc024000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x000edcba98765432,
  0x0000000000000000,
  0x000ffffffffffffe,
  0x000fffffffffffff,
  0x001fffffffffffff,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x4024000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x001123456789abcc,
  0x001ffffffffffffe,
  0x0010000000000000,
  0x0000000000000001,
  0x800fffffffffffff,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff8000000000000,
  0xc024000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x800123456789abcc,
  0x800ffffffffffffe,
  0x0000000000000000,
  0x0000000000000001,
  0x0010000000000001,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x4024000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x000123456789abce,
  0x0010000000000000,
  0x0000000000000002,
  0x8000000000000000,
  0x8010000000000000,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff8000000000000,
  0xc024000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x800123456789abcd,
  0x800fffffffffffff,
  0x8000000000000001,
  0x0000000000000000,
  0x0010000000000000,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x4024000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x000123456789abcd,
  0x000fffffffffffff,
  0x0000000000000001,
  0x8010000000000000,
  0x8020000000000000,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff8000000000000,
  0xc024000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x801123456789abcd,
  0x801fffffffffffff,
  0x8010000000000001,
  0x8010000000000000,
  0x0000000000000000,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x4024000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x800edcba98765433,
  0x8000000000000001,
  0x800fffffffffffff,
  0xbfdfffffffffffff,
  0xbfdfffffffffffff,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbff7ffffffffffff,
  0xbff8000000000000,
  0xbff8000000000001,
  0xc000000000000000,
  0xc025000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0xbfdfffffffffffff,
  0xbfdfffffffffffff,
  0xbfdfffffffffffff,
  0xbfdfffffffffffff,
  0xbfdfffffffffffff,
  0x0000000000000000,
  0x3c90000000000000,
  0x3ca8000000000000,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000002,
  0x3ff0000000000000,
  0x4023000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0xbfdfffffffffffff,
  0xbfdfffffffffffff,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000000,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbff8000000000000,
  0xbff8000000000000,
  0xbff8000000000001,
  0xc000000000000000,
  0xc025000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0xbfe0000000000000,
  0xbfe0000000000000,
  0xbfe0000000000000,
  0xbfe0000000000000,
  0xbfe0000000000000,
  0xbc90000000000000,
  0x0000000000000000,
  0x3ca0000000000000,
  0x3fdffffffffffffe,
  0x3fe0000000000000,
  0x3fe0000000000002,
  0x3ff0000000000000,
  0x4023000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0xbfe0000000000000,
  0xbfe0000000000000,
  0xbfe0000000000000,
  0xbfe0000000000001,
  0xbfe0000000000001,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff8000000000000,
  0xbff8000000000000,
  0xbff8000000000002,
  0xc000000000000000,
  0xc025000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0xbfe0000000000001,
  0xbfe0000000000001,
  0xbfe0000000000001,
  0xbfe0000000000001,
  0xbfe0000000000001,
  0xbca8000000000000,
  0xbca0000000000000,
  0x0000000000000000,
  0x3fdffffffffffffc,
  0x3fdffffffffffffe,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x4023000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0xbfe0000000000001,
  0xbfe0000000000001,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xbfefffffffffffff,
  0xbff7ffffffffffff,
  0xbff8000000000000,
  0xbff8000000000000,
  0xbfffffffffffffff,
  0xc000000000000000,
  0xc000000000000000,
  0xc004000000000000,
  0xc026000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0xbfefffffffffffff,
  0xbfefffffffffffff,
  0xbfefffffffffffff,
  0xbfefffffffffffff,
  0xbfefffffffffffff,
  0xbfdfffffffffffff,
  0xbfdffffffffffffe,
  0xbfdffffffffffffc,
  0x0000000000000000,
  0x3ca0000000000000,
  0x3cb8000000000000,
  0x3fe0000000000001,
  0x4022000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0xbfefffffffffffff,
  0xbfefffffffffffff,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbff8000000000000,
  0xbff8000000000000,
  0xbff8000000000000,
  0xc000000000000000,
  0xc000000000000000,
  0xc000000000000000,
  0xc004000000000000,
  0xc026000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbfe0000000000000,
  0xbfe0000000000000,
  0xbfdffffffffffffe,
  0xbca0000000000000,
  0x0000000000000000,
  0x3cb0000000000000,
  0x3fe0000000000000,
  0x4022000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff0000000000001,
  0xbff8000000000001,
  0xbff8000000000001,
  0xbff8000000000002,
  0xc000000000000000,
  0xc000000000000000,
  0xc000000000000001,
  0xc004000000000000,
  0xc026000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0xbff0000000000001,
  0xbff0000000000001,
  0xbff0000000000001,
  0xbff0000000000001,
  0xbff0000000000001,
  0xbfe0000000000002,
  0xbfe0000000000002,
  0xbfe0000000000001,
  0xbcb8000000000000,
  0xbcb0000000000000,
  0x0000000000000000,
  0x3fdffffffffffffc,
  0x4022000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0xbff0000000000001,
  0xbff0000000000001,
  0xbff0000000000001,
  0xbff8000000000000,
  0xbff8000000000000,
  0xc000000000000000,
  0xc000000000000000,
  0xc000000000000000,
  0xc004000000000000,
  0xc004000000000000,
  0xc004000000000000,
  0xc008000000000000,
  0xc027000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0xbff8000000000000,
  0xbff8000000000000,
  0xbff8000000000000,
  0xbff8000000000000,
  0xbff8000000000000,
  0xbff0000000000000,
  0xbff0000000000000,
  0xbfefffffffffffff,
  0xbfe0000000000001,
  0xbfe0000000000000,
  0xbfdffffffffffffc,
  0x0000000000000000,
  0x4021000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0xbff8000000000000,
  0xbff8000000000000,
  0xbff8000000000000,
  0xc024000000000000,
  0xc024000000000000,
  0xc025000000000000,
  0xc025000000000000,
  0xc025000000000000,
  0xc026000000000000,
  0xc026000000000000,
  0xc026000000000000,
  0xc027000000000000,
  0xc034000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0xc024000000000000,
  0xc024000000000000,
  0xc024000000000000,
  0xc024000000000000,
  0xc024000000000000,
  0xc023000000000000,
  0xc023000000000000,
  0xc023000000000000,
  0xc022000000000000,
  0xc022000000000000,
  0xc022000000000000,
  0xc021000000000000,
  0x0000000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0xc024000000000000,
  0xc024000000000000,
  0xc024000000000000,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xfff0000000000000,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0x0000000000000000,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xffefffffffffffff,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0x7ff8000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff8000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0x7ff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0x7ff923456789abcd,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff8000000000000,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff923456789abcd,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0x7ff8000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff8000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0xfff0000000000000,
  0x800123456789abcd,
  0x801123456789abcd,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff8000000000000,
  0xc024000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x8002468acf13579a,
  0x801123456789abcc,
  0x800123456789abce,
  0x800123456789abcd,
  0x000edcba98765433,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x4024000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x0000000000000000,
  0x000edcba98765432,
  0x800123456789abcc,
  0x800fffffffffffff,
  0x801fffffffffffff,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff8000000000000,
  0xc024000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x801123456789abcc,
  0x801ffffffffffffe,
  0x8010000000000000,
  0x800fffffffffffff,
  0x0000000000000001,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x4024000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x800edcba98765432,
  0x0000000000000000,
  0x800ffffffffffffe,
  0x8000000000000001,
  0x8010000000000001,
  0xbfdfffffffffffff,
  0xbfe0000000000000,
  0xbfe0000000000001,
  0xbfefffffffffffff,
  0xbff0000000000000,
  0xbff0000000000001,
  0xbff8000000000000,
  0xc024000000000000,
  0xffefffffffffffff,
  0xfff0000000000000,
  0x7ff923456789abcd,
  0x7ff8000000000000,
  0x7ff923456789abcd,
  0xfff0000000000000,
  0x800123456789abce,
  0x8010000000000000,
  0x8000000000000002,
  0x8000000000000001,
  0x000fffffffffffff,
  0x3fdfffffffffffff,
  0x3fe0000000000000,
  0x3fe0000000000001,
  0x3fefffffffffffff,
  0x3ff0000000000000,
  0x3ff0000000000001,
  0x3ff8000000000000,
  0x4024000000000000,
  0x7fefffffffffffff,
  0x7ff0000000000000,
  0xfff923456789abcd,
  0xfff8000000000000,
  0xfff923456789abcd,
  0x7ff0000000000000,
  0x000123456789abcc,
  0x000ffffffffffffe,
  0x0000000000000000,
};
const unsigned kExpectedCount_fsub_d = 1444;

#endif  // VIXL_SIM_FSUB_D_TRACE_AARCH64_H_
