/* <<< Start of information >>>                                             */
/* This file is part of the xcolmix package.                                */
/* Copyright (C) 1996  Karel Kubat. All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */
/* Form definition file generated with fdesign. */

#include <X11/forms.h>
#include <stdlib.h>
#include "design.h"

FL_FORM *colormixer;

FL_OBJECT
        *logo,
        *red_slider,
        *green_slider,
        *blue_slider,
        *foreground_button,
        *background_button,
        *hexdisplay;

void create_form_colormixer(void)
{
  FL_OBJECT *obj;

  if (colormixer)
     return;

  colormixer = fl_bgn_form(FL_NO_BOX,320,230);
  obj = fl_add_box(FL_UP_BOX,0,0,320,230,"");
  logo = obj = fl_add_text(FL_NORMAL_TEXT,10,10,140,70,"Color Mixer\nV1.00");
    fl_set_object_lcol(obj,FL_BLUE);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE);
  obj = fl_add_button(FL_NORMAL_BUTTON,235,180,75,35,"Quit");
    fl_set_button_shortcut(obj,"Qq^Q^[",1);
    fl_set_object_callback(obj,cb_quit,0);
  red_slider = obj = fl_add_valslider(FL_HOR_SLIDER,40,85,270,25,"Red");
    fl_set_object_lsize(obj,FL_DEFAULT_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT);
    fl_set_object_callback(obj,cb_red,0);
     fl_set_slider_return(obj, FL_RETURN_CHANGED);
  green_slider = obj = fl_add_valslider(FL_HOR_SLIDER,40,115,270,25,"Green");
    fl_set_object_lsize(obj,FL_DEFAULT_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT);
    fl_set_object_callback(obj,cb_green,0);
     fl_set_slider_return(obj, FL_RETURN_CHANGED);
  blue_slider = obj = fl_add_valslider(FL_HOR_SLIDER,40,145,270,25,"Blue");
    fl_set_object_lsize(obj,FL_DEFAULT_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT);
    fl_set_object_callback(obj,cb_blue,0);
     fl_set_slider_return(obj, FL_RETURN_CHANGED);
  obj = fl_add_button(FL_NORMAL_BUTTON,145,180,75,35,"Lookup");
    fl_set_button_shortcut(obj,"Ll",1);
    fl_set_object_callback(obj,cb_lookup,0);
  foreground_button = obj = fl_add_checkbutton(FL_PUSH_BUTTON,20,180,20,20,"Foreground");
    fl_set_button_shortcut(obj,"Ff",1);
    fl_set_object_callback(obj,cb_select_foreground,0);
  background_button = obj = fl_add_checkbutton(FL_PUSH_BUTTON,20,200,20,20,"Background");
    fl_set_button_shortcut(obj,"Bb",1);
    fl_set_object_callback(obj,cb_select_background,0);
  hexdisplay = obj = fl_add_browser(FL_NORMAL_BROWSER,160,10,150,70,"");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_FIXEDBOLD_STYLE);
  fl_end_form();

}
/*---------------------------------------*/

FL_FORM *lookup;

FL_OBJECT
        *lookup_browser,
        *search_input;

void create_form_lookup(void)
{
  FL_OBJECT *obj;

  if (lookup)
     return;

  lookup = fl_bgn_form(FL_NO_BOX,315,375);
  obj = fl_add_box(FL_UP_BOX,0,0,315,375,"");
  lookup_browser = obj = fl_add_browser(FL_HOLD_BROWSER,10,40,295,325,"");
    fl_set_object_callback(obj,cb_selectcolor,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,195,5,110,30,"Dismiss");
    fl_set_object_callback(obj,cb_lookupdone,0);
  search_input = obj = fl_add_input(FL_NORMAL_INPUT,50,5,135,30,"Search:");
    fl_set_object_callback(obj,cb_search,0);
  fl_end_form();

}
/*---------------------------------------*/

void create_the_forms(void)
{
  create_form_colormixer();
  create_form_lookup();
}

