/* <<< Start of information >>>                                             */
/* This file is part of the xcolmix package.                                */
/* Copyright (C) 1996  Karel Kubat. All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xcolmix.h"
#include "version.h" 

void initforms ()
{
    /* initialize fore/background color */
    makecolor ();

    /* make all forms */
    create_the_forms ();
    
    /* color mixer form definition */
    /* --------------------------- */

    /* color redefs of logo */
    fl_set_object_lcol (logo, FG_COL);
    fl_set_object_color (logo, BG_COL, 0);

    /* color redefs of hex display and font */
    fl_set_object_lcol (hexdisplay, FG_COL);
    fl_set_object_color (hexdisplay, BG_COL, 0);
    fl_set_browser_fontsize (hexdisplay, FL_MEDIUM_SIZE);
    fl_set_browser_fontstyle (hexdisplay, FL_FIXEDBOLD_STYLE);

    /* bounds and precisions of sliders */
    fl_set_slider_bounds (red_slider, 0, 255);
    fl_set_slider_step (red_slider, 1);
    fl_set_slider_precision (red_slider, 0); 
    fl_set_slider_value (red_slider, bg_red);
    
    fl_set_slider_bounds (green_slider, 0, 255);
    fl_set_slider_step (green_slider, 1);
    fl_set_slider_precision (green_slider, 0);
    fl_set_slider_value (green_slider, bg_green);

    fl_set_slider_bounds (blue_slider, 0, 255);
    fl_set_slider_step (blue_slider, 1);
    fl_set_slider_precision (blue_slider, 0);
    fl_set_slider_value (blue_slider, bg_blue);

    /* the lookup form definition */
    /* -------------------------- */
    
    fl_set_browser_fontstyle (lookup_browser, FL_FIXED_STYLE);
    load_lookup_browser ();
    
    /* when should the search object generate a callback */
    /* ------------------------------------------------- */
    fl_set_object_return (search_input, FL_RETURN_END);

    /* now re-display objects that affect colors */
    makecolor ();
}

