/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jde.wizards.Signature;
import jde.wizards.SignatureVisitor;

public class SignatureContainer {
    private Hashtable classes = new Hashtable();

    public final void add(Signature sig) {
        if (!this.alreadyStored(sig)) {
            String declaring = sig.getDeclaringClass().getName();
            if (this.classes.containsKey(declaring)) {
                ((Vector)this.classes.get(declaring)).addElement(sig);
            } else {
                Vector<Signature> v = new Vector<Signature>();
                v.addElement(sig);
                this.classes.put(declaring, v);
            }
        }
    }

    private final boolean alreadyStored(Signature sig) {
        Enumeration declaringClasses = this.classes.keys();
        boolean found = false;
        while (declaringClasses.hasMoreElements() && !found) {
            String interf = (String)declaringClasses.nextElement();
            Vector v = (Vector)this.classes.get(interf);
            found = v.contains(sig);
        }
        return found;
    }

    public void clear() {
        this.classes.clear();
    }

    public boolean isEmpty() {
        return this.classes.isEmpty();
    }

    public void visit(SignatureVisitor visitor) {
        Enumeration declaringClasses = this.classes.keys();
        while (declaringClasses.hasMoreElements()) {
            String className = (String)declaringClasses.nextElement();
            Vector v = (Vector)this.classes.get(className);
            boolean firstOfClass = true;
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                Signature sig = (Signature)e.nextElement();
                visitor.visit(sig, firstOfClass);
                firstOfClass = false;
            }
        }
    }
}

