/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: utils.c,v 1.4 2000/01/18 22:29:57 rich Exp $
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "xracer.h"

void *
xmalloc (size_t n)
{
  void *p;

  if (n == 0) n = 1;            /* Fix required for AIX. */
  p = malloc (n);
  if (p == 0) { perror ("malloc"); exit (1); }
  return p;
}

void *
xrealloc (void *p, size_t n)
{
  if (n == 0) n = 1;            /* Fix required for AIX. */

  if (p == 0)                   /* For non-GNU realloc. */
    p = malloc (n);
  else
    p = realloc (p, n);
  if (p == 0) { perror ("realloc"); exit (1); }
  return p;
}

char *
xstrdup(char *p)
{
  char *r;

  if (p == NULL)
    return NULL;

  r = (char *) xmalloc (strlen(p) + 1);

  strcpy(r,p);

  return r;
}
