/* narray_ext_dfloat.c : Extention library of NArray (DFLOAT only)
 */
#include<stdio.h>
#include<string.h>
#include "ruby.h"
#include "narray.h"
#ifndef NARRAY_BIGMEM
typedef int na_shape_t;
#endif

typedef double c_num_t;
#define NATYPE NA_DFLOAT

static VALUE
cum_sum_dfloat(obj, self, dim)
     VALUE obj;
     VALUE self;
     VALUE dim;
{
    VALUE res;
    int d, dj, rank;
    struct NARRAY *na;
    na_shape_t i, j, k, ni, nj, nk, nij;
    na_shape_t *sh;
    c_num_t *p, *c;
    
    /* check & read arguments */
    dj = NUM2INT(dim);

    if (NA_TYPE(self) != NATYPE) rb_raise(rb_eArgError,"Unexpected type");
    rank = NA_RANK(self);
    if (dj<-rank || dj>=rank) rb_raise(rb_eArgError,
                     "dim (%d) out of range (%d to %d)", dj, -rank, rank-1);
    if (dj<0) dj += rank;
    
    /* interpret shape as 3D */
    GetNArray(self, na);
    sh = na->shape;
    p = (c_num_t *) NA_PTR(na, 0);
    ni = 1;
    for(d=0; d<dj; d++) ni *= sh[d];
    nj = sh[dj];
    nij = ni*nj;
    nk = 1;
    for(d=dj+1; d<rank; d++) nk *= sh[d];

    /* initialize the output object */
    res = na_make_object(NATYPE, rank, sh, cNArray);
    GetNArray(res, na);
    c = (c_num_t *) NA_PTR(na, 0);

    /* operation */
    for(k=0; k<nk; k++){
        for(i=0; i<ni; i++){
            c[i+nij*k] = p[i+nij*k];   /* copy the first element */
        }
    }
    for(k=0; k<nk; k++){
        for(j=1; j<nj; j++){
            for(i=0; i<ni; i++){
                c[i+ni*j+nij*k] = p[i+ni*j+nij*k] + c[i+ni*(j-1)+nij*k];
            }
        }
    }

    return(res);
}


// VALUE cNArray;

void
init_narray_ext_dfloat()
{
    /* 以下はどうもうまく行かない。(NArrayが拡張ライブラリだからか)
       rb_require("narray");
       // cNArray = rb_define_class("NArray", rb_cObject);
       rb_define_method(cNArray, "cum_sum_dfloat", cum_sum_dfloat, 1);
     */
    static VALUE mNumRu, mNArrayExt;
    mNumRu = rb_define_module("NumRu");
    mNArrayExt = rb_define_module_under(mNumRu, "NArrayExt");
    rb_define_module_function(mNArrayExt, "cum_sum_dfloat", cum_sum_dfloat, 2);
}
