#
# uipk03.rb
#

require "numru/dcl"

include NumRu
include Math

nx = 100
ny = 100

r = NArray.sfloat(nx, ny)
g = NArray.sfloat(nx, ny)
b = NArray.sfloat(nx, ny)

for j in 0..ny-1
  for i in 0..nx-1
    r[i,j] = exp(-((i-nx/2.0 )**2  + (j-ny/2.0)**2 ) / 5000.0)
    g[i,j] = exp(-((i-nx/1.01)**2  + (j-ny/1.02)**2) / 1000.0)
    b[i,j] = exp(-((i-ny/3.0 )**2  + (j-ny/5.0)**2 ) / 3000.0)
  end
end

rc = DCL.rnorml(r,0.0,1.0)
gc = DCL.rnorml(g,0.2,1.0)
bc = DCL.rnorml(b,0.0,1.0)

DCL.swpset('iheight', 300)
DCL.swpset('iwidth', 300)

iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i

DCL.gropn(iws)
DCL.grfrm
DCL.grswnd( -1.0, 1.0, -1.0, 1.0)
DCL.grsvpt(0.1, 0.9, 0.1, 0.9)
DCL.grstrn(1)
DCL.grstrf

DCL.prcopn('DclPaintGrid3')
DCL.uipda3(rc, gc, bc)
DCL.prccls('DclPaintGrid3')

DCL.uxaxdv('T', 0.1, 0.5)
DCL.uxaxdv('B', 0.1, 0.5)
DCL.uyaxdv('L', 0.1, 0.5)
DCL.uyaxdv('R', 0.1, 0.5)

DCL.grcls
